/*
 * Decompiled with CFR 0.152.
 */
package com.github.robust.client;

import android.util.Log;
import com.github.robust.client.AppMetaData;
import com.github.robust.client.PatchInfo;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;

public final class RobustSdkManager {
    private final AppMetaData appMetaData = new AppMetaData();
    private PatchInfo patchInfo = null;

    public static void setPatchInfo(PatchInfo patchInfo) {
        RobustSdkManager instance = RobustSdkManager.getInstance();
        instance.patchInfo = patchInfo;
    }

    public static PatchInfo getPatchInfo() {
        RobustSdkManager instance = RobustSdkManager.getInstance();
        return instance.patchInfo;
    }

    public AppMetaData getAppMetaData() {
        return this.appMetaData;
    }

    public static void init(String appId, String url, String reportUrl, String accessKey) {
        RobustSdkManager manager = RobustSdkManager.getInstance();
        manager.getAppMetaData().setUrl(url);
        manager.getAppMetaData().setReportUrl(reportUrl);
        manager.getAppMetaData().setAccessKey(accessKey);
        manager.getAppMetaData().setAppId(appId);
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048, new SecureRandom());
            KeyPair keyPair = generator.generateKeyPair();
            manager.getAppMetaData().setPublicKey(keyPair.getPublic());
            manager.getAppMetaData().setPrivateKey(keyPair.getPrivate());
        }
        catch (Exception e) {
            Log.e((String)"RobustSdkManager", (String)"\u65e0\u6cd5\u751f\u6210RSA\u7684\u5bc6\u94a5\uff0c\u90a3\u4e48Robust\u5c06\u4e0d\u6267\u884c\u4efb\u4f55\u64cd\u4f5c");
            e.printStackTrace();
        }
    }

    public static RobustSdkManager getInstance() {
        return Holder.MANAGER;
    }

    private static class Holder {
        private static final RobustSdkManager MANAGER = new RobustSdkManager();

        private Holder() {
        }
    }
}

