/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.javabitcoindrpcclient;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import wf.bitcoin.javabitcoindrpcclient.MapWrapperType;
import wf.bitcoin.krotjson.HexCoder;

class MapWrapper
implements MapWrapperType {
    public final Map<String, ?> m;

    MapWrapper(Map<String, ?> m) {
        this.m = m;
    }

    @Override
    public Boolean mapBool(String key) {
        return MapWrapper.mapBool(this.m, key);
    }

    @Override
    public Integer mapInt(String key) {
        return MapWrapper.mapInt(this.m, key);
    }

    @Override
    public Long mapLong(String key) {
        return MapWrapper.mapLong(this.m, key);
    }

    @Override
    public String mapStr(String key) {
        return MapWrapper.mapStr(this.m, key);
    }

    @Override
    public Date mapDate(String key) {
        return MapWrapper.mapDate(this.m, key);
    }

    @Override
    public BigDecimal mapBigDecimal(String key) {
        return MapWrapper.mapBigDecimal(this.m, key);
    }

    @Override
    public byte[] mapHex(String key) {
        return MapWrapper.mapHex(this.m, key);
    }

    private static Boolean mapBool(Map<String, ?> m, String key) {
        Object val = m.get(key);
        if (!(val instanceof Boolean)) {
            return null;
        }
        return (Boolean)val;
    }

    private static BigDecimal mapBigDecimal(Map<String, ?> m, String key) {
        Object val = m.get(key);
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        String strVal = MapWrapper.mapStr(m, key);
        if (strVal == null) {
            return null;
        }
        return new BigDecimal(strVal);
    }

    private static Integer mapInt(Map<String, ?> m, String key) {
        Object val = m.get(key);
        if (!(val instanceof Number)) {
            return null;
        }
        return ((Number)val).intValue();
    }

    private static Long mapLong(Map<String, ?> m, String key) {
        Object val = m.get(key);
        if (!(val instanceof Number)) {
            return null;
        }
        return ((Number)val).longValue();
    }

    private static String mapStr(Map<String, ?> m, String key) {
        Object val = m.get(key);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    private static Date mapDate(Map<String, ?> m, String key) {
        Long longVal = MapWrapper.mapLong(m, key);
        if (longVal == null) {
            return null;
        }
        return new Date(longVal * 1000L);
    }

    private static byte[] mapHex(Map<String, ?> m, String key) {
        String strVal = MapWrapper.mapStr(m, key);
        if (strVal == null) {
            return null;
        }
        return HexCoder.decode(strVal);
    }

    public String toString() {
        return String.valueOf(this.m);
    }
}

