/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.javabitcoindrpcclient;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCError;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCException;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;
import wf.bitcoin.javabitcoindrpcclient.GenericRpcException;
import wf.bitcoin.javabitcoindrpcclient.ListMapWrapper;
import wf.bitcoin.javabitcoindrpcclient.MapWrapper;
import wf.bitcoin.krotjson.Base64Coder;
import wf.bitcoin.krotjson.HexCoder;
import wf.bitcoin.krotjson.JSON;

public class BitcoinJSONRPCClient
implements BitcoindRpcClient {
    private static final Logger logger;
    public final URL rpcURL;
    private URL noAuthURL;
    private String authStr;
    public static final URL DEFAULT_JSONRPC_URL;
    public static final URL DEFAULT_JSONRPC_TESTNET_URL;
    public static final URL DEFAULT_JSONRPC_REGTEST_URL;
    private HostnameVerifier hostnameVerifier = null;
    private SSLSocketFactory sslSocketFactory = null;
    public static final Charset QUERY_CHARSET;

    public BitcoinJSONRPCClient(String rpcUrl) throws MalformedURLException {
        this(new URL(rpcUrl));
    }

    public BitcoinJSONRPCClient(URL rpc) {
        this.rpcURL = rpc;
        try {
            this.noAuthURL = new URI(rpc.getProtocol(), null, rpc.getHost(), rpc.getPort(), rpc.getPath(), rpc.getQuery(), null).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new IllegalArgumentException(rpc.toString(), ex);
        }
        this.authStr = rpc.getUserInfo() == null ? null : String.valueOf(Base64Coder.encode(rpc.getUserInfo().getBytes(Charset.forName("ISO8859-1"))));
    }

    public BitcoinJSONRPCClient(boolean testNet) {
        this(testNet ? DEFAULT_JSONRPC_TESTNET_URL : DEFAULT_JSONRPC_URL);
    }

    public BitcoinJSONRPCClient() {
        this(DEFAULT_JSONRPC_TESTNET_URL);
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public byte[] prepareRequest(final String method, final Object ... params) {
        return JSON.stringify(new LinkedHashMap(){
            {
                this.put("method", method);
                this.put("params", params);
                this.put("id", "1");
            }
        }).getBytes(QUERY_CHARSET);
    }

    private static byte[] loadStream(InputStream in, boolean close) throws IOException {
        int nr;
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((nr = in.read(buffer)) != -1) {
            if (nr == 0) {
                throw new IOException("Read timed out");
            }
            o.write(buffer, 0, nr);
        }
        return o.toByteArray();
    }

    public Object loadResponse(InputStream in, Object expectedID, boolean close) throws IOException, GenericRpcException {
        try {
            String r = new String(BitcoinJSONRPCClient.loadStream(in, close), QUERY_CHARSET);
            logger.log(Level.FINE, "Bitcoin JSON-RPC response:\n{0}", r);
            try {
                Map response = (Map)JSON.parse(r);
                if (!expectedID.equals(response.get("id"))) {
                    throw new BitcoinRPCException("Wrong response ID (expected: " + String.valueOf(expectedID) + ", response: " + response.get("id") + ")");
                }
                if (response.get("error") != null) {
                    throw new BitcoinRPCException(new BitcoinRPCError((Map)response.get("error")));
                }
                Object v = response.get("result");
                return v;
            }
            catch (ClassCastException ex) {
                throw new BitcoinRPCException("Invalid server response format (data: \"" + r + "\")");
            }
        }
        finally {
            if (close) {
                in.close();
            }
        }
    }

    public Object query(String method, Object ... o) throws GenericRpcException {
        try {
            HttpURLConnection conn = (HttpURLConnection)this.noAuthURL.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            if (conn instanceof HttpsURLConnection) {
                if (this.hostnameVerifier != null) {
                    ((HttpsURLConnection)conn).setHostnameVerifier(this.hostnameVerifier);
                }
                if (this.sslSocketFactory != null) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslSocketFactory);
                }
            }
            conn.setRequestProperty("Authorization", "Basic " + this.authStr);
            byte[] r = this.prepareRequest(method, o);
            logger.log(Level.FINE, "Bitcoin JSON-RPC request:\n{0}", new String(r, QUERY_CHARSET));
            conn.getOutputStream().write(r);
            conn.getOutputStream().close();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                InputStream errorStream = conn.getErrorStream();
                throw new BitcoinRPCException(method, Arrays.deepToString(o), responseCode, conn.getResponseMessage(), errorStream == null ? null : new String(BitcoinJSONRPCClient.loadStream(errorStream, true)));
            }
            return this.loadResponse(conn.getInputStream(), "1", true);
        }
        catch (IOException ex) {
            throw new BitcoinRPCException(method, Arrays.deepToString(o), ex);
        }
    }

    @Override
    public String createRawTransaction(List<BitcoindRpcClient.TxInput> inputs, List<BitcoindRpcClient.TxOutput> outputs) throws GenericRpcException {
        ArrayList<2> pInputs = new ArrayList<2>();
        for (final BitcoindRpcClient.TxInput txInput : inputs) {
            pInputs.add(new LinkedHashMap(){
                {
                    this.put("txid", txInput.txid());
                    this.put("vout", txInput.vout());
                }
            });
        }
        LinkedHashMap<String, Object> pOutputs = new LinkedHashMap<String, Object>();
        for (BitcoindRpcClient.TxOutput txOutput : outputs) {
            pOutputs.put(txOutput.address(), txOutput.amount());
            if (txOutput.data() == null) continue;
            String hex = HexCoder.encode(txOutput.data());
            pOutputs.put("data", hex);
        }
        return (String)this.query("createrawtransaction", pInputs, pOutputs);
    }

    @Override
    public String dumpPrivKey(String address) throws GenericRpcException {
        return (String)this.query("dumpprivkey", address);
    }

    @Override
    public String getAccount(String address) throws GenericRpcException {
        return (String)this.query("getaccount", address);
    }

    @Override
    public String getAccountAddress(String account) throws GenericRpcException {
        return (String)this.query("getaccountaddress", account);
    }

    @Override
    public List<String> getAddressesByAccount(String account) throws GenericRpcException {
        return (List)this.query("getaddressesbyaccount", account);
    }

    @Override
    public BigDecimal getBalance() throws GenericRpcException {
        return (BigDecimal)this.query("getbalance", new Object[0]);
    }

    @Override
    public BigDecimal getBalance(String account) throws GenericRpcException {
        return (BigDecimal)this.query("getbalance", account);
    }

    @Override
    public BigDecimal getBalance(String account, int minConf) throws GenericRpcException {
        return (BigDecimal)this.query("getbalance", account, minConf);
    }

    @Override
    public BitcoindRpcClient.SmartFeeResult estimateSmartFee(int blocks) {
        return new SmartFeeResultMapWrapper((Map)this.query("estimatesmartfee", blocks));
    }

    @Override
    public BitcoindRpcClient.Block getBlock(int height) throws GenericRpcException {
        String hash = (String)this.query("getblockhash", height);
        return this.getBlock(hash);
    }

    @Override
    public BitcoindRpcClient.Block getBlock(String blockHash) throws GenericRpcException {
        return new BlockMapWrapper((Map)this.query("getblock", blockHash));
    }

    @Override
    public String getRawBlock(String blockHash) throws GenericRpcException {
        return (String)this.query("getblock", blockHash, false);
    }

    @Override
    public String getBlockHash(int height) throws GenericRpcException {
        return (String)this.query("getblockhash", height);
    }

    @Override
    public BitcoindRpcClient.BlockChainInfo getBlockChainInfo() throws GenericRpcException {
        return new BlockChainInfoMapWrapper((Map)this.query("getblockchaininfo", new Object[0]));
    }

    @Override
    public int getBlockCount() throws GenericRpcException {
        return ((Number)this.query("getblockcount", new Object[0])).intValue();
    }

    @Override
    public BitcoindRpcClient.Info getInfo() throws GenericRpcException {
        return new InfoWrapper((Map)this.query("getinfo", new Object[0]));
    }

    @Override
    public BitcoindRpcClient.TxOutSetInfo getTxOutSetInfo() throws GenericRpcException {
        return new TxOutSetInfoWrapper((Map)this.query("gettxoutsetinfo", new Object[0]));
    }

    @Override
    public BitcoindRpcClient.NetworkInfo getNetworkInfo() throws GenericRpcException {
        return new NetworkInfoWrapper((Map)this.query("getnetworkinfo", new Object[0]));
    }

    @Override
    public BitcoindRpcClient.MiningInfo getMiningInfo() throws GenericRpcException {
        return new MiningInfoWrapper((Map)this.query("getmininginfo", new Object[0]));
    }

    @Override
    public List<BitcoindRpcClient.NodeInfo> getAddedNodeInfo(boolean dummy, String node) throws GenericRpcException {
        List list = (List)this.query("getaddednodeinfo", dummy, node);
        LinkedList<BitcoindRpcClient.NodeInfo> nodeInfoList = new LinkedList<BitcoindRpcClient.NodeInfo>();
        for (Map m : list) {
            NodeInfoWrapper niw = new NodeInfoWrapper(m);
            nodeInfoList.add(niw);
        }
        return nodeInfoList;
    }

    @Override
    public BitcoindRpcClient.MultiSig createMultiSig(int nRequired, List<String> keys) throws GenericRpcException {
        return new MultiSigWrapper((Map)this.query("createmultisig", nRequired, keys));
    }

    @Override
    public BitcoindRpcClient.WalletInfo getWalletInfo() {
        return new WalletInfoWrapper((Map)this.query("getwalletinfo", new Object[0]));
    }

    @Override
    public String getNewAddress() throws GenericRpcException {
        return (String)this.query("getnewaddress", new Object[0]);
    }

    @Override
    public String getNewAddress(String account) throws GenericRpcException {
        return (String)this.query("getnewaddress", account);
    }

    @Override
    public String getNewAddress(String account, String addressType) throws GenericRpcException {
        return (String)this.query("getnewaddress", account, addressType);
    }

    @Override
    public List<String> getRawMemPool() throws GenericRpcException {
        return (List)this.query("getrawmempool", new Object[0]);
    }

    @Override
    public String getBestBlockHash() throws GenericRpcException {
        return (String)this.query("getbestblockhash", new Object[0]);
    }

    @Override
    public String getRawTransactionHex(String txId) throws GenericRpcException {
        return (String)this.query("getrawtransaction", txId);
    }

    @Override
    public BitcoindRpcClient.RawTransaction getRawTransaction(String txId) throws GenericRpcException {
        return new RawTransactionImpl((Map)this.query("getrawtransaction", txId, 1));
    }

    @Override
    public BigDecimal getReceivedByAddress(String address) throws GenericRpcException {
        return (BigDecimal)this.query("getreceivedbyaddress", address);
    }

    @Override
    public BigDecimal getReceivedByAddress(String address, int minConf) throws GenericRpcException {
        return (BigDecimal)this.query("getreceivedbyaddress", address, minConf);
    }

    @Override
    public void importPrivKey(String bitcoinPrivKey) throws GenericRpcException {
        this.query("importprivkey", bitcoinPrivKey);
    }

    @Override
    public void importPrivKey(String bitcoinPrivKey, String label) throws GenericRpcException {
        this.query("importprivkey", bitcoinPrivKey, label);
    }

    @Override
    public void importPrivKey(String bitcoinPrivKey, String label, boolean rescan) throws GenericRpcException {
        this.query("importprivkey", bitcoinPrivKey, label, rescan);
    }

    @Override
    public Object importAddress(String address, String label, boolean rescan) throws GenericRpcException {
        this.query("importaddress", address, label, rescan);
        return null;
    }

    @Override
    public Map<String, Number> listAccounts() throws GenericRpcException {
        return (Map)this.query("listaccounts", new Object[0]);
    }

    @Override
    public Map<String, Number> listAccounts(int minConf) throws GenericRpcException {
        return (Map)this.query("listaccounts", minConf);
    }

    @Override
    public Map<String, Number> listAccounts(int minConf, boolean watchonly) throws GenericRpcException {
        return (Map)this.query("listaccounts", minConf, watchonly);
    }

    @Override
    public List<BitcoindRpcClient.LockedUnspent> listLockUnspent() {
        return new ListMapWrapper<BitcoindRpcClient.LockedUnspent>((List)this.query("listlockunspent", new Object[0])){

            @Override
            protected BitcoindRpcClient.LockedUnspent wrap(final Map m) {
                return new BitcoindRpcClient.LockedUnspent(){

                    @Override
                    public String txId() {
                        return (String)m.get("txid");
                    }

                    @Override
                    public int vout() {
                        return ((Long)m.get("vout")).intValue();
                    }
                };
            }
        };
    }

    @Override
    public List<BitcoindRpcClient.ReceivedAddress> listReceivedByAddress() throws GenericRpcException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaddress", new Object[0]));
    }

    @Override
    public List<BitcoindRpcClient.ReceivedAddress> listReceivedByAddress(int minConf) throws GenericRpcException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaddress", minConf));
    }

    @Override
    public List<BitcoindRpcClient.ReceivedAddress> listReceivedByAddress(int minConf, boolean includeEmpty) throws GenericRpcException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaddress", minConf, includeEmpty));
    }

    @Override
    public BitcoindRpcClient.TransactionsSinceBlock listSinceBlock() throws GenericRpcException {
        return new TransactionsSinceBlockImpl((Map)this.query("listsinceblock", new Object[0]));
    }

    @Override
    public BitcoindRpcClient.TransactionsSinceBlock listSinceBlock(String blockHash) throws GenericRpcException {
        return new TransactionsSinceBlockImpl((Map)this.query("listsinceblock", blockHash));
    }

    @Override
    public BitcoindRpcClient.TransactionsSinceBlock listSinceBlock(String blockHash, int targetConfirmations) throws GenericRpcException {
        return new TransactionsSinceBlockImpl((Map)this.query("listsinceblock", blockHash, targetConfirmations));
    }

    @Override
    public List<BitcoindRpcClient.Transaction> listTransactions() throws GenericRpcException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", new Object[0]));
    }

    @Override
    public List<BitcoindRpcClient.Transaction> listTransactions(String account) throws GenericRpcException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", account));
    }

    @Override
    public List<BitcoindRpcClient.Transaction> listTransactions(String account, int count) throws GenericRpcException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", account, count));
    }

    @Override
    public List<BitcoindRpcClient.Transaction> listTransactions(String account, int count, int skip) throws GenericRpcException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", account, count, skip));
    }

    @Override
    public List<BitcoindRpcClient.Unspent> listUnspent() throws GenericRpcException {
        return new UnspentListWrapper((List)this.query("listunspent", new Object[0]));
    }

    @Override
    public List<BitcoindRpcClient.Unspent> listUnspent(int minConf) throws GenericRpcException {
        return new UnspentListWrapper((List)this.query("listunspent", minConf));
    }

    @Override
    public List<BitcoindRpcClient.Unspent> listUnspent(int minConf, int maxConf) throws GenericRpcException {
        return new UnspentListWrapper((List)this.query("listunspent", minConf, maxConf));
    }

    @Override
    public List<BitcoindRpcClient.Unspent> listUnspent(int minConf, int maxConf, String ... addresses) throws GenericRpcException {
        return new UnspentListWrapper((List)this.query("listunspent", minConf, maxConf, addresses));
    }

    @Override
    public boolean lockUnspent(boolean unlock, String txid, int vout) throws GenericRpcException {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("txid", txid);
        params.put("vout", vout);
        return (Boolean)this.query("lockunspent", unlock, Arrays.asList(params).toArray());
    }

    @Override
    public boolean move(String fromAccount, String toAddress, BigDecimal amount) throws GenericRpcException {
        return (Boolean)this.query("move", fromAccount, toAddress, amount);
    }

    @Override
    public boolean move(String fromAccount, String toAddress, BigDecimal amount, String comment) throws GenericRpcException {
        return (Boolean)this.query("move", fromAccount, toAddress, amount, 0, comment);
    }

    @Override
    public boolean move(String fromAccount, String toAddress, BigDecimal amount, int minConf) throws GenericRpcException {
        return (Boolean)this.query("move", fromAccount, toAddress, amount, minConf);
    }

    @Override
    public boolean move(String fromAccount, String toAddress, BigDecimal amount, int minConf, String comment) throws GenericRpcException {
        return (Boolean)this.query("move", fromAccount, toAddress, amount, minConf, comment);
    }

    @Override
    public String sendFrom(String fromAccount, String toAddress, BigDecimal amount) throws GenericRpcException {
        return (String)this.query("sendfrom", fromAccount, toAddress, amount);
    }

    @Override
    public String sendFrom(String fromAccount, String toAddress, BigDecimal amount, int minConf) throws GenericRpcException {
        return (String)this.query("sendfrom", fromAccount, toAddress, amount, minConf);
    }

    @Override
    public String sendFrom(String fromAccount, String toAddress, BigDecimal amount, int minConf, String comment) throws GenericRpcException {
        return (String)this.query("sendfrom", fromAccount, toAddress, amount, minConf, comment);
    }

    @Override
    public String sendFrom(String fromAccount, String toAddress, BigDecimal amount, int minConf, String comment, String commentTo) throws GenericRpcException {
        return (String)this.query("sendfrom", fromAccount, toAddress, amount, minConf, comment, commentTo);
    }

    @Override
    public String sendRawTransaction(String hex) throws GenericRpcException {
        return (String)this.query("sendrawtransaction", hex);
    }

    @Override
    public String sendToAddress(String toAddress, BigDecimal amount) throws GenericRpcException {
        return (String)this.query("sendtoaddress", toAddress, amount);
    }

    @Override
    public String sendToAddress(String toAddress, BigDecimal amount, String comment) throws GenericRpcException {
        return (String)this.query("sendtoaddress", toAddress, amount, comment);
    }

    @Override
    public String sendToAddress(String toAddress, BigDecimal amount, String comment, String commentTo) throws GenericRpcException {
        return (String)this.query("sendtoaddress", toAddress, amount, comment, commentTo);
    }

    public String signRawTransaction(String hex) throws GenericRpcException {
        return this.signRawTransaction(hex, null, null, "ALL");
    }

    @Override
    public String signRawTransaction(String hex, List<? extends BitcoindRpcClient.TxInput> inputs, List<String> privateKeys) throws GenericRpcException {
        return this.signRawTransaction(hex, inputs, privateKeys, "ALL");
    }

    public String signRawTransaction(String hex, List<? extends BitcoindRpcClient.TxInput> inputs, List<String> privateKeys, String sigHashType) {
        Map result;
        ArrayList<4> pInputs = null;
        if (inputs != null) {
            pInputs = new ArrayList<4>();
            for (final BitcoindRpcClient.TxInput txInput : inputs) {
                pInputs.add(new LinkedHashMap(){
                    {
                        this.put("txid", txInput.txid());
                        this.put("vout", txInput.vout());
                        this.put("scriptPubKey", txInput.scriptPubKey());
                        if (txInput instanceof BitcoindRpcClient.ExtendedTxInput) {
                            BitcoindRpcClient.ExtendedTxInput extin = (BitcoindRpcClient.ExtendedTxInput)txInput;
                            this.put("redeemScript", extin.redeemScript());
                            this.put("amount", extin.amount());
                        }
                    }
                });
            }
        }
        if (((Boolean)(result = (Map)this.query("signrawtransaction", hex, pInputs, privateKeys, sigHashType)).get("complete")).booleanValue()) {
            return (String)result.get("hex");
        }
        throw new GenericRpcException("Incomplete");
    }

    public BitcoindRpcClient.RawTransaction decodeRawTransaction(String hex) throws GenericRpcException {
        Map result = (Map)this.query("decoderawtransaction", hex);
        RawTransactionImpl rawTransaction = new RawTransactionImpl(result);
        return rawTransaction.vOut().get(0).transaction();
    }

    @Override
    public BitcoindRpcClient.AddressValidationResult validateAddress(String address) throws GenericRpcException {
        final Map validationResult = (Map)this.query("validateaddress", address);
        return new BitcoindRpcClient.AddressValidationResult(){

            @Override
            public boolean isValid() {
                return (Boolean)validationResult.get("isvalid");
            }

            @Override
            public String address() {
                return (String)validationResult.get("address");
            }

            @Override
            public boolean isMine() {
                return (Boolean)validationResult.get("ismine");
            }

            @Override
            public boolean isScript() {
                return (Boolean)validationResult.get("isscript");
            }

            @Override
            public String pubKey() {
                return (String)validationResult.get("pubkey");
            }

            @Override
            public boolean isCompressed() {
                return (Boolean)validationResult.get("iscompressed");
            }

            @Override
            public String account() {
                return (String)validationResult.get("account");
            }

            public String toString() {
                return validationResult.toString();
            }
        };
    }

    @Override
    public void setGenerate(boolean b) throws BitcoinRPCException {
        this.query("setgenerate", b);
    }

    @Override
    public List<String> generate(int numBlocks) throws BitcoinRPCException {
        return (List)this.query("generate", numBlocks);
    }

    @Override
    public List<String> generate(int numBlocks, long maxTries) throws BitcoinRPCException {
        return (List)this.query("generate", numBlocks, maxTries);
    }

    @Override
    public List<String> generateToAddress(int numBlocks, String address) throws BitcoinRPCException {
        return (List)this.query("generatetoaddress", numBlocks, address);
    }

    @Override
    public BigDecimal estimateFee(int nBlocks) throws GenericRpcException {
        return (BigDecimal)this.query("estimatefee", nBlocks);
    }

    @Override
    public BigDecimal estimatePriority(int nBlocks) throws GenericRpcException {
        return (BigDecimal)this.query("estimatepriority", nBlocks);
    }

    @Override
    public void invalidateBlock(String hash) throws GenericRpcException {
        this.query("invalidateblock", hash);
    }

    @Override
    public void reconsiderBlock(String hash) throws GenericRpcException {
        this.query("reconsiderblock", hash);
    }

    @Override
    public List<BitcoindRpcClient.PeerInfoResult> getPeerInfo() throws GenericRpcException {
        final List l = (List)this.query("getpeerinfo", new Object[0]);
        return new AbstractList<BitcoindRpcClient.PeerInfoResult>(){

            @Override
            public BitcoindRpcClient.PeerInfoResult get(int index) {
                return new PeerInfoWrapper((Map)l.get(index));
            }

            @Override
            public int size() {
                return l.size();
            }
        };
    }

    @Override
    public void stop() {
        this.query("stop", new Object[0]);
    }

    @Override
    public String getRawChangeAddress() throws GenericRpcException {
        return (String)this.query("getrawchangeaddress", new Object[0]);
    }

    @Override
    public long getConnectionCount() throws GenericRpcException {
        return (Long)this.query("getconnectioncount", new Object[0]);
    }

    @Override
    public BigDecimal getUnconfirmedBalance() throws GenericRpcException {
        return (BigDecimal)this.query("getunconfirmedbalance", new Object[0]);
    }

    @Override
    public BigDecimal getDifficulty() throws GenericRpcException {
        return (BigDecimal)this.query("getdifficulty", new Object[0]);
    }

    @Override
    public BitcoindRpcClient.NetTotals getNetTotals() throws GenericRpcException {
        return new NetTotalsImpl((Map)this.query("getnettotals", new Object[0]));
    }

    @Override
    public BitcoindRpcClient.DecodedScript decodeScript(String hex) throws GenericRpcException {
        return new DecodedScriptImpl((Map)this.query("decodescript", hex));
    }

    @Override
    public void ping() throws GenericRpcException {
        this.query("ping", new Object[0]);
    }

    @Override
    public boolean getGenerate() throws BitcoinRPCException {
        return (Boolean)this.query("getgenerate", new Object[0]);
    }

    @Override
    public BigDecimal getNetworkHashPs() throws GenericRpcException {
        return (BigDecimal)this.query("getnetworkhashps", new Object[0]);
    }

    @Override
    public boolean setTxFee(BigDecimal amount) throws GenericRpcException {
        return (Boolean)this.query("settxfee", amount);
    }

    @Override
    public void addNode(String node, String command) throws GenericRpcException {
        this.query("addnode", node, command);
    }

    @Override
    public void backupWallet(String destination) throws GenericRpcException {
        this.query("backupwallet", destination);
    }

    @Override
    public String signMessage(String bitcoinAdress, String message) throws GenericRpcException {
        return (String)this.query("signmessage", bitcoinAdress, message);
    }

    @Override
    public void dumpWallet(String filename) throws GenericRpcException {
        this.query("dumpwallet", filename);
    }

    @Override
    public void importWallet(String filename) throws GenericRpcException {
        this.query("dumpwallet", filename);
    }

    @Override
    public void keyPoolRefill() throws GenericRpcException {
        this.keyPoolRefill(100L);
    }

    public void keyPoolRefill(long size) throws GenericRpcException {
        this.query("keypoolrefill", size);
    }

    @Override
    public BigDecimal getReceivedByAccount(String account) throws GenericRpcException {
        return this.getReceivedByAccount(account, 1);
    }

    public BigDecimal getReceivedByAccount(String account, int minConf) throws GenericRpcException {
        return new BigDecimal((String)this.query("getreceivedbyaccount", account, minConf));
    }

    @Override
    public void encryptWallet(String passPhrase) throws GenericRpcException {
        this.query("encryptwallet", passPhrase);
    }

    @Override
    public void walletPassPhrase(String passPhrase, long timeOut) throws GenericRpcException {
        this.query("walletpassphrase", passPhrase, timeOut);
    }

    @Override
    public boolean verifyMessage(String bitcoinAddress, String signature, String message) throws GenericRpcException {
        return (Boolean)this.query("verifymessage", bitcoinAddress, signature, message);
    }

    @Override
    public String addMultiSigAddress(int nRequired, List<String> keyObject) throws GenericRpcException {
        return (String)this.query("addmultisigaddress", nRequired, keyObject);
    }

    @Override
    public String addMultiSigAddress(int nRequired, List<String> keyObject, String account) throws GenericRpcException {
        return (String)this.query("addmultisigaddress", nRequired, keyObject, account);
    }

    @Override
    public boolean verifyChain() {
        return this.verifyChain(3, 6);
    }

    public boolean verifyChain(int checklevel, int numblocks) {
        return (Boolean)this.query("verifychain", checklevel, numblocks);
    }

    @Override
    public void submitBlock(String hexData) {
        this.query("submitblock", hexData);
    }

    @Override
    public BitcoindRpcClient.Transaction getTransaction(String txId) {
        return new TransactionWrapper((Map)this.query("gettransaction", txId));
    }

    @Override
    public BitcoindRpcClient.TxOut getTxOut(String txId, long vout) throws GenericRpcException {
        return new TxOutWrapper((Map)this.query("gettxout", txId, vout, true));
    }

    public BitcoindRpcClient.TxOut getTxOut(String txId, long vout, boolean includemempool) throws GenericRpcException {
        return new TxOutWrapper((Map)this.query("gettxout", txId, vout, includemempool));
    }

    @Override
    public BitcoindRpcClient.AddressBalance getAddressBalance(String address) {
        return new AddressBalanceWrapper((Map)this.query("getaddressbalance", address));
    }

    @Override
    public List<BitcoindRpcClient.AddressUtxo> getAddressUtxo(String address) {
        return new AddressUtxoList((List)this.query("getaddressutxos", address));
    }

    static {
        String port;
        String host;
        String password;
        String user;
        block17: {
            logger = Logger.getLogger(BitcoindRpcClient.class.getPackage().getName());
            user = "user";
            password = "pass";
            host = "localhost";
            port = null;
            try {
                File home = new File(System.getProperty("user.home"));
                File f = new File(home, ".bitcoin" + File.separatorChar + "bitcoin.conf");
                if (!f.exists() && !(f = new File(home, "AppData" + File.separatorChar + "Roaming" + File.separatorChar + "Bitcoin" + File.separatorChar + "bitcoin.conf")).exists()) {
                    f = null;
                }
                if (f == null) break block17;
                logger.fine("Bitcoin configuration file found");
                Properties p = new Properties();
                try (FileInputStream i = new FileInputStream(f);){
                    p.load(i);
                }
                user = p.getProperty("rpcuser", user);
                password = p.getProperty("rpcpassword", password);
                host = p.getProperty("rpcconnect", host);
                port = p.getProperty("rpcport", port);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        try {
            DEFAULT_JSONRPC_URL = new URL("http://" + user + ':' + password + "@" + host + ":" + (port == null ? "8332" : port) + "/");
            DEFAULT_JSONRPC_TESTNET_URL = new URL("http://" + user + ':' + password + "@" + host + ":" + (port == null ? "18332" : port) + "/");
            DEFAULT_JSONRPC_REGTEST_URL = new URL("http://" + user + ':' + password + "@" + host + ":" + (port == null ? "18443" : port) + "/");
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        QUERY_CHARSET = Charset.forName("ISO8859-1");
    }

    private static class AddressUtxoList
    extends ListMapWrapper<BitcoindRpcClient.AddressUtxo> {
        public AddressUtxoList(List<Map> list) {
            super(list);
        }

        @Override
        protected BitcoindRpcClient.AddressUtxo wrap(Map m) {
            return new AddressUtxoWrapper(m);
        }
    }

    private static class AddressUtxoWrapper
    implements BitcoindRpcClient.AddressUtxo {
        private String address;
        private String txid;
        private int outputIndex;
        private String script;
        private long satoshis;
        private long height;

        public AddressUtxoWrapper(Map<String, Object> result) {
            this.address = this.getOrDefault(result, "address", "").toString();
            this.txid = this.getOrDefault(result, "txid", "").toString();
            this.outputIndex = this.getOrDefault(result, "outputIndex", 0);
            this.script = this.getOrDefault(result, "script", "").toString();
            this.satoshis = this.getOrDefault(result, "satoshis", 0L);
            this.height = this.getOrDefault(result, "height", -1L);
        }

        <T> T getOrDefault(Map<String, Object> result, String key, T defval) {
            Object val = result.get(key);
            return (T)(val != null ? val : defval);
        }

        @Override
        public String getAddress() {
            return this.address;
        }

        @Override
        public String getTxid() {
            return this.txid;
        }

        @Override
        public int getOutputIndex() {
            return this.outputIndex;
        }

        @Override
        public String getScript() {
            return this.script;
        }

        @Override
        public long getSatoshis() {
            return this.satoshis;
        }

        @Override
        public long getHeight() {
            return this.height;
        }
    }

    private static class AddressBalanceWrapper
    extends MapWrapper
    implements BitcoindRpcClient.AddressBalance,
    Serializable {
        public AddressBalanceWrapper(Map<String, Object> r) {
            super(r);
        }

        @Override
        public long getBalance() {
            return this.mapLong("balance");
        }

        @Override
        public long getReceived() {
            return this.mapLong("received");
        }
    }

    private class PeerInfoWrapper
    extends MapWrapper
    implements BitcoindRpcClient.PeerInfoResult,
    Serializable {
        public PeerInfoWrapper(Map m) {
            super(m);
        }

        @Override
        public long getId() {
            return this.mapLong("id");
        }

        @Override
        public String getAddr() {
            return this.mapStr("addr");
        }

        @Override
        public String getAddrLocal() {
            return this.mapStr("addrlocal");
        }

        @Override
        public String getServices() {
            return this.mapStr("services");
        }

        @Override
        public long getLastSend() {
            return this.mapLong("lastsend");
        }

        @Override
        public long getLastRecv() {
            return this.mapLong("lastrecv");
        }

        @Override
        public long getBytesSent() {
            return this.mapLong("bytessent");
        }

        @Override
        public long getBytesRecv() {
            return this.mapLong("bytesrecv");
        }

        @Override
        public long getConnTime() {
            return this.mapLong("conntime");
        }

        @Override
        public int getTimeOffset() {
            return this.mapInt("timeoffset");
        }

        @Override
        public BigDecimal getPingTime() {
            return this.mapBigDecimal("pingtime");
        }

        @Override
        public long getVersion() {
            return this.mapLong("version");
        }

        @Override
        public String getSubVer() {
            return this.mapStr("subver");
        }

        @Override
        public boolean isInbound() {
            return this.mapBool("inbound");
        }

        @Override
        public int getStartingHeight() {
            return this.mapInt("startingheight");
        }

        @Override
        public long getBanScore() {
            return this.mapLong("banscore");
        }

        @Override
        public int getSyncedHeaders() {
            return this.mapInt("synced_headers");
        }

        @Override
        public int getSyncedBlocks() {
            return this.mapInt("synced_blocks");
        }

        @Override
        public boolean isWhiteListed() {
            return this.mapBool("whitelisted");
        }
    }

    private class UnspentWrapper
    implements BitcoindRpcClient.Unspent {
        final Map m;

        UnspentWrapper(Map m) {
            this.m = m;
        }

        @Override
        public String txid() {
            return MapWrapper.mapStr(this.m, "txid");
        }

        @Override
        public Integer vout() {
            return MapWrapper.mapInt(this.m, "vout");
        }

        @Override
        public String address() {
            return MapWrapper.mapStr(this.m, "address");
        }

        @Override
        public String scriptPubKey() {
            return MapWrapper.mapStr(this.m, "scriptPubKey");
        }

        @Override
        public String account() {
            return MapWrapper.mapStr(this.m, "account");
        }

        @Override
        public BigDecimal amount() {
            return MapWrapper.mapBigDecimal(this.m, "amount");
        }

        @Override
        public byte[] data() {
            return MapWrapper.mapHex(this.m, "data");
        }

        @Override
        public int confirmations() {
            return MapWrapper.mapInt(this.m, "confirmations");
        }

        public String toString() {
            return this.m.toString();
        }
    }

    private class UnspentListWrapper
    extends ListMapWrapper<BitcoindRpcClient.Unspent> {
        public UnspentListWrapper(List<Map> list) {
            super(list);
        }

        @Override
        protected BitcoindRpcClient.Unspent wrap(Map m) {
            return new UnspentWrapper(m);
        }
    }

    private class TransactionsSinceBlockImpl
    implements BitcoindRpcClient.TransactionsSinceBlock,
    Serializable {
        public final List<BitcoindRpcClient.Transaction> transactions;
        public final String lastBlock;

        public TransactionsSinceBlockImpl(Map r) {
            this.transactions = new TransactionListMapWrapper((List)r.get("transactions"));
            this.lastBlock = (String)r.get("lastblock");
        }

        @Override
        public List<BitcoindRpcClient.Transaction> transactions() {
            return this.transactions;
        }

        @Override
        public String lastBlock() {
            return this.lastBlock;
        }
    }

    private class TransactionListMapWrapper
    extends ListMapWrapper<BitcoindRpcClient.Transaction> {
        public TransactionListMapWrapper(List<Map> list) {
            super(list);
        }

        @Override
        protected BitcoindRpcClient.Transaction wrap(Map m) {
            return new TransactionWrapper(m);
        }
    }

    private static class ReceivedAddressListWrapper
    extends AbstractList<BitcoindRpcClient.ReceivedAddress> {
        private final List<Map<String, Object>> wrappedList;

        public ReceivedAddressListWrapper(List<Map<String, Object>> wrappedList) {
            this.wrappedList = wrappedList;
        }

        @Override
        public BitcoindRpcClient.ReceivedAddress get(int index) {
            final Map<String, Object> e = this.wrappedList.get(index);
            return new BitcoindRpcClient.ReceivedAddress(){

                @Override
                public String address() {
                    return (String)e.get("address");
                }

                @Override
                public String account() {
                    return (String)e.get("account");
                }

                @Override
                public BigDecimal amount() {
                    return (BigDecimal)e.get("amount");
                }

                @Override
                public int confirmations() {
                    return ((Number)e.get("confirmations")).intValue();
                }

                public String toString() {
                    return e.toString();
                }
            };
        }

        @Override
        public int size() {
            return this.wrappedList.size();
        }
    }

    public class NetTotalsImpl
    extends MapWrapper
    implements BitcoindRpcClient.NetTotals,
    Serializable {
        public NetTotalsImpl(Map m) {
            super(m);
        }

        @Override
        public long totalBytesRecv() {
            return this.mapLong("totalbytesrecv");
        }

        @Override
        public long totalBytesSent() {
            return this.mapLong("totalbytessent");
        }

        @Override
        public long timeMillis() {
            return this.mapLong("timemillis");
        }

        @Override
        public BitcoindRpcClient.NetTotals.uploadTarget uploadTarget() {
            return new uploadTargetImpl((Map)this.m.get("uploadtarget"));
        }

        public class uploadTargetImpl
        extends MapWrapper
        implements BitcoindRpcClient.NetTotals.uploadTarget,
        Serializable {
            public uploadTargetImpl(Map m) {
                super(m);
            }

            @Override
            public long timeFrame() {
                return this.mapLong("timeframe");
            }

            @Override
            public int target() {
                return this.mapInt("target");
            }

            @Override
            public boolean targetReached() {
                return this.mapBool("targetreached");
            }

            @Override
            public boolean serveHistoricalBlocks() {
                return this.mapBool("servehistoricalblocks");
            }

            @Override
            public long bytesLeftInCycle() {
                return this.mapLong("bytesleftincycle");
            }

            @Override
            public long timeLeftInCycle() {
                return this.mapLong("timeleftincycle");
            }
        }
    }

    private class DecodedScriptImpl
    extends MapWrapper
    implements BitcoindRpcClient.DecodedScript,
    Serializable {
        public DecodedScriptImpl(Map m) {
            super(m);
        }

        @Override
        public String asm() {
            return this.mapStr("asm");
        }

        @Override
        public String hex() {
            return this.mapStr("hex");
        }

        @Override
        public String type() {
            return this.mapStr("type");
        }

        @Override
        public int reqSigs() {
            return this.mapInt("reqSigs");
        }

        @Override
        public List<String> addresses() {
            return (List)this.m.get("addresses");
        }

        @Override
        public String p2sh() {
            return this.mapStr("p2sh");
        }
    }

    private class RawTransactionImpl
    extends MapWrapper
    implements BitcoindRpcClient.RawTransaction,
    Serializable {
        public RawTransactionImpl(Map<String, Object> tx) {
            super(tx);
        }

        @Override
        public String hex() {
            return this.mapStr("hex");
        }

        @Override
        public String txId() {
            return this.mapStr("txid");
        }

        @Override
        public int version() {
            return this.mapInt("version");
        }

        @Override
        public long lockTime() {
            return this.mapLong("locktime");
        }

        @Override
        public String hash() {
            return this.mapStr("hash");
        }

        @Override
        public long size() {
            return this.mapLong("size");
        }

        @Override
        public long vsize() {
            return this.mapLong("vsize");
        }

        @Override
        public List<BitcoindRpcClient.RawTransaction.In> vIn() {
            final List vIn = (List)this.m.get("vin");
            return new AbstractList<BitcoindRpcClient.RawTransaction.In>(){

                @Override
                public BitcoindRpcClient.RawTransaction.In get(int index) {
                    return new InImpl((Map)vIn.get(index));
                }

                @Override
                public int size() {
                    return vIn.size();
                }
            };
        }

        @Override
        public List<BitcoindRpcClient.RawTransaction.Out> vOut() {
            final List vOut = (List)this.m.get("vout");
            return new AbstractList<BitcoindRpcClient.RawTransaction.Out>(){

                @Override
                public BitcoindRpcClient.RawTransaction.Out get(int index) {
                    return new OutImpl((Map)vOut.get(index));
                }

                @Override
                public int size() {
                    return vOut.size();
                }
            };
        }

        @Override
        public String blockHash() {
            return this.mapStr("blockhash");
        }

        @Override
        public Integer confirmations() {
            Object o = this.m.get("confirmations");
            return o == null ? null : Integer.valueOf(((Number)o).intValue());
        }

        @Override
        public Date time() {
            return this.mapCTime("time");
        }

        @Override
        public Date blocktime() {
            return this.mapCTime("blocktime");
        }

        @Override
        public long height() {
            return this.mapLong("height");
        }

        private class OutImpl
        extends MapWrapper
        implements BitcoindRpcClient.RawTransaction.Out,
        Serializable {
            public OutImpl(Map m) {
                super(m);
            }

            @Override
            public BigDecimal value() {
                return this.mapBigDecimal("value");
            }

            @Override
            public int n() {
                return this.mapInt("n");
            }

            @Override
            public BitcoindRpcClient.RawTransaction.Out.ScriptPubKey scriptPubKey() {
                return new ScriptPubKeyImpl((Map)this.m.get("scriptPubKey"));
            }

            @Override
            public BitcoindRpcClient.TxInput toInput() {
                return new BitcoindRpcClient.BasicTxInput(this.transaction().txId(), this.n());
            }

            @Override
            public BitcoindRpcClient.RawTransaction transaction() {
                return RawTransactionImpl.this;
            }

            private class ScriptPubKeyImpl
            extends MapWrapper
            implements BitcoindRpcClient.RawTransaction.Out.ScriptPubKey,
            Serializable {
                public ScriptPubKeyImpl(Map m) {
                    super(m);
                }

                @Override
                public String asm() {
                    return this.mapStr("asm");
                }

                @Override
                public String hex() {
                    return this.mapStr("hex");
                }

                @Override
                public int reqSigs() {
                    return this.mapInt("reqSigs");
                }

                @Override
                public String type() {
                    return this.mapStr("type");
                }

                @Override
                public List<String> addresses() {
                    return (List)this.m.get("addresses");
                }
            }
        }

        private class InImpl
        extends MapWrapper
        implements BitcoindRpcClient.RawTransaction.In,
        Serializable {
            public InImpl(Map m) {
                super(m);
            }

            @Override
            public String txid() {
                return this.mapStr("txid");
            }

            @Override
            public Integer vout() {
                return this.mapInt("vout");
            }

            @Override
            public Map<String, Object> scriptSig() {
                return (Map)this.m.get("scriptSig");
            }

            @Override
            public long sequence() {
                return this.mapLong("sequence");
            }

            @Override
            public BitcoindRpcClient.RawTransaction getTransaction() {
                try {
                    return BitcoinJSONRPCClient.this.getRawTransaction(this.mapStr("txid"));
                }
                catch (GenericRpcException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public BitcoindRpcClient.RawTransaction.Out getTransactionOutput() {
                return this.getTransaction().vOut().get(this.mapInt("vout"));
            }

            @Override
            public String scriptPubKey() {
                return this.mapStr("scriptPubKey");
            }

            @Override
            public String address() {
                return this.mapStr("address");
            }
        }
    }

    private class BlockMapWrapper
    extends MapWrapper
    implements BitcoindRpcClient.Block,
    Serializable {
        public BlockMapWrapper(Map<String, ?> m) {
            super(m);
        }

        @Override
        public String hash() {
            return this.mapStr("hash");
        }

        @Override
        public int confirmations() {
            return this.mapInt("confirmations");
        }

        @Override
        public int size() {
            return this.mapInt("size");
        }

        @Override
        public int height() {
            return this.mapInt("height");
        }

        @Override
        public int version() {
            return this.mapInt("version");
        }

        @Override
        public String merkleRoot() {
            return this.mapStr("merkleroot");
        }

        @Override
        public String chainwork() {
            return this.mapStr("chainwork");
        }

        @Override
        public List<String> tx() {
            return (List)this.m.get("tx");
        }

        @Override
        public Date time() {
            return this.mapCTime("time");
        }

        @Override
        public long nonce() {
            return this.mapLong("nonce");
        }

        @Override
        public String bits() {
            return this.mapStr("bits");
        }

        @Override
        public BigDecimal difficulty() {
            return this.mapBigDecimal("difficulty");
        }

        @Override
        public String previousHash() {
            return this.mapStr("previousblockhash");
        }

        @Override
        public String nextHash() {
            return this.mapStr("nextblockhash");
        }

        @Override
        public BitcoindRpcClient.Block previous() throws GenericRpcException {
            if (!this.m.containsKey("previousblockhash")) {
                return null;
            }
            return BitcoinJSONRPCClient.this.getBlock(this.previousHash());
        }

        @Override
        public BitcoindRpcClient.Block next() throws GenericRpcException {
            if (!this.m.containsKey("nextblockhash")) {
                return null;
            }
            return BitcoinJSONRPCClient.this.getBlock(this.nextHash());
        }
    }

    private class SmartFeeResultMapWrapper
    extends MapWrapper
    implements BitcoindRpcClient.SmartFeeResult,
    Serializable {
        public SmartFeeResultMapWrapper(Map<String, ?> m) {
            super(m);
        }

        @Override
        public BigDecimal feeRate() {
            return this.mapBigDecimal("feerate");
        }

        @Override
        public int blocks() {
            return this.mapInt("blocks");
        }

        @Override
        public String errors() {
            return this.mapStr("errors");
        }
    }

    private class BlockChainInfoMapWrapper
    extends MapWrapper
    implements BitcoindRpcClient.BlockChainInfo,
    Serializable {
        public BlockChainInfoMapWrapper(Map m) {
            super(m);
        }

        @Override
        public String chain() {
            return this.mapStr("chain");
        }

        @Override
        public int blocks() {
            return this.mapInt("blocks");
        }

        @Override
        public String bestBlockHash() {
            return this.mapStr("bestblockhash");
        }

        @Override
        public BigDecimal difficulty() {
            return this.mapBigDecimal("difficulty");
        }

        @Override
        public BigDecimal verificationProgress() {
            return this.mapBigDecimal("verificationprogress");
        }

        @Override
        public String chainWork() {
            return this.mapStr("chainwork");
        }
    }

    private class MiningInfoWrapper
    extends MapWrapper
    implements BitcoindRpcClient.MiningInfo,
    Serializable {
        public MiningInfoWrapper(Map m) {
            super(m);
        }

        @Override
        public int blocks() {
            return this.mapInt("blocks");
        }

        @Override
        public int currentBlockSize() {
            return this.mapInt("currentblocksize");
        }

        @Override
        public int currentBlockWeight() {
            return this.mapInt("currentblockweight");
        }

        @Override
        public int currentBlockTx() {
            return this.mapInt("currentblocktx");
        }

        @Override
        public BigDecimal difficulty() {
            return this.mapBigDecimal("difficulty");
        }

        @Override
        public String errors() {
            return this.mapStr("errors");
        }

        @Override
        public BigDecimal networkHashps() {
            return this.mapBigDecimal("networkhashps");
        }

        @Override
        public int pooledTx() {
            return this.mapInt("pooledtx");
        }

        @Override
        public boolean testNet() {
            return this.mapBool("testnet");
        }

        @Override
        public String chain() {
            return this.mapStr("chain");
        }
    }

    private class TxOutWrapper
    extends MapWrapper
    implements BitcoindRpcClient.TxOut,
    Serializable {
        public TxOutWrapper(Map m) {
            super(m);
        }

        @Override
        public String bestBlock() {
            return this.mapStr("bestblock");
        }

        @Override
        public long confirmations() {
            return this.mapLong("confirmations");
        }

        @Override
        public BigDecimal value() {
            return this.mapBigDecimal("value");
        }

        @Override
        public String asm() {
            return this.mapStr("asm");
        }

        @Override
        public String hex() {
            return this.mapStr("hex");
        }

        @Override
        public long reqSigs() {
            return this.mapLong("reqSigs");
        }

        @Override
        public String type() {
            return this.mapStr("type");
        }

        @Override
        public List<String> addresses() {
            return (List)this.m.get("addresses");
        }

        @Override
        public long version() {
            return this.mapLong("version");
        }

        @Override
        public boolean coinBase() {
            return this.mapBool("coinbase");
        }
    }

    private class TransactionWrapper
    extends MapWrapper
    implements BitcoindRpcClient.Transaction,
    Serializable {
        private BitcoindRpcClient.RawTransaction raw;

        public TransactionWrapper(Map m) {
            super(m);
            this.raw = null;
        }

        @Override
        public String account() {
            return TransactionWrapper.mapStr(this.m, "account");
        }

        @Override
        public String address() {
            return TransactionWrapper.mapStr(this.m, "address");
        }

        @Override
        public String category() {
            return TransactionWrapper.mapStr(this.m, "category");
        }

        @Override
        public BigDecimal amount() {
            return TransactionWrapper.mapBigDecimal(this.m, "amount");
        }

        @Override
        public BigDecimal fee() {
            return TransactionWrapper.mapBigDecimal(this.m, "fee");
        }

        @Override
        public int confirmations() {
            return TransactionWrapper.mapInt(this.m, "confirmations");
        }

        @Override
        public String blockHash() {
            return TransactionWrapper.mapStr(this.m, "blockhash");
        }

        @Override
        public int blockIndex() {
            return TransactionWrapper.mapInt(this.m, "blockindex");
        }

        @Override
        public Date blockTime() {
            return TransactionWrapper.mapCTime(this.m, "blocktime");
        }

        @Override
        public String txId() {
            return TransactionWrapper.mapStr(this.m, "txid");
        }

        @Override
        public Date time() {
            return TransactionWrapper.mapCTime(this.m, "time");
        }

        @Override
        public Date timeReceived() {
            return TransactionWrapper.mapCTime(this.m, "timereceived");
        }

        @Override
        public String comment() {
            return TransactionWrapper.mapStr(this.m, "comment");
        }

        @Override
        public String commentTo() {
            return TransactionWrapper.mapStr(this.m, "to");
        }

        @Override
        public boolean generated() {
            return TransactionWrapper.mapBool(this.m, "generated");
        }

        @Override
        public BitcoindRpcClient.RawTransaction raw() {
            if (this.raw == null) {
                try {
                    this.raw = BitcoinJSONRPCClient.this.getRawTransaction(this.txId());
                }
                catch (GenericRpcException ex) {
                    logger.warning(ex.getMessage());
                }
            }
            return this.raw;
        }

        @Override
        public String toString() {
            return this.m.toString();
        }
    }

    private class AddressWrapper
    extends MapWrapper
    implements BitcoindRpcClient.Address,
    Serializable {
        public AddressWrapper(Map m) {
            super(m);
        }

        @Override
        public String address() {
            return this.mapStr("address");
        }

        @Override
        public String connected() {
            return this.mapStr("connected");
        }
    }

    private class NodeInfoWrapper
    extends MapWrapper
    implements BitcoindRpcClient.NodeInfo,
    Serializable {
        public NodeInfoWrapper(Map m) {
            super(m);
        }

        @Override
        public String addedNode() {
            return this.mapStr("addednode");
        }

        @Override
        public boolean connected() {
            return this.mapBool("connected");
        }

        @Override
        public List<BitcoindRpcClient.Address> addresses() {
            List maps = (List)this.m.get("addresses");
            LinkedList<BitcoindRpcClient.Address> addresses = new LinkedList<BitcoindRpcClient.Address>();
            for (Map m : maps) {
                AddressWrapper add = new AddressWrapper(m);
                addresses.add(add);
            }
            return addresses;
        }
    }

    private class MultiSigWrapper
    extends MapWrapper
    implements BitcoindRpcClient.MultiSig,
    Serializable {
        public MultiSigWrapper(Map m) {
            super(m);
        }

        @Override
        public String address() {
            return this.mapStr("address");
        }

        @Override
        public String redeemScript() {
            return this.mapStr("redeemScript");
        }
    }

    private class NetworkWrapper
    extends MapWrapper
    implements BitcoindRpcClient.Network,
    Serializable {
        public NetworkWrapper(Map m) {
            super(m);
        }

        @Override
        public String name() {
            return this.mapStr("name");
        }

        @Override
        public boolean limited() {
            return this.mapBool("limited");
        }

        @Override
        public boolean reachable() {
            return this.mapBool("reachable");
        }

        @Override
        public String proxy() {
            return this.mapStr("proxy");
        }

        @Override
        public boolean proxyRandomizeCredentials() {
            return this.mapBool("proxy_randomize_credentials");
        }
    }

    private class NetworkInfoWrapper
    extends MapWrapper
    implements BitcoindRpcClient.NetworkInfo,
    Serializable {
        public NetworkInfoWrapper(Map m) {
            super(m);
        }

        @Override
        public long version() {
            return this.mapLong("version");
        }

        @Override
        public String subversion() {
            return this.mapStr("subversion");
        }

        @Override
        public long protocolVersion() {
            return this.mapLong("protocolversion");
        }

        @Override
        public String localServices() {
            return this.mapStr("localservices");
        }

        @Override
        public boolean localRelay() {
            return this.mapBool("localrelay");
        }

        @Override
        public long timeOffset() {
            return this.mapLong("timeoffset");
        }

        @Override
        public long connections() {
            return this.mapLong("connections");
        }

        @Override
        public List<BitcoindRpcClient.Network> networks() {
            List maps = (List)this.m.get("networks");
            LinkedList<BitcoindRpcClient.Network> networks = new LinkedList<BitcoindRpcClient.Network>();
            for (Map m : maps) {
                NetworkWrapper net = new NetworkWrapper(m);
                networks.add(net);
            }
            return networks;
        }

        @Override
        public BigDecimal relayFee() {
            return this.mapBigDecimal("relayfee");
        }

        @Override
        public List<String> localAddresses() {
            return (List)this.m.get("localaddresses");
        }

        @Override
        public String warnings() {
            return this.mapStr("warnings");
        }
    }

    private class WalletInfoWrapper
    extends MapWrapper
    implements BitcoindRpcClient.WalletInfo,
    Serializable {
        public WalletInfoWrapper(Map m) {
            super(m);
        }

        @Override
        public long walletVersion() {
            return this.mapLong("walletversion");
        }

        @Override
        public BigDecimal balance() {
            return this.mapBigDecimal("balance");
        }

        @Override
        public BigDecimal unconfirmedBalance() {
            return this.mapBigDecimal("unconfirmed_balance");
        }

        @Override
        public BigDecimal immatureBalance() {
            return this.mapBigDecimal("immature_balance");
        }

        @Override
        public long txCount() {
            return this.mapLong("txcount");
        }

        @Override
        public long keyPoolOldest() {
            return this.mapLong("keypoololdest");
        }

        @Override
        public long keyPoolSize() {
            return this.mapLong("keypoolsize");
        }

        @Override
        public long unlockedUntil() {
            return this.mapLong("unlocked_until");
        }

        @Override
        public BigDecimal payTxFee() {
            return this.mapBigDecimal("paytxfee");
        }

        @Override
        public String hdMasterKeyId() {
            return this.mapStr("hdmasterkeyid");
        }
    }

    private class TxOutSetInfoWrapper
    extends MapWrapper
    implements BitcoindRpcClient.TxOutSetInfo,
    Serializable {
        public TxOutSetInfoWrapper(Map m) {
            super(m);
        }

        @Override
        public long height() {
            return this.mapInt("height").intValue();
        }

        @Override
        public String bestBlock() {
            return this.mapStr("bestBlock");
        }

        @Override
        public long transactions() {
            return this.mapInt("transactions").intValue();
        }

        @Override
        public long txouts() {
            return this.mapInt("txouts").intValue();
        }

        @Override
        public long bytesSerialized() {
            return this.mapInt("bytes_serialized").intValue();
        }

        @Override
        public String hashSerialized() {
            return this.mapStr("hash_serialized");
        }

        @Override
        public BigDecimal totalAmount() {
            return this.mapBigDecimal("total_amount");
        }
    }

    private class InfoWrapper
    extends MapWrapper
    implements BitcoindRpcClient.Info,
    Serializable {
        public InfoWrapper(Map m) {
            super(m);
        }

        @Override
        public BigDecimal balance() {
            return this.mapBigDecimal("balance");
        }

        @Override
        public int blocks() {
            return this.mapInt("blocks");
        }

        @Override
        public int connections() {
            return this.mapInt("connections");
        }

        @Override
        public BigDecimal difficulty() {
            return this.mapBigDecimal("difficulty");
        }

        @Override
        public String errors() {
            return this.mapStr("errors");
        }

        @Override
        public long keyPoolOldest() {
            return this.mapLong("keypoololdest");
        }

        @Override
        public long keyPoolSize() {
            return this.mapLong("keypoolsize");
        }

        @Override
        public BigDecimal payTxFee() {
            return this.mapBigDecimal("paytxfee");
        }

        @Override
        public long protocolVersion() {
            return this.mapLong("protocolversion");
        }

        @Override
        public String proxy() {
            return this.mapStr("proxy");
        }

        @Override
        public BigDecimal relayFee() {
            return this.mapBigDecimal("relayfee");
        }

        @Override
        public boolean testnet() {
            return this.mapBool("testnet");
        }

        @Override
        public int timeOffset() {
            return this.mapInt("timeoffset");
        }

        @Override
        public long version() {
            return this.mapLong("version");
        }

        @Override
        public long walletVersion() {
            return this.mapLong("walletversion");
        }
    }
}

