/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.javabitcoindrpcclient;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCException;
import wf.bitcoin.javabitcoindrpcclient.GenericRpcException;

public interface BitcoindRpcClient {
    public String createRawTransaction(List<TxInput> var1, List<TxOutput> var2) throws GenericRpcException;

    public String dumpPrivKey(String var1) throws GenericRpcException;

    public String getAccount(String var1) throws GenericRpcException;

    public String getAccountAddress(String var1) throws GenericRpcException;

    public List<String> getAddressesByAccount(String var1) throws GenericRpcException;

    public BigDecimal getBalance() throws GenericRpcException;

    public BigDecimal getBalance(String var1) throws GenericRpcException;

    public BigDecimal getBalance(String var1, int var2) throws GenericRpcException;

    public Info getInfo() throws GenericRpcException;

    public MiningInfo getMiningInfo() throws GenericRpcException;

    public MultiSig createMultiSig(int var1, List<String> var2) throws GenericRpcException;

    public NetworkInfo getNetworkInfo() throws GenericRpcException;

    public TxOutSetInfo getTxOutSetInfo();

    public WalletInfo getWalletInfo();

    public Block getBlock(int var1) throws GenericRpcException;

    public Block getBlock(String var1) throws GenericRpcException;

    public String getRawBlock(String var1) throws GenericRpcException;

    public String getBlockHash(int var1) throws GenericRpcException;

    public BlockChainInfo getBlockChainInfo() throws GenericRpcException;

    public int getBlockCount() throws GenericRpcException;

    public String getNewAddress() throws GenericRpcException;

    public String getNewAddress(String var1) throws GenericRpcException;

    public String getNewAddress(String var1, String var2) throws GenericRpcException;

    public List<String> getRawMemPool() throws GenericRpcException;

    public String getBestBlockHash() throws GenericRpcException;

    public RawTransaction getRawTransaction(String var1) throws GenericRpcException;

    public String getRawTransactionHex(String var1) throws GenericRpcException;

    public BigDecimal getReceivedByAddress(String var1) throws GenericRpcException;

    public BigDecimal getReceivedByAddress(String var1, int var2) throws GenericRpcException;

    public void importPrivKey(String var1) throws GenericRpcException;

    public void importPrivKey(String var1, String var2) throws GenericRpcException;

    public void importPrivKey(String var1, String var2, boolean var3) throws GenericRpcException;

    public Object importAddress(String var1, String var2, boolean var3) throws GenericRpcException;

    public Map<String, Number> listAccounts() throws GenericRpcException;

    public Map<String, Number> listAccounts(int var1) throws GenericRpcException;

    public Map<String, Number> listAccounts(int var1, boolean var2) throws GenericRpcException;

    public List<LockedUnspent> listLockUnspent();

    public List<ReceivedAddress> listReceivedByAddress() throws GenericRpcException;

    public List<ReceivedAddress> listReceivedByAddress(int var1) throws GenericRpcException;

    public List<ReceivedAddress> listReceivedByAddress(int var1, boolean var2) throws GenericRpcException;

    public TransactionsSinceBlock listSinceBlock() throws GenericRpcException;

    public TransactionsSinceBlock listSinceBlock(String var1) throws GenericRpcException;

    public TransactionsSinceBlock listSinceBlock(String var1, int var2) throws GenericRpcException;

    public List<Transaction> listTransactions() throws GenericRpcException;

    public List<Transaction> listTransactions(String var1) throws GenericRpcException;

    public List<Transaction> listTransactions(String var1, int var2) throws GenericRpcException;

    public List<Transaction> listTransactions(String var1, int var2, int var3) throws GenericRpcException;

    public List<Unspent> listUnspent() throws GenericRpcException;

    public List<Unspent> listUnspent(int var1) throws GenericRpcException;

    public List<Unspent> listUnspent(int var1, int var2) throws GenericRpcException;

    public List<Unspent> listUnspent(int var1, int var2, String ... var3) throws GenericRpcException;

    public boolean lockUnspent(boolean var1, String var2, int var3) throws GenericRpcException;

    public boolean move(String var1, String var2, BigDecimal var3) throws GenericRpcException;

    public boolean move(String var1, String var2, BigDecimal var3, String var4) throws GenericRpcException;

    public boolean move(String var1, String var2, BigDecimal var3, int var4) throws GenericRpcException;

    public boolean move(String var1, String var2, BigDecimal var3, int var4, String var5) throws GenericRpcException;

    public String sendFrom(String var1, String var2, BigDecimal var3) throws GenericRpcException;

    public String sendFrom(String var1, String var2, BigDecimal var3, int var4) throws GenericRpcException;

    public String sendFrom(String var1, String var2, BigDecimal var3, int var4, String var5) throws GenericRpcException;

    public String sendFrom(String var1, String var2, BigDecimal var3, int var4, String var5, String var6) throws GenericRpcException;

    public String sendRawTransaction(String var1) throws GenericRpcException;

    public String sendToAddress(String var1, BigDecimal var2) throws GenericRpcException;

    public String sendToAddress(String var1, BigDecimal var2, String var3) throws GenericRpcException;

    public String sendToAddress(String var1, BigDecimal var2, String var3, String var4) throws GenericRpcException;

    public String signRawTransaction(String var1, List<? extends TxInput> var2, List<String> var3) throws GenericRpcException;

    public void setGenerate(boolean var1) throws BitcoinRPCException;

    public List<String> generate(int var1) throws BitcoinRPCException;

    public List<String> generate(int var1, long var2) throws BitcoinRPCException;

    public List<String> generateToAddress(int var1, String var2) throws BitcoinRPCException;

    public AddressValidationResult validateAddress(String var1) throws GenericRpcException;

    public BigDecimal getEstimateFee(int var1) throws GenericRpcException;

    public BigDecimal getEstimatePriority(int var1) throws GenericRpcException;

    public void invalidateBlock(String var1) throws GenericRpcException;

    public void reconsiderBlock(String var1) throws GenericRpcException;

    public List<PeerInfoResult> getPeerInfo();

    public void stop();

    public String getRawChangeAddress();

    public long getConnectionCount();

    public BigDecimal getUnconfirmedBalance();

    public BigDecimal getDifficulty();

    public void ping();

    public DecodedScript decodeScript(String var1);

    public NetTotals getNetTotals();

    public boolean getGenerate();

    public BigDecimal getNetworkHashPs();

    public boolean setTxFee(BigDecimal var1);

    public void addNode(String var1, String var2);

    public void backupWallet(String var1);

    public String signMessage(String var1, String var2);

    public void dumpWallet(String var1);

    public void importWallet(String var1);

    public void keyPoolRefill();

    public BigDecimal getReceivedByAccount(String var1);

    public void encryptWallet(String var1);

    public void walletPassPhrase(String var1, long var2);

    public boolean verifyMessage(String var1, String var2, String var3);

    public String addMultiSigAddress(int var1, List<String> var2);

    public String addMultiSigAddress(int var1, List<String> var2, String var3);

    public boolean verifyChain();

    public List<NodeInfo> getAddedNodeInfo(boolean var1, String var2);

    public void submitBlock(String var1);

    public Transaction getTransaction(String var1);

    public TxOut getTxOut(String var1, long var2);

    public SmartFeeResult getEstimateSmartFee(int var1);

    public AddressBalance getAddressBalance(String var1);

    public List<AddressUtxo> getAddressUtxo(String var1);

    public static interface AddressUtxo {
        public String getAddress();

        public String getTxid();

        public int getOutputIndex();

        public String getScript();

        public long getSatoshis();

        public long getHeight();
    }

    public static interface AddressBalance {
        public long getBalance();

        public long getReceived();
    }

    public static interface SmartFeeResult
    extends Serializable {
        public BigDecimal feeRate();

        public int blocks();
    }

    public static interface PeerInfoResult
    extends Serializable {
        public long getId();

        public String getAddr();

        public String getAddrLocal();

        public String getServices();

        public long getLastSend();

        public long getLastRecv();

        public long getBytesSent();

        public long getBytesRecv();

        public long getConnTime();

        public int getTimeOffset();

        public BigDecimal getPingTime();

        public long getVersion();

        public String getSubVer();

        public boolean isInbound();

        public int getStartingHeight();

        public long getBanScore();

        public int getSyncedHeaders();

        public int getSyncedBlocks();

        public boolean isWhiteListed();
    }

    public static interface AddressValidationResult
    extends Serializable {
        public boolean isValid();

        public String address();

        public boolean isMine();

        public boolean isScript();

        public String pubKey();

        public boolean isCompressed();

        public String account();
    }

    public static interface Unspent
    extends TxInput,
    TxOutput,
    Serializable {
        public String account();

        public int confirmations();
    }

    public static interface TransactionsSinceBlock
    extends Serializable {
        public List<Transaction> transactions();

        public String lastBlock();
    }

    public static interface Transaction
    extends Serializable {
        public String account();

        public String address();

        public String category();

        public BigDecimal amount();

        public BigDecimal fee();

        public int confirmations();

        public String blockHash();

        public int blockIndex();

        public Date blockTime();

        public String txId();

        public Date time();

        public Date timeReceived();

        public String comment();

        public String commentTo();

        public boolean generated();

        public RawTransaction raw();
    }

    public static interface ReceivedAddress
    extends Serializable {
        public String address();

        public String account();

        public BigDecimal amount();

        public int confirmations();
    }

    public static interface RawTransaction
    extends Serializable {
        public String hex();

        public String txId();

        public int version();

        public long lockTime();

        public long size();

        public long vsize();

        public String hash();

        public long height();

        public List<In> vIn();

        public List<Out> vOut();

        public String blockHash();

        public Integer confirmations();

        public Date time();

        public Date blocktime();

        public static interface Out
        extends Serializable {
            public BigDecimal value();

            public int n();

            public ScriptPubKey scriptPubKey();

            public TxInput toInput();

            public RawTransaction transaction();

            public static interface ScriptPubKey
            extends Serializable {
                public String asm();

                public String hex();

                public int reqSigs();

                public String type();

                public List<String> addresses();
            }
        }

        public static interface In
        extends TxInput,
        Serializable {
            public Map<String, Object> scriptSig();

            public long sequence();

            public RawTransaction getTransaction();

            public Out getTransactionOutput();

            public String address();
        }
    }

    public static interface TxOutSetInfo
    extends Serializable {
        public long height();

        public String bestBlock();

        public long transactions();

        public long txouts();

        public long bytesSerialized();

        public String hashSerialized();

        public BigDecimal totalAmount();
    }

    public static interface Block
    extends Serializable {
        public String hash();

        public int confirmations();

        public int size();

        public int height();

        public int version();

        public String merkleRoot();

        public List<String> tx();

        public Date time();

        public long nonce();

        public String bits();

        public BigDecimal difficulty();

        public String previousHash();

        public String nextHash();

        public String chainwork();

        public Block previous() throws GenericRpcException;

        public Block next() throws GenericRpcException;
    }

    public static interface TxOut
    extends Serializable {
        public String bestBlock();

        public long confirmations();

        public BigDecimal value();

        public String asm();

        public String hex();

        public long reqSigs();

        public String type();

        public List<String> addresses();

        public long version();

        public boolean coinBase();
    }

    public static interface LockedUnspent
    extends Serializable {
        public String txId();

        public int vout();
    }

    public static interface Address
    extends Serializable {
        public String address();

        public String connected();
    }

    public static interface NodeInfo
    extends Serializable {
        public String addedNode();

        public boolean connected();

        public List<Address> addresses();
    }

    public static interface MultiSig
    extends Serializable {
        public String address();

        public String redeemScript();
    }

    public static interface Network
    extends Serializable {
        public String name();

        public boolean limited();

        public boolean reachable();

        public String proxy();

        public boolean proxyRandomizeCredentials();
    }

    public static interface NetworkInfo
    extends Serializable {
        public long version();

        public String subversion();

        public long protocolVersion();

        public String localServices();

        public boolean localRelay();

        public long timeOffset();

        public long connections();

        public List<Network> networks();

        public BigDecimal relayFee();

        public List<String> localAddresses();

        public String warnings();
    }

    public static interface WalletInfo
    extends Serializable {
        public long walletVersion();

        public BigDecimal balance();

        public BigDecimal unconfirmedBalance();

        public BigDecimal immatureBalance();

        public long txCount();

        public long keyPoolOldest();

        public long keyPoolSize();

        public long unlockedUntil();

        public BigDecimal payTxFee();

        public String hdMasterKeyId();
    }

    public static interface DecodedScript
    extends Serializable {
        public String asm();

        public String hex();

        public String type();

        public int reqSigs();

        public List<String> addresses();

        public String p2sh();
    }

    public static interface BlockChainInfo
    extends Serializable {
        public String chain();

        public int blocks();

        public String bestBlockHash();

        public BigDecimal difficulty();

        public BigDecimal verificationProgress();

        public String chainWork();
    }

    public static interface NetTotals
    extends Serializable {
        public long totalBytesRecv();

        public long totalBytesSent();

        public long timeMillis();

        public uploadTarget uploadTarget();

        public static interface uploadTarget
        extends Serializable {
            public long timeFrame();

            public int target();

            public boolean targetReached();

            public boolean serveHistoricalBlocks();

            public long bytesLeftInCycle();

            public long timeLeftInCycle();
        }
    }

    public static interface MiningInfo
    extends Serializable {
        public int blocks();

        public int currentBlockSize();

        public int currentBlockWeight();

        public int currentBlockTx();

        public BigDecimal difficulty();

        public String errors();

        public BigDecimal networkHashps();

        public int pooledTx();

        public boolean testNet();

        public String chain();
    }

    public static interface Info
    extends Serializable {
        public long version();

        public long protocolVersion();

        public long walletVersion();

        public BigDecimal balance();

        public int blocks();

        public int timeOffset();

        public int connections();

        public String proxy();

        public BigDecimal difficulty();

        public boolean testnet();

        public long keyPoolOldest();

        public long keyPoolSize();

        public BigDecimal payTxFee();

        public BigDecimal relayFee();

        public String errors();
    }

    public static class BasicTxOutput
    implements TxOutput {
        public final String address;
        public final BigDecimal amount;
        public final byte[] data;

        public BasicTxOutput(String address, BigDecimal amount) {
            this(address, amount, null);
        }

        public BasicTxOutput(String address, BigDecimal amount, byte[] data) {
            this.address = address;
            this.amount = amount;
            this.data = data;
        }

        @Override
        public String address() {
            return this.address;
        }

        @Override
        public BigDecimal amount() {
            return this.amount;
        }

        @Override
        public byte[] data() {
            return this.data;
        }
    }

    public static interface TxOutput
    extends Serializable {
        public String address();

        public BigDecimal amount();

        public byte[] data();
    }

    public static class ExtendedTxInput
    extends BasicTxInput {
        public String redeemScript;
        public BigDecimal amount;

        public ExtendedTxInput(String txid, int vout) {
            super(txid, vout);
        }

        public ExtendedTxInput(String txid, int vout, String scriptPubKey) {
            super(txid, vout, scriptPubKey);
        }

        public ExtendedTxInput(String txid, int vout, String scriptPubKey, String redeemScript, BigDecimal amount) {
            super(txid, vout, scriptPubKey);
            this.redeemScript = redeemScript;
            this.amount = amount;
        }

        public String redeemScript() {
            return this.redeemScript;
        }

        public BigDecimal amount() {
            return this.amount;
        }
    }

    public static class BasicTxInput
    implements TxInput {
        public String txid;
        public Integer vout;
        public String scriptPubKey;

        public BasicTxInput(String txid, Integer vout) {
            this.txid = txid;
            this.vout = vout;
        }

        public BasicTxInput(String txid, Integer vout, String scriptPubKey) {
            this(txid, vout);
            this.scriptPubKey = scriptPubKey;
        }

        @Override
        public String txid() {
            return this.txid;
        }

        @Override
        public Integer vout() {
            return this.vout;
        }

        @Override
        public String scriptPubKey() {
            return this.scriptPubKey;
        }
    }

    public static interface TxInput
    extends Serializable {
        public String txid();

        public Integer vout();

        public String scriptPubKey();
    }
}

