/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.javabitcoindrpcclient;

import java.util.Map;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCError;
import wf.bitcoin.javabitcoindrpcclient.GenericRpcException;
import wf.bitcoin.krotjson.JSON;

public class BitcoinRPCException
extends GenericRpcException {
    private String rpcMethod;
    private String rpcParams;
    private int responseCode;
    private String responseMessage;
    private String response;
    private BitcoinRPCError rpcError;

    public BitcoinRPCException(String method, String params, int responseCode, String responseMessage, String response) {
        super("RPC Query Failed (method: " + method + ", params: " + params + ", response code: " + responseCode + " responseMessage " + responseMessage + ", response: " + response);
        Map error;
        this.rpcMethod = method;
        this.rpcParams = params;
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.response = response;
        if (responseCode == 500 && (error = (Map)((Map)JSON.parse(response)).get("error")) != null) {
            this.rpcError = new BitcoinRPCError(error);
        }
    }

    public BitcoinRPCException(String method, String params, Throwable cause) {
        super("RPC Query Failed (method: " + method + ", params: " + params + ")", cause);
        this.rpcMethod = method;
        this.rpcParams = params;
    }

    public BitcoinRPCException(String msg) {
        super(msg);
    }

    public BitcoinRPCException(BitcoinRPCError error) {
        super(error.getMessage());
        this.rpcError = error;
    }

    public BitcoinRPCException(String message, Throwable cause) {
        super(message, cause);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getRpcMethod() {
        return this.rpcMethod;
    }

    public String getRpcParams() {
        return this.rpcParams;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getResponse() {
        return this.response;
    }

    public BitcoinRPCError getRPCError() {
        return this.rpcError;
    }
}

