/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.StringTokenizer;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.util.IO;
import net.lightbody.bmp.proxy.jetty.util.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextLoader
extends URLClassLoader {
    private final Logger log;
    private final HttpContext _context;
    private boolean _java2compliant;
    private ClassLoader _parent;
    private PermissionCollection _permissions;
    private String _urlClassPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLoader(HttpContext context, String classPath, ClassLoader parent, PermissionCollection permissions) throws IOException {
        block7: {
            block6: {
                super(new URL[0], parent);
                this.log = LoggerFactory.getLogger(ContextLoader.class);
                this._java2compliant = false;
                this._context = context;
                this._permissions = permissions;
                this._parent = parent;
                if (this._parent == null) {
                    this._parent = ContextLoader.getSystemClassLoader();
                }
                if (classPath != null) break block6;
                this._urlClassPath = "";
                break block7;
            }
            StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
            while (tokenizer.hasMoreTokens()) {
                URL url;
                Resource resource;
                block8: {
                    resource = Resource.newResource(tokenizer.nextToken());
                    this.log.debug("Path resource={}", (Object)resource);
                    File file = resource.getFile();
                    if (file != null) {
                        url = resource.getURL();
                        this.addURL(url);
                        this._urlClassPath = this._urlClassPath == null ? url.toString() : this._urlClassPath + "," + url.toString();
                        continue;
                    }
                    if (resource.isDirectory() || file != null) break block8;
                    InputStream in = resource.getInputStream();
                    File lib = new File(context.getTempDirectory(), "lib");
                    if (!lib.exists()) {
                        lib.mkdir();
                        lib.deleteOnExit();
                    }
                    File jar = File.createTempFile("Jetty-", ".jar", lib);
                    jar.deleteOnExit();
                    this.log.debug("Extract {} to {}", (Object)resource, (Object)jar);
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(jar);
                        IO.copy(in, out);
                    }
                    catch (Throwable throwable) {
                        IO.close(out);
                        throw throwable;
                    }
                    IO.close(out);
                    URL url2 = jar.toURL();
                    this.addURL(url2);
                    this._urlClassPath = this._urlClassPath == null ? url2.toString() : this._urlClassPath + "," + url2.toString();
                    continue;
                }
                url = resource.getURL();
                this.addURL(url);
                this._urlClassPath = this._urlClassPath == null ? url.toString() : this._urlClassPath + "," + url.toString();
            }
        }
        this.log.debug("ClassPath={}", (Object)this._urlClassPath);
        this.log.debug("Permissions={}", (Object)this._permissions);
        this.log.debug("URL=" + Arrays.asList(this.getURLs()));
    }

    public boolean isJava2Compliant() {
        return this._java2compliant;
    }

    public void setJava2Compliant(boolean compliant) {
        this._java2compliant = compliant;
    }

    public String toString() {
        return "ContextLoader@" + this.hashCode() + "(" + this._urlClassPath + ")\n  --parent--> " + this._parent.toString();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection pc = this._permissions == null ? super.getPermissions(cs) : this._permissions;
        this.log.debug("loader.getPermissions({})={}", (Object)cs, (Object)pc);
        return pc;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        boolean tried_parent = false;
        if (c == null && (this._java2compliant || this.isSystemPath(name)) && !this.isServerPath(name) && this._parent != null) {
            this.log.trace("try loadClass {} from {}", (Object)name, (Object)this._parent);
            tried_parent = true;
            try {
                c = this._parent.loadClass(name);
                this.log.trace("p0 loaded {}", c);
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null) {
            this.log.trace("try findClass {} from {}", (Object)name, (Object)this._urlClassPath);
            try {
                c = this.findClass(name);
                this.log.trace("cx loaded {}", c);
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null && !tried_parent && !this.isServerPath(name) && this._parent != null) {
            this.log.trace("try loadClass {} name {}", (Object)name, (Object)this._parent);
            c = this._parent.loadClass(name);
            this.log.trace("p1 loaded {}", c);
        }
        if (c == null) {
            throw ex;
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        boolean tried_parent = false;
        if (this._parent != null && (this._java2compliant || this.isSystemPath(name))) {
            this.log.trace("try getResource {} from {}", (Object)name, (Object)this._parent);
            tried_parent = true;
            url = this._parent.getResource(name);
        }
        if (url == null) {
            this.log.trace("try findResource {} from {}", (Object)name, (Object)this._urlClassPath);
            url = this.findResource(name);
            if (url == null && name.startsWith("/")) {
                this.log.debug("HACK leading / off {}", (Object)name);
                url = this.findResource(name.substring(1));
            }
        }
        if (this._parent != null && url == null && !tried_parent) {
            this.log.trace("try getResource {} from {}", (Object)name, (Object)this._parent);
            url = this._parent.getResource(name);
        }
        if (url != null) {
            this.log.trace("found {}", url);
        }
        return url;
    }

    public boolean isServerPath(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        String[] server_classes = this._context.getServerClasses();
        if (server_classes != null) {
            for (String server_class : server_classes) {
                boolean result = true;
                String c = server_class;
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    result = false;
                }
                if (!(c.endsWith(".") ? name.startsWith(c) : name.equals(c))) continue;
                return result;
            }
        }
        return false;
    }

    public boolean isSystemPath(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        String[] system_classes = this._context.getSystemClasses();
        if (system_classes != null) {
            for (String system_class : system_classes) {
                boolean result = true;
                String c = system_class;
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    result = false;
                }
                if (!(c.endsWith(".") ? name.startsWith(c) : name.equals(c))) continue;
                return result;
            }
        }
        return false;
    }

    public void destroy() {
        this._parent = null;
        this._permissions = null;
        this._urlClassPath = null;
    }

    String[] getServerClasses() {
        return this._context.getServerClasses();
    }

    void setServerClasses(String[] serverClasses) {
        this._context.setServerClasses(serverClasses);
    }

    String[] getSystemClasses() {
        return this._context.getSystemClasses();
    }

    void setSystemClasses(String[] systemClasses) {
        this._context.setSystemClasses(systemClasses);
    }
}

