/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarCookie;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarNameValuePair;
import net.lightbody.bmp.core.har.HarPostData;
import net.lightbody.bmp.core.har.HarPostDataParam;
import net.lightbody.bmp.core.har.HarRequest;
import net.lightbody.bmp.core.har.HarResponse;
import net.lightbody.bmp.core.har.HarTimings;
import net.lightbody.bmp.proxy.http.BadURIException;
import net.lightbody.bmp.proxy.http.BlankCookieStore;
import net.lightbody.bmp.proxy.http.BrowserMobHostNameResolver;
import net.lightbody.bmp.proxy.http.HttpClientInterrupter;
import net.lightbody.bmp.proxy.http.RequestInfo;
import net.lightbody.bmp.proxy.http.SimulatedRequestExecutor;
import net.lightbody.bmp.proxy.http.SimulatedSocketFactory;
import net.lightbody.bmp.proxy.http.TrustingSSLSocketFactory;
import net.lightbody.bmp.proxy.http.WildcardMatchingCredentialsProvider;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.util.Base64;
import net.lightbody.bmp.proxy.util.CappedByteArrayOutputStream;
import net.lightbody.bmp.proxy.util.ClonedOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Cache;
import website.magyar.mitm.proxy.ProxyServer;
import website.magyar.mitm.proxy.RequestInterceptor;
import website.magyar.mitm.proxy.ResponseInterceptor;
import website.magyar.mitm.proxy.http.MitmJavaProxyHttpRequest;
import website.magyar.mitm.proxy.http.MitmJavaProxyHttpResponse;

public class BrowserMobHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowserMobHttpClient.class);
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final int BUFFER = 4096;
    private static final int MAX_REDIRECT = 10;
    private final List<RewriteRule> rewriteRules = new CopyOnWriteArrayList<RewriteRule>();
    private final List<RequestInterceptor> requestInterceptors = new CopyOnWriteArrayList<RequestInterceptor>();
    private final List<ResponseInterceptor> responseInterceptors = new CopyOnWriteArrayList<ResponseInterceptor>();
    private final HashMap<String, String> additionalHeaders = new LinkedHashMap<String, String>();
    private final AtomicBoolean allowNewRequests = new AtomicBoolean(true);
    private final Set<ActiveRequest> activeRequests = new HashSet<ActiveRequest>();
    private Har har;
    private String harPageRef;
    private boolean captureHeaders;
    private boolean captureContent;
    private boolean captureBinaryContent = true;
    private final SimulatedSocketFactory socketFactory;
    private final TrustingSSLSocketFactory sslSocketFactory;
    private final PoolingHttpClientConnectionManager httpClientConnMgr;
    private final HttpClient httpClient;
    private int requestTimeout;
    private BrowserMobHostNameResolver hostNameResolver;
    private boolean decompress = true;
    private WildcardMatchingCredentialsProvider credsProvider;
    private boolean shutdown = false;
    private boolean followRedirects = true;
    private AtomicInteger requestCounter;

    public BrowserMobHttpClient(AtomicInteger requestCounter, int requestTimeOut) {
        this.requestCounter = requestCounter;
        this.requestTimeout = requestTimeOut;
        this.hostNameResolver = new BrowserMobHostNameResolver(new Cache(255));
        this.socketFactory = new SimulatedSocketFactory(this.hostNameResolver, this.requestTimeout);
        try {
            this.sslSocketFactory = new TrustingSSLSocketFactory(this.requestTimeout);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)this.socketFactory).register("https", (Object)this.sslSocketFactory).build();
        this.httpClientConnMgr = new PoolingHttpClientConnectionManager(registry){

            public ConnectionRequest requestConnection(HttpRoute route, Object state) {
                final ConnectionRequest wrapped = super.requestConnection(route, state);
                return new ConnectionRequest(){

                    public boolean cancel() {
                        return wrapped.cancel();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public HttpClientConnection get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, ConnectionPoolTimeoutException {
                        Date start = new Date();
                        try {
                            HttpClientConnection httpClientConnection = wrapped.get(timeout, timeUnit);
                            return httpClientConnection;
                        }
                        finally {
                            RequestInfo.get().blocked(start, new Date());
                        }
                    }
                };
            }
        };
        this.httpClientConnMgr.setMaxTotal(30);
        this.httpClientConnMgr.setDefaultMaxPerRoute(6);
        this.credsProvider = new WildcardMatchingCredentialsProvider();
        this.httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslSocketFactory).setConnectionManager((HttpClientConnectionManager)this.httpClientConnMgr).setRequestExecutor((HttpRequestExecutor)new SimulatedRequestExecutor()).setDefaultCredentialsProvider((CredentialsProvider)this.credsProvider).addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuth()).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).setDefaultCookieStore((CookieStore)new BlankCookieStore()).setDefaultCookieSpecRegistry((Lookup)RegistryBuilder.create().register("easy", (Object)new CookieSpecProvider(){

            public CookieSpec create(HttpContext context) {
                return new BrowserCompatSpec(){

                    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                    }
                };
            }
        }).build()).disableRedirectHandling().setConnectionTimeToLive((long)requestTimeOut, TimeUnit.MILLISECONDS).build();
        HttpClientInterrupter.watch(this);
    }

    public void remapHost(String source, String target) {
        this.hostNameResolver.remap(source, target);
    }

    public void addRequestInterceptor(RequestInterceptor interceptor) {
        this.requestInterceptors.add(interceptor);
    }

    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        this.responseInterceptors.add(interceptor);
    }

    public MitmJavaProxyHttpRequest newPost(String url, HttpRequest proxyRequest) {
        try {
            URI uri = this.makeUri(url);
            return new MitmJavaProxyHttpRequest((HttpRequestBase)new HttpPost(uri), this, -1, this.captureContent, proxyRequest);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "POST");
        }
    }

    public MitmJavaProxyHttpRequest newGet(String url, HttpRequest proxyRequest) {
        try {
            URI uri = this.makeUri(url);
            return new MitmJavaProxyHttpRequest((HttpRequestBase)new HttpGet(uri), this, -1, this.captureContent, proxyRequest);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "GET");
        }
    }

    public MitmJavaProxyHttpRequest newPut(String url, HttpRequest proxyRequest) {
        try {
            URI uri = this.makeUri(url);
            return new MitmJavaProxyHttpRequest((HttpRequestBase)new HttpPut(uri), this, -1, this.captureContent, proxyRequest);
        }
        catch (Exception e) {
            throw this.reportBadURI(url, "PUT");
        }
    }

    public MitmJavaProxyHttpRequest newDelete(String url, HttpRequest proxyRequest) {
        try {
            URI uri = this.makeUri(url);
            return new MitmJavaProxyHttpRequest((HttpRequestBase)new HttpDelete(uri), this, -1, this.captureContent, proxyRequest);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "DELETE");
        }
    }

    public MitmJavaProxyHttpRequest newOptions(String url, HttpRequest proxyRequest) {
        try {
            URI uri = this.makeUri(url);
            return new MitmJavaProxyHttpRequest((HttpRequestBase)new HttpOptions(uri), this, -1, this.captureContent, proxyRequest);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "OPTIONS");
        }
    }

    public MitmJavaProxyHttpRequest newHead(String url, HttpRequest proxyRequest) {
        try {
            URI uri = this.makeUri(url);
            return new MitmJavaProxyHttpRequest((HttpRequestBase)new HttpHead(uri), this, -1, this.captureContent, proxyRequest);
        }
        catch (URISyntaxException e) {
            throw this.reportBadURI(url, "HEAD");
        }
    }

    private URI makeUri(String url) throws URISyntaxException {
        url = url.replace(" ", "%20");
        url = url.replace(">", "%3C");
        url = url.replace("<", "%3E");
        url = url.replace("#", "%23");
        url = url.replace("{", "%7B");
        url = url.replace("}", "%7D");
        url = url.replace("|", "%7C");
        url = url.replace("\\", "%5C");
        url = url.replace("^", "%5E");
        url = url.replace("~", "%7E");
        url = url.replace("[", "%5B");
        url = url.replace("]", "%5D");
        url = url.replace("`", "%60");
        URI uri = new URI(url = url.replace("\"", "%22"));
        if (uri.getPort() == 80 && "http".equals(uri.getScheme()) || uri.getPort() == 443 && "https".equals(uri.getScheme())) {
            StringBuilder sb = new StringBuilder(uri.getScheme()).append("://");
            if (uri.getRawUserInfo() != null) {
                sb.append(uri.getRawUserInfo()).append("@");
            }
            sb.append(uri.getHost());
            if (uri.getRawPath() != null) {
                sb.append(uri.getRawPath());
            }
            if (uri.getRawQuery() != null) {
                sb.append("?").append(uri.getRawQuery());
            }
            if (uri.getRawFragment() != null) {
                sb.append("#").append(uri.getRawFragment());
            }
            uri = new URI(sb.toString());
        }
        return uri;
    }

    private RuntimeException reportBadURI(String url, String method) {
        if (this.har != null && this.harPageRef != null) {
            HarEntry entry = new HarEntry(this.harPageRef, MitmJavaProxyHttpRequest.TIME_STAMP_BASED_ID_GENERATOR.nextIdentifier());
            entry.setTime(0L);
            entry.setRequest(new HarRequest(method, url, "HTTP/1.1"));
            entry.setResponse(new HarResponse(-998, "Bad URI", "HTTP/1.1"));
            entry.setTimings(new HarTimings());
            this.har.getLog().addEntry(entry);
        }
        throw new BadURIException("Bad URI requested: " + url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTimeout() {
        Set<ActiveRequest> set = this.activeRequests;
        synchronized (set) {
            for (ActiveRequest activeRequest : this.activeRequests) {
                activeRequest.checkTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MitmJavaProxyHttpResponse execute(MitmJavaProxyHttpRequest req) {
        if (!this.allowNewRequests.get()) {
            throw new RuntimeException("No more requests allowed");
        }
        try {
            boolean isResponseVolatile = ProxyServer.getResponseVolatile();
            req.setResponseVolatile(isResponseVolatile);
            this.requestCounter.incrementAndGet();
            for (RequestInterceptor mitmJavaProxyHttpResponse : this.requestInterceptors) {
                mitmJavaProxyHttpResponse.process(req);
            }
            isResponseVolatile = req.getResponseVolatile();
            MitmJavaProxyHttpResponse response = this.execute(req, 1, isResponseVolatile);
            for (ResponseInterceptor interceptor : this.responseInterceptors) {
                interceptor.process(response);
            }
            if (isResponseVolatile) {
                HttpResponse httpResponse = req.getProxyRequest().getHttpConnection().getResponse();
                response.doAnswer(httpResponse);
            }
            MitmJavaProxyHttpResponse mitmJavaProxyHttpResponse = response;
            return mitmJavaProxyHttpResponse;
        }
        finally {
            this.requestCounter.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private MitmJavaProxyHttpResponse execute(MitmJavaProxyHttpRequest req, int depth, boolean isResponseVolatile) {
        if (depth >= 10) {
            throw new IllegalStateException("Max number of redirects (10) reached");
        }
        callback = req.getRequestCallback();
        method = req.getMethod();
        url = method.getURI().toString();
        rewrote = false;
        newUrl = url;
        for (RewriteRule rule : this.rewriteRules) {
            matcher = rule.match.matcher(newUrl);
            newUrl = matcher.replaceAll(rule.replace);
            rewrote = true;
        }
        if (rewrote) {
            try {
                method.setURI(new URI(newUrl));
                url = newUrl;
            }
            catch (URISyntaxException e) {
                BrowserMobHttpClient.LOGGER.warn("Could not rewrite url to {}", (Object)newUrl);
            }
        }
        if (!this.additionalHeaders.isEmpty()) {
            for (Map.Entry<String, String> entry : this.additionalHeaders.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                method.removeHeaders(key);
                method.addHeader(key, value);
            }
        }
        charSet = "UTF-8";
        is = null;
        statusCode = -998;
        bytes = 0L;
        gzipping = false;
        deflating = false;
        os = req.getOutputStream();
        if (os == null) {
            os = new CappedByteArrayOutputStream(0x100000);
        }
        entry = new HarEntry(this.harPageRef, req.getMessageId());
        RequestInfo.clear(url, entry);
        entry.setRequest(new HarRequest(method.getMethod(), url, method.getProtocolVersion().getProtocol()));
        entry.setResponse(new HarResponse(-999, "NO RESPONSE", method.getProtocolVersion().getProtocol()));
        if (this.har != null && this.harPageRef != null) {
            this.har.getLog().addEntry(entry);
        }
        errorMessage = null;
        response = null;
        ctx = new BasicHttpContext();
        activeRequest = new ActiveRequest(method, ctx, entry.getStartedDateTime());
        var22_24 = this.activeRequests;
        synchronized (var22_24) {
            this.activeRequests.add(activeRequest);
        }
        statusLine = null;
        bos = null;
        try {
            if (method.getHeaders("User-Agent").length == 0) {
                method.addHeader("User-Agent", "MITM-JavaProxy V/1.0");
            }
            response = this.httpClient.execute((HttpUriRequest)method, (HttpContext)ctx);
            statusLine = response.getStatusLine();
            statusCode = statusLine.getStatusCode();
            if (callback != null) {
                callback.handleStatusLine(statusLine);
                callback.handleHeaders(response.getAllHeaders());
            }
            if (response.getEntity() != null) {
                is = response.getEntity().getContent();
            }
            if (is != null) {
                contentEncodingHeader /* !! */  = response.getFirstHeader("Content-Encoding");
                if (contentEncodingHeader /* !! */  != null) {
                    if ("gzip".equalsIgnoreCase(contentEncodingHeader /* !! */ .getValue())) {
                        gzipping = true;
                    } else if ("deflate".equalsIgnoreCase(contentEncodingHeader /* !! */ .getValue())) {
                        deflating = true;
                    }
                }
                if (this.decompress && response.getEntity().getContentLength() != 0L) {
                    if (gzipping) {
                        is = new GZIPInputStream(is);
                    } else if (deflating) {
                        is = new InflaterInputStream(is, new Inflater(true));
                    }
                }
                if (isResponseVolatile) {
                    bytes = is.available();
                    bos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)is, (OutputStream)bos);
                } else {
                    if (this.captureContent) {
                        os = new ClonedOutputStream(os);
                    }
                    bytes = this.copyWithStatsDynamic(is, os);
                }
            }
        }
        catch (Exception e) {
            errorMessage = e.toString();
            BrowserMobHttpClient.LOGGER.debug("EX @ call to server from proxy.", (Throwable)e);
            if (callback != null) {
                if (activeRequest.wasTimeout) {
                    e /* !! */  = new ConnectTimeoutException();
                }
                callback.reportError((Exception)e /* !! */ );
            }
            if (!this.shutdown) {
                BrowserMobHttpClient.LOGGER.info("{} when requesting {}", (Object)errorMessage, (Object)url);
            }
        }
        finally {
            e /* !! */  = this.activeRequests;
            synchronized (e /* !! */ ) {
                this.activeRequests.remove(activeRequest);
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        RequestInfo.get().finish();
        entry.setStartedDateTime(RequestInfo.get().getStart());
        entry.setTimings(RequestInfo.get().getTimings());
        entry.setServerIPAddress(RequestInfo.get().getResolvedAddress());
        entry.setTime(RequestInfo.get().getTotalTime());
        entry.getResponse().setBodySize(bytes);
        entry.getResponse().getContent().setSize(bytes);
        entry.getResponse().setStatus(statusCode);
        if (statusLine != null) {
            entry.getResponse().setStatusText(statusLine.getReasonPhrase());
        }
        urlEncoded = false;
        if (this.captureHeaders || this.captureContent) {
            for (Header header : method.getAllHeaders()) {
                if (header.getValue() != null && header.getValue().startsWith("application/x-www-form-urlencoded")) {
                    urlEncoded = true;
                }
                entry.getRequest().getHeaders().add(new HarNameValuePair(header.getName(), header.getValue()));
            }
            if (response != null) {
                for (Header header : response.getAllHeaders()) {
                    entry.getResponse().getHeaders().add(new HarNameValuePair(header.getName(), header.getValue()));
                }
            }
        }
        if (this.captureContent && method instanceof HttpEntityEnclosingRequestBase && req.getCopy() != null) {
            enclosingReq = (HttpEntityEnclosingRequestBase)method;
            entity = enclosingReq.getEntity();
            data = new HarPostData();
            data.setMimeType(req.getMethod().getFirstHeader("Content-Type").getValue());
            entry.getRequest().setPostData(data);
            if (urlEncoded || URLEncodedUtils.isEncoded((HttpEntity)entity)) {
                try {
                    content = new String(req.getCopy().toByteArray(), "UTF-8");
                    if (content == null || content.length() <= 0) ** GOTO lbl163
                    result = new ArrayList<E>();
                    URLEncodedUtils.parse(result, (Scanner)new Scanner(content), null);
                    params = new ArrayList<HarPostDataParam>();
                    data.setParams(params);
                    for (NameValuePair pair : result) {
                        params.add(new HarPostDataParam(pair.getName(), pair.getValue()));
                    }
                }
                catch (Exception e) {
                    BrowserMobHttpClient.LOGGER.info("Unexpected problem when parsing input copy", (Throwable)e);
                }
            } else {
                data.setText(new String(req.getCopy().toByteArray()));
            }
        }
lbl163:
        // 7 sources

        for (javax.servlet.http.Cookie cookie : cookies = req.getProxyRequest().getCookies()) {
            hc = new HarCookie();
            hc.setName(cookie.getName());
            hc.setValue(cookie.getValue());
            entry.getRequest().getCookies().add(hc);
        }
        contentType = null;
        if (response != null && (contentTypeHdr = response.getFirstHeader("Content-Type")) != null) {
            contentType = contentTypeHdr.getValue();
            entry.getResponse().getContent().setMimeType(contentType);
            copy = null;
            enableWorkWithCopy = false;
            if (!isResponseVolatile && this.captureContent && os instanceof ClonedOutputStream) {
                copy = ((ClonedOutputStream)os).getOutput();
                enableWorkWithCopy = true;
            }
            if (isResponseVolatile && this.captureContent && bos != null) {
                enableWorkWithCopy = true;
                copy = bos;
            }
            if (this.captureContent && enableWorkWithCopy) {
                if (entry.getResponse().getBodySize() != 0L && (gzipping || deflating)) {
                    try {
                        temp /* !! */  = null;
                        if (gzipping) {
                            temp /* !! */  = new GZIPInputStream(new ByteArrayInputStream(copy.toByteArray()));
                        } else if (deflating) {
                            temp /* !! */  = new InflaterInputStream(new ByteArrayInputStream(copy.toByteArray()), new Inflater(true));
                        }
                        copy = new ByteArrayOutputStream();
                        net.lightbody.bmp.proxy.util.IOUtils.copy(temp /* !! */ , copy);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (contentType != null && (contentType.startsWith("text/") || contentType.startsWith("application/x-javascript")) || contentType.startsWith("application/javascript") || contentType.startsWith("application/json") || contentType.startsWith("application/xml") || contentType.startsWith("application/xhtml+xml") || contentType.startsWith("application/soap+xml")) {
                    entry.getResponse().getContent().setText(new String(copy.toByteArray()));
                } else if (this.captureBinaryContent) {
                    entry.getResponse().getContent().setText(Base64.byteArrayToBase64(copy.toByteArray()));
                }
            }
            if ((nvp = contentTypeHdr.getElements()[0].getParameterByName("charset")) != null) {
                charSet = nvp.getValue();
            }
        }
        if (contentType != null) {
            entry.getResponse().getContent().setMimeType(contentType);
        }
        isRedirect = false;
        location = null;
        if (response != null && statusCode >= 300 && statusCode < 400 && statusCode != 304) {
            isRedirect = true;
            locationHeader = response.getLastHeader("location");
            if (locationHeader != null) {
                location = locationHeader.getValue();
            } else if (this.followRedirects) {
                throw new RuntimeException("Invalid redirect - missing location header");
            }
        }
        if ((expectedStatusCode = req.getExpectedStatusCode()) > -1) {
            if (this.followRedirects) {
                throw new RuntimeException("Response validation cannot be used while following redirects");
            }
            if (expectedStatusCode != statusCode) {
                if (isRedirect) {
                    throw new RuntimeException("Expected status code of " + expectedStatusCode + " but saw " + statusCode + " redirecting to: " + location);
                }
                throw new RuntimeException("Expected status code of " + expectedStatusCode + " but saw " + statusCode);
            }
        }
        if (isRedirect && req.getExpectedLocation() != null) {
            if (this.followRedirects) {
                throw new RuntimeException("Response validation cannot be used while following redirects");
            }
            if (location.compareTo(req.getExpectedLocation()) != 0) {
                throw new RuntimeException("Expected a redirect to  " + req.getExpectedLocation() + " but saw " + location);
            }
        }
        if (isRedirect && this.followRedirects) {
            try {
                redirectUri = new URI(location);
                newUri = method.getURI().resolve(redirectUri);
                method.setURI(newUri);
                return this.execute(req, ++depth, isResponseVolatile);
            }
            catch (URISyntaxException e) {
                BrowserMobHttpClient.LOGGER.warn("Could not parse URL", (Throwable)e);
            }
        }
        return new MitmJavaProxyHttpResponse(statusCode, entry, method, req.getProxyRequest().getURI(), response, errorMessage, entry.getResponse().getContent().getText(), contentType, charSet, bos, os, isResponseVolatile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyWithStatsDynamic(InputStream is, OutputStream os) throws IOException {
        long bytesCopied = 0L;
        byte[] buffer = new byte[4096];
        try {
            int length;
            int firstByte = is.read();
            if (firstByte == -1) {
                long l = 0L;
                return l;
            }
            os.write(firstByte);
            ++bytesCopied;
            do {
                if ((length = is.read(buffer, 0, 4096)) == -1) continue;
                bytesCopied += (long)length;
                os.write(buffer, 0, length);
                os.flush();
            } while (length != -1);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        return bytesCopied;
    }

    public void shutdown() {
        this.shutdown = true;
        this.abortActiveRequests();
        this.rewriteRules.clear();
        this.credsProvider.clear();
        this.httpClientConnMgr.shutdown();
        HttpClientInterrupter.release(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortActiveRequests() {
        this.allowNewRequests.set(true);
        Set<ActiveRequest> set = this.activeRequests;
        synchronized (set) {
            for (ActiveRequest activeRequest : this.activeRequests) {
                activeRequest.abort();
            }
            this.activeRequests.clear();
        }
    }

    public void setHarPageRef(String harPageRef) {
        this.harPageRef = harPageRef;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void rewriteUrl(String match, String replace) {
        this.rewriteRules.add(new RewriteRule(match, replace));
    }

    public void addHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    public String remappedHost(String host) {
        return this.hostNameResolver.remapping(host);
    }

    public List<String> originalHosts(String host) {
        return this.hostNameResolver.original(host);
    }

    public Har getHar() {
        return this.har;
    }

    public void setHar(Har har) {
        this.har = har;
    }

    public void setCaptureHeaders(boolean captureHeaders) {
        this.captureHeaders = captureHeaders;
    }

    public void setCaptureContent(boolean captureContent) {
        this.captureContent = captureContent;
    }

    public void setCaptureBinaryContent(boolean captureBinaryContent) {
        this.captureBinaryContent = captureBinaryContent;
    }

    public void setHttpProxy(String httpProxy) {
        String host = httpProxy.split(":")[0];
        Integer port = Integer.parseInt(httpProxy.split(":")[1]);
        HttpHost proxy = new HttpHost(host, port.intValue());
        this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }

    public void clearDNSCache() {
        this.hostNameResolver.clearCache();
    }

    public void setDNSCacheTimeout(int timeout) {
        this.hostNameResolver.setCacheTimeout(timeout);
    }

    public void prepareForBrowser() {
        this.decompress = false;
        this.setFollowRedirects(false);
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        PreemptiveAuth() {
        }

        public void process(org.apache.http.HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                Credentials creds;
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null && (creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                    authState.setAuthScheme(authScheme);
                    authState.setCredentials(creds);
                }
            }
        }
    }

    class ActiveRequest {
        HttpRequestBase request;
        BasicHttpContext ctx;
        Date start;
        boolean wasTimeout;

        ActiveRequest(HttpRequestBase request, BasicHttpContext ctx, Date start) {
            this.request = request;
            this.ctx = ctx;
            this.start = start;
            this.wasTimeout = false;
        }

        void checkTimeout() {
            if (BrowserMobHttpClient.this.requestTimeout != -1 && this.request != null && this.start != null && new Date(System.currentTimeMillis() - (long)BrowserMobHttpClient.this.requestTimeout).after(this.start)) {
                LOGGER.info("Aborting request to {} after it failed to complete in {} ms", (Object)this.request.getURI().toString(), (Object)BrowserMobHttpClient.this.requestTimeout);
                this.wasTimeout = true;
                this.abort();
            }
        }

        public void abort() {
            this.request.abort();
            HttpConnection conn = (HttpConnection)this.ctx.getAttribute("http.connection");
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private class RewriteRule {
        private final Pattern match;
        private final String replace;

        private RewriteRule(String match, String replace) {
            this.match = Pattern.compile(match);
            this.replace = replace;
        }
    }
}

