/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.http.InclusiveByteRange;
import net.lightbody.bmp.proxy.jetty.http.MultiPartResponse;
import net.lightbody.bmp.proxy.jetty.http.ResourceCache;
import net.lightbody.bmp.proxy.jetty.http.handler.AbstractHttpHandler;
import net.lightbody.bmp.proxy.jetty.util.CachedResource;
import net.lightbody.bmp.proxy.jetty.util.IO;
import net.lightbody.bmp.proxy.jetty.util.Resource;
import net.lightbody.bmp.proxy.jetty.util.StringMap;
import net.lightbody.bmp.proxy.jetty.util.TypeUtil;
import net.lightbody.bmp.proxy.jetty.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHandler
extends AbstractHttpHandler {
    private final Logger log = LoggerFactory.getLogger(ResourceHandler.class);
    private final StringMap _methodMap = new StringMap();
    private boolean _acceptRanges = true;
    private boolean _redirectWelcomeFiles;
    private String[] _methods = null;
    private String _allowed;
    private boolean _dirAllowed = true;
    private int _minGzipLength = -1;

    public ResourceHandler() {
        this.setAllowedMethods(new String[]{"GET", "POST", "HEAD", "OPTIONS", "TRACE"});
    }

    @Override
    public synchronized void start() throws Exception {
        super.start();
    }

    @Override
    public void stop() throws InterruptedException {
        super.stop();
    }

    public String[] getAllowedMethods() {
        return this._methods;
    }

    public void setAllowedMethods(String[] methods) {
        StringBuffer b = new StringBuffer();
        this._methods = methods;
        this._methodMap.clear();
        for (int i = 0; i < methods.length; ++i) {
            this._methodMap.put(methods[i], (Object)methods[i]);
            if (i > 0) {
                b.append(',');
            }
            b.append(methods[i]);
        }
        this._allowed = b.toString();
    }

    public boolean isMethodAllowed(String method) {
        return this._methodMap.get(method) != null;
    }

    public String getAllowedString() {
        return this._allowed;
    }

    public boolean isDirAllowed() {
        return this._dirAllowed;
    }

    public void setDirAllowed(boolean dirAllowed) {
        this._dirAllowed = dirAllowed;
    }

    public boolean isAcceptRanges() {
        return this._acceptRanges;
    }

    public void setAcceptRanges(boolean ar) {
        this._acceptRanges = ar;
    }

    public boolean getRedirectWelcome() {
        return this._redirectWelcomeFiles;
    }

    public void setRedirectWelcome(boolean redirectWelcome) {
        this._redirectWelcomeFiles = redirectWelcome;
    }

    public int getMinGzipLength() {
        return this._minGzipLength;
    }

    public void setMinGzipLength(int minGzipLength) {
        this._minGzipLength = minGzipLength;
    }

    protected Resource getResource(String pathInContext) throws IOException {
        return this.getHttpContext().getResource(pathInContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws IOException {
        Resource resource = this.getResource(pathInContext);
        if (resource == null) {
            return;
        }
        if (!this.isMethodAllowed(request.getMethod())) {
            this.log.debug("Method not allowed: {}", (Object)request.getMethod());
            if (!resource.exists()) return;
            this.setAllowHeader(response);
            response.sendError(405);
            return;
        }
        try {
            String method;
            this.log.debug("PATH={} RESOURCE={}", (Object)pathInContext, (Object)resource);
            switch (method = request.getMethod()) {
                case "GET": 
                case "POST": 
                case "HEAD": {
                    this.handleGet(request, response, pathInContext, pathParams, resource);
                    return;
                }
                case "PUT": {
                    this.handlePut(request, response, pathInContext, resource);
                    return;
                }
                case "DELETE": {
                    this.handleDelete(request, response, pathInContext, resource);
                    return;
                }
                case "OPTIONS": {
                    this.handleOptions(response, pathInContext);
                    return;
                }
                case "MOVE": {
                    this.handleMove(request, response, pathInContext, resource);
                    return;
                }
                case "TRACE": {
                    this.handleTrace(request, response);
                    return;
                }
                default: {
                    this.log.debug("Unknown action:{}", (Object)method);
                    try {
                        if (!resource.exists()) return;
                        response.sendError(501);
                        return;
                    }
                    catch (Exception e) {
                        this.log.trace(e.getMessage(), (Throwable)e);
                    }
                    return;
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.log.trace(e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            if (!(resource instanceof CachedResource)) {
                resource.release();
            }
        }
    }

    public void handleGet(HttpRequest request, HttpResponse response, String pathInContext, String pathParams, Resource resource) throws IOException {
        this.log.debug("Looking for {}", (Object)resource);
        if (resource != null && resource.exists()) {
            if (resource.isDirectory()) {
                if (!pathInContext.endsWith("/") && !pathInContext.equals("/")) {
                    this.log.debug("Redirect to directory/");
                    String q = request.getQuery();
                    StringBuffer buf = request.getRequestURL();
                    if (q != null && q.length() != 0) {
                        buf.append('?');
                        buf.append(q);
                    }
                    response.setField("Location", URI.addPaths(buf.toString(), "/"));
                    response.setStatus(302);
                    request.setHandled(true);
                    return;
                }
                String welcome = this.getHttpContext().getWelcomeFile(resource);
                if (welcome != null) {
                    String ipath = URI.addPaths(pathInContext, welcome);
                    if (this._redirectWelcomeFiles) {
                        ipath = URI.addPaths(this.getHttpContext().getContextPath(), ipath);
                        response.setContentLength(0);
                        response.sendRedirect(ipath);
                    } else {
                        URI uri = request.getURI();
                        uri.setPath(URI.addPaths(uri.getPath(), welcome));
                        this.getHttpContext().handle(ipath, pathParams, request, response);
                    }
                    return;
                }
                if (!this.passConditionalHeaders(request, response, resource)) {
                    return;
                }
                this.sendDirectory(request, response, resource, pathInContext.length() > 1);
            } else if (resource.exists()) {
                if (!this.passConditionalHeaders(request, response, resource)) {
                    return;
                }
                this.sendData(request, response, pathInContext, resource, true);
            } else {
                this.log.warn("Unknown file type");
            }
        }
    }

    private boolean passConditionalHeaders(HttpRequest request, HttpResponse response, Resource resource) throws IOException {
        if (!request.getMethod().equals("HEAD")) {
            ResourceCache.ResourceMetaData metaData = (ResourceCache.ResourceMetaData)resource.getAssociate();
            if (metaData != null) {
                String ifms = request.getField("If-Modified-Since");
                String mdlm = metaData.getLastModified();
                if (ifms != null && mdlm != null && ifms.equals(mdlm)) {
                    response.setStatus(304);
                    request.setHandled(true);
                    return false;
                }
            }
            long date = 0L;
            date = request.getDateField("If-Unmodified-Since");
            if (date > 0L && resource.lastModified() / 1000L > date / 1000L) {
                response.sendError(412);
                return false;
            }
            date = request.getDateField("If-Modified-Since");
            if (date > 0L && resource.lastModified() / 1000L <= date / 1000L) {
                response.setStatus(304);
                request.setHandled(true);
                return false;
            }
        }
        return true;
    }

    void handlePut(HttpRequest request, HttpResponse response, String pathInContext, Resource resource) throws IOException {
        boolean exists;
        this.log.debug("PUT {} in {}", (Object)pathInContext, (Object)resource);
        boolean bl = exists = resource != null && resource.exists();
        if (exists && !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        if (pathInContext.endsWith("/")) {
            if (!exists) {
                if (!resource.getFile().mkdirs()) {
                    response.sendError(403, "Directories could not be created");
                } else {
                    request.setHandled(true);
                    response.setStatus(201);
                    response.commit();
                }
            } else {
                request.setHandled(true);
                response.setStatus(200);
                response.commit();
            }
        } else {
            try {
                int toRead = request.getContentLength();
                InputStream in = request.getInputStream();
                OutputStream out = resource.getOutputStream();
                if (toRead >= 0) {
                    IO.copy(in, out, (long)toRead);
                } else {
                    IO.copy(in, out);
                }
                out.close();
                request.setHandled(true);
                response.setStatus(exists ? 200 : 201);
                response.commit();
            }
            catch (Exception ex) {
                this.log.warn("EXCEPTION ", (Throwable)ex);
                response.sendError(403, ex.getMessage());
            }
        }
    }

    void handleDelete(HttpRequest request, HttpResponse response, String pathInContext, Resource resource) throws IOException {
        this.log.debug("DELETE {} from {}", (Object)pathInContext, (Object)resource);
        if (!resource.exists() || !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        try {
            if (resource.delete()) {
                response.setStatus(204);
            } else {
                response.sendError(403);
            }
            request.setHandled(true);
        }
        catch (SecurityException e) {
            this.log.warn("EXCEPTION ", (Throwable)e);
            response.sendError(403, e.getMessage());
        }
    }

    void handleMove(HttpRequest request, HttpResponse response, String pathInContext, Resource resource) throws IOException {
        if (!resource.exists() || !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        String newPath = URI.canonicalPath(request.getField("New-uri"));
        if (newPath == null) {
            response.sendError(405, "Bad new uri");
            return;
        }
        String contextPath = this.getHttpContext().getContextPath();
        if (contextPath != null && !newPath.startsWith(contextPath)) {
            response.sendError(405, "Not in context");
            return;
        }
        try {
            String newInfo = newPath;
            if (contextPath != null) {
                newInfo = newInfo.substring(contextPath.length());
            }
            Resource newFile = this.getHttpContext().getBaseResource().addPath(newInfo);
            this.log.debug("Moving {} to {}", (Object)resource, (Object)newFile);
            resource.renameTo(newFile);
            response.setStatus(204);
            request.setHandled(true);
        }
        catch (Exception ex) {
            this.log.warn("EXCEPTION ", (Throwable)ex);
            this.setAllowHeader(response);
            response.sendError(405, "Error:" + ex);
        }
    }

    void handleOptions(HttpResponse response, String pathInContext) throws IOException {
        if ("*".equals(pathInContext)) {
            return;
        }
        this.setAllowHeader(response);
        response.commit();
    }

    void setAllowHeader(HttpResponse response) {
        response.setField("Allow", this.getAllowedString());
    }

    public void writeHeaders(HttpResponse response, Resource resource, long count) {
        ResourceCache.ResourceMetaData metaData = (ResourceCache.ResourceMetaData)resource.getAssociate();
        response.setContentType(metaData.getMimeType());
        if (count != -1L) {
            if (count == resource.length()) {
                response.setField("Content-Length", metaData.getLength());
            } else {
                response.setContentLength((int)count);
            }
        }
        response.setField("Last-Modified", metaData.getLastModified());
        if (this._acceptRanges && response.getHttpRequest().getDotVersion() > 0) {
            response.setField("Accept-Ranges", "bytes");
        }
    }

    public void sendData(HttpRequest request, HttpResponse response, String pathInContext, Resource resource, boolean writeHeaders) throws IOException {
        Enumeration reqRanges;
        long resLength = resource.length();
        Enumeration enumeration = reqRanges = request.getDotVersion() > 0 ? request.getFieldValues("Range") : null;
        if (!writeHeaders || reqRanges == null || !reqRanges.hasMoreElements()) {
            Resource gz;
            String accept;
            Resource data = resource;
            if (this._minGzipLength > 0 && (accept = request.getField("Accept-Encoding")) != null && resLength > (long)this._minGzipLength && !pathInContext.endsWith(".gz") && (gz = this.getHttpContext().getResource(pathInContext + ".gz")).exists() && accept.contains("gzip")) {
                this.log.debug("gzip={}", (Object)gz);
                response.setField("Content-Encoding", "gzip");
                data = gz;
                resLength = data.length();
            }
            this.writeHeaders(response, resource, resLength);
            request.setHandled(true);
            OutputStream out = response.getOutputStream();
            data.writeTo(out, 0L, resLength);
            return;
        }
        List ranges = InclusiveByteRange.satisfiableRanges(reqRanges, resLength);
        this.log.debug("ranges: {} == {}", (Object)reqRanges, (Object)ranges);
        if (ranges == null || ranges.size() == 0) {
            this.log.debug("no satisfiable ranges");
            this.writeHeaders(response, resource, resLength);
            response.setStatus(416);
            response.setReason((String)HttpResponse.__statusMsg.get(TypeUtil.newInteger(416)));
            response.setField("Content-Range", InclusiveByteRange.to416HeaderRangeString(resLength));
            OutputStream out = response.getOutputStream();
            resource.writeTo(out, 0L, resLength);
            request.setHandled(true);
            return;
        }
        if (ranges.size() == 1) {
            InclusiveByteRange singleSatisfiableRange = (InclusiveByteRange)ranges.get(0);
            this.log.debug("single satisfiable range: " + singleSatisfiableRange);
            long singleLength = singleSatisfiableRange.getSize(resLength);
            this.writeHeaders(response, resource, singleLength);
            response.setStatus(206);
            response.setReason((String)HttpResponse.__statusMsg.get(TypeUtil.newInteger(206)));
            response.setField("Content-Range", singleSatisfiableRange.toHeaderRangeString(resLength));
            OutputStream out = response.getOutputStream();
            resource.writeTo(out, singleSatisfiableRange.getFirst(resLength), singleLength);
            request.setHandled(true);
            return;
        }
        ResourceCache.ResourceMetaData metaData = (ResourceCache.ResourceMetaData)resource.getAssociate();
        String encoding = metaData.getMimeType();
        MultiPartResponse multi = new MultiPartResponse(response);
        response.setStatus(206);
        response.setReason((String)HttpResponse.__statusMsg.get(TypeUtil.newInteger(206)));
        String ctp = request.containsField("Request-Range") ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
        response.setContentType(ctp + multi.getBoundary());
        InputStream in = resource instanceof CachedResource ? null : resource.getInputStream();
        OutputStream out = response.getOutputStream();
        long pos = 0L;
        for (int i = 0; i < ranges.size(); ++i) {
            InclusiveByteRange ibr = (InclusiveByteRange)ranges.get(i);
            String header = "Content-Range: " + ibr.toHeaderRangeString(resLength);
            this.log.debug("multi range: {} {}", (Object)encoding, (Object)header);
            multi.startPart(encoding, new String[]{header});
            long start = ibr.getFirst(resLength);
            long size = ibr.getSize(resLength);
            if (in != null) {
                if (start < pos) {
                    in.close();
                    in = resource.getInputStream();
                    pos = 0L;
                }
                if (pos < start) {
                    in.skip(start - pos);
                    pos = start;
                }
                IO.copy(in, out, size);
                pos += size;
                continue;
            }
            resource.writeTo(out, start, size);
        }
        if (in != null) {
            in.close();
        }
        multi.close();
        request.setHandled(true);
    }

    void sendDirectory(HttpRequest request, HttpResponse response, Resource resource, boolean parent) throws IOException {
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        request.setHandled(true);
        this.log.debug("sendDirectory: {}", (Object)resource);
        byte[] data = null;
        if (resource instanceof CachedResource) {
            data = ((CachedResource)resource).getCachedData();
        }
        if (data == null) {
            String base = URI.addPaths(request.getPath(), "/");
            String dir = resource.getListHTML(URI.encodePath(base), parent);
            if (dir == null) {
                response.sendError(403, "No directory");
                return;
            }
            data = dir.getBytes("UTF8");
            if (resource instanceof CachedResource) {
                ((CachedResource)resource).setCachedData(data);
            }
        }
        response.setContentType("text/html; charset=UTF8");
        response.setContentLength(data.length);
        if (request.getMethod().equals("HEAD")) {
            response.commit();
            return;
        }
        response.getOutputStream().write(data, 0, data.length);
        response.commit();
    }
}

