/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.lightbody.bmp.proxy.http.BrowserMobHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientInterrupter {
    protected static final Logger logger = LoggerFactory.getLogger(HttpClientInterrupter.class);
    private static final Set<BrowserMobHttpClient> clients = new CopyOnWriteArraySet<BrowserMobHttpClient>();

    public static void watch(BrowserMobHttpClient client) {
        clients.add(client);
    }

    public static void release(BrowserMobHttpClient client) {
        clients.remove(client);
    }

    static {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    for (BrowserMobHttpClient client : clients) {
                        try {
                            client.checkTimeout();
                        }
                        catch (Exception e) {
                            logger.error("Unexpected problem while checking timeout on a client", (Throwable)e);
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }, "HttpClientInterrupter Thread");
        thread.setDaemon(true);
        thread.start();
    }
}

