/*
 * Decompiled with CFR 0.152.
 */
package wang.leal.ahel.storage;

import android.content.Context;
import androidx.room.Room;
import com.tencent.mmkv.MMKV;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wang.leal.ahel.storage.FileService;
import wang.leal.ahel.storage.KVService;
import wang.leal.ahel.storage.RoomService;
import wang.leal.ahel.storage.room.StorageDatabase;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lwang/leal/ahel/storage/StorageService;", "", "()V", "db", "Lwang/leal/ahel/storage/room/StorageDatabase;", "mmkvDir", "", "storageDir", "Ljava/io/File;", "fileService", "Lwang/leal/ahel/storage/FileService;", "key", "initialize", "", "context", "Landroid/content/Context;", "kvService", "Lwang/leal/ahel/storage/KVService;", "name", "roomService", "Lwang/leal/ahel/storage/RoomService;", "storage_release"})
public final class StorageService {
    @NotNull
    public static final StorageService INSTANCE = new StorageService();
    @Nullable
    private static File storageDir;
    @Nullable
    private static StorageDatabase db;
    @Nullable
    private static String mmkvDir;

    private StorageService() {
    }

    public final void initialize(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        mmkvDir = MMKV.initialize((Context)context);
        File file = storageDir = new File(context.getFilesDir(), "storage");
        if ((file == null ? false : !file.exists()) && (file = storageDir) != null) {
            file.mkdirs();
        }
        db = (StorageDatabase)Room.databaseBuilder((Context)context, StorageDatabase.class, (String)"storage.db").build();
    }

    @NotNull
    public final KVService kvService(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (mmkvDir == null) {
            throw new IllegalStateException("You should Call Storage.initialize() first.");
        }
        return new KVService(name);
    }

    @NotNull
    public final KVService kvService() {
        if (mmkvDir == null) {
            throw new IllegalStateException("You should Call Storage.initialize() first.");
        }
        return new KVService("storage");
    }

    @NotNull
    public final FileService fileService(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (storageDir == null) {
            throw new IllegalStateException("You should Call Storage.initialize() first.");
        }
        return new FileService(key, storageDir);
    }

    @NotNull
    public final RoomService roomService() {
        if (db == null) {
            throw new IllegalStateException("You should Call Storage.initialize() first.");
        }
        return new RoomService(db);
    }
}

