/*
 * Decompiled with CFR 0.152.
 */
package wang.leal.ahel.storage;

import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u0005H\u0002J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lwang/leal/ahel/storage/FileService;", "", "fileName", "", "dir", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "readLock", "Ljava/util/concurrent/locks/Lock;", "readWriteLock", "Ljava/util/concurrent/locks/ReadWriteLock;", "writeLock", "delete", "", "getFile", "read", "Lio/reactivex/rxjava3/core/Observable;", "write", "value", "storage_release"})
public final class FileService {
    @NotNull
    private final String fileName;
    @Nullable
    private final File dir;
    @NotNull
    private final ReadWriteLock readWriteLock;
    @NotNull
    private final Lock readLock;
    @NotNull
    private final Lock writeLock;

    public FileService(@NotNull String fileName, @Nullable File dir) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.fileName = fileName;
        this.dir = dir;
        this.readWriteLock = new ReentrantReadWriteLock();
        Lock lock = this.readWriteLock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"readWriteLock.readLock()");
        this.readLock = lock;
        lock = this.readWriteLock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"readWriteLock.writeLock()");
        this.writeLock = lock;
    }

    public final void write(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Observable.create(arg_0 -> FileService.write$lambda-0(this, value, arg_0)).subscribeOn(Schedulers.io()).subscribe();
    }

    @NotNull
    public final Observable<String> read() {
        Observable observable = Observable.create(arg_0 -> FileService.read$lambda-1(this, arg_0)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"create<String> {\n       \u2026dSchedulers.mainThread())");
        return observable;
    }

    private final File getFile() {
        File file = new File(this.dir, this.fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    public final void delete() {
        Observable.create(arg_0 -> FileService.delete$lambda-2(this, arg_0)).subscribeOn(Schedulers.io()).subscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void write$lambda-0(FileService this$0, String $value, ObservableEmitter it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        this$0.writeLock.lock();
        try {
            File file = this$0.getFile();
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write($value);
            fileWriter.flush();
            fileWriter.close();
        }
        finally {
            this$0.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void read$lambda-1(FileService this$0, ObservableEmitter it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.readLock.lock();
        String value = "";
        try {
            File file = this$0.getFile();
            FileReader fileReader = new FileReader(file);
            value = TextStreamsKt.readText((Reader)fileReader);
            fileReader.close();
        }
        finally {
            this$0.readLock.unlock();
            it.onNext((Object)value);
            it.onComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void delete$lambda-2(FileService this$0, ObservableEmitter it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.writeLock.lock();
        try {
            File file = this$0.getFile();
            file.deleteOnExit();
        }
        finally {
            this$0.writeLock.unlock();
        }
    }
}

