/*
 * Decompiled with CFR 0.152.
 */
package com.sunmi.android.elephant.manager;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceSet;
import com.google.gson.Gson;
import com.sunmi.android.elephant.ConfigManager;
import com.sunmi.android.elephant.exception.MonkeyBuildException;
import com.sunmi.android.elephant.model.ConfigModule;
import com.sunmi.android.elephant.model.Pages;
import com.sunmi.android.elephant.model.Runtime;
import com.sunmi.android.elephant.model.client.Manifest;
import com.sunmi.android.elephant.model.client.Module;
import com.sunmi.android.elephant.model.client.Page;
import com.sunmi.android.elephant.network.NetworkClient;
import com.sunmi.android.elephant.utils.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.NotNull;

public class ElephantJsManager {
    public static void transactionSource(AppExtension appExtension) {
        File assetsDir = ElephantJsManager.getAssetsDir(appExtension);
        File res = new File(assetsDir, "res");
        if (!res.exists()) {
            res.mkdirs();
        }
        Runtime runtime = ConfigManager.getInstance().getConfig().getRuntime();
        List<Pages> pages = runtime.getPages();
        Manifest manifest = new Manifest();
        manifest.setManifestVersion(runtime.getManifestVersion());
        manifest.setBaseWidth(runtime.getBaseWidth());
        manifest.setDevWebSocketServer(runtime.getWs());
        String launcherRouter = runtime.getLauncherRouter();
        manifest.setLauncherRouter(launcherRouter);
        if (launcherRouter == null) {
            throw new MonkeyBuildException("launcherRouter it's required");
        }
        boolean isMatchLauncherRouter = false;
        for (int i = 0; i < pages.size(); ++i) {
            Pages page = pages.get(i);
            String source = Utils.getPath(page.getSource());
            File sourceFile = new File(source);
            File file = new File(res, sourceFile.getName());
            if (!file.exists()) {
                try {
                    FileUtils.copyFile((File)sourceFile, (File)file);
                }
                catch (IOException e) {
                    throw new MonkeyBuildException(e);
                }
            }
            file.delete();
            try {
                FileUtils.copyFile((File)new File(source), (File)file);
            }
            catch (IOException e) {
                throw new MonkeyBuildException(e);
            }
            String router = page.getRouter();
            if (router == null || router.equals("")) {
                throw new MonkeyBuildException("page Router it's required");
            }
            if (launcherRouter.equals(router)) {
                isMatchLauncherRouter = true;
            }
            ArrayList<Module> modules = new ArrayList<Module>();
            manifest.addPage(ElephantJsManager.getAbsPath(res, file), page.getName(), router, page.getVersion(), modules);
        }
        if (!isMatchLauncherRouter) {
            throw new MonkeyBuildException("Invalid launcherRouter");
        }
        ElephantJsManager.transactionManifestJson(manifest, new File(res, "manifest.json"));
        ElephantJsManager.clean(manifest, res);
    }

    private static void clean(Manifest manifest, File res) {
        File[] files;
        List<Page> pages = manifest.getPages();
        for (File file : files = res.listFiles()) {
            String name = file.getName();
            if ("manifest.json".equals(name)) continue;
            boolean isUse = false;
            block1: for (Page page : pages) {
                String hash = page.getAssetsPath();
                if (name.equals(hash = hash.replace("res/", ""))) {
                    isUse = true;
                    break;
                }
                List<Module> modules = page.getModules();
                for (Module module : modules) {
                    if (!name.equals(module.getHash())) continue;
                    isUse = true;
                    continue block1;
                }
            }
            if (isUse) continue;
            Utils.logE("delete no index file:" + file.getPath());
            file.delete();
        }
    }

    private static void doWriteSouce(String source, File file, boolean exists) throws Exception {
        if (exists) {
            file.delete();
        }
        file.createNewFile();
        ElephantJsManager.writeSource(source, file);
        Utils.logE("writeSource: " + source + " to " + file.getPath());
    }

    @NotNull
    private static File getAssetsDir(AppExtension appExtension) {
        NamedDomainObjectContainer androidSourceSets = appExtension.getSourceSets();
        AndroidSourceSet main = (AndroidSourceSet)androidSourceSets.getByName("main");
        AndroidSourceDirectorySet assets = main.getAssets();
        Set srcDirs = assets.getSrcDirs();
        File assetsDir = null;
        if (!srcDirs.isEmpty()) {
            File[] objects = srcDirs.toArray(new File[srcDirs.size()]);
            assetsDir = objects[0];
        }
        if (!assetsDir.exists()) {
            assetsDir.mkdirs();
        }
        return assetsDir;
    }

    private static void transactionManifestJson(Manifest manifest, File manifestJsonFile) {
        String json = new Gson().toJson((Object)manifest);
        if (manifestJsonFile.exists()) {
            manifestJsonFile.delete();
        }
        ElephantJsManager.writeManifest(manifestJsonFile, json);
    }

    private static void writeManifest(File manifestJsonFile, String json) {
        try {
            manifestJsonFile.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(manifestJsonFile);
            fileOutputStream.write(json.getBytes("UTF-8"));
            fileOutputStream.flush();
            fileOutputStream.close();
            Utils.logE("write manifest ~");
        }
        catch (Exception e) {
            throw new MonkeyBuildException(e);
        }
    }

    private static void transactionJsModule(File res, List<ConfigModule> configModules, ArrayList<Module> modules) throws Exception {
        if (configModules == null) {
            return;
        }
        for (int m = 0; m < configModules.size(); ++m) {
            ConfigModule tempModule = configModules.get(m);
            String moduleHash = tempModule.getHash();
            File moduleOutFile = new File(res, moduleHash);
            String source = tempModule.getSource();
            if (!moduleOutFile.exists()) {
                ElephantJsManager.doWriteSouce(source, moduleOutFile, true);
                Utils.logE("writeSource:" + source + " to " + moduleOutFile.getPath());
            } else {
                ElephantJsManager.doWriteSouce(source, moduleOutFile, true);
            }
            Module module = new Module();
            module.setAssetsPath(ElephantJsManager.getAbsPath(res, moduleOutFile));
            module.setHash(moduleHash);
            module.setImportPath(tempModule.getImportPath());
            modules.add(module);
        }
    }

    @NotNull
    private static String getAbsPath(File res, File file) {
        return file.getPath().replace(res.getParent() + "/", "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeSource(String source, File file) {
        if (Utils.isNullStr(source)) throw new MonkeyBuildException("check runtime source fail, source field is null ~");
        if (Utils.isFilePath(source)) {
            if (source.contains("$project")) {
                source = Utils.getPath(source);
            }
            try {
                FileUtils.copyFile((File)new File(source), (File)file);
                return;
            }
            catch (Exception e) {
                throw new MonkeyBuildException(e);
            }
        }
        if (!Utils.isHttpUrl(source)) throw new MonkeyBuildException("check runtime source fail, source field must file path or http/https url ~");
        try {
            byte[] download = NetworkClient.getInstance().download(source);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(download);
            fileOutputStream.flush();
            fileOutputStream.close();
            return;
        }
        catch (Exception e) {
            throw new MonkeyBuildException(e);
        }
    }

    private static void checkHash(String hash, String md5) {
        Utils.logE(hash + " " + md5);
        if (!hash.equals(md5)) {
            throw new MonkeyBuildException("check runtime source fail, source hash not match~");
        }
    }

    public static void transaction(final AppExtension appExtension, Gradle gradle, final File buildCache) {
        final TaskExecutionGraph taskGraph = gradle.getTaskGraph();
        taskGraph.addTaskExecutionGraphListener(new TaskExecutionGraphListener(){

            public void graphPopulated(TaskExecutionGraph taskExecutionGraph) {
                List allTasks = taskExecutionGraph.getAllTasks();
                for (Task allTask : allTasks) {
                    String name = allTask.getName();
                    if ("assembleRelease".equals(name) || "assembleDebug".equals(name)) {
                        if (Utils.isDev() || Utils.isPreBuild()) {
                            Utils.logE("\u9884\u6784\u5efa \u6216 dev \u6a21\u5f0f\u4e0d\u6ce8\u5165js");
                            break;
                        }
                        ElephantJsManager.transactionSource(appExtension);
                        break;
                    }
                    if (!"clean".equals(name)) continue;
                    taskGraph.removeTaskExecutionGraphListener((TaskExecutionGraphListener)this);
                    if (Utils.isDev()) {
                        ElephantJsManager.cleanDevDSLRes(appExtension);
                        continue;
                    }
                    ElephantJsManager.cleanReleaseDSLRes(buildCache);
                }
                taskGraph.removeTaskExecutionGraphListener((TaskExecutionGraphListener)this);
            }
        });
    }

    private static void cleanDevDSLRes(AppExtension appExtension) {
        File assetsDir = ElephantJsManager.getAssetsDir(appExtension);
        if (assetsDir.exists()) {
            File file = new File(assetsDir, "res");
            if (!file.exists()) {
                return;
            }
            try {
                FileUtils.cleanDirectory((File)file);
            }
            catch (Exception e) {
                throw new MonkeyBuildException(e);
            }
        }
    }

    private static void cleanReleaseDSLRes(File buildCache) {
        if (buildCache == null || !buildCache.exists()) {
            return;
        }
        try {
            FileUtils.cleanDirectory((File)buildCache);
        }
        catch (IOException e) {
            throw new MonkeyBuildException(e);
        }
    }
}

