/*
 * Decompiled with CFR 0.152.
 */
package com.sunmi.android.elephant.manager;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.internal.dsl.BuildType;
import com.sunmi.android.elephant.ConfigManager;
import com.sunmi.android.elephant.exception.MonkeyBuildException;
import com.sunmi.android.elephant.model.Build;
import com.sunmi.android.elephant.model.Dependency;
import com.sunmi.android.elephant.network.NetworkClient;
import com.sunmi.android.elephant.utils.Utils;
import java.io.File;
import java.util.List;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.apache.commons.codec.digest.DigestUtils;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class DependencyManager {
    public static void injectionDependency(Project project, AppExtension appExtension) {
        DependencyHandler dependencies = project.getDependencies();
        Build build = ConfigManager.getInstance().getConfig().getBuild();
        List<Dependency> myDependencies = build.getDependencies();
        if (myDependencies == null || myDependencies.isEmpty()) {
            return;
        }
        NamedDomainObjectContainer buildTypes = appExtension.getBuildTypes();
        BuildType release = (BuildType)buildTypes.getByName("release");
        List proguardFiles = release.getProguardFiles();
        for (Dependency myDependency : myDependencies) {
            String dep = myDependency.getGroupId() + ":" + myDependency.getArtifactId() + ":" + myDependency.getVersion();
            dependencies.add("implementation", (Object)dep, null);
            Utils.logE("dep implementation " + dep);
            String proguardRules = myDependency.getProguardRules();
            if (!release.isMinifyEnabled()) continue;
            DependencyManager.transactionProguardRules(project, proguardFiles, proguardRules, myDependency.getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void transactionProguardRules(Project project, List<File> proguardFiles, String proguardRules, String name) {
        File buildDir = project.getBuildDir();
        File downloadDir = new File(buildDir, "proguardRules");
        if (!downloadDir.exists()) {
            downloadDir.mkdir();
        }
        if (Utils.isNullStr(proguardRules)) return;
        if (Utils.isFilePath(proguardRules)) {
            Utils.logE(name + " R8 \u6ce8\u5165:" + proguardRules);
            proguardFiles.add(new File(proguardRules));
            return;
        }
        if (!Utils.isHttpUrl(proguardRules)) throw new MonkeyBuildException("check runtime source fail, source field must file path or http/https url ~");
        String s = DigestUtils.md2Hex((String)proguardRules);
        File out = new File(downloadDir, s);
        if (out.exists() && out.length() > 0L) {
            proguardFiles.add(out);
            Utils.logE(name + " R8 \u6ce8\u5165:" + out.getPath());
            return;
        }
        if (!out.exists()) {
            try {
                out.createNewFile();
            }
            catch (Exception e) {
                throw new MonkeyBuildException(e);
            }
        }
        try {
            byte[] download = NetworkClient.getInstance().download(proguardRules);
            if (download == null) return;
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)out));
            sink.write(download);
            sink.flush();
            sink.close();
            proguardFiles.add(out);
            Utils.logE(name + " R8 \u6ce8\u5165:" + out.getPath());
            return;
        }
        catch (Exception e) {
            throw new MonkeyBuildException(e);
        }
    }
}

