/*
 * Decompiled with CFR 0.152.
 */
package com.sunmi.android.elephant.manager;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.sunmi.android.elephant.ConfigManager;
import com.sunmi.android.elephant.exception.MonkeyBuildException;
import com.sunmi.android.elephant.model.Background;
import com.sunmi.android.elephant.model.Build;
import com.sunmi.android.elephant.model.LauncherIcon;
import com.sunmi.android.elephant.model.LocalIconModel;
import com.sunmi.android.elephant.model.Splash;
import com.sunmi.android.elephant.model.client.SplashImg;
import com.sunmi.android.elephant.network.NetworkClient;
import com.sunmi.android.elephant.utils.Utils;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.gradle.api.NamedDomainObjectContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidManifestManager {
    public static void transactionFields(AppExtension appExtension, Build config) {
        DefaultConfig defaultConfig = appExtension.getDefaultConfig();
        String applicationId = config.getApplicationId();
        defaultConfig.applicationId(applicationId);
        defaultConfig.versionCode(Integer.valueOf(config.getVersionCode()));
        defaultConfig.versionName(config.getVersionName());
    }

    public static void transaction(AppExtension appExtension) {
        ConfigManager instance = ConfigManager.getInstance();
        Build build = instance.getConfig().getBuild();
        AndroidManifestManager.transactionFields(appExtension, build);
        File resDir = AndroidManifestManager.getResDir(appExtension);
        AndroidManifestManager.transactionAppName(build, resDir);
        AndroidManifestManager.transactionIcon(build, resDir);
        AndroidManifestManager.transactionSplash(build, resDir);
    }

    private static void transactionSplash(Build build, File resDir) {
        ArrayList<SplashImg> splashImages = AndroidManifestManager.getSplashImages();
        Splash splash = build.getSplash();
        Background splashBackground = AndroidManifestManager.getSplashBackground(splash);
        if (splashBackground != null) {
            String icon = splashBackground.getSrc();
            byte[] iconByteData = AndroidManifestManager.getImgBytesData(icon);
            for (SplashImg splashImage : splashImages) {
                File outFile;
                String name = splashImage.getName();
                File file = new File(resDir, name);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if ((outFile = new File(file, "splash.png")).exists()) {
                    outFile.delete();
                }
                AndroidManifestManager.reSize(iconByteData, outFile, splashImage.getWidth(), splashImage.getHeight());
            }
        }
    }

    private static Background getSplashBackground(Splash splash) {
        List<Background> backgroundRes = splash.getBackground();
        for (Background temp : backgroundRes) {
            String resolution = temp.getResolution();
            if (!"xxxhdpi".equals(resolution)) continue;
            return temp;
        }
        return null;
    }

    private static ArrayList<SplashImg> getSplashImages() {
        ArrayList<SplashImg> splashImages = new ArrayList<SplashImg>();
        splashImages.add(new SplashImg("mipmap-hdpi", 480, 800));
        splashImages.add(new SplashImg("mipmap-mdpi", 320, 480));
        splashImages.add(new SplashImg("mipmap-xhdpi", 720, 1280));
        splashImages.add(new SplashImg("mipmap-xxhdpi", 1080, 1920));
        splashImages.add(new SplashImg("mipmap-xxxhdpi", 2160, 3840));
        return splashImages;
    }

    private static void transactionIcon(Build build, File resDir) {
        ArrayList<LocalIconModel> mipmaps = new ArrayList<LocalIconModel>();
        AndroidManifestManager.setData(mipmaps, "mipmap-hdpi", 72);
        AndroidManifestManager.setData(mipmaps, "mipmap-mdpi", 48);
        AndroidManifestManager.setData(mipmaps, "mipmap-xhdpi", 96);
        AndroidManifestManager.setData(mipmaps, "mipmap-xxhdpi", 144);
        AndroidManifestManager.setData(mipmaps, "mipmap-xxxhdpi", 192);
        List<LauncherIcon> launcherIcon = build.getLauncherIcon();
        for (LauncherIcon iconData : launcherIcon) {
            if (!"xxxhdpi".equals(iconData.getResolution())) continue;
            String icon = iconData.getIcon();
            byte[] iconByteData = AndroidManifestManager.getImgBytesData(icon);
            for (LocalIconModel mipmap : mipmaps) {
                File file;
                File mipmapDir = new File(resDir, mipmap.getName());
                if (!mipmapDir.exists()) {
                    mipmapDir.mkdirs();
                }
                if ((file = new File(mipmapDir, "ic_launcher.png")).exists()) {
                    file.delete();
                }
                Utils.logE("icon:" + file.getPath());
                AndroidManifestManager.reSize(iconByteData, file, mipmap.getValue(), mipmap.getValue());
            }
        }
    }

    private static void setData(ArrayList<LocalIconModel> mipmaps, String key, int value) {
        LocalIconModel localIconModel = new LocalIconModel();
        localIconModel.setName(key);
        localIconModel.setValue(value);
        mipmaps.add(localIconModel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getImgBytesData(String icon) {
        if (Utils.isNullStr(icon)) {
            return null;
        }
        if (Utils.isHttpUrl(icon)) {
            return NetworkClient.getInstance().download(icon);
        }
        if (!Utils.isFilePath(icon)) throw new MonkeyBuildException("check runtime source fail, source field must file path or http/https url ~" + icon);
        String path = Utils.getPath(icon);
        try (BufferedSource source = Okio.buffer((Source)Okio.source((File)new File(path)));){
            byte[] byArray = source.readByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new MonkeyBuildException(e);
        }
    }

    private static void transactionAppName(Build build, File resDir) {
        Map<String, String> appName = build.getAppName();
        Set<Map.Entry<String, String>> entries = appName.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            File valuesDir = null;
            String key = entry.getKey();
            valuesDir = "default".equals(key) ? new File(resDir, "values") : new File(resDir, "values-" + key);
            if (!valuesDir.exists()) {
                valuesDir.mkdir();
            }
            File file = new File(valuesDir, "strings.xml");
            AndroidManifestManager.parseStringsXml(file, entry.getValue());
        }
    }

    private static void parseStringsXml(File file, String value) {
        Document dom;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MonkeyBuildException(e);
        }
        boolean isChange = false;
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new MonkeyBuildException(e);
            }
            dom = documentBuilder.newDocument();
            Element resources = dom.createElement("resources");
            Element string = dom.createElement("string");
            string.setAttribute("name", "app_name");
            string.setTextContent(value);
            resources.appendChild(string);
            dom.appendChild(resources);
            isChange = true;
        } else {
            try {
                dom = documentBuilder.parse(file);
            }
            catch (Exception e) {
                throw new MonkeyBuildException(e);
            }
            NodeList string = dom.getElementsByTagName("string");
            int stringsLength = string.getLength();
            for (int i = 0; i < stringsLength; ++i) {
                Node item = string.item(i);
                NamedNodeMap attributes = item.getAttributes();
                int length = attributes.getLength();
                boolean isAppNameNode = false;
                for (int a = 0; a < length; ++a) {
                    Node item1 = attributes.item(a);
                    if (!"app_name".equals(item1.getNodeValue())) continue;
                    isAppNameNode = true;
                    break;
                }
                if (!isAppNameNode) continue;
                if (!value.equals(item.getTextContent())) {
                    item.setTextContent(value);
                    isChange = true;
                    Utils.logE("change appName :" + file.getPath());
                    break;
                }
                Utils.logE("appName is true not change" + file.getPath());
                break;
            }
        }
        if (isChange) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = null;
            try {
                transformer = transformerFactory.newTransformer();
                transformer.transform(new DOMSource(dom), new StreamResult(file));
            }
            catch (Exception e) {
                throw new MonkeyBuildException(e);
            }
        }
    }

    private static File getResDir(AppExtension appExtension) {
        NamedDomainObjectContainer sourceSets = appExtension.getSourceSets();
        AndroidSourceSet main = (AndroidSourceSet)sourceSets.getByName("main");
        AndroidSourceDirectorySet res = main.getRes();
        Set srcDirs = res.getSrcDirs();
        File resDir = null;
        Iterator iterator = srcDirs.iterator();
        if (iterator.hasNext()) {
            File srcDir;
            resDir = srcDir = (File)iterator.next();
        }
        if (!resDir.exists()) {
            resDir.mkdirs();
        }
        return resDir;
    }

    public static void reSize(byte[] srcImg, File destImg, int width, int height) {
        BufferedImage srcImage = null;
        try {
            srcImage = ImageIO.read(new ByteArrayInputStream(srcImg));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (srcImage != null) {
            BufferedImage target = null;
            double sx = (double)width / (double)srcImage.getWidth();
            double sy = (double)height / (double)srcImage.getHeight();
            ColorModel cm = srcImage.getColorModel();
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            boolean alphaPremultiplied = cm.isAlphaPremultiplied();
            target = new BufferedImage(cm, raster, alphaPremultiplied, null);
            Graphics2D g = target.createGraphics();
            g.drawRenderedImage(srcImage, AffineTransform.getScaleInstance(sx, sy));
            g.dispose();
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)target, "png", baos);
                FileOutputStream fos = new FileOutputStream(destImg);
                fos.write(baos.toByteArray());
                fos.flush();
                fos.close();
                Utils.logE("out img:" + width + "*" + height + " " + destImg.getPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

