/*
 * Decompiled with CFR 0.152.
 */
package com.sunmi.android.elephant;

import com.google.gson.Gson;
import com.sunmi.android.elephant.exception.MonkeyBuildException;
import com.sunmi.android.elephant.model.Config;
import com.sunmi.android.elephant.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.gradle.api.Project;

public class ConfigManager {
    static int mode = 0;
    private static Config config;
    private static String path;
    private static ConfigManager instance;

    public static boolean isDev() {
        return mode == 1;
    }

    public static ConfigManager getInstance() {
        return instance;
    }

    public static void init(Project project) {
        path = instance.readEnv(project);
        config = instance.loadConfigByPath(path);
    }

    public static String getPath() {
        return path;
    }

    private String readEnv(Project project) {
        String androidBuildConfig = System.getenv("ANDROID_BUILD_CONFIG");
        String path = null;
        if (!Utils.isNullStr(androidBuildConfig) && Utils.isFilePath(androidBuildConfig)) {
            path = androidBuildConfig;
            Utils.logE("use production mode");
        } else {
            File file = new File(new File(project.getRootDir(), "/mock/"), "BuildConfig.json");
            if (!file.exists()) {
                throw new MonkeyBuildException("BuildConfig.json not found~");
            }
            path = file.getPath();
            mode = 1;
            Utils.logE("use develop mode!");
        }
        return path;
    }

    private Config loadConfigByPath(String path) {
        try {
            BufferedSource buffer = Okio.buffer((Source)Okio.source((File)new File(path)));
            String json = buffer.readUtf8();
            Config config = (Config)new Gson().fromJson(json, Config.class);
            return config;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Config getConfig() {
        return config;
    }

    static {
        instance = new ConfigManager();
    }
}

