/*
 * Decompiled with CFR 0.152.
 */
package com.sunmi.android.elephant;

import com.android.build.gradle.AppExtension;
import com.sunmi.android.elephant.ConfigManager;
import com.sunmi.android.elephant.manager.AndroidManifestManager;
import com.sunmi.android.elephant.manager.BuildCacheManager;
import com.sunmi.android.elephant.manager.DependencyManager;
import com.sunmi.android.elephant.manager.ElephantJsManager;
import com.sunmi.android.elephant.manager.ProductManager;
import com.sunmi.android.elephant.utils.Utils;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;

public class BuildTools {
    private static BuildTools buildTools = new BuildTools();

    public static BuildTools getBuildTools() {
        return buildTools;
    }

    public void init(Project project) {
        Utils.init(project);
        ConfigManager.init(project);
        this.initBuild(project);
    }

    private void initBuild(Project project) {
        AppExtension appExtension = (AppExtension)project.getExtensions().findByType(AppExtension.class);
        File buildCache = BuildCacheManager.getInstance().setBuildCache(project, appExtension);
        Gradle gradle = project.getGradle();
        this.buildRuntime(project, appExtension, buildCache, gradle);
        AndroidManifestManager.transaction(appExtension);
        ProductManager.signing(appExtension);
        ProductManager.injectionBuildId(appExtension);
        DependencyManager.injectionDependency(project, appExtension);
    }

    private void buildRuntime(Project project, AppExtension appExtension, File buildCache, Gradle gradle) {
        ProductManager.transaction(project, gradle, appExtension);
        ElephantJsManager.transaction(appExtension, gradle, buildCache);
    }
}

