/*
 * Decompiled with CFR 0.152.
 */
package vn.tiki.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import vn.tiki.widgets.R;

public class AutoCompleteEmailEditText
extends AppCompatEditText {
    private List<String> domains;
    private boolean isBackPressing;
    private TextWatcher watcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            AutoCompleteEmailEditText.this.isBackPressing = count > 0 && after == 0;
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            if (!AutoCompleteEmailEditText.this.isBackPressing) {
                String textAfterChange = s.toString();
                String matchDomain = "";
                String textAfterAtSymbol = "";
                int atSignPosition = textAfterChange.indexOf(64);
                if (atSignPosition > 1 && atSignPosition < textAfterChange.length() + 1) {
                    textAfterAtSymbol = textAfterChange.substring(atSignPosition + 1, textAfterChange.length());
                    if (textAfterAtSymbol.isEmpty()) {
                        return;
                    }
                    for (String domain : AutoCompleteEmailEditText.this.domains) {
                        if (!domain.startsWith(textAfterAtSymbol)) continue;
                        matchDomain = domain;
                    }
                }
                AutoCompleteEmailEditText.this.removeTextChangedListener(AutoCompleteEmailEditText.this.watcher);
                if (!matchDomain.isEmpty()) {
                    String filled = matchDomain.substring(textAfterAtSymbol.length(), matchDomain.length());
                    String text = textAfterChange + filled;
                    int highlight = text.lastIndexOf(filled);
                    AutoCompleteEmailEditText.this.setText(text);
                    AutoCompleteEmailEditText.this.setSelection(highlight, text.length());
                }
                AutoCompleteEmailEditText.this.addTextChangedListener(AutoCompleteEmailEditText.this.watcher);
            }
        }
    };

    public AutoCompleteEmailEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoCompleteEmailEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AutoCompleteEmailEditText);
        try {
            CharSequence[] arrayOfCharSequences = a.getTextArray(R.styleable.AutoCompleteEmailEditText_domains);
            if (arrayOfCharSequences != null) {
                String[] referencedDomains = new String[arrayOfCharSequences.length];
                int i = 0;
                for (CharSequence ch : arrayOfCharSequences) {
                    referencedDomains[i++] = ch.toString();
                }
                this.domains = Arrays.asList(referencedDomains);
            } else {
                this.domains = new ArrayList<String>();
            }
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    public AutoCompleteEmailEditText(Context context) {
        super(context);
        this.init();
    }

    public void init() {
        this.setInputType(32);
        this.addTextChangedListener(this.watcher);
        this.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus && AutoCompleteEmailEditText.this.getSelectionStart() != AutoCompleteEmailEditText.this.getSelectionEnd()) {
                    AutoCompleteEmailEditText.this.setSelection(AutoCompleteEmailEditText.this.getText().length());
                }
            }
        });
    }

    public void setSuggestedDomains(List<String> domains) {
        this.domains = domains;
    }
}

