/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.repository;

import androidx.annotation.Keep;
import com.netacom.base.chat.network.BaseRepository;
import com.netacom.lite.entity.database.callog.DbCallEntity;
import com.netacom.lite.entity.ui.call.NeCallLog;
import com.netacom.lite.hilt.executor.PostExecutionThread;
import com.netacom.lite.local.db.DbManager;
import com.netacom.lite.mapper.CallLog_DB_UI_Mapper;
import com.netacom.lite.mapper.CallLog_Server_DB_Mapper;
import com.netacom.lite.network.model.request.CallLogDeleteRequest;
import com.netacom.lite.network.model.request.CallLogItemByUserRequest;
import com.netacom.lite.network.remote.RestCallLogService;
import com.netacom.lite.repository.base.State;
import com.netacom.lite.repository.module.call.CallLogByUserModule;
import com.netacom.lite.repository.module.call.CallLogDeleteModule;
import com.netacom.lite.repository.module.call.CallLogModule;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f0\u000eJ \u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f0\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lcom/netacom/lite/repository/CallLogRepository;", "Lcom/netacom/base/chat/network/BaseRepository;", "dbManager", "Lcom/netacom/lite/local/db/DbManager;", "restCallLogService", "Lcom/netacom/lite/network/remote/RestCallLogService;", "postExecutionThread", "Lcom/netacom/lite/hilt/executor/PostExecutionThread;", "callLogDbUiMapper", "Lcom/netacom/lite/mapper/CallLog_DB_UI_Mapper;", "callLogRCDbMapper", "Lcom/netacom/lite/mapper/CallLog_Server_DB_Mapper;", "(Lcom/netacom/lite/local/db/DbManager;Lcom/netacom/lite/network/remote/RestCallLogService;Lcom/netacom/lite/hilt/executor/PostExecutionThread;Lcom/netacom/lite/mapper/CallLog_DB_UI_Mapper;Lcom/netacom/lite/mapper/CallLog_Server_DB_Mapper;)V", "deleteCallLog", "Lkotlinx/coroutines/flow/Flow;", "Lcom/netacom/lite/repository/base/State;", "", "Lcom/netacom/lite/entity/ui/call/NeCallLog;", "callLogDeleteItemRequest", "Lcom/netacom/lite/network/model/request/CallLogDeleteRequest;", "getCallLogs", "getCallLogsByUser", "callLogItemRequest", "Lcom/netacom/lite/network/model/request/CallLogItemByUserRequest;", "getLocalCallLog", "Lcom/netacom/lite/entity/database/callog/DbCallEntity;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveLocalCallLog", "callLogs", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "netacom-sdk-lite_NetAloProdRelease"})
@Keep
public final class CallLogRepository
extends BaseRepository {
    @NotNull
    private final DbManager dbManager;
    @NotNull
    private final RestCallLogService restCallLogService;
    @NotNull
    private final PostExecutionThread postExecutionThread;
    @NotNull
    private final CallLog_DB_UI_Mapper callLogDbUiMapper;
    @NotNull
    private final CallLog_Server_DB_Mapper callLogRCDbMapper;

    @Inject
    public CallLogRepository(@NotNull DbManager dbManager, @NotNull RestCallLogService restCallLogService, @NotNull PostExecutionThread postExecutionThread, @NotNull CallLog_DB_UI_Mapper callLogDbUiMapper, @NotNull CallLog_Server_DB_Mapper callLogRCDbMapper) {
        Intrinsics.checkNotNullParameter((Object)dbManager, (String)"dbManager");
        Intrinsics.checkNotNullParameter((Object)restCallLogService, (String)"restCallLogService");
        Intrinsics.checkNotNullParameter((Object)postExecutionThread, (String)"postExecutionThread");
        Intrinsics.checkNotNullParameter((Object)callLogDbUiMapper, (String)"callLogDbUiMapper");
        Intrinsics.checkNotNullParameter((Object)callLogRCDbMapper, (String)"callLogRCDbMapper");
        this.dbManager = dbManager;
        this.restCallLogService = restCallLogService;
        this.postExecutionThread = postExecutionThread;
        this.callLogDbUiMapper = callLogDbUiMapper;
        this.callLogRCDbMapper = callLogRCDbMapper;
    }

    @Nullable
    public final Object saveLocalCallLog(@NotNull List<? extends DbCallEntity> callLogs, @NotNull Continuation<? super List<? extends DbCallEntity>> $completion) {
        return this.dbManager.saveLocalCallLog(callLogs, $completion);
    }

    @Nullable
    public final Object getLocalCallLog(@NotNull Continuation<? super List<? extends DbCallEntity>> $completion) {
        return this.dbManager.getLocalCallLog();
    }

    @NotNull
    public final Flow<State<List<NeCallLog>>> getCallLogs() {
        return CallLogModule.INSTANCE.provideCallLogModuleStore(this.restCallLogService, this.dbManager, this.postExecutionThread, this.callLogDbUiMapper, this.callLogRCDbMapper);
    }

    @NotNull
    public final Flow<State<List<NeCallLog>>> getCallLogsByUser(@NotNull CallLogItemByUserRequest callLogItemRequest) {
        Intrinsics.checkNotNullParameter((Object)callLogItemRequest, (String)"callLogItemRequest");
        return CallLogByUserModule.INSTANCE.provideCallLogByUserModuleStore(callLogItemRequest, this.restCallLogService, this.dbManager, this.postExecutionThread, this.callLogDbUiMapper, this.callLogRCDbMapper);
    }

    @NotNull
    public final Flow<State<List<NeCallLog>>> deleteCallLog(@NotNull CallLogDeleteRequest callLogDeleteItemRequest) {
        Intrinsics.checkNotNullParameter((Object)callLogDeleteItemRequest, (String)"callLogDeleteItemRequest");
        return CallLogDeleteModule.INSTANCE.provideCallLogDeleteModuleStore(callLogDeleteItemRequest, this.restCallLogService, this.dbManager, this.postExecutionThread, this.callLogDbUiMapper, this.callLogRCDbMapper);
    }
}

