/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.util;

import android.app.Application;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import androidx.core.content.ContextCompat;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.base.chat.android_utils.FileIOUtils;
import com.netacom.base.chat.android_utils.UriUtils;
import com.netacom.base.chat.android_utils.Utils;
import com.netacom.base.chat.imageloader.ImageUtilsKt;
import com.netacom.base.chat.logger.Logger;
import com.netacom.base.chat.util.ConvertUtil;
import com.netacom.base.chat.util.CoreUtilsKt;
import com.netacom.lite.R;
import com.netacom.lite.define.MediaType;
import com.netacom.lite.entity.ui.local.LocalFileModel;
import com.netacom.lite.repository.secretChat.ChatSecretUtils;
import com.netacom.lite.util.AppUtils;
import com.netacom.lite.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0013j\b\u0012\u0004\u0012\u00020\u0004`\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0013j\b\u0012\u0004\u0012\u00020\u0004`\u00142\u0006\u0010\u0015\u001a\u00020\u0016J(\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0013j\b\u0012\u0004\u0012\u00020\u0004`\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0013j\b\u0012\u0004\u0012\u00020\u0004`\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001aJ%\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J;\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010$\u001a\u0004\u0018\u00010\r2\b\u0010%\u001a\u0004\u0018\u00010\u00042\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0004H\u0002J\u000e\u0010/\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0004J\u001a\u00100\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0016\u00101\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u00042\u0006\u00102\u001a\u000203J\u0018\u00104\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\rH\u0002J\u0010\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010*\u001a\u00020+J\u0018\u00106\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00107\u001a\u00020\rJ\u0018\u00108\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\rJ\u0016\u00109\u001a\u00020:2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u001aJ\u0010\u0010<\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\rH\u0002J\u0010\u0010=\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\rH\u0002J\u000e\u0010>\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u0004J\u0010\u0010?\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\rH\u0002J\u0010\u0010@\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\rH\u0002J$\u0010A\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00110CJ\u0012\u0010D\u001a\u0004\u0018\u00010+2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001e\u0010E\u001a\u00020\u00042\u0006\u0010F\u001a\u00020G2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004J8\u0010I\u001a\u00020\u00042\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010H\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010J\u001a\u00020\u001a2\b\b\u0002\u0010K\u001a\u00020\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006L"}, d2={"Lcom/netacom/lite/util/FileUtils;", "", "()V", "downloadFolderPath", "", "getDownloadFolderPath", "()Ljava/lang/String;", "secretFolderPath", "getSecretFolderPath", "stickerFolder", "getStickerFolder", "videoThumbnailPath", "convertBitmapToUriTemp", "Landroid/net/Uri;", "bitmap", "Landroid/graphics/Bitmap;", "deleteVideoThumbnailFile", "", "findAllDocumentPath", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "context", "Landroid/content/Context;", "findAllImagesPath", "findAllMediaTypePath", "isFull", "", "findAllVideoMediaPath", "getAllLocalFileForMedia", "", "Lcom/netacom/lite/entity/ui/local/LocalFileModel;", "isLoadFull", "getBitmapFromLocalPath", "localPath", "(Ljava/lang/String;Landroid/content/Context;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDataColumn", "uri", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getDocumentMimeType", "file", "Ljava/io/File;", "getDurationOfMediaByPath", "", "path", "getFileSizeMbByPath", "getImageUriShare", "getLocalFileByPath", "type", "Lcom/netacom/lite/define/MediaType;", "getMediaPath", "getMimeType", "getPathFromUri", "contentUri", "getRealPathFromURI", "getWidthOrHeightOfMediaByPath", "", "isWidth", "isDownloadsDocument", "isExternalStorageDocument", "isFolderEmpty", "isGooglePhotosUri", "isMediaDocument", "openFile", "callback", "Lkotlin/Function0;", "saveBitmapToFile", "saveEncryptedFileToLocal", "body", "Lokhttp3/ResponseBody;", "fileName", "saveFileToLocal", "isTemp", "isSaveDocument", "netacom-sdk-lite_NetAloProdRelease"})
@ExperimentalCoroutinesApi
public final class FileUtils {
    private static final String videoThumbnailPath;
    @NotNull
    private static final String downloadFolderPath;
    @NotNull
    private static final String secretFolderPath;
    @NotNull
    private static final String stickerFolder;
    @NotNull
    public static final FileUtils INSTANCE;

    @NotNull
    public final String getDownloadFolderPath() {
        return downloadFolderPath;
    }

    @NotNull
    public final String getSecretFolderPath() {
        return secretFolderPath;
    }

    @NotNull
    public final String getStickerFolder() {
        return stickerFolder;
    }

    @Nullable
    public final String getMimeType(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            String extension = FilesKt.getExtension((File)file);
            CharSequence charSequence = extension;
            int n = 0;
            if (charSequence.length() > 0) {
                MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
                charSequence = extension;
                n = 1;
                boolean bl = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)charSequence2).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                return mimeTypeMap.getMimeTypeFromExtension(string2);
            }
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            e.printStackTrace();
        }
        return "application/octet-stream";
    }

    public final void deleteVideoThumbnailFile() {
        com.netacom.base.chat.android_utils.FileUtils.deleteAllInDir((File)new File(videoThumbnailPath));
    }

    @Nullable
    public final Uri convertBitmapToUriTemp(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"Utils.getApp()");
        File file = application.getCacheDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"Utils.getApp().cacheDir");
        File tempDir = new File(file.getAbsolutePath());
        File tempFile = File.createTempFile("cache" + UUID.randomUUID(), ".jpg", tempDir);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            byte[] bitmapData = bos.toByteArray();
            FileOutputStream fos = new FileOutputStream(tempFile);
            fos.write(bitmapData);
            fos.flush();
            fos.close();
            Logger.INSTANCE.d("___FileUtils = " + Uri.fromFile((File)tempFile), new Object[0]);
            return Uri.fromFile((File)tempFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            Uri uri = Uri.fromFile((File)tempFile);
            return uri;
        }
    }

    @Nullable
    public final File saveBitmapToFile(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        File videoThumbLocalFile = new File(videoThumbnailPath + AppUtils.INSTANCE.createFileNamePNG());
        com.netacom.base.chat.android_utils.FileUtils.createOrExistsFile((File)videoThumbLocalFile);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos);
            byte[] bitmapData = bos.toByteArray();
            FileOutputStream fos = new FileOutputStream(videoThumbLocalFile);
            fos.write(bitmapData);
            fos.flush();
            fos.close();
            Logger.INSTANCE.d("___FileUtils = " + Uri.parse((String)videoThumbLocalFile.getPath()), new Object[0]);
            return videoThumbLocalFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            File file = videoThumbLocalFile;
            return file;
        }
    }

    @Nullable
    public final Uri getImageUriShare(@NotNull Context context, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bytes);
        String bitmapUri = MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (Bitmap)bitmap, (String)context.getString(R.string.app_name), null);
        return Uri.parse((String)bitmapUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getPathFromUri(@NotNull Context context, @NotNull Uri contentUri) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)contentUri, (String)"contentUri");
        Cursor cursor = null;
        try {
            String string3;
            String[] proj = new String[]{"_data"};
            Cursor cursor2 = cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
            Integer column_index = cursor2 != null ? Integer.valueOf(cursor2.getColumnIndexOrThrow("_data")) : null;
            Cursor cursor3 = cursor;
            if (cursor3 != null) {
                cursor3.moveToFirst();
            }
            Cursor cursor4 = cursor;
            if (cursor4 != null) {
                Integer n = column_index;
                string3 = cursor4.getString(n != null ? n : 0);
            } else {
                string3 = null;
            }
            string2 = string3;
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            e.printStackTrace();
            string2 = "";
        }
        finally {
            Cursor cursor5 = cursor;
            if (cursor5 != null) {
                cursor5.close();
            }
        }
        return string2;
    }

    @Nullable
    public final String getRealPathFromURI(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (this.isExternalStorageDocument(uri)) {
                String docId;
                String string2 = docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"docId");
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                if (StringsKt.equals((String)"primary", (String)type, (boolean)true)) {
                    return Environment.getExternalStorageDirectory().toString() + "/" + split[1];
                }
            } else {
                if (this.isDownloadsDocument(uri)) {
                    String id;
                    String string3 = id = DocumentsContract.getDocumentId((Uri)uri);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"id");
                    CharSequence $this$isDigitsOnly$iv = string3;
                    boolean $i$f$isDigitsOnly = false;
                    if (!TextUtils.isDigitsOnly((CharSequence)$this$isDigitsOnly$iv) && Intrinsics.areEqual((Object)(id = CoreUtilsKt.getOnlyDigits((String)id)), (Object)"")) {
                        id = "0";
                    }
                    Uri uri2 = Uri.parse((String)"content://downloads/public_downloads");
                    Long l = Long.valueOf(id);
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"java.lang.Long.valueOf(id)");
                    Uri uri3 = ContentUris.withAppendedId((Uri)uri2, (long)l);
                    Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"ContentUris.withAppended\u2026eOf(id)\n                )");
                    Uri contentUri = uri3;
                    return this.getDataColumn(context, contentUri, null, null);
                }
                if (this.isMediaDocument(uri)) {
                    String docId;
                    String string4 = docId = DocumentsContract.getDocumentId((Uri)uri);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"docId");
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string4, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Object thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] split = stringArray;
                    String type = split[0];
                    Uri contentUri = null;
                    switch (type) {
                        case "image": {
                            contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                            break;
                        }
                        case "video": {
                            contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                            break;
                        }
                        case "audio": {
                            contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                            break;
                        }
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return this.getDataColumn(context, contentUri, selection, selectionArgs);
                }
            }
        } else {
            if (StringsKt.equals((String)"content", (String)uri.getScheme(), (boolean)true)) {
                return this.isGooglePhotosUri(uri) ? uri.getLastPathSegment() : this.getDataColumn(context, uri, null, null);
            }
            if (StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true)) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor;
        block6: {
            String string2;
            cursor = null;
            String column = "_data";
            String[] projection = new String[]{column};
            try {
                Cursor cursor2;
                Uri uri2 = uri;
                if (uri2 != null) {
                    Uri uri3 = uri2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Uri it = uri3;
                    boolean bl3 = false;
                    cursor2 = context.getContentResolver().query(it, projection, selection, selectionArgs, null);
                } else {
                    cursor2 = cursor = null;
                }
                if (cursor == null || !cursor.moveToFirst()) break block6;
                int index = cursor.getColumnIndexOrThrow(column);
                string2 = cursor.getString(index);
            }
            catch (Throwable throwable) {
                Cursor cursor3 = cursor;
                if (cursor3 != null) {
                    cursor3.close();
                }
                throw throwable;
            }
            cursor.close();
            return string2;
        }
        Cursor cursor4 = cursor;
        if (cursor4 != null) {
            cursor4.close();
        }
        return null;
    }

    private final boolean isExternalStorageDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    private final boolean isDownloadsDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    private final boolean isMediaDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    private final boolean isGooglePhotosUri(Uri uri) {
        return Intrinsics.areEqual((Object)"com.google.android.apps.photos.content", (Object)uri.getAuthority());
    }

    @NotNull
    public final ArrayList<String> findAllImagesPath(@NotNull Context context) {
        ArrayList<String> allPath;
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Cursor cursor = null;
            int columnIndexData = 0;
            Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"MediaStore.Images.Media.EXTERNAL_CONTENT_URI");
            Uri uri2 = uri;
            String[] projection = new String[]{"_data", "bucket_display_name"};
            String orderBy = "datetaken";
            cursor = context.getContentResolver().query(uri2, projection, null, null, orderBy + " DESC");
            allPath = new ArrayList<String>();
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                Cursor cursor3 = cursor2;
                boolean bl = false;
                boolean bl2 = false;
                Cursor it = cursor3;
                boolean bl3 = false;
                columnIndexData = it.getColumnIndexOrThrow("_data");
                while (it.moveToNext()) {
                    String absolutePathOfImage = it.getString(columnIndexData);
                    Logger.INSTANCE.e("Column", new Object[]{absolutePathOfImage});
                    allPath.add(absolutePathOfImage);
                }
            }
            Cursor cursor4 = cursor;
            if (cursor4 == null) break block2;
            cursor4.close();
        }
        return allPath;
    }

    @NotNull
    public final ArrayList<String> findAllVideoMediaPath(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Uri uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        String[] projection = new String[]{"_data"};
        Cursor cursor = context.getContentResolver().query(uri, projection, null, null, null);
        ArrayList<String> pathArrList = new ArrayList<String>();
        String pattern = ".mp4";
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String string2 = cursor.getString(0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cursor.getString(0)");
                if (!StringsKt.endsWith$default((String)string2, (String)pattern, (boolean)false, (int)2, null)) continue;
                pathArrList.add(cursor.getString(0));
            }
            cursor.close();
        }
        return pathArrList;
    }

    private final ArrayList<String> findAllMediaTypePath(Context context, boolean isFull) {
        ArrayList<String> allPath = new ArrayList<String>();
        try {
            String[] projection = new String[]{"_id", "_data", "date_added", "media_type", "mime_type", "title"};
            String selection = "media_type=1 OR media_type=3";
            String orderBy = "date_added";
            Cursor cursor = context.getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), projection, selection, null, orderBy + " DESC");
            int columnIndexData = 0;
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                Cursor cursor3 = cursor2;
                boolean bl = false;
                boolean bl2 = false;
                Cursor it = cursor3;
                boolean bl3 = false;
                columnIndexData = it.getColumnIndexOrThrow("_data");
                while (it.moveToNext()) {
                    allPath.add(it.getString(columnIndexData));
                    if (isFull || allPath.size() <= 100) continue;
                    break;
                }
            }
            Cursor cursor4 = cursor;
            if (cursor4 != null) {
                cursor4.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
        }
        return allPath;
    }

    private final ArrayList<String> findAllDocumentPath(Context context) {
        ArrayList<String> allDocPath;
        block3: {
            String[] projection = new String[]{"_id", "_data", "mime_type", "date_added", "date_modified", "_display_name", "title", "_size"};
            boolean bl = false;
            List mimeTypes = new ArrayList();
            List extenstions = CollectionsKt.mutableListOf((Object[])new String[]{"pdf", "doc", "docx", "csv", "xls", "xlsx", "ppt", "pptx"});
            Iterable $this$forEach$iv = extenstions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string2;
                String mimeType = (String)element$iv;
                boolean bl2 = false;
                if (MimeTypeMap.getSingleton().getMimeTypeFromExtension(mimeType) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                String it = string2;
                boolean bl5 = false;
                mimeTypes.add('\'' + it + '\'');
            }
            String selectionMimeType = "mime_type" + " IN (" + CollectionsKt.joinToString$default((Iterable)mimeTypes, null, null, null, (int)0, null, null, (int)63, null) + ')';
            Cursor allDocumentFilesCursor = context.getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), projection, selectionMimeType, null, "date_added");
            int columnIndexData = 0;
            allDocPath = new ArrayList<String>();
            Cursor cursor = allDocumentFilesCursor;
            if (cursor != null) {
                Cursor cursor2 = cursor;
                boolean bl6 = false;
                boolean bl7 = false;
                Cursor cursor3 = cursor2;
                boolean bl8 = false;
                columnIndexData = cursor3.getColumnIndexOrThrow("_data");
                while (cursor3.moveToNext()) {
                    allDocPath.add(cursor3.getString(columnIndexData));
                }
            }
            Cursor cursor4 = allDocumentFilesCursor;
            if (cursor4 == null) break block3;
            cursor4.close();
        }
        return allDocPath;
    }

    private final long getDurationOfMediaByPath(String path) {
        long l;
        try {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource(path);
            String time = retriever.extractMetadata(9);
            Object object = time;
            long duration = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 0L;
            retriever.release();
            l = duration > (long)1000 ? duration / (long)1000 : 0L;
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            e.printStackTrace();
            l = 0L;
        }
        return l;
    }

    public final int getWidthOrHeightOfMediaByPath(@NotNull String path, boolean isWidth) {
        int n;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource(path);
            int dataType = isWidth ? 18 : 19;
            String metadata = retriever.extractMetadata(dataType);
            Object object = metadata;
            int distance = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
            retriever.release();
            n = distance;
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            e.printStackTrace();
            n = 0;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getBitmapFromLocalPath(@NotNull String var1_1, @Nullable Context var2_2, @NotNull Continuation<? super Bitmap> var3_3) {
        if (!(var3_3 instanceof getBitmapFromLocalPath.1)) ** GOTO lbl-1000
        var11_4 = var3_3;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ FileUtils this$0;
                Object L$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getBitmapFromLocalPath(null, null, (Continuation<? super Bitmap>)this);
                }
                {
                    this.this$0 = fileUtils;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 = new Ref.ObjectRef();
                var4_7.element = null;
                v0 = context;
                if (v0 == null) break;
                var5_8 = v0;
                var6_9 = false;
                var7_10 = false;
                var8_11 = var5_8;
                $i$a$-let-FileUtils$getBitmapFromLocalPath$2 = false;
                $continuation.L$0 = bitmap;
                $continuation.label = 1;
                v1 = ImageUtilsKt.loadBitmapSync$default((Context)context, (Object)localPath, (Function1)((Function1)new Function1<Bitmap, Unit>((Continuation)$continuation, (Context)context, (String)localPath, bitmap){
                    final /* synthetic */ Continuation $continuation$inlined;
                    final /* synthetic */ Context $context$inlined;
                    final /* synthetic */ String $localPath$inlined;
                    final /* synthetic */ Ref.ObjectRef $bitmap$inlined;
                    {
                        this.$continuation$inlined = continuation;
                        this.$context$inlined = context;
                        this.$localPath$inlined = string2;
                        this.$bitmap$inlined = objectRef;
                        super(1);
                    }

                    public final void invoke(@Nullable Bitmap it) {
                        this.$bitmap$inlined.element = it;
                    }
                }), (int)0, (Continuation)$continuation, (int)8, null);
                if (v1 == var12_6) {
                    return var12_6;
                }
                break;
            }
            case 1: {
                $i$a$-let-FileUtils$getBitmapFromLocalPath$2 = false;
                bitmap = (Ref.ObjectRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                break;
            }
        }
        return (Bitmap)bitmap.element;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final long getFileSizeMbByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        long length = new File(path).length() / (long)1024;
        return length / (long)1024;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getMediaPath(Context context, Uri uri) {
        ContentResolver resolver = context.getContentResolver();
        String[] projection = new String[]{"_data"};
        Cursor cursor = null;
        try {
            String string2;
            cursor = resolver.query(uri, projection, null, null, null);
            if (cursor != null) {
                int columnIndex = cursor.getColumnIndexOrThrow("_data");
                cursor.moveToFirst();
                String string3 = cursor.getString(columnIndex);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"cursor.getString(columnIndex)");
            } else {
                string2 = "";
            }
            String columnIndex = string2;
            return columnIndex;
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            ContentResolver contentResolver = resolver;
            boolean bl = false;
            boolean bl2 = false;
            ContentResolver it = contentResolver;
            boolean bl3 = false;
            String filePath = context.getApplicationInfo().dataDir + File.separator + System.currentTimeMillis();
            File file = new File(filePath);
            InputStream inputStream = resolver.openInputStream(uri);
            if (inputStream != null) {
                Closeable closeable = inputStream;
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable = null;
                try {
                    InputStream inputStream2 = (InputStream)closeable;
                    boolean bl6 = false;
                    Closeable closeable2 = new FileOutputStream(file);
                    boolean bl7 = false;
                    boolean bl8 = false;
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream outputStream = (FileOutputStream)closeable2;
                        boolean bl9 = false;
                        byte[] buf = new byte[4096];
                        int len = 0;
                        while (true) {
                            int n = inputStream2.read(buf);
                            boolean bl10 = false;
                            boolean bl11 = false;
                            int it2 = n;
                            boolean bl12 = false;
                            len = it2;
                            if (n <= 0) break;
                            outputStream.write(buf, 0, len);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            String string4 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"file.absolutePath");
            String string5 = string4;
            return string5;
        }
        finally {
            block21: {
                Cursor cursor2 = cursor;
                if (cursor2 == null) break block21;
                cursor2.close();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void openFile(@NotNull Context context, @NotNull File file, @NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        try {
            block6: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                block12: {
                                                    block11: {
                                                        block10: {
                                                            block9: {
                                                                block8: {
                                                                    block7: {
                                                                        block5: {
                                                                            block4: {
                                                                                uri = Build.VERSION.SDK_INT >= 24 ? UriUtils.file2Uri((File)file) : Uri.fromFile((File)file);
                                                                                intent = new Intent("android.intent.action.VIEW");
                                                                                v0 = file.toString();
                                                                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"file.toString()");
                                                                                if (StringsKt.contains$default((CharSequence)v0, (CharSequence)".doc", (boolean)false, (int)2, null)) break block4;
                                                                                v1 = file.toString();
                                                                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"file.toString()");
                                                                                if (!StringsKt.contains$default((CharSequence)v1, (CharSequence)".docx", (boolean)false, (int)2, null)) break block5;
                                                                            }
                                                                            intent.setDataAndType(uri, "application/msword");
                                                                            break block6;
                                                                        }
                                                                        v2 = file.toString();
                                                                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"file.toString()");
                                                                        if (!StringsKt.contains$default((CharSequence)v2, (CharSequence)".pdf", (boolean)false, (int)2, null)) break block7;
                                                                        intent.setDataAndType(uri, "application/pdf");
                                                                        break block6;
                                                                    }
                                                                    v3 = file.toString();
                                                                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"file.toString()");
                                                                    if (StringsKt.contains$default((CharSequence)v3, (CharSequence)".ppt", (boolean)false, (int)2, null)) break block8;
                                                                    v4 = file.toString();
                                                                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"file.toString()");
                                                                    if (!StringsKt.contains$default((CharSequence)v4, (CharSequence)".pptx", (boolean)false, (int)2, null)) break block9;
                                                                }
                                                                intent.setDataAndType(uri, "application/vnd.ms-powerpoint");
                                                                break block6;
                                                            }
                                                            v5 = file.toString();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"file.toString()");
                                                            if (StringsKt.contains$default((CharSequence)v5, (CharSequence)".xls", (boolean)false, (int)2, null)) break block10;
                                                            v6 = file.toString();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"file.toString()");
                                                            if (!StringsKt.contains$default((CharSequence)v6, (CharSequence)".xlsx", (boolean)false, (int)2, null)) break block11;
                                                        }
                                                        intent.setDataAndType(uri, "application/vnd.ms-excel");
                                                        break block6;
                                                    }
                                                    v7 = file.toString();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"file.toString()");
                                                    if (!StringsKt.contains$default((CharSequence)v7, (CharSequence)".zip", (boolean)false, (int)2, null)) break block12;
                                                    intent.setDataAndType(uri, "application/zip");
                                                    break block6;
                                                }
                                                v8 = file.toString();
                                                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"file.toString()");
                                                if (!StringsKt.contains$default((CharSequence)v8, (CharSequence)".rar", (boolean)false, (int)2, null)) break block13;
                                                intent.setDataAndType(uri, "application/x-rar-compressed");
                                                break block6;
                                            }
                                            v9 = file.toString();
                                            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"file.toString()");
                                            if (!StringsKt.contains$default((CharSequence)v9, (CharSequence)".rtf", (boolean)false, (int)2, null)) break block14;
                                            intent.setDataAndType(uri, "application/rtf");
                                            break block6;
                                        }
                                        v10 = file.toString();
                                        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"file.toString()");
                                        if (StringsKt.contains$default((CharSequence)v10, (CharSequence)".wav", (boolean)false, (int)2, null)) break block15;
                                        v11 = file.toString();
                                        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"file.toString()");
                                        if (!StringsKt.contains$default((CharSequence)v11, (CharSequence)".mp3", (boolean)false, (int)2, null)) break block16;
                                    }
                                    intent.setDataAndType(uri, "audio/x-wav");
                                    break block6;
                                }
                                v12 = file.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"file.toString()");
                                if (!StringsKt.contains$default((CharSequence)v12, (CharSequence)".gif", (boolean)false, (int)2, null)) break block17;
                                intent.setDataAndType(uri, "image/gif");
                                break block6;
                            }
                            v13 = file.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"file.toString()");
                            if (StringsKt.contains$default((CharSequence)v13, (CharSequence)".jpg", (boolean)false, (int)2, null)) break block18;
                            v14 = file.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"file.toString()");
                            if (StringsKt.contains$default((CharSequence)v14, (CharSequence)".jpeg", (boolean)false, (int)2, null)) break block18;
                            v15 = file.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"file.toString()");
                            if (!StringsKt.contains$default((CharSequence)v15, (CharSequence)".png", (boolean)false, (int)2, null)) break block19;
                        }
                        intent.setDataAndType(uri, "image/jpeg");
                        break block6;
                    }
                    v16 = file.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"file.toString()");
                    if (!StringsKt.contains$default((CharSequence)v16, (CharSequence)".txt", (boolean)false, (int)2, null)) break block20;
                    intent.setDataAndType(uri, "text/plain");
                    break block6;
                }
                v17 = file.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"file.toString()");
                if (StringsKt.contains$default((CharSequence)v17, (CharSequence)".3gp", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v18 = file.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"file.toString()");
                if (StringsKt.contains$default((CharSequence)v18, (CharSequence)".mpg", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v19 = file.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"file.toString()");
                if (StringsKt.contains$default((CharSequence)v19, (CharSequence)".mpeg", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v20 = file.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"file.toString()");
                if (StringsKt.contains$default((CharSequence)v20, (CharSequence)".mpe", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v21 = file.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"file.toString()");
                if (StringsKt.contains$default((CharSequence)v21, (CharSequence)".mp4", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v22 = file.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"file.toString()");
                if (StringsKt.contains$default((CharSequence)v22, (CharSequence)".avi", (boolean)false, (int)2, null)) lbl-1000:
                // 6 sources

                {
                    intent.setDataAndType(uri, "video/*");
                } else {
                    intent.setDataAndType(uri, "*/*");
                }
            }
            intent.addFlags(1);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            Toast.makeText((Context)context, (CharSequence)"No application found which can open the file", (int)0).show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String saveFileToLocal(@Nullable ResponseBody body, @NotNull Context context, @Nullable String fileName, boolean isTemp, boolean isSaveDocument) {
        File file;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (body == null) {
            return "";
        }
        InputStream input = null;
        if (isTemp) {
            Application application = Utils.getApp();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"Utils.getApp()");
            File file2 = application.getCacheDir();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"Utils.getApp().cacheDir");
            File tempDir = new File(file2.getAbsolutePath());
            file = File.createTempFile("cache" + UUID.randomUUID(), ".jpg", tempDir);
        } else {
            String string2;
            File dir;
            File file3;
            if (isSaveDocument) {
                file3 = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOCUMENTS);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                File file4 = Environment.getExternalStorageDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"Environment.getExternalStorageDirectory()");
                file3 = dir = new File(stringBuilder.append(file4.getPath()).append("/download_file").toString());
            }
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if ((string2 = fileName) == null) {
                string2 = AppUtils.INSTANCE.createFileNamePNG();
            }
            file = new File(dir, string2);
        }
        File file5 = file;
        try {
            input = body.byteStream();
            File file6 = file5;
            Intrinsics.checkNotNullExpressionValue((Object)file6, (String)"file");
            FileOutputStream fos = new FileOutputStream(file6.getAbsolutePath());
            Object object = fos;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream output = (FileOutputStream)object;
                boolean bl3 = false;
                byte[] buffer = new byte[4096];
                int read = 0;
                while (true) {
                    int n = input.read(buffer);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    int it = n;
                    boolean bl6 = false;
                    read = it;
                    if (n == -1) break;
                    output.write(buffer, 0, read);
                }
                output.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            String string3 = UriUtils.file2Uri((File)file5).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"UriUtils.file2Uri(file).toString()");
            object = string3;
            return object;
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            e.printStackTrace();
        }
        finally {
            InputStream inputStream = input;
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return "";
    }

    public static /* synthetic */ String saveFileToLocal$default(FileUtils fileUtils, ResponseBody responseBody, Context context, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return fileUtils.saveFileToLocal(responseBody, context, string2, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String saveEncryptedFileToLocal(@NotNull ResponseBody body, @NotNull String path, @NotNull String fileName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File dir = new File(path);
        com.netacom.base.chat.android_utils.FileUtils.createOrExistsDir((File)dir);
        File file = new File(dir, fileName);
        InputStream inputStream = body.byteStream();
        try {
            FileIOUtils.writeFileFromBytesByStream((File)file, (byte[])ChatSecretUtils.INSTANCE.decryptFileInput(ByteStreamsKt.readBytes((InputStream)inputStream)));
            String string3 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.absolutePath");
            string2 = string3;
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            e.printStackTrace();
            String string4 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"file.absolutePath");
            string2 = string4;
        }
        finally {
            body.close();
            inputStream.close();
        }
        return string2;
    }

    @NotNull
    public final List<LocalFileModel> getAllLocalFileForMedia(@NotNull Context context, boolean isLoadFull) {
        boolean hasPermissionStore;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean bl = false;
        List allMediaFile = new ArrayList();
        boolean bl2 = Build.VERSION.SDK_INT >= 30 ? Environment.isExternalStorageManager() : (hasPermissionStore = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0);
        if (hasPermissionStore) {
            Boolean bl3;
            LocalFileModel localMedia;
            LocalFileModel $this$apply;
            boolean bl4;
            boolean bl5;
            LocalFileModel localFileModel;
            File file;
            String path;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.findAllMediaTypePath(context, isLoadFull);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                MediaType mediaType;
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                file = com.netacom.base.chat.android_utils.FileUtils.getFileByPath((String)path);
                localFileModel = new LocalFileModel(path, null, null, 0L, 0L, null, 0L, null, null, null, null, null, 0, 0L, 16382, null);
                bl5 = false;
                bl4 = false;
                $this$apply = localFileModel;
                boolean bl7 = false;
                if (StringsKt.endsWith$default((String)path, (String)".mp4", (boolean)false, (int)2, null)) {
                    $this$apply.setFileDuration(INSTANCE.getDurationOfMediaByPath(path));
                    mediaType = MediaType.VIDEO;
                } else {
                    mediaType = MediaType.PHOTO;
                }
                $this$apply.setFileType(mediaType);
                $this$apply.setFileSize(com.netacom.base.chat.android_utils.FileUtils.getFileLength((String)path));
                $this$apply.setFileSizeText(ConvertUtil.INSTANCE.convertSize($this$apply.getFileSize()));
                File file2 = file;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                $this$apply.setFileExtension(FilesKt.getExtension((File)file2));
                $this$apply.setDateAdded(file.lastModified());
                $this$apply.setFileName(FilesKt.getNameWithoutExtension((File)file));
                localMedia = localFileModel;
                bl3 = allMediaFile.add(localMedia);
                collection.add(bl3);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            $this$map$iv = this.findAllDocumentPath(context);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                path = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl8 = false;
                file = com.netacom.base.chat.android_utils.FileUtils.getFileByPath((String)path);
                localFileModel = new LocalFileModel(path, null, null, 0L, 0L, null, 0L, null, null, null, null, null, 0, 0L, 16382, null);
                bl5 = false;
                bl4 = false;
                $this$apply = localFileModel;
                boolean bl9 = false;
                $this$apply.setFileType(MediaType.FILE);
                $this$apply.setFileSize(com.netacom.base.chat.android_utils.FileUtils.getFileLength((String)path));
                $this$apply.setFileSizeText(ConvertUtil.INSTANCE.convertSize($this$apply.getFileSize()));
                File file3 = file;
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file");
                $this$apply.setFileExtension(FilesKt.getExtension((File)file3));
                $this$apply.setDateAdded(file.lastModified());
                $this$apply.setFileName(FilesKt.getNameWithoutExtension((File)file));
                $this$apply.setFileDuration(0L);
                localMedia = localFileModel;
                bl3 = allMediaFile.add(localMedia);
                collection.add(bl3);
            }
            List cfr_ignored_1 = (List)destination$iv$iv;
        }
        return allMediaFile;
    }

    @NotNull
    public final String getDocumentMimeType(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            String extension = FilesKt.getExtension((File)file);
            CharSequence charSequence = extension;
            boolean bl = false;
            if (charSequence.length() > 0) {
                String string2;
                switch (extension) {
                    case "doc": {
                        string2 = "application/msword";
                        break;
                    }
                    case "docx": {
                        string2 = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
                        break;
                    }
                    case "xls": {
                        string2 = "application/vnd.ms-excel";
                        break;
                    }
                    case "xlsx": {
                        string2 = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                        break;
                    }
                    case "ppt": {
                        string2 = "application/vnd.ms-powerpoint";
                        break;
                    }
                    case "pptx": {
                        string2 = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
                        break;
                    }
                    case "pdf": {
                        string2 = "application/pdf";
                        break;
                    }
                    default: {
                        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
                        String string3 = extension;
                        int n = 1;
                        boolean bl2 = false;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                        String string6 = mimeTypeMap.getMimeTypeFromExtension(string5);
                        if (string6 == null) {
                            string6 = "";
                        }
                        string2 = string6;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"MimeTypeMap.getSingleton\u2026nsion.substring(1)) ?: \"\"");
                    }
                }
                return string2;
            }
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            e.printStackTrace();
        }
        return "";
    }

    @NotNull
    public final LocalFileModel getLocalFileByPath(@NotNull String path, @NotNull MediaType type) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        File file = com.netacom.base.chat.android_utils.FileUtils.getFileByPath((String)path);
        LocalFileModel localFileModel = new LocalFileModel(path, null, null, 0L, 0L, null, 0L, null, null, null, null, null, 0, 0L, 16382, null);
        boolean bl = false;
        boolean bl2 = false;
        LocalFileModel $this$apply = localFileModel;
        boolean bl3 = false;
        if (type == MediaType.VIDEO || type == MediaType.AUDIO) {
            $this$apply.setFileDuration(INSTANCE.getDurationOfMediaByPath(path));
        } else {
            $this$apply.setFileDuration(0L);
        }
        $this$apply.setFileType(type);
        $this$apply.setFileSize(com.netacom.base.chat.android_utils.FileUtils.getFileLength((String)path));
        $this$apply.setFileSizeText(ConvertUtil.INSTANCE.convertSize($this$apply.getFileSize()));
        File file2 = file;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
        $this$apply.setFileExtension(FilesKt.getExtension((File)file2));
        $this$apply.setDateAdded(file.lastModified());
        $this$apply.setFileName(FilesKt.getNameWithoutExtension((File)file));
        return localFileModel;
    }

    public final boolean isFolderEmpty(@NotNull String path) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        if (file.isDirectory()) {
            String[] list;
            String[] stringArray = file.list();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"file.list()");
            String[] stringArray2 = list = stringArray;
            boolean bl2 = false;
            bl = stringArray2.length == 0;
        } else {
            bl = true;
        }
        return bl;
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
        StringBuilder stringBuilder = new StringBuilder();
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"Utils.getApp()");
        File file = application.getFilesDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"Utils.getApp().filesDir");
        videoThumbnailPath = stringBuilder.append(file.getPath()).append("/download_file/video_thumbnail/").toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        Application application2 = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"Utils.getApp()");
        File file2 = application2.getFilesDir();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"Utils.getApp().filesDir");
        downloadFolderPath = stringBuilder2.append(file2.getPath()).append("/download_file").toString();
        StringBuilder stringBuilder3 = new StringBuilder();
        Application application3 = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application3, (String)"Utils.getApp()");
        File file3 = application3.getFilesDir();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"Utils.getApp().filesDir");
        secretFolderPath = stringBuilder3.append(file3.getPath()).append("/download_file/secret").toString();
        StringBuilder stringBuilder4 = new StringBuilder();
        Application application4 = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application4, (String)"Utils.getApp()");
        File file4 = application4.getFilesDir();
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"Utils.getApp().filesDir");
        stickerFolder = stringBuilder4.append(file4.getPath()).append("/Stickers").toString();
    }
}

