/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.util;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Typeface;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.ContactsContract;
import android.text.Html;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.DisplayMetrics;
import android.util.Patterns;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.content.ContextCompat;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.base.chat.android_utils.ActivityUtils;
import com.netacom.base.chat.android_utils.StringUtils;
import com.netacom.base.chat.android_utils.Utils;
import com.netacom.base.chat.logger.Logger;
import com.netacom.base.chat.util.CoreUtilsKt;
import com.netacom.base.chat.util.ExtensionsUtilsKt;
import com.netacom.lite.R;
import com.netacom.lite.define.MentionType;
import com.netacom.lite.entity.database.attachment.NeAttachments;
import com.netacom.lite.entity.mention.NeMentionPosition;
import com.netacom.lite.entity.mention.NeWebPhoneMail;
import com.netacom.lite.entity.ui.message.NeMessage;
import com.netacom.lite.entity.ui.user.NeUser;
import com.netacom.lite.repository.GroupRepository;
import com.netacom.lite.util.AppUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\b\u0010\u0015\u001a\u00020\u0004H\u0002J\b\u0010\u0016\u001a\u00020\u0004H\u0002J\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00042\b\b\u0002\u0010\u001e\u001a\u00020\u0004J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010!\u001a\u0004\u0018\u00010\u00042\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#2\u0006\u0010%\u001a\u00020&J(\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\f\u0010)\u001a\b\u0012\u0004\u0012\u00020$0#2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+J\u0016\u0010,\u001a\u00020-2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010.\u001a\u00020$J0\u0010/\u001a\b\u0012\u0004\u0012\u0002000#2\u0006\u0010(\u001a\u00020\u00042\f\u0010)\u001a\b\u0012\u0004\u0012\u00020$0#2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u001e\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\nJ \u00105\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020-H\u0002J\u0018\u00109\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010:\u001a\u000207H\u0002J\u0010\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020\u0004J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020?0#2\u0006\u0010(\u001a\u00020\u0004H\u0002J\u000e\u0010@\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010A\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u0004J\u000e\u0010B\u001a\u00020-2\u0006\u0010(\u001a\u00020\u0004J\u000e\u0010C\u001a\u00020-2\u0006\u0010(\u001a\u00020\u0004J\u000e\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\u0004J\u000e\u0010F\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010G\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010H\u001a\u00020\u001cJ\u0016\u0010G\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010H\u001a\u00020\u001aJ\u001a\u0010I\u001a\u0004\u0018\u00010\u00142\u0006\u0010J\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\u001aH\u0002J\u0014\u0010L\u001a\u0004\u0018\u00010\u00142\b\u0010(\u001a\u0004\u0018\u00010\u0014H\u0003J\u0016\u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010O\u001a\u00020\r2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\nJ\u000e\u0010S\u001a\u00020\u00042\u0006\u0010R\u001a\u00020\nJV\u0010T\u001a\u00020\r2\u0006\u0010P\u001a\u00020Q2\u0006\u0010U\u001a\u00020V2\u0006\u0010(\u001a\u00020\u00042\f\u0010)\u001a\b\u0012\u0004\u0012\u00020$0#2\u0014\b\u0002\u0010W\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\r0X2\u0006\u0010Y\u001a\u00020\u001a2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/netacom/lite/util/AppUtils;", "", "()V", "EMAIL_REGEX", "", "MENTION_ALL_REGEX", "MENTION_REGEX", "VN_MINI_PHONE_REGEX", "VN_PHONE_REGEX", "convertSizeToMB", "", "value", "copyTextToClipboard", "", "context", "Landroid/content/Context;", "content", "createFileFromBitmap", "Ljava/io/File;", "bitmap", "Landroid/graphics/Bitmap;", "createFileName", "createFileNameJPEG", "createFileNamePNG", "createImageFile", "dpToPx", "", "dp", "", "email", "subject", "getContactName", "phoneNumber", "getContentPinMessage", "listUser", "", "Lcom/netacom/lite/entity/ui/user/NeUser;", "neMessage", "Lcom/netacom/lite/entity/ui/message/NeMessage;", "getMentionContent", "input", "neMembers", "groupRepository", "Lcom/netacom/lite/repository/GroupRepository;", "getMessagesHasOwnerMention", "", "owner", "getNeMentionMembers", "Lcom/netacom/lite/entity/mention/NeMentionPosition;", "getRandomReceiverColor", "arrColorSize", "userID", "groupID", "getRotation", "imageUri", "Landroid/net/Uri;", "isCamera", "getRotationFromCamera", "imageFile", "getSpannedText", "Landroid/text/Spanned;", "text", "getWebPhoneMailText", "Lcom/netacom/lite/entity/mention/NeWebPhoneMail;", "getWidth", "intentGoToLink", "isMiniVnPhoneNumber", "isVnPhoneNumber", "nameRepresent", "name", "notificationSetting", "pxToDp", "px", "rotate", "bm", "rotation", "scaleBitmap", "sendSMSIntent", "phone", "setAudioTextViewTag", "view", "Landroid/widget/TextView;", "time", "setAudioTextViewTime", "setupSpannableString", "type", "Lcom/netacom/lite/define/MentionType;", "callback", "Lkotlin/Function1;", "themeColor", "netacom-sdk-lite_NetAloProdRelease"})
public final class AppUtils {
    private static final String VN_PHONE_REGEX = "(0|[+]84)+([0-9]{9})\\b";
    private static final String VN_MINI_PHONE_REGEX = "(0|[+]84)+([0-9]{0,9})\\b";
    private static final String MENTION_REGEX = "@([0-9]){15,16}";
    private static final String MENTION_ALL_REGEX = "@all";
    private static final String EMAIL_REGEX = "^[a-z][a-z0-9_.]{5,32}@[a-z0-9]{2,}(\\.[a-z0-9]{2,4}){1,2}$";
    @NotNull
    public static final AppUtils INSTANCE;

    public final int getWidth(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().widthPixels;
    }

    public final int dpToPx(@NotNull Context context, float dp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public final float pxToDp(@NotNull Context context, int px) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.pxToDp(context, 1.0f * (float)px);
    }

    public final float pxToDp(@NotNull Context context, float px) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return px / (float)(resources.getDisplayMetrics().densityDpi / 160);
    }

    private final String createFileName() {
        return "NetAlo_" + System.currentTimeMillis() + '_' + new Random().nextInt(10) + '_' + new Random().nextInt(10);
    }

    private final String createFileNameJPEG() {
        return this.createFileName() + ".jpg";
    }

    @NotNull
    public final String createFileNamePNG() {
        return this.createFileName() + ".png";
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    private final Bitmap scaleBitmap(Bitmap input) {
        Bitmap bitmap;
        block6: {
            if (input == null) {
                return null;
            }
            bitmap = null;
            try {
                int bmWidth = input.getWidth();
                int bmHeight = input.getHeight();
                if (bmWidth > 1080 || bmHeight > 1080) {
                    if (bmWidth > bmHeight) {
                        bmHeight = 1080 * bmHeight / bmWidth;
                        bmWidth = 1080;
                        bitmap = Bitmap.createScaledBitmap((Bitmap)input, (int)bmWidth, (int)bmHeight, (boolean)false);
                    } else {
                        bmWidth = 1080 * bmWidth / bmHeight;
                        bmHeight = 1080;
                        bitmap = Bitmap.createScaledBitmap((Bitmap)input, (int)bmWidth, (int)bmHeight, (boolean)false);
                    }
                    break block6;
                }
                return input;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return bitmap;
    }

    @Nullable
    public final File createFileFromBitmap(@NotNull Context context, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            if (bitmap == null) {
                return null;
            }
            File file = new File(context.getCacheDir(), this.createFileNamePNG());
            file.createNewFile();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos);
            byte[] bitmapData = bos.toByteArray();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bitmapData);
            fos.flush();
            fos.close();
            return file;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            File file = null;
            return file;
        }
    }

    private final int getRotation(Context context, Uri imageUri, boolean isCamera) {
        return isCamera ? this.getRotationFromCamera(context, imageUri) : this.getRotationFromCamera(context, imageUri);
    }

    private final int getRotationFromCamera(Context context, Uri imageFile) {
        int rotate = 0;
        try {
            context.getContentResolver().notifyChange(imageFile, null);
            ExifInterface exif = new ExifInterface(String.valueOf(imageFile.getPath()));
            int orientation = exif.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 6: {
                    rotate = 90;
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rotate;
    }

    private final Bitmap rotate(Bitmap bm, int rotation) {
        if (rotation != 0) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)rotation);
            return Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)matrix, (boolean)true);
        }
        return bm;
    }

    @NotNull
    public final File createImageFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String timeStamp = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault()).format(new Date());
        String fileName = "JPEG_" + timeStamp + "_";
        File storageDir = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        File file = File.createTempFile(fileName, ".jpg", storageDir);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"File.createTempFile(fileName, \".jpg\", storageDir)");
        return file;
    }

    public final void intentGoToLink(@NotNull Context context, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            if (Pattern.compile(EMAIL_REGEX).matcher(input).find()) {
                Intent i = new Intent("android.intent.action.SENDTO", Uri.fromParts((String)"mailto", (String)input, null));
                context.startActivity(Intent.createChooser((Intent)i, (CharSequence)"Send email"));
            } else if (Patterns.WEB_URL.matcher(input).find()) {
                String string2 = input;
                boolean bl = false;
                boolean bl2 = false;
                String string3 = string2;
                String string4 = "android.intent.action.VIEW";
                boolean bl3 = false;
                String string5 = StringsKt.startsWith$default((String)input, (String)"Http", (boolean)false, (int)2, null) ? StringsKt.replaceFirst$default((String)input, (String)"Http", (String)"http", (boolean)false, (int)4, null) : input;
                Uri uri = Uri.parse((String)string5);
                String string6 = string4;
                Intent browserIntent = new Intent(string6, uri);
                context.startActivity(browserIntent);
            } else if (Pattern.compile(VN_PHONE_REGEX).matcher(input).find()) {
                context.startActivity(new Intent("android.intent.action.DIAL", Uri.fromParts((String)"tel", (String)input, null)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
        }
    }

    public final boolean isMiniVnPhoneNumber(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Pattern.compile(VN_MINI_PHONE_REGEX).matcher(input).find();
    }

    public final boolean isVnPhoneNumber(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Pattern.compile(VN_PHONE_REGEX).matcher(input).find();
    }

    public final void sendSMSIntent(@NotNull String phone, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)phone, (String)"phone");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Intent sendIntent = new Intent("android.intent.action.SENDTO");
            sendIntent.setData(Uri.parse((String)("smsto:" + Uri.encode((String)phone))));
            sendIntent.putExtra("sms_body", StringUtils.INSTANCE.getString(R.string.text_invite));
            context.startActivity(sendIntent);
            Logger.INSTANCE.d("sendSMSIntent SENT", new Object[0]);
        }
        catch (Exception e) {
            StringBuilder stringBuilder = new StringBuilder().append("sendSMSIntent Exception: ");
            e.printStackTrace();
            Logger.INSTANCE.d(stringBuilder.append(Unit.INSTANCE).toString(), new Object[0]);
            e.printStackTrace();
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
        }
    }

    public final void setupSpannableString(@NotNull TextView view, @NotNull MentionType type, @NotNull String input, @NotNull List<NeUser> neMembers, @NotNull Function1<? super NeMentionPosition, Unit> callback, int themeColor, @Nullable GroupRepository groupRepository) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(neMembers, (String)"neMembers");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        List<NeMentionPosition> mentionMembers = this.getNeMentionMembers(input, neMembers, groupRepository);
        int fixPosition = 0;
        String spanInput = input;
        Iterable $this$forEach$iv = mentionMembers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NeMentionPosition it2 = (NeMentionPosition)element$iv;
            boolean bl = false;
            spanInput = StringsKt.replaceFirst$default((String)spanInput, (String)it2.getMentionId(), (String)it2.getMentionName(), (boolean)false, (int)4, null);
            it2.setPosition(it2.getPosition() - fixPosition);
            fixPosition = fixPosition + it2.getMentionId().length() - it2.getMentionName().length();
        }
        List<NeWebPhoneMail> webOrPhoneText = this.getWebPhoneMailText(spanInput);
        SpannableString neMention = new SpannableString((CharSequence)spanInput);
        Iterable $this$forEach$iv2 = webOrPhoneText;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (NeWebPhoneMail)element$iv;
            boolean bl = false;
            neMention.setSpan((Object)new ClickableSpan((NeWebPhoneMail)it){
                final /* synthetic */ NeWebPhoneMail $it;

                public void onClick(@NotNull View view) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Context context = view.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
                    AppUtils.INSTANCE.intentGoToLink(context, this.$it.getText());
                }

                public void updateDrawState(@NotNull TextPaint ds) {
                    Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
                    super.updateDrawState(ds);
                    ds.setUnderlineText(true);
                }
                {
                    this.$it = $captured_local_variable$0;
                }
            }, ((NeWebPhoneMail)it).getPosition(), ((NeWebPhoneMail)it).getPosition() + ((NeWebPhoneMail)it).getText().length(), 33);
        }
        $this$forEach$iv2 = mentionMembers;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (NeMentionPosition)element$iv;
            boolean bl = false;
            neMention.setSpan((Object)new ClickableSpan((NeMentionPosition)it, neMention, callback, type){
                final /* synthetic */ NeMentionPosition $it;
                final /* synthetic */ SpannableString $neMention$inlined;
                final /* synthetic */ Function1 $callback$inlined;
                final /* synthetic */ MentionType $type$inlined;
                {
                    this.$it = $captured_local_variable$1;
                    this.$neMention$inlined = spannableString;
                    this.$callback$inlined = function1;
                    this.$type$inlined = mentionType;
                }

                public void onClick(@NotNull View p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    this.$callback$inlined.invoke((Object)this.$it);
                }

                public void updateDrawState(@NotNull TextPaint ds) {
                    Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
                    super.updateDrawState(ds);
                    if (Intrinsics.areEqual((Object)this.$type$inlined, (Object)MentionType.MINE.INSTANCE)) {
                        ds.setTypeface(Typeface.DEFAULT_BOLD);
                    }
                    ds.setUnderlineText(false);
                }
            }, ((NeMentionPosition)it).getPosition(), ((NeMentionPosition)it).getPosition() + ((NeMentionPosition)it).getMentionName().length(), 33);
        }
        view.setText((CharSequence)neMention);
        view.setMovementMethod(LinkMovementMethod.getInstance());
        MentionType mentionType = type;
        if (Intrinsics.areEqual((Object)mentionType, (Object)MentionType.MINE.INSTANCE)) {
            view.setTextColor(-1);
            view.setLinkTextColor(-1);
        } else if (Intrinsics.areEqual((Object)mentionType, (Object)MentionType.PARTNER.INSTANCE)) {
            view.setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)R.color.color_text_partner_type));
            view.setLinkTextColor(ExtensionsUtilsKt.getThemeColor((int)themeColor));
        } else if (Intrinsics.areEqual((Object)mentionType, (Object)MentionType.REPLY.INSTANCE)) {
            view.setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)R.color.color_text_replay_type));
            view.setLinkTextColor(ExtensionsUtilsKt.getThemeColor((int)themeColor));
        } else if (Intrinsics.areEqual((Object)mentionType, (Object)MentionType.NORMAL.INSTANCE)) {
            view.setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)R.color.color_black_25272a));
            view.setLinkTextColor(ExtensionsUtilsKt.getThemeColor((int)themeColor));
        } else if (Intrinsics.areEqual((Object)mentionType, (Object)MentionType.OTHER.INSTANCE)) {
            view.setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)R.color.color_black_25272a));
            view.setLinkTextColor(ExtensionsUtilsKt.getThemeColor((int)themeColor));
        }
        view.setHighlightColor(0);
    }

    public static /* synthetic */ void setupSpannableString$default(AppUtils appUtils, TextView textView, MentionType mentionType, String string2, List list, Function1 function1, int n, GroupRepository groupRepository, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            function1 = setupSpannableString.1.INSTANCE;
        }
        if ((n2 & 0x40) != 0) {
            groupRepository = null;
        }
        appUtils.setupSpannableString(textView, mentionType, string2, list, (Function1<? super NeMentionPosition, Unit>)function1, n, groupRepository);
    }

    @NotNull
    public final String getMentionContent(@NotNull String input, @NotNull List<NeUser> neMembers, @Nullable GroupRepository groupRepository) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(neMembers, (String)"neMembers");
        List<NeMentionPosition> mentionMembers = this.getNeMentionMembers(input, neMembers, groupRepository);
        String result = input;
        Iterable $this$forEach$iv = mentionMembers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NeMentionPosition it = (NeMentionPosition)element$iv;
            boolean bl = false;
            result = StringsKt.replaceFirst$default((String)result, (String)it.getMentionId(), (String)it.getMentionName(), (boolean)false, (int)4, null);
        }
        return result;
    }

    public static /* synthetic */ String getMentionContent$default(AppUtils appUtils, String string2, List list, GroupRepository groupRepository, int n, Object object) {
        if ((n & 4) != 0) {
            groupRepository = null;
        }
        return appUtils.getMentionContent(string2, list, groupRepository);
    }

    /*
     * WARNING - void declaration
     */
    private final List<NeMentionPosition> getNeMentionMembers(String input, List<NeUser> neMembers, GroupRepository groupRepository) {
        void $this$mapTo$iv$iv;
        boolean bl = false;
        List mentionMembers = new ArrayList();
        Pattern pattern = Pattern.compile(MENTION_ALL_REGEX);
        String string2 = input;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        boolean bl2 = false;
        String string3 = string2;
        boolean bl3 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        Matcher matcherMentionAll = pattern.matcher(string5);
        while (matcherMentionAll.find()) {
            String string6 = matcherMentionAll.group();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"matcherMentionAll.group()");
            mentionMembers.add(new NeMentionPosition(string6, matcherMentionAll.start(), null, true, 4, null));
        }
        Pattern pattern2 = Pattern.compile(MENTION_REGEX);
        Matcher matcher = pattern2.matcher(input);
        while (matcher.find()) {
            String string7 = matcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"matcher.group()");
            mentionMembers.add(new NeMentionPosition(string7, matcher.start(), null, false, 12, null));
        }
        Iterable $this$map$iv = mentionMembers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection collection;
            block11: {
                Object object;
                void v7;
                block12: {
                    block13: {
                        void it;
                        Object v6;
                        Object element$iv2;
                        void men;
                        block9: {
                            block10: {
                                NeMentionPosition neMentionPosition = (NeMentionPosition)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl4 = false;
                                if (!men.isAll()) break block10;
                                men.setMentionName("@All");
                                break block11;
                            }
                            Iterable $this$firstOrNull$iv = neMembers;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv2 : $this$firstOrNull$iv) {
                                NeUser it2 = (NeUser)element$iv2;
                                boolean bl5 = false;
                                if (!Intrinsics.areEqual((Object)("" + '@' + it2.getId()), (Object)men.getMentionId())) continue;
                                v6 = element$iv2;
                                break block9;
                            }
                            v6 = null;
                        }
                        NeUser mentionMember = v6;
                        v7 = men;
                        object = mentionMember;
                        if (object != null && (object = ((NeUser)object).getGetDisplayName()) != null) break block12;
                        object = groupRepository;
                        if (object == null) break block13;
                        Object object2 = object;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        element$iv2 = object2;
                        void var24_31 = v7;
                        boolean bl8 = false;
                        String mentionId = StringsKt.replace$default((String)men.getMentionId(), (String)"@", (String)"", (boolean)false, (int)4, null);
                        Long l = StringsKt.toLongOrNull((String)mentionId);
                        Object object3 = it.getUserById(l != null ? l : 0L);
                        if (object3 == null || (object3 = ((NeUser)object3).getGetDisplayName()) == null) {
                            object3 = StringUtils.INSTANCE.getString(R.string.unknown_user);
                        }
                        Object object4 = object3;
                        v7 = var24_31;
                        object = object4;
                        if (object != null) break block12;
                    }
                    object = StringUtils.INSTANCE.getString(R.string.unknown_user);
                }
                v7.setMentionName((String)object);
            }
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return mentionMembers;
    }

    static /* synthetic */ List getNeMentionMembers$default(AppUtils appUtils, String string2, List list, GroupRepository groupRepository, int n, Object object) {
        if ((n & 4) != 0) {
            groupRepository = null;
        }
        return appUtils.getNeMentionMembers(string2, list, groupRepository);
    }

    public final boolean getMessagesHasOwnerMention(@NotNull String input, @NotNull NeUser owner) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Pattern pattern = Pattern.compile(MENTION_REGEX);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            String string2 = matcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group()");
            String string3 = StringsKt.replace$default((String)string2, (String)"@", (String)"", (boolean)false, (int)4, null);
            boolean bl2 = false;
            Long l = owner.getId();
            bl = l != null && Long.parseLong(string3) == l;
        } else {
            bl = false;
        }
        return bl;
    }

    private final List<NeWebPhoneMail> getWebPhoneMailText(String input) {
        boolean bl = false;
        List result = new ArrayList();
        Pattern patternPhone = Pattern.compile(VN_PHONE_REGEX);
        Matcher matcherPhone = patternPhone.matcher(input);
        while (matcherPhone.find()) {
            String string2 = matcherPhone.group();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcherPhone.group()");
            result.add(new NeWebPhoneMail(string2, matcherPhone.start()));
        }
        Matcher matcherWeb = Patterns.WEB_URL.matcher(input);
        while (matcherWeb.find()) {
            Object v1;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            block7: {
                $this$firstOrNull$iv = result;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    NeWebPhoneMail it = (NeWebPhoneMail)element$iv;
                    boolean bl2 = false;
                    int n = it.getPosition();
                    if (!(matcherWeb.start() <= n && matcherWeb.end() >= n)) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            $this$firstOrNull$iv = v1;
            $i$f$firstOrNull = false;
            boolean bl3 = false;
            NeWebPhoneMail it = (NeWebPhoneMail)((Object)$this$firstOrNull$iv);
            boolean bl4 = false;
            if (it == null) {
                String string3 = matcherWeb.group();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"matcherWeb.group()");
                result.add(new NeWebPhoneMail(string3, matcherWeb.start()));
                continue;
            }
            it.setPosition(matcherWeb.start());
            String string4 = matcherWeb.group();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"matcherWeb.group()");
            it.setText(string4);
        }
        Pattern patternEmail = Pattern.compile(EMAIL_REGEX);
        Matcher matcherEmail = patternEmail.matcher(input);
        while (matcherEmail.find()) {
            Object v4;
            block8: {
                Iterable $this$firstOrNull$iv = result;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    NeWebPhoneMail it = (NeWebPhoneMail)element$iv;
                    boolean bl5 = false;
                    int n = it.getPosition();
                    if (!(matcherEmail.start() <= n && matcherEmail.end() >= n)) continue;
                    v4 = element$iv;
                    break block8;
                }
                v4 = null;
            }
            Object var8_12 = v4;
            boolean bl6 = false;
            boolean bl7 = false;
            NeWebPhoneMail it = var8_12;
            boolean bl8 = false;
            if (it == null) {
                String string5 = matcherEmail.group();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"matcherEmail.group()");
                result.add(new NeWebPhoneMail(string5, matcherEmail.start()));
                continue;
            }
            it.setPosition(matcherEmail.start());
            String string6 = matcherEmail.group();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"matcherEmail.group()");
            it.setText(string6);
        }
        return result;
    }

    @NotNull
    public final String setAudioTextViewTime(long time) {
        long setTimeToMillisecond = time * (long)1000;
        long minutes = setTimeToMillisecond / (long)1000 / (long)60;
        long seconds = setTimeToMillisecond / (long)1000 % (long)60;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = Locale.getDefault();
        String string2 = "%02d:%02d";
        Object[] objectArray = new Object[]{minutes, seconds};
        boolean bl = false;
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        return string3;
    }

    public final void setAudioTextViewTag(@NotNull TextView view, long time) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        long setTimeToMillisecond = time * (long)1000;
        long minutes = setTimeToMillisecond / (long)1000 / (long)60;
        long seconds = setTimeToMillisecond / (long)1000 % (long)60;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = Locale.getDefault();
        String string2 = "%02d:%02d";
        Object[] objectArray = new Object[]{minutes, seconds};
        boolean bl = false;
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        String timeLeftFormatted = string3;
        view.setTag((Object)timeLeftFormatted);
    }

    public final void notificationSetting(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent();
        intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
        intent.putExtra("app_package", context.getPackageName());
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        intent.putExtra("app_uid", (Serializable)(applicationInfo != null ? Integer.valueOf(applicationInfo.uid) : null));
        intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
        context.startActivity(intent);
    }

    public final void email(@NotNull String email, @NotNull String subject) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intent emailIntent = new Intent("android.intent.action.SENDTO");
        emailIntent.setData(Uri.parse((String)("mailto:" + email)));
        emailIntent.putExtra("android.intent.extra.SUBJECT", subject);
        try {
            ActivityUtils.startActivity((Intent)Intent.createChooser((Intent)emailIntent, (CharSequence)"Send email using..."));
        }
        catch (ActivityNotFoundException ex) {
            Toast.makeText((Context)((Context)Utils.getApp()), (CharSequence)"No email clients installed.", (int)0).show();
        }
    }

    public static /* synthetic */ void email$default(AppUtils appUtils, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "";
        }
        appUtils.email(string2, string3);
    }

    public final long convertSizeToMB(long value) {
        return value <= 0L ? value : value / (long)1024 / (long)1024;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String nameRepresent(@NotNull String name) {
        void $this$reduce$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CharSequence charSequence = name;
        boolean bl = false;
        charSequence = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
        bl = false;
        if (charSequence.length() == 0) {
            return "";
        }
        String nameAvatar = null;
        Object object = name;
        boolean bl2 = false;
        String unAccentText = CoreUtilsKt.unAccentText((String)((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString());
        object = unAccentText;
        bl2 = false;
        String string2 = object;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        object = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        void var6_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            String it = (String)element$iv$iv;
            boolean bl4 = false;
            Character c = StringsKt.firstOrNull((CharSequence)it);
            if ((c != null ? String.valueOf(c.charValue()) : null) == null) continue;
            string3 = string3;
            boolean bl5 = false;
            boolean bl6 = false;
            String it$iv$iv = string3;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void s;
            String $i$f$mapNotNullTo2 = (String)iterator$iv.next();
            String acc = (String)accumulator$iv;
            boolean bl8 = false;
            accumulator$iv = acc + (String)s;
        }
        nameAvatar = (String)accumulator$iv;
        if (nameAvatar.length() < 2 && unAccentText.length() > 1) {
            nameAvatar = ((Object)unAccentText.subSequence(0, 2)).toString();
        } else if (nameAvatar.length() < 2 && unAccentText.length() == 1) {
            nameAvatar = ((Object)unAccentText.subSequence(0, 1)).toString();
        } else if (nameAvatar.length() > 2) {
            nameAvatar = ((Object)nameAvatar.subSequence(0, 2)).toString();
        }
        object = nameAvatar;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        boolean bl9 = false;
        Object object2 = object;
        boolean bl10 = false;
        Object object3 = object2;
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = ((String)object3).toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase(locale)");
        return string4;
    }

    @Nullable
    public final String getContentPinMessage(@Nullable List<NeUser> listUser, @NotNull NeMessage neMessage) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)neMessage, (String)"neMessage");
        Long l = neMessage.getStatus();
        long l2 = 3L;
        if (l != null && l == l2) {
            string2 = StringUtils.INSTANCE.getString(R.string.message_has_been_removed);
        } else {
            Integer n;
            Integer n2 = n = neMessage.getType();
            int n3 = 0;
            if (n2 != null && n2 == 0) {
                List list;
                String string3 = neMessage.getContent();
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    string4 = "";
                }
                if ((list = listUser) == null) {
                    boolean bl2 = false;
                    list = new ArrayList();
                }
                string2 = AppUtils.getMentionContent$default(this, string4, list, null, 4, null);
            } else {
                Integer n4 = n;
                n3 = 2;
                if (n4 != null && n4 == n3) {
                    Object object = neMessage.getAttachment();
                    if (object != null && (object = ((NeAttachments)object).getImages()) != null) {
                        n3 = object.size();
                        boolean bl = false;
                        boolean bl3 = false;
                        int $this$run = n3;
                        boolean bl4 = false;
                        return $this$run > 0 ? "" + $this$run + ' ' + StringUtils.INSTANCE.getString(R.string.last_message_sent_images) : StringUtils.INSTANCE.getString(R.string.last_message_sent_one_image);
                    }
                    string2 = StringUtils.INSTANCE.getString(R.string.last_message_sent_one_image);
                } else {
                    Integer n5 = n;
                    n3 = 3;
                    if (n5 != null && n5 == n3) {
                        string2 = StringUtils.INSTANCE.getString(R.string.last_message_audio);
                    } else {
                        Integer n6 = n;
                        n3 = 4;
                        if (n6 != null && n6 == n3) {
                            string2 = StringUtils.INSTANCE.getString(R.string.last_message_video);
                        } else {
                            Integer n7 = n;
                            n3 = 14;
                            string2 = n7 != null && n7 == n3 ? StringUtils.INSTANCE.getString(R.string.str_location) : StringUtils.INSTANCE.getString(R.string.blank);
                        }
                    }
                }
            }
        }
        return string2;
    }

    public final void copyTextToClipboard(@NotNull Context context, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Object object = context.getSystemService("clipboard");
        if (!(object instanceof ClipboardManager)) {
            object = null;
        }
        ClipboardManager clipboardManager = (ClipboardManager)object;
        if (clipboardManager != null) {
            ClipData clipData = ClipData.newPlainText((CharSequence)context.getString(R.string.copy_to_clipboard), (CharSequence)content);
            boolean bl = false;
            boolean bl2 = false;
            ClipData clipData2 = clipData;
            ClipboardManager clipboardManager2 = clipboardManager;
            boolean bl3 = false;
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.copy_to_clipboard), (int)0).show();
            Unit unit = Unit.INSTANCE;
            clipboardManager2.setPrimaryClip(clipData);
        } else {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.error_text_401), (int)0).show();
        }
    }

    public final int getRandomReceiverColor(int arrColorSize, long userID, long groupID) {
        if (userID != 0L) {
            int lastUserIdDigit = (int)(userID % (long)10);
            int lastGroupIdDigit = (int)(groupID % (long)10);
            return (lastUserIdDigit + lastGroupIdDigit) % arrColorSize;
        }
        return kotlin.random.Random.Default.nextInt(arrColorSize);
    }

    @Nullable
    public final Spanned getSpannedText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)text, (int)0) : Html.fromHtml((String)text);
    }

    @Nullable
    public final String getContactName(@Nullable String phoneNumber, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = phoneNumber;
        String phoneNumberTarget = string2 != null ? StringsKt.replace$default((String)string2, (String)"+84", (String)"0", (boolean)false, (int)4, null) : null;
        Uri uri = Uri.withAppendedPath((Uri)ContactsContract.PhoneLookup.CONTENT_FILTER_URI, (String)Uri.encode((String)phoneNumberTarget));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Uri.withAppendedPath(\n  \u2026neNumberTarget)\n        )");
        Uri uri2 = uri;
        String[] projection = new String[]{"display_name"};
        String contactName = null;
        Cursor cursor = context.getContentResolver().query(uri2, projection, null, null, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                contactName = cursor.getString(0);
            }
            cursor.close();
        }
        return contactName;
    }

    private AppUtils() {
    }

    static {
        AppUtils appUtils;
        INSTANCE = appUtils = new AppUtils();
    }
}

