/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.hilt.network;

import com.netacom.base.chat.network.logging.Level;
import com.netacom.base.chat.network.logging.LoggingInterceptor;
import com.netacom.base.chat.okhttp.OkHttpExtensionsKt;
import com.netacom.base.chat.util.ExtensionsUtilsKt;
import com.netacom.lite.config.EndPoint;
import com.netacom.lite.hilt.network.HostApiInterceptor;
import com.netacom.lite.hilt.type.ApiOkHttpClient;
import com.netacom.lite.hilt.type.BaseRetrofit;
import com.netacom.lite.hilt.type.BaseUrl;
import com.netacom.lite.hilt.type.SocketOkHttpClient;
import com.netacom.lite.hilt.type.SocketUrl;
import com.netacom.lite.hilt.type.TrackingOkHttpClient;
import com.netacom.lite.hilt.type.UploadFileRetrofit;
import com.netacom.lite.hilt.type.UploadOkHttpClient;
import com.netacom.lite.local.prefs.PreferencesHelperImpl;
import com.squareup.moshi.Moshi;
import dagger.Module;
import dagger.Provides;
import dagger.hilt.InstallIn;
import dagger.hilt.components.SingletonComponent;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

@Module
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0014\u001a\u00020\u0006H\u0007J$\u0010\u0015\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u0016\u001a\u00020\bH\u0007J\b\u0010\u0017\u001a\u00020\rH\u0007J\b\u0010\u0018\u001a\u00020\bH\u0007\u00a8\u0006\u0019"}, d2={"Lcom/netacom/lite/hilt/network/NetworkModule;", "", "()V", "provideBaseRetrofit", "Lretrofit2/Retrofit;", "okHttpClient", "Lokhttp3/OkHttpClient;", "baseUrl", "", "moShi", "Lcom/squareup/moshi/Moshi;", "provideOkHttpClient", "loggingInterceptor", "Lcom/netacom/base/chat/network/logging/LoggingInterceptor;", "hostApiInterceptor", "Lcom/netacom/lite/hilt/network/HostApiInterceptor;", "provideOkHttpClientUpload", "preferencesHelperImpl", "Lcom/netacom/lite/local/prefs/PreferencesHelperImpl;", "provideOkHttpSocket", "provideOkHttpTracking", "provideUploadFileRetrofit", "providesBaseUrl", "providesLoggingInterceptor", "providesSocketUrl", "netacom-sdk-lite_NetAloDevRelease"})
@InstallIn(value={SingletonComponent.class})
public final class NetworkModule {
    @NotNull
    public static final NetworkModule INSTANCE = new NetworkModule();

    private NetworkModule() {
    }

    @Provides
    @ApiOkHttpClient
    @NotNull
    public final OkHttpClient provideOkHttpClient(@NotNull LoggingInterceptor loggingInterceptor, @NotNull HostApiInterceptor hostApiInterceptor) {
        Intrinsics.checkNotNullParameter((Object)loggingInterceptor, (String)"loggingInterceptor");
        Intrinsics.checkNotNullParameter((Object)hostApiInterceptor, (String)"hostApiInterceptor");
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().addInterceptor((Interceptor)hostApiInterceptor).connectTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS);
        OkHttpExtensionsKt.clearText((OkHttpClient.Builder)clientBuilder);
        return clientBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @UploadOkHttpClient
    @NotNull
    public final OkHttpClient provideOkHttpClientUpload(@NotNull LoggingInterceptor loggingInterceptor, @NotNull PreferencesHelperImpl preferencesHelperImpl) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)loggingInterceptor, (String)"loggingInterceptor");
        Intrinsics.checkNotNullParameter((Object)preferencesHelperImpl, (String)"preferencesHelperImpl");
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        boolean bl = false;
        OkHttpClient.Builder clientBuilder = this_$iv.addInterceptor(new Interceptor(preferencesHelperImpl){
            final /* synthetic */ PreferencesHelperImpl $preferencesHelperImpl$inlined;
            {
                this.$preferencesHelperImpl$inlined = preferencesHelperImpl;
            }

            @NotNull
            public final Response intercept(@NotNull Interceptor.Chain chain) {
                Response response2;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                    Interceptor.Chain chain2 = chain;
                    boolean bl = false;
                    try {
                        Request.Builder headers = chain2.request().newBuilder();
                        headers.addHeader("Accept", "application/json");
                        headers.addHeader("Content-Type", "application/json");
                        String string2 = this.$preferencesHelperImpl$inlined.getToken();
                        if (string2 != null) {
                            String string3 = string2;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            String token = string3;
                            boolean bl4 = false;
                            if (ExtensionsUtilsKt.isNotNull((Object)token)) {
                                headers.addHeader("TC-Token", token);
                            }
                        }
                        response2 = chain2.proceed(headers.build());
                        break block5;
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    response2 = chain2.proceed(chain2.request());
                }
                return response2;
            }
        }).connectTimeout(3L, TimeUnit.MINUTES).readTimeout(3L, TimeUnit.MINUTES);
        OkHttpExtensionsKt.clearText((OkHttpClient.Builder)clientBuilder);
        return clientBuilder.build();
    }

    @Provides
    @SocketOkHttpClient
    @NotNull
    public final OkHttpClient provideOkHttpSocket(@NotNull LoggingInterceptor loggingInterceptor, @NotNull HostApiInterceptor hostApiInterceptor) {
        Intrinsics.checkNotNullParameter((Object)loggingInterceptor, (String)"loggingInterceptor");
        Intrinsics.checkNotNullParameter((Object)hostApiInterceptor, (String)"hostApiInterceptor");
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().pingInterval(4L, TimeUnit.SECONDS).retryOnConnectionFailure(false);
        OkHttpExtensionsKt.clearText((OkHttpClient.Builder)clientBuilder);
        return clientBuilder.build();
    }

    @Provides
    @TrackingOkHttpClient
    @NotNull
    public final OkHttpClient provideOkHttpTracking() {
        OkHttpClient.Builder clientBuilder;
        OkHttpClient.Builder this_$iv = clientBuilder = new OkHttpClient.Builder();
        boolean bl = false;
        this_$iv.addInterceptor(new Interceptor(){

            @NotNull
            public final Response intercept(@NotNull Interceptor.Chain chain) {
                Response response2;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                    Interceptor.Chain chain2 = chain;
                    boolean bl = false;
                    try {
                        Request.Builder headers = chain2.request().newBuilder();
                        headers.addHeader("X-Platform", "android");
                        headers.addHeader("X-Version", "1.0.0");
                        response2 = chain2.proceed(headers.build());
                        break block3;
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    response2 = chain2.proceed(chain2.request());
                }
                return response2;
            }
        });
        OkHttpExtensionsKt.clearText((OkHttpClient.Builder)clientBuilder);
        return clientBuilder.build();
    }

    @Provides
    @BaseUrl
    @NotNull
    public final String providesBaseUrl() {
        return EndPoint.INSTANCE.getURL_API();
    }

    @Provides
    @SocketUrl
    @NotNull
    public final String providesSocketUrl() {
        return EndPoint.INSTANCE.getURL_SOCKET();
    }

    @Provides
    @Singleton
    @NotNull
    public final LoggingInterceptor providesLoggingInterceptor() {
        return new LoggingInterceptor.Builder().loggable(false).setLevel(Level.BODY).log(4).request("NetAlo_request").response("NetAlo_response").build();
    }

    @Provides
    @Singleton
    @BaseRetrofit
    @NotNull
    public final Retrofit provideBaseRetrofit(@ApiOkHttpClient @NotNull OkHttpClient okHttpClient, @BaseUrl @NotNull String baseUrl, @NotNull Moshi moShi) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)moShi, (String)"moShi");
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(okHttpClient).addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)moShi).asLenient()).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"Builder()\n            .baseUrl(baseUrl)\n            .client(okHttpClient)\n            .addConverterFactory(MoshiConverterFactory.create(moShi).asLenient())\n            .build()");
        return retrofit;
    }

    @Provides
    @Singleton
    @UploadFileRetrofit
    @NotNull
    public final Retrofit provideUploadFileRetrofit(@UploadOkHttpClient @NotNull OkHttpClient okHttpClient, @BaseUrl @NotNull String baseUrl, @NotNull Moshi moShi) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)moShi, (String)"moShi");
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(okHttpClient).addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)moShi).asLenient()).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"Builder()\n            .baseUrl(baseUrl)\n            .client(okHttpClient)\n            .addConverterFactory(MoshiConverterFactory.create(moShi).asLenient())\n            .build()");
        return retrofit;
    }
}

