/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.widget.swipe_layout;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.customview.widget.ViewDragHelper;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u000234B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\"H\u0016J\u0006\u0010$\u001a\u00020\u0013J\b\u0010%\u001a\u00020\"H\u0014J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(H\u0016J0\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0007H\u0014J\u0010\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020(H\u0016J\u000e\u00101\u001a\u00020\"2\u0006\u00102\u001a\u00020\u0013R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/netacom/full/widget/swipe_layout/SwipeLayout;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "downX", "", "getDownX", "()F", "setDownX", "(F)V", "downY", "getDownY", "setDownY", "forceClose", "", "isSwipe", "leftOffset", "mContentView", "Landroid/view/View;", "mGestureDetector", "Landroid/view/GestureDetector;", "mMenuView", "mMenuWidth", "mScreenWidth", "mTouchSlop", "mViewDragHelper", "Landroidx/customview/widget/ViewDragHelper;", "menuIsOpen", "closeMenu", "", "computeScroll", "isOpen", "onFinishInflate", "onInterceptTouchEvent", "ev", "Landroid/view/MotionEvent;", "onLayout", "changed", "left", "top", "right", "bottom", "onTouchEvent", "event", "setNoSwipe", "is_swipe", "GestureDetectorCallback", "MyDragHelperCallback", "netacom-sdk-full_NetAloProdRelease"})
public final class SwipeLayout
extends FrameLayout {
    private ViewDragHelper mViewDragHelper;
    private View mContentView;
    private View mMenuView;
    private int mMenuWidth;
    private int mTouchSlop;
    private boolean menuIsOpen;
    private boolean isSwipe;
    private int mScreenWidth;
    private boolean forceClose;
    private GestureDetector mGestureDetector;
    private int leftOffset;
    private float downX;
    private float downY;

    public final void setNoSwipe(boolean is_swipe) {
        this.isSwipe = is_swipe;
    }

    public final boolean isOpen() {
        return this.menuIsOpen;
    }

    protected void onFinishInflate() {
        block1: {
            View $this$apply;
            boolean bl;
            boolean bl2;
            View view;
            super.onFinishInflate();
            View view2 = this.getChildAt(0);
            if (view2 != null) {
                view = view2;
                bl2 = false;
                bl = false;
                $this$apply = view;
                boolean bl3 = false;
                this.mMenuView = $this$apply;
            }
            View view3 = this.getChildAt(1);
            if (view3 == null) break block1;
            view = view3;
            bl2 = false;
            bl = false;
            $this$apply = view;
            boolean bl4 = false;
            this.mContentView = $this$apply;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        View view = this.mMenuView;
        this.mMenuWidth = view != null ? view.getMeasuredWidth() : 0;
    }

    public final float getDownX() {
        return this.downX;
    }

    public final void setDownX(float f) {
        this.downX = f;
    }

    public final float getDownY() {
        return this.downY;
    }

    public final void setDownY(float f) {
        this.downY = f;
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        switch (ev.getAction()) {
            case 0: {
                this.mViewDragHelper.processTouchEvent(ev);
                this.downX = ev.getX();
                this.downY = ev.getY();
                if (!this.menuIsOpen || !(this.downX < (float)(this.mScreenWidth - this.mMenuWidth))) break;
                this.forceClose = true;
                return true;
            }
            case 2: {
                float dy = ev.getY() - this.downY;
                float dx = ev.getX() - this.downX;
                if (this.menuIsOpen) break;
                return !(Math.abs(dx) < (float)this.mTouchSlop) || !(Math.abs(dy) < (float)this.mTouchSlop);
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.mGestureDetector.onTouchEvent(event)) {
            return true;
        }
        this.mViewDragHelper.processTouchEvent(event);
        return true;
    }

    public void computeScroll() {
        if (this.mViewDragHelper.continueSettling(true)) {
            this.invalidate();
        }
    }

    public final void closeMenu() {
        block1: {
            View view = this.mContentView;
            if (view == null) break block1;
            View view2 = view;
            boolean bl = false;
            boolean bl2 = false;
            View $this$apply = view2;
            boolean bl3 = false;
            if (this.mViewDragHelper.smoothSlideViewTo($this$apply, 0, 0)) {
                this.menuIsOpen = false;
                this.forceClose = false;
                this.leftOffset = 0;
                $this$apply.invalidate();
            }
        }
    }

    @JvmOverloads
    public SwipeLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.isSwipe = true;
        ViewDragHelper viewDragHelper = ViewDragHelper.create((ViewGroup)((ViewGroup)this), (ViewDragHelper.Callback)new MyDragHelperCallback());
        Intrinsics.checkNotNullExpressionValue((Object)viewDragHelper, (String)"ViewDragHelper.create(th\u2026, MyDragHelperCallback())");
        this.mViewDragHelper = viewDragHelper;
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetectorCallback());
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        this.mScreenWidth = resources.getDisplayMetrics().widthPixels;
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)viewConfiguration, (String)"ViewConfiguration.get(context)");
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
    }

    public /* synthetic */ SwipeLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public SwipeLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SwipeLayout(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$setSwipe$p(SwipeLayout $this, boolean bl) {
        $this.isSwipe = bl;
    }

    public static final /* synthetic */ void access$setMMenuWidth$p(SwipeLayout $this, int n) {
        $this.mMenuWidth = n;
    }

    public static final /* synthetic */ boolean access$getMenuIsOpen$p(SwipeLayout $this) {
        return $this.menuIsOpen;
    }

    public static final /* synthetic */ void access$setMViewDragHelper$p(SwipeLayout $this, ViewDragHelper viewDragHelper) {
        $this.mViewDragHelper = viewDragHelper;
    }

    public static final /* synthetic */ void access$setMContentView$p(SwipeLayout $this, View view) {
        $this.mContentView = view;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0004H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/netacom/full/widget/swipe_layout/SwipeLayout$MyDragHelperCallback;", "Landroidx/customview/widget/ViewDragHelper$Callback;", "(Lcom/netacom/full/widget/swipe_layout/SwipeLayout;)V", "clampViewPositionHorizontal", "", "child", "Landroid/view/View;", "left", "dx", "onViewReleased", "", "releasedChild", "xvel", "", "yvel", "tryCaptureView", "", "pointerId", "netacom-sdk-full_NetAloProdRelease"})
    public final class MyDragHelperCallback
    extends ViewDragHelper.Callback {
        public int clampViewPositionHorizontal(@NotNull View child, int left, int dx) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (!SwipeLayout.this.isSwipe) {
                return 0;
            }
            SwipeLayout.this.leftOffset = left;
            if (SwipeLayout.this.leftOffset < -SwipeLayout.this.mMenuWidth) {
                SwipeLayout.this.leftOffset = -SwipeLayout.this.mMenuWidth;
            } else if (SwipeLayout.this.leftOffset >= 0) {
                SwipeLayout.this.leftOffset = 0;
            }
            return SwipeLayout.this.leftOffset;
        }

        public void onViewReleased(@NotNull View releasedChild, float xvel, float yvel) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)releasedChild, (String)"releasedChild");
            if (!SwipeLayout.this.isSwipe) {
                return;
            }
            if (SwipeLayout.this.forceClose) {
                SwipeLayout.this.menuIsOpen = false;
                SwipeLayout.this.forceClose = false;
                SwipeLayout.this.leftOffset = 0;
                SwipeLayout.this.mViewDragHelper.settleCapturedViewAt(0, 0);
                SwipeLayout.this.invalidate();
                return;
            }
            if (SwipeLayout.this.leftOffset >= -SwipeLayout.this.mMenuWidth / 2) {
                SwipeLayout.this.mViewDragHelper.settleCapturedViewAt(0, 0);
                bl = false;
            } else {
                SwipeLayout.this.mViewDragHelper.settleCapturedViewAt(-SwipeLayout.this.mMenuWidth, 0);
                bl = true;
            }
            SwipeLayout.this.menuIsOpen = bl;
            SwipeLayout.this.invalidate();
        }

        public boolean tryCaptureView(@NotNull View child, int pointerId) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            return Intrinsics.areEqual((Object)child, (Object)SwipeLayout.this.mContentView);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/netacom/full/widget/swipe_layout/SwipeLayout$GestureDetectorCallback;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "(Lcom/netacom/full/widget/swipe_layout/SwipeLayout;)V", "onFling", "", "e1", "Landroid/view/MotionEvent;", "e2", "velocityX", "", "velocityY", "netacom-sdk-full_NetAloProdRelease"})
    public final class GestureDetectorCallback
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onFling(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float velocityX, float velocityY) {
            return false;
        }
    }
}

