/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.utils;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.CountDownTimer;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import com.netacom.base.chat.android_utils.ThreadUtils;
import com.netacom.full.R;
import com.netacom.full.utils.AudioSupport;
import com.netacom.lite.util.AppUtils;
import com.netacom.lite.util.AvatarUtilKt;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0004J\b\u0010$\u001a\u00020\u001bH\u0002J\u0006\u0010%\u001a\u00020\u001bR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/netacom/full/utils/AudioSupport;", "", "()V", "audioView", "Landroid/view/View;", "getAudioView", "()Landroid/view/View;", "setAudioView", "(Landroid/view/View;)V", "mediaPlayer", "Landroid/media/MediaPlayer;", "messageId", "", "getMessageId", "()Ljava/lang/Long;", "setMessageId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "status", "Lcom/netacom/full/utils/AudioSupport$AudioStatus;", "getStatus", "()Lcom/netacom/full/utils/AudioSupport$AudioStatus;", "setStatus", "(Lcom/netacom/full/utils/AudioSupport$AudioStatus;)V", "timer", "Landroid/os/CountDownTimer;", "playAudio", "", "context", "Landroid/content/Context;", "audioUrl", "", "userToken", "(Landroid/content/Context;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;)V", "setViewPlayer", "view", "startTimer", "stopAudio", "AudioStatus", "netacom-sdk-full_NetAloProdRelease"})
public final class AudioSupport {
    @Nullable
    private static Long messageId;
    @NotNull
    private static AudioStatus status;
    @Nullable
    private static View audioView;
    private static CountDownTimer timer;
    private static final MediaPlayer mediaPlayer;
    @NotNull
    public static final AudioSupport INSTANCE;

    @Nullable
    public final Long getMessageId() {
        return messageId;
    }

    public final void setMessageId(@Nullable Long l) {
        messageId = l;
    }

    @NotNull
    public final AudioStatus getStatus() {
        return status;
    }

    public final void setStatus(@NotNull AudioStatus audioStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioStatus), (String)"<set-?>");
        status = audioStatus;
    }

    @Nullable
    public final View getAudioView() {
        return audioView;
    }

    public final void setAudioView(@Nullable View view) {
        audioView = view;
    }

    public final void playAudio(@NotNull Context context, @Nullable Long messageId, @NotNull String audioUrl, @Nullable String userToken) {
        String it;
        boolean bl;
        boolean bl2;
        String string2;
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)audioUrl, (String)"audioUrl");
        AudioSupport.messageId = messageId;
        if (StringsKt.split$default((CharSequence)audioUrl, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null).size() > 2) {
            uri = Uri.parse((String)audioUrl);
            if (uri == null) {
                return;
            }
        } else {
            uri = Uri.parse((String)AvatarUtilKt.getUrlImage((String)audioUrl));
            if (uri == null) {
                return;
            }
        }
        Uri uri2 = uri;
        HashMap<String, String> headers = new HashMap<String, String>(3);
        String string3 = userToken;
        if (string3 != null) {
            string2 = string3;
            bl2 = false;
            bl = false;
            it = string2;
            boolean bl3 = false;
            headers.put("TC-Token", it);
        }
        if (mediaPlayer.isPlaying()) {
            this.stopAudio();
        }
        mediaPlayer.setDataSource(context, uri2, (Map)headers);
        mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)playAudio.2.INSTANCE);
        mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)playAudio.3.INSTANCE);
        mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)playAudio.4.INSTANCE);
        View view = audioView;
        if (view != null && (view = (AppCompatImageView)view.findViewById(R.id.imgPlay)) != null) {
            string2 = view;
            bl2 = false;
            bl = false;
            it = string2;
            boolean bl4 = false;
            it.setImageResource(R.drawable.ic_record_pause);
            it.setAlpha(0.5f);
        }
        status = AudioStatus.STATUS_LOADING;
        mediaPlayer.prepareAsync();
    }

    public static /* synthetic */ void playAudio$default(AudioSupport audioSupport, Context context, Long l, String string2, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        audioSupport.playAudio(context, l, string2, string3);
    }

    public final void setViewPlayer(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        audioView = view;
    }

    public final void stopAudio() {
        View view;
        View view2;
        View it;
        boolean bl;
        boolean bl2;
        View view3;
        CountDownTimer countDownTimer = timer;
        if (countDownTimer != null) {
            countDownTimer.cancel();
        }
        timer = null;
        View view4 = audioView;
        if (view4 != null && (view4 = (AppCompatImageView)view4.findViewById(R.id.imgPlay)) != null) {
            view3 = view4;
            bl2 = false;
            bl = false;
            it = view3;
            boolean bl3 = false;
            it.setImageResource(R.drawable.ic_record_play);
            it.setAlpha(1.0f);
        }
        if ((view2 = audioView) != null && (view2 = (AppCompatTextView)view2.findViewById(R.id.txtProgress)) != null) {
            view3 = view2;
            bl2 = false;
            bl = false;
            it = view3;
            boolean bl4 = false;
            Object object = it.getTag();
            if (!(object instanceof String)) {
                object = null;
            }
            String string2 = (String)object;
            boolean bl5 = false;
            boolean bl6 = false;
            String tag = string2;
            boolean bl7 = false;
            if (tag != null) {
                it.setText((CharSequence)tag);
            } else {
                it.setText((CharSequence)AppUtils.INSTANCE.setAudioTextViewTime((long)(mediaPlayer.getDuration() / 1000)));
            }
        }
        if ((view = audioView) != null && (view = (ProgressBar)view.findViewById(R.id.seekbar)) != null) {
            view3 = view;
            bl2 = false;
            bl = false;
            it = view3;
            boolean bl8 = false;
            it.setProgress(0);
        }
        mediaPlayer.reset();
        audioView = null;
        messageId = null;
        status = AudioStatus.STATUS_NONE;
    }

    private final void startTimer() {
        block1: {
            long audioDurations = mediaPlayer.getDuration();
            View view = audioView;
            if (view == null || (view = view.getContext()) == null) break block1;
            View view2 = view;
            boolean bl = false;
            boolean bl2 = false;
            View it = view2;
            boolean bl3 = false;
            CountDownTimer countDownTimer = timer = (CountDownTimer)new CountDownTimer(audioDurations + (long)1000, 20L, audioDurations){
                final /* synthetic */ long $audioDurations$inlined;
                {
                    this.$audioDurations$inlined = l;
                    super($super_call_param$1, $super_call_param$2);
                }

                public void onTick(long ticks) {
                    long remainTimes = this.$audioDurations$inlined - (long)AudioSupport.access$getMediaPlayer$p(AudioSupport.INSTANCE).getCurrentPosition();
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    long minutes = remainTimes / (long)1000 / (long)60;
                    long seconds = remainTimes / (long)1000 % (long)60;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = "%02d:%02d";
                    Object[] objectArray = new Object[]{minutes, seconds};
                    boolean bl4 = false;
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                    String time = string3;
                    bl2 = false;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    int progress = (int)((float)(this.$audioDurations$inlined - remainTimes) * 1000.0f / (float)this.$audioDurations$inlined);
                    ThreadUtils.runOnUiThread((Runnable)new Runnable(time, progress){
                        final /* synthetic */ String $time;
                        final /* synthetic */ int $progress;
                        {
                            this.$time = string2;
                            this.$progress = n;
                        }

                        public final void run() {
                            block1: {
                                View view;
                                View view2 = AudioSupport.INSTANCE.getAudioView();
                                if (view2 != null && (view2 = (TextView)view2.findViewById(R.id.txtProgress)) != null) {
                                    view2.setText((CharSequence)this.$time);
                                }
                                if ((view = AudioSupport.INSTANCE.getAudioView()) == null || (view = (ProgressBar)view.findViewById(R.id.seekbar)) == null) break block1;
                                view.setProgress(this.$progress);
                            }
                        }
                    });
                }

                public void onFinish() {
                }
            };
            if (countDownTimer != null) {
                countDownTimer.start();
            }
        }
    }

    private AudioSupport() {
    }

    static {
        AudioSupport audioSupport;
        INSTANCE = audioSupport = new AudioSupport();
        status = AudioStatus.STATUS_NONE;
        MediaPlayer mediaPlayer = new MediaPlayer();
        boolean bl = false;
        boolean bl2 = false;
        MediaPlayer $this$apply = mediaPlayer;
        boolean bl3 = false;
        $this$apply.setAudioStreamType(3);
        AudioSupport.mediaPlayer = mediaPlayer;
    }

    public static final /* synthetic */ void access$startTimer(AudioSupport $this) {
        $this.startTimer();
    }

    public static final /* synthetic */ MediaPlayer access$getMediaPlayer$p(AudioSupport $this) {
        AudioSupport audioSupport = $this;
        return mediaPlayer;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/netacom/full/utils/AudioSupport$AudioStatus;", "", "(Ljava/lang/String;I)V", "STATUS_NONE", "STATUS_LOADING", "STATUS_PLAYING", "netacom-sdk-full_NetAloProdRelease"})
    public static final class AudioStatus
    extends Enum<AudioStatus> {
        public static final /* enum */ AudioStatus STATUS_NONE;
        public static final /* enum */ AudioStatus STATUS_LOADING;
        public static final /* enum */ AudioStatus STATUS_PLAYING;
        private static final /* synthetic */ AudioStatus[] $VALUES;

        static {
            AudioStatus[] audioStatusArray = new AudioStatus[3];
            AudioStatus[] audioStatusArray2 = audioStatusArray;
            audioStatusArray[0] = STATUS_NONE = new AudioStatus();
            audioStatusArray[1] = STATUS_LOADING = new AudioStatus();
            audioStatusArray[2] = STATUS_PLAYING = new AudioStatus();
            $VALUES = audioStatusArray;
        }

        public static AudioStatus[] values() {
            return (AudioStatus[])$VALUES.clone();
        }

        public static AudioStatus valueOf(String string2) {
            return Enum.valueOf(AudioStatus.class, string2);
        }
    }
}

