/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.ui.main.theme;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.SwitchCompat;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import com.netacom.base.chat.android_utils.BarUtils;
import com.netacom.base.chat.binding.BindingAdaptersKt;
import com.netacom.base.chat.logger.Logger;
import com.netacom.base.chat.util.CoreUtilsKt;
import com.netacom.base.chat.util.ExtensionsUtilsKt;
import com.netacom.full.BR;
import com.netacom.full.R;
import com.netacom.full.databinding.FragmentThemeBinding;
import com.netacom.full.ui.main.theme.Hilt_ThemeFragment;
import com.netacom.full.ui.main.theme.ThemeHelperImpl;
import com.netacom.full.ui.main.theme.ThemeViewModel;
import com.netacom.full.ui.main.theme.adapter.ColorAdapter;
import com.netacom.full.utils.ThemeUtils;
import com.netacom.lite.entity.ui.theme.NeTheme;
import dagger.hilt.android.AndroidEntryPoint;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Signature claims super is com.netacom.full.basechat.BaseSDKDataFragment<com.netacom.full.databinding.FragmentThemeBinding, com.netacom.full.ui.main.theme.ThemeViewModel>, not com.netacom.full.ui.main.theme.Hilt_ThemeFragment - discarding signature.
 */
@AndroidEntryPoint
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0014J\b\u0010\u0011\u001a\u00020\bH\u0014J\b\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0014\u001a\u00020\nH\u0014J\b\u0010\u0015\u001a\u00020\bH\u0014J\b\u0010\u0016\u001a\u00020\bH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/netacom/full/ui/main/theme/ThemeFragment;", "Lcom/netacom/full/basechat/BaseSDKDataFragment;", "Lcom/netacom/full/databinding/FragmentThemeBinding;", "Lcom/netacom/full/ui/main/theme/ThemeViewModel;", "()V", "colorAdapter", "Lcom/netacom/full/ui/main/theme/adapter/ColorAdapter;", "applyColorForPreviewChat", "", "colorId", "", "applyColorForToolbar", "drawableId", "applyDarkMode", "applyLightMode", "applyThemeFollowSystem", "initData", "initViews", "onStop", "setSwitchColor", "setViewModel", "setupTheme", "syncEvent", "netacom-sdk-full_NetAloProdRelease"})
public final class ThemeFragment
extends Hilt_ThemeFragment {
    private ColorAdapter colorAdapter;

    protected int setViewModel() {
        return BR.viewModel;
    }

    protected void initViews() {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        this.colorAdapter = new ColorAdapter(context, (Function3<? super NeTheme, ? super View, ? super Integer, Unit>)((Function3)new Function3<NeTheme, View, Integer, Unit>(this){
            final /* synthetic */ ThemeFragment this$0;

            public final void invoke(@NotNull NeTheme neTheme, @NotNull View $noName_1, int $noName_2) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)neTheme, (String)"neTheme");
                    Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                    this.this$0.getThemeHelperImpl().setNeTheme(neTheme);
                    Context context = this.this$0.requireContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                    ThemeFragment.access$applyColorForPreviewChat(this.this$0, CoreUtilsKt.resIdByNameColor((Context)context, (String)neTheme.getMainColor()));
                    Context context2 = this.this$0.requireContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"requireContext()");
                    Integer n = CoreUtilsKt.resIdByNameDrawable((Context)context2, (String)neTheme.getToolbarDrawable());
                    Intrinsics.checkNotNull((Object)n);
                    ThemeFragment.access$applyColorForToolbar(this.this$0, n);
                    Context context3 = this.this$0.requireContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"requireContext()");
                    ThemeFragment.access$setSwitchColor(this.this$0, CoreUtilsKt.resIdByNameColor((Context)context3, (String)neTheme.getMainColor()));
                    FragmentActivity fragmentActivity = this.this$0.getActivity();
                    if (fragmentActivity == null) break block2;
                    FragmentActivity fragmentActivity2 = fragmentActivity;
                    boolean bl = false;
                    boolean bl2 = false;
                    FragmentActivity $this$apply = fragmentActivity2;
                    boolean bl3 = false;
                    if (Intrinsics.areEqual((Object)((FragmentThemeBinding)this.this$0.getBinding()).getIsDarkMode(), (Object)true)) {
                        BarUtils.setNavBarColor((Activity)((Activity)$this$apply), (int)ContextCompat.getColor((Context)this.this$0.requireContext(), (int)R.color.color_black));
                    } else {
                        BarUtils.setNavBarColor((Activity)((Activity)$this$apply), (int)ExtensionsUtilsKt.getThemeColor((int)this.this$0.getThemeHelperImpl().getMainColor()));
                    }
                }
            }
            {
                this.this$0 = themeFragment;
                super(3);
            }
        }), ((ThemeViewModel)this.getViewModel()).appId(), this.getThemeHelperImpl().getMainColor());
        RecyclerView recyclerView = ((FragmentThemeBinding)this.getBinding()).recyclerViewColor;
        boolean bl = false;
        boolean bl2 = false;
        RecyclerView $this$apply = recyclerView;
        boolean bl3 = false;
        ColorAdapter colorAdapter = this.colorAdapter;
        if (colorAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"colorAdapter");
        }
        $this$apply.setAdapter((RecyclerView.Adapter)colorAdapter);
        switch (this.getThemeHelperImpl().getDisplayMode()) {
            case 0: {
                this.applyLightMode();
                break;
            }
            case 1: {
                this.applyDarkMode();
                break;
            }
            case 2: {
                this.applyThemeFollowSystem();
                SwitchCompat switchCompat = ((FragmentThemeBinding)this.getBinding()).switchAutoColor;
                Intrinsics.checkNotNullExpressionValue((Object)switchCompat, (String)"binding.switchAutoColor");
                switchCompat.setChecked(true);
                break;
            }
        }
        LinearLayout linearLayout = ((FragmentThemeBinding)this.getBinding()).layoutPreviewLight;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"binding.layoutPreviewLight");
        BindingAdaptersKt.clickDebounce((View)((View)linearLayout), (View.OnClickListener)new View.OnClickListener(this){
            final /* synthetic */ ThemeFragment this$0;

            public final void onClick(View it) {
                ThemeFragment.access$applyLightMode(this.this$0);
                SwitchCompat switchCompat = ((FragmentThemeBinding)this.this$0.getBinding()).switchAutoColor;
                Intrinsics.checkNotNullExpressionValue((Object)switchCompat, (String)"binding.switchAutoColor");
                switchCompat.setChecked(false);
            }
            {
                this.this$0 = themeFragment;
            }
        });
        LinearLayout linearLayout2 = ((FragmentThemeBinding)this.getBinding()).layoutPreviewDark;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout2, (String)"binding.layoutPreviewDark");
        BindingAdaptersKt.clickDebounce((View)((View)linearLayout2), (View.OnClickListener)new View.OnClickListener(this){
            final /* synthetic */ ThemeFragment this$0;

            public final void onClick(View it) {
                ThemeFragment.access$applyDarkMode(this.this$0);
                SwitchCompat switchCompat = ((FragmentThemeBinding)this.this$0.getBinding()).switchAutoColor;
                Intrinsics.checkNotNullExpressionValue((Object)switchCompat, (String)"binding.switchAutoColor");
                switchCompat.setChecked(false);
            }
            {
                this.this$0 = themeFragment;
            }
        });
        ((FragmentThemeBinding)this.getBinding()).toolbar.setOnLeftClickListener(new View.OnClickListener(this){
            final /* synthetic */ ThemeFragment this$0;

            public final void onClick(View it) {
                ((ThemeViewModel)this.this$0.getViewModel()).onBack();
            }
            {
                this.this$0 = themeFragment;
            }
        });
        ((FragmentThemeBinding)this.getBinding()).switchAutoColor.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(this){
            final /* synthetic */ ThemeFragment this$0;

            public final void onCheckedChanged(CompoundButton compoundButton, boolean checked) {
                if (checked) {
                    ThemeFragment.access$applyThemeFollowSystem(this.this$0);
                }
            }
            {
                this.this$0 = themeFragment;
            }
        });
        if (Build.VERSION.SDK_INT < 29) {
            RelativeLayout relativeLayout = ((FragmentThemeBinding)this.getBinding()).rlAutoChange;
            Intrinsics.checkNotNullExpressionValue((Object)relativeLayout, (String)"binding.rlAutoChange");
            relativeLayout.setVisibility(8);
        }
        this.setSwitchColor(this.getThemeHelperImpl().getMainColor());
        this.applyColorForPreviewChat(this.getThemeHelperImpl().getMainColor());
    }

    private final void applyThemeFollowSystem() {
        boolean darkModeOnSystem = ThemeUtils.isDarkModeInSystem();
        if (darkModeOnSystem) {
            this.applyDarkMode();
        } else {
            this.applyLightMode();
        }
        this.getThemeHelperImpl().setDisplayMode(2);
    }

    protected void initData() {
    }

    protected void syncEvent() {
    }

    private final void applyLightMode() {
        block0: {
            Logger.INSTANCE.d("Liem - apply Light mode", new Object[0]);
            ((FragmentThemeBinding)this.getBinding()).setIsDarkMode(false);
            ((FragmentThemeBinding)this.getBinding()).layoutPreviewDark.setBackgroundResource(R.drawable.bg_theme_dark_setting);
            ((FragmentThemeBinding)this.getBinding()).layoutPreviewLight.setBackgroundResource(R.drawable.theme_preview_light_checked);
            this.getThemeHelperImpl().setDisplayMode(0);
            ThemeHelperImpl themeHelperImpl = this.getThemeHelperImpl();
            LinearLayout linearLayout = ((FragmentThemeBinding)this.getBinding()).layoutPreviewLight;
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"binding.layoutPreviewLight");
            Drawable drawable2 = linearLayout.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"binding.layoutPreviewLight.background");
            themeHelperImpl.setThemeColorForBorder(drawable2);
            this.applyColorForToolbar(this.getThemeHelperImpl().getToolbarDrawableId());
            FragmentActivity fragmentActivity = this.getActivity();
            if (fragmentActivity == null) break block0;
            FragmentActivity fragmentActivity2 = fragmentActivity;
            boolean bl = false;
            boolean bl2 = false;
            FragmentActivity it = fragmentActivity2;
            boolean bl3 = false;
            BarUtils.setNavBarColor((Activity)((Activity)it), (int)ExtensionsUtilsKt.getThemeColor((int)this.getThemeHelperImpl().getMainColor()));
        }
    }

    private final void applyDarkMode() {
        block0: {
            Logger.INSTANCE.d("Liem - apply Dark mode", new Object[0]);
            ((FragmentThemeBinding)this.getBinding()).setIsDarkMode(true);
            ((FragmentThemeBinding)this.getBinding()).layoutPreviewLight.setBackgroundResource(R.drawable.bg_theme_light_setting);
            ((FragmentThemeBinding)this.getBinding()).layoutPreviewDark.setBackgroundResource(R.drawable.theme_preview_dark_checked);
            this.getThemeHelperImpl().setDisplayMode(1);
            ThemeHelperImpl themeHelperImpl = this.getThemeHelperImpl();
            LinearLayout linearLayout = ((FragmentThemeBinding)this.getBinding()).layoutPreviewDark;
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"binding.layoutPreviewDark");
            Drawable drawable2 = linearLayout.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"binding.layoutPreviewDark.background");
            themeHelperImpl.setThemeColorForBorder(drawable2);
            this.applyColorForToolbar(this.getThemeHelperImpl().getToolbarDrawableId());
            FragmentActivity fragmentActivity = this.getActivity();
            if (fragmentActivity == null) break block0;
            FragmentActivity fragmentActivity2 = fragmentActivity;
            boolean bl = false;
            boolean bl2 = false;
            FragmentActivity it = fragmentActivity2;
            boolean bl3 = false;
            BarUtils.setNavBarColor((Activity)((Activity)it), (int)ContextCompat.getColor((Context)this.requireContext(), (int)R.color.color_black));
        }
    }

    private final void applyColorForPreviewChat(int colorId) {
        AppCompatTextView appCompatTextView = ((FragmentThemeBinding)this.getBinding()).txtDarkSenderMessage;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"binding.txtDarkSenderMessage");
        CoreUtilsKt.setBackgroundTheme((TextView)((TextView)appCompatTextView), (int)colorId);
        AppCompatTextView appCompatTextView2 = ((FragmentThemeBinding)this.getBinding()).txtLightSenderMessage;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView2, (String)"binding.txtLightSenderMessage");
        CoreUtilsKt.setBackgroundTheme((TextView)((TextView)appCompatTextView2), (int)colorId);
        AppCompatImageView appCompatImageView = ((FragmentThemeBinding)this.getBinding()).imgSendLight;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"binding.imgSendLight");
        com.netacom.full.databinding.BindingAdaptersKt.setImageColorTheme((ImageView)appCompatImageView, colorId);
        AppCompatImageView appCompatImageView2 = ((FragmentThemeBinding)this.getBinding()).imgSendDark;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView2, (String)"binding.imgSendDark");
        com.netacom.full.databinding.BindingAdaptersKt.setImageColorTheme((ImageView)appCompatImageView2, colorId);
        if (Intrinsics.areEqual((Object)((FragmentThemeBinding)this.getBinding()).getIsDarkMode(), (Object)true)) {
            ThemeHelperImpl themeHelperImpl = this.getThemeHelperImpl();
            LinearLayout linearLayout = ((FragmentThemeBinding)this.getBinding()).layoutPreviewDark;
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"binding.layoutPreviewDark");
            Drawable drawable2 = linearLayout.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"binding.layoutPreviewDark.background");
            themeHelperImpl.setThemeColorForBorder(drawable2);
        } else {
            ThemeHelperImpl themeHelperImpl = this.getThemeHelperImpl();
            LinearLayout linearLayout = ((FragmentThemeBinding)this.getBinding()).layoutPreviewLight;
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"binding.layoutPreviewLight");
            Drawable drawable3 = linearLayout.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"binding.layoutPreviewLight.background");
            themeHelperImpl.setThemeColorForBorder(drawable3);
        }
    }

    private final void applyColorForToolbar(int drawableId) {
        ((FragmentThemeBinding)this.getBinding()).toolbar.setBackgroundTheme(((ThemeViewModel)this.getViewModel()).appId(), this.getThemeHelperImpl().isDarkMode(), drawableId);
    }

    public void onStop() {
        super.onStop();
        ThemeUtils.INSTANCE.enableDisplayMode(this.getThemeHelperImpl().getDisplayMode());
    }

    private final void setSwitchColor(int colorId) {
        SwitchCompat switchCompat = ((FragmentThemeBinding)this.getBinding()).switchAutoColor;
        Intrinsics.checkNotNullExpressionValue((Object)switchCompat, (String)"binding.switchAutoColor");
        DrawableCompat.setTintList((Drawable)switchCompat.getThumbDrawable(), (ColorStateList)new ColorStateList((int[][])new int[][]{{-16842912}, new int[0]}, new int[]{-1, -1}));
        SwitchCompat switchCompat2 = ((FragmentThemeBinding)this.getBinding()).switchAutoColor;
        Intrinsics.checkNotNullExpressionValue((Object)switchCompat2, (String)"binding.switchAutoColor");
        DrawableCompat.setTintList((Drawable)switchCompat2.getTrackDrawable(), (ColorStateList)new ColorStateList((int[][])new int[][]{{-16842912}, new int[0]}, new int[]{-7829368, ContextCompat.getColor((Context)this.requireContext(), (int)colorId)}));
    }

    protected void setupTheme() {
    }

    public ThemeFragment() {
        super(R.layout.fragment_theme, ThemeViewModel.class);
    }

    public static final /* synthetic */ void access$applyColorForPreviewChat(ThemeFragment $this, int colorId) {
        $this.applyColorForPreviewChat(colorId);
    }

    public static final /* synthetic */ void access$applyColorForToolbar(ThemeFragment $this, int drawableId) {
        $this.applyColorForToolbar(drawableId);
    }

    public static final /* synthetic */ void access$setSwitchColor(ThemeFragment $this, int colorId) {
        $this.setSwitchColor(colorId);
    }

    public static final /* synthetic */ void access$applyLightMode(ThemeFragment $this) {
        $this.applyLightMode();
    }

    public static final /* synthetic */ void access$applyDarkMode(ThemeFragment $this) {
        $this.applyDarkMode();
    }

    public static final /* synthetic */ void access$applyThemeFollowSystem(ThemeFragment $this) {
        $this.applyThemeFollowSystem();
    }
}

