/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.worker.call;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.Settings;
import android.util.Log;
import androidx.core.content.ContextCompat;
import androidx.hilt.work.HiltWorker;
import androidx.work.CoroutineWorker;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.base.chat.json.JsonSerializer;
import com.netacom.base.chat.logger.Logger;
import com.netacom.full.R;
import com.netacom.full.ui.main.calling.CallNotificationService;
import com.netacom.full.ui.main.theme.ThemeHelperImpl;
import com.netacom.full.ui.sdk.NetAloSDK;
import com.netacom.lite.entity.socket.Call;
import com.netacom.lite.entity.ui.user.NeUser;
import com.netacom.lite.repository.GroupRepository;
import com.netacom.lite.repository.SocketRepository;
import com.netacom.lite.util.AppUtils;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B;\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0011\u0010\u0015\u001a\u00020\u0016H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lcom/netacom/full/worker/call/CallWorker;", "Landroidx/work/CoroutineWorker;", "context", "Landroid/content/Context;", "workerParameters", "Landroidx/work/WorkerParameters;", "socketRepository", "Lcom/netacom/lite/repository/SocketRepository;", "groupRepository", "Lcom/netacom/lite/repository/GroupRepository;", "jsonSerializer", "Lcom/netacom/base/chat/json/JsonSerializer;", "themeHelperImpl", "Lcom/netacom/full/ui/main/theme/ThemeHelperImpl;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;Lcom/netacom/lite/repository/SocketRepository;Lcom/netacom/lite/repository/GroupRepository;Lcom/netacom/base/chat/json/JsonSerializer;Lcom/netacom/full/ui/main/theme/ThemeHelperImpl;)V", "getSocketRepository", "()Lcom/netacom/lite/repository/SocketRepository;", "checkNotification", "", "call", "Lcom/netacom/lite/entity/socket/Call;", "doWork", "Landroidx/work/ListenableWorker$Result;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "netacom-sdk-full_NetAloDevRelease"})
@HiltWorker
public final class CallWorker
extends CoroutineWorker {
    @NotNull
    private final SocketRepository socketRepository;
    @NotNull
    private final GroupRepository groupRepository;
    @NotNull
    private final JsonSerializer jsonSerializer;
    @NotNull
    private final ThemeHelperImpl themeHelperImpl;

    @AssistedInject
    public CallWorker(@Assisted @NotNull Context context, @Assisted @NotNull WorkerParameters workerParameters, @NotNull SocketRepository socketRepository, @NotNull GroupRepository groupRepository, @NotNull JsonSerializer jsonSerializer, @NotNull ThemeHelperImpl themeHelperImpl) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workerParameters, (String)"workerParameters");
        Intrinsics.checkNotNullParameter((Object)socketRepository, (String)"socketRepository");
        Intrinsics.checkNotNullParameter((Object)groupRepository, (String)"groupRepository");
        Intrinsics.checkNotNullParameter((Object)jsonSerializer, (String)"jsonSerializer");
        Intrinsics.checkNotNullParameter((Object)themeHelperImpl, (String)"themeHelperImpl");
        super(context, workerParameters);
        this.socketRepository = socketRepository;
        this.groupRepository = groupRepository;
        this.jsonSerializer = jsonSerializer;
        this.themeHelperImpl = themeHelperImpl;
    }

    @NotNull
    public final SocketRepository getSocketRepository() {
        return this.socketRepository;
    }

    @Nullable
    public Object doWork(@NotNull Continuation<? super ListenableWorker.Result> $completion) {
        ListenableWorker.Result result2;
        try {
            Call call = (Call)this.jsonSerializer.asObject(this.getInputData().getString("KEY_DATA"), Call.class);
            if (call != null) {
                Long l;
                Call call2 = call;
                boolean bl = false;
                boolean bl2 = false;
                Call $this$doWork_u24lambda_u2d0 = call2;
                boolean bl3 = false;
                Logger.INSTANCE.e(Intrinsics.stringPlus((String)"CallWorker=", (Object)$this$doWork_u24lambda_u2d0), new Object[0]);
                Logger.INSTANCE.e(Intrinsics.stringPlus((String)"CallWorker=", (Object)Boxing.boxBoolean((boolean)this.getSocketRepository().isConnect())), new Object[0]);
                CharSequence charSequence = $this$doWork_u24lambda_u2d0.getGroupCallId();
                boolean bl4 = false;
                boolean bl5 = false;
                if (!(charSequence == null || charSequence.length() == 0) || Calendar.getInstance().getTimeInMillis() / (long)1000 - ((charSequence = $this$doWork_u24lambda_u2d0.getMStartedAt()) == null ? 0L : ((l = StringsKt.toLongOrNull((String)charSequence)) == null ? 0L : l)) <= 30L) {
                    if (!this.getSocketRepository().isConnect()) {
                        this.getSocketRepository().connectSocket((Function1)new Function1<Boolean, Unit>(this, $this$doWork_u24lambda_u2d0){
                            final /* synthetic */ CallWorker this$0;
                            final /* synthetic */ Call $this_apply;
                            {
                                this.this$0 = $receiver;
                                this.$this_apply = $receiver2;
                                super(1);
                            }

                            public final void invoke(boolean isConnected) {
                                if (isConnected) {
                                    CallWorker.access$checkNotification(this.this$0, this.$this_apply);
                                }
                            }
                        });
                    } else {
                        this.checkNotification($this$doWork_u24lambda_u2d0);
                    }
                }
            }
            result2 = ListenableWorker.Result.success();
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"{\n            jsonSerial\u2026esult.success()\n        }");
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            Log.d((String)"qqq", (String)Intrinsics.stringPlus((String)"!! exception.message:", (Object)e.getMessage()));
            ListenableWorker.Result result3 = ListenableWorker.Result.failure();
            Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"{\n            FirebaseCr\u2026esult.failure()\n        }");
            result2 = result3;
        }
        return result2;
    }

    private final void checkNotification(Call call) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (Settings.canDrawOverlays((Context)this.getApplicationContext())) {
                Context context = this.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                NetAloSDK.openNetAloSDK$default(NetAloSDK.INSTANCE, context, null, null, null, call, true, 14, null);
            } else {
                boolean bl;
                Object object;
                Object object2;
                Context context = this.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                if (!AppUtils.INSTANCE.isAppBackground(context)) {
                    return;
                }
                Intent serviceIntent = new Intent(this.getApplicationContext(), CallNotificationService.class);
                CharSequence charSequence = call.getGroupCallId();
                boolean bl2 = false;
                boolean bl3 = false;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    object2 = this.groupRepository.getGroupDbById(call.getGroupId());
                    CharSequence charSequence2 = charSequence = object2 == null ? null : object2.getGetDisplayName();
                    if (charSequence == null) {
                        object2 = this.getApplicationContext().getString(R.string.group_call);
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"applicationContext.getString(R.string.group_call)");
                        object = object2;
                    } else {
                        object = charSequence;
                    }
                } else {
                    String string2;
                    object2 = StringsKt.toLongOrNull((String)call.getMCallerUin());
                    if (object2 == null) {
                        string2 = null;
                    } else {
                        Long l = object2;
                        bl = false;
                        boolean bl4 = false;
                        long it = ((Number)l).longValue();
                        boolean bl5 = false;
                        NeUser neUser = this.groupRepository.getUserById(it);
                        string2 = neUser == null ? null : neUser.getGetDisplayName();
                    }
                    charSequence = string2;
                    if (charSequence == null) {
                        object2 = this.getApplicationContext().getString(R.string.unknown_user);
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"applicationContext.getSt\u2026ng(R.string.unknown_user)");
                        object = object2;
                    } else {
                        object = charSequence;
                    }
                }
                CharSequence title = object;
                object2 = new Bundle();
                bl3 = false;
                bl = false;
                Object $this$checkNotification_u24lambda_u2d2 = object2;
                boolean bl6 = false;
                $this$checkNotification_u24lambda_u2d2.putString("NOTIFICATION_TITLE", (String)title);
                $this$checkNotification_u24lambda_u2d2.putParcelable("call", (Parcelable)call);
                Object mBundle = object2;
                serviceIntent.putExtras((Bundle)mBundle);
                ContextCompat.startForegroundService((Context)this.getApplicationContext(), (Intent)serviceIntent);
            }
        } else {
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            NetAloSDK.openNetAloSDK$default(NetAloSDK.INSTANCE, context, null, null, null, call, true, 14, null);
        }
    }

    public static final /* synthetic */ void access$checkNotification(CallWorker $this, Call call) {
        $this.checkNotification(call);
    }
}

