/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.widget.swipe_layout;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.netacom.full.widget.swipe_layout.SwipeLayout;

public class SwipeRecylerView
extends RecyclerView {
    int mTouchSlop = 0;
    float downX = 0.0f;
    float downY = 0.0f;
    private Rect touchFrame;

    public SwipeRecylerView(Context context) {
        this(context, null);
    }

    public SwipeRecylerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeRecylerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        switch (e.getAction()) {
            case 0: {
                SwipeLayout childView;
                View positionView;
                this.downX = e.getX();
                this.downY = e.getY();
                int position = this.pointToPosition((int)e.getX(), (int)e.getY());
                int count = this.getChildCount();
                if (count > position && (positionView = this.getChildAt(position)) instanceof SwipeLayout && (childView = (SwipeLayout)positionView).isOpen()) {
                    return super.onInterceptTouchEvent(e);
                }
                if (!this.hasChildOpen()) break;
                this.closeMenu();
                break;
            }
            case 2: {
                float dy = e.getY() - this.downY;
                float dx = e.getX() - this.downX;
                if (!(Math.abs(dx) > Math.abs(dy)) || !(Math.abs(dx) > (float)this.mTouchSlop)) break;
                return false;
            }
        }
        return super.onInterceptTouchEvent(e);
    }

    private int pointToPosition(int x, int y) {
        Rect frame = this.touchFrame;
        if (frame == null) {
            frame = this.touchFrame = new Rect();
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0) continue;
            child.getHitRect(frame);
            if (!frame.contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    private boolean hasChildOpen() {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            SwipeLayout childView;
            View view = this.getChildAt(i);
            if (!(view instanceof SwipeLayout) || !(childView = (SwipeLayout)view).isOpen()) continue;
            return true;
        }
        return false;
    }

    private void closeMenu() {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            SwipeLayout childView;
            View view = this.getChildAt(i);
            if (!(view instanceof SwipeLayout) || !(childView = (SwipeLayout)view).isOpen()) continue;
            childView.closeMenu();
        }
    }
}

