/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.android_utils;

import android.app.Activity;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.storage.StorageManager;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.core.content.FileProvider;
import com.netacom.base.chat.android_utils.Utils;
import com.netacom.base.chat.android_utils.UtilsBridge;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public final class UriUtils {
    public static final String FILE_BROWSER_CACHE_DIR = "CertCache";

    private UriUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Uri res2Uri(String resPath) {
        return Uri.parse((String)("android.resource://" + Utils.getApp().getPackageName() + "/" + resPath));
    }

    public static Uri file2Uri(File file) {
        if (!UtilsBridge.isFileExists(file)) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            String authority = Utils.getApp().getPackageName() + ".provider";
            return FileProvider.getUriForFile((Context)Utils.getApp(), (String)authority, (File)file);
        }
        return Uri.fromFile((File)file);
    }

    public static File uri2File(Uri uri) {
        if (uri == null) {
            return null;
        }
        File file = UriUtils.uri2FileReal(uri);
        if (file != null) {
            return file;
        }
        return UriUtils.copyUri2Cache(uri);
    }

    private static File uri2FileReal(Uri uri) {
        Log.d((String)"UriUtils", (String)uri.toString());
        String authority = uri.getAuthority();
        String scheme = uri.getScheme();
        String path = uri.getPath();
        if (Build.VERSION.SDK_INT >= 24 && path != null) {
            String[] externals = new String[]{"/external/", "/external_path/"};
            File file = null;
            for (String external : externals) {
                if (!path.startsWith(external) || !(file = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + path.replace(external, "/"))).exists()) continue;
                Log.d((String)"UriUtils", (String)(uri.toString() + " -> " + external));
                return file;
            }
            file = null;
            if (path.startsWith("/files_path/")) {
                file = new File(Utils.getApp().getFilesDir().getAbsolutePath() + path.replace("/files_path/", "/"));
            } else if (path.startsWith("/cache_path/")) {
                file = new File(Utils.getApp().getCacheDir().getAbsolutePath() + path.replace("/cache_path/", "/"));
            } else if (path.startsWith("/external_files_path/")) {
                file = new File(Utils.getApp().getExternalFilesDir(null).getAbsolutePath() + path.replace("/external_files_path/", "/"));
            } else if (path.startsWith("/external_cache_path/")) {
                file = new File(Utils.getApp().getExternalCacheDir().getAbsolutePath() + path.replace("/external_cache_path/", "/"));
            }
            if (file != null && file.exists()) {
                Log.d((String)"UriUtils", (String)(uri.toString() + " -> " + path));
                return file;
            }
        }
        if ("file".equals(scheme)) {
            if (path != null) {
                return new File(path);
            }
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 0"));
            return null;
        }
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)Utils.getApp(), (Uri)uri)) {
            String type;
            String[] split;
            String docId;
            if ("com.android.externalstorage.documents".equals(authority)) {
                docId = DocumentsContract.getDocumentId((Uri)uri);
                split = docId.split(":");
                type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return new File(Environment.getExternalStorageDirectory() + "/" + split[1]);
                }
                StorageManager mStorageManager = (StorageManager)Utils.getApp().getSystemService("storage");
                try {
                    Class<?> storageVolumeClazz = Class.forName("android.os.storage.StorageVolume");
                    Method getVolumeList = mStorageManager.getClass().getMethod("getVolumeList", new Class[0]);
                    Method getUuid = storageVolumeClazz.getMethod("getUuid", new Class[0]);
                    Method getState = storageVolumeClazz.getMethod("getState", new Class[0]);
                    Method getPath = storageVolumeClazz.getMethod("getPath", new Class[0]);
                    Method isPrimary = storageVolumeClazz.getMethod("isPrimary", new Class[0]);
                    Method isEmulated = storageVolumeClazz.getMethod("isEmulated", new Class[0]);
                    Object result = getVolumeList.invoke((Object)mStorageManager, new Object[0]);
                    int length = Array.getLength(result);
                    for (int i = 0; i < length; ++i) {
                        String uuid;
                        boolean mounted;
                        Object storageVolumeElement = Array.get(result, i);
                        boolean bl = mounted = "mounted".equals(getState.invoke(storageVolumeElement, new Object[0])) || "mounted_ro".equals(getState.invoke(storageVolumeElement, new Object[0]));
                        if (!mounted || ((Boolean)isPrimary.invoke(storageVolumeElement, new Object[0])).booleanValue() && ((Boolean)isEmulated.invoke(storageVolumeElement, new Object[0])).booleanValue() || (uuid = (String)getUuid.invoke(storageVolumeElement, new Object[0])) == null || !uuid.equals(type)) continue;
                        return new File(getPath.invoke(storageVolumeElement, new Object[0]) + "/" + split[1]);
                    }
                }
                catch (Exception ex) {
                    Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. " + ex.toString() + " -> 1_0"));
                }
                Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 1_0"));
                return null;
            }
            if ("com.android.providers.downloads.documents".equals(authority)) {
                String[] contentUriPrefixesToTry;
                String id2 = DocumentsContract.getDocumentId((Uri)uri);
                if (TextUtils.isEmpty((CharSequence)id2)) {
                    Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(id is null). -> 1_1"));
                    return null;
                }
                if (id2.startsWith("raw:")) {
                    return new File(id2.substring(4));
                }
                if (id2.startsWith("msf:")) {
                    id2 = id2.split(":")[1];
                }
                long availableId = 0L;
                try {
                    availableId = Long.parseLong(id2);
                }
                catch (Exception e) {
                    return null;
                }
                for (String contentUriPrefix : contentUriPrefixesToTry = new String[]{"content://downloads/public_downloads", "content://downloads/all_downloads", "content://downloads/my_downloads"}) {
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)contentUriPrefix), (long)availableId);
                    try {
                        File file = UriUtils.getFileFromUri(contentUri, "1_1");
                        if (file == null) continue;
                        return file;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 1_1"));
                return null;
            }
            if ("com.android.providers.media.documents".equals(authority)) {
                Uri contentUri;
                docId = DocumentsContract.getDocumentId((Uri)uri);
                split = docId.split(":");
                type = split[0];
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                } else {
                    Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 1_2"));
                    return null;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                return UriUtils.getFileFromUri(contentUri, "_id=?", selectionArgs, "1_2");
            }
            if ("content".equals(scheme)) {
                return UriUtils.getFileFromUri(uri, "1_3");
            }
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 1_4"));
            return null;
        }
        if ("content".equals(scheme)) {
            return UriUtils.getFileFromUri(uri, "2");
        }
        Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 3"));
        return null;
    }

    private static File getFileFromUri(Uri uri, String code) {
        return UriUtils.getFileFromUri(uri, null, null, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getFileFromUri(Uri uri, String selection, String[] selectionArgs, String code) {
        Cursor cursor;
        String path;
        if ("com.google.android.apps.photos.content".equals(uri.getAuthority())) {
            if (!TextUtils.isEmpty((CharSequence)uri.getLastPathSegment())) {
                return new File(uri.getLastPathSegment());
            }
        } else if ("com.tencent.mtt.fileprovider".equals(uri.getAuthority())) {
            path = uri.getPath();
            if (!TextUtils.isEmpty((CharSequence)path)) {
                File fileDir = Environment.getExternalStorageDirectory();
                return new File(fileDir, path.substring("/QQBrowser".length(), path.length()));
            }
        } else if ("com.huawei.hidisk.fileprovider".equals(uri.getAuthority()) && !TextUtils.isEmpty((CharSequence)(path = uri.getPath()))) {
            return new File(path.replace("/root", ""));
        }
        if ((cursor = Utils.getApp().getContentResolver().query(uri, new String[]{"_data"}, selection, selectionArgs, null)) == null) {
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(cursor is null). -> " + code));
            return null;
        }
        try {
            if (cursor.moveToFirst()) {
                int columnIndex = cursor.getColumnIndex("_data");
                if (columnIndex > -1) {
                    File file = new File(cursor.getString(columnIndex));
                    return file;
                }
                Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(columnIndex: " + columnIndex + " is wrong). -> " + code));
                File file = null;
                return file;
            }
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(moveToFirst return false). -> " + code));
            File columnIndex = null;
            return columnIndex;
        }
        catch (Exception e) {
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> " + code));
            File file = null;
            return file;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyUri2Cache(Uri uri) {
        Log.d((String)"UriUtils", (String)"copyUri2Cache() called");
        InputStream is = null;
        try {
            is = Utils.getApp().getContentResolver().openInputStream(uri);
            File file = new File(Utils.getApp().getCacheDir(), "" + System.currentTimeMillis());
            UtilsBridge.writeFileFromIS(file.getAbsolutePath(), is);
            File file2 = file;
            return file2;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            File file = null;
            return file;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] uri2Bytes(Uri uri) {
        if (uri == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = Utils.getApp().getContentResolver().openInputStream(uri);
            byte[] byArray = UtilsBridge.inputStream2Bytes(is);
            return byArray;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Log.d((String)"UriUtils", (String)"uri to bytes failed.");
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String uri2FileAndroid11(Uri uri, Activity activity) throws IOException {
        InputStream selectedFileInputStream = activity.getContentResolver().openInputStream(uri);
        if (selectedFileInputStream != null) {
            File certCacheDir = new File(activity.getExternalFilesDir(null), FILE_BROWSER_CACHE_DIR);
            boolean isCertCacheDirExists = certCacheDir.exists();
            if (!isCertCacheDirExists) {
                isCertCacheDirExists = certCacheDir.mkdirs();
            }
            if (isCertCacheDirExists) {
                int length;
                String filePath = certCacheDir.getAbsolutePath() + "/" + UriUtils.getFileDisplayName(uri, activity);
                FileOutputStream selectedFileOutPutStream = new FileOutputStream(filePath);
                byte[] buffer = new byte[1024];
                while ((length = selectedFileInputStream.read(buffer)) > 0) {
                    ((OutputStream)selectedFileOutPutStream).write(buffer, 0, length);
                }
                selectedFileOutPutStream.flush();
                ((OutputStream)selectedFileOutPutStream).close();
                return filePath;
            }
            selectedFileInputStream.close();
        }
        return null;
    }

    @Nullable
    private static String getFileDisplayName(Uri uri, Activity activity) {
        String displayName = null;
        try (Cursor cursor = activity.getContentResolver().query(uri, null, null, null, null, null);){
            if (cursor != null && cursor.moveToFirst()) {
                displayName = cursor.getString(cursor.getColumnIndexOrThrow("_display_name"));
            }
        }
        return displayName;
    }
}

