/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.android_utils;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.AnimRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityOptionsCompat;
import androidx.core.util.Pair;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.netacom.base.chat.android_utils.Utils;
import com.netacom.base.chat.android_utils.UtilsBridge;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class ActivityUtils {
    private ActivityUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void addActivityLifecycleCallbacks(Utils.ActivityLifecycleCallbacks callbacks) {
        UtilsBridge.addActivityLifecycleCallbacks(callbacks);
    }

    public static void addActivityLifecycleCallbacks(Activity activity, Utils.ActivityLifecycleCallbacks callbacks) {
        UtilsBridge.addActivityLifecycleCallbacks(activity, callbacks);
    }

    public static void removeActivityLifecycleCallbacks(Utils.ActivityLifecycleCallbacks callbacks) {
        UtilsBridge.removeActivityLifecycleCallbacks(callbacks);
    }

    public static void removeActivityLifecycleCallbacks(Activity activity) {
        UtilsBridge.removeActivityLifecycleCallbacks(activity);
    }

    public static void removeActivityLifecycleCallbacks(Activity activity, Utils.ActivityLifecycleCallbacks callbacks) {
        UtilsBridge.removeActivityLifecycleCallbacks(activity, callbacks);
    }

    public static Activity getActivityByContext(Context context) {
        Activity activity = ActivityUtils.getActivityByContextInner(context);
        if (!ActivityUtils.isActivityAlive(activity)) {
            return null;
        }
        return activity;
    }

    private static Activity getActivityByContextInner(Context context) {
        if (context == null) {
            return null;
        }
        ArrayList<Context> list = new ArrayList<Context>();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            Activity activity = ActivityUtils.getActivityFromDecorContext(context);
            if (activity != null) {
                return activity;
            }
            list.add(context);
            context = ((ContextWrapper)context).getBaseContext();
            if (context == null) {
                return null;
            }
            if (!list.contains(context)) continue;
            return null;
        }
        return null;
    }

    private static Activity getActivityFromDecorContext(Context context) {
        if (context == null) {
            return null;
        }
        if (context.getClass().getName().equals("com.android.internal.policy.DecorContext")) {
            try {
                Field mActivityContextField = context.getClass().getDeclaredField("mActivityContext");
                mActivityContextField.setAccessible(true);
                return (Activity)((WeakReference)mActivityContextField.get(context)).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isActivityExists(@NonNull String pkg, @NonNull String cls) {
        Intent intent = new Intent();
        intent.setClassName(pkg, cls);
        PackageManager pm = Utils.getApp().getPackageManager();
        return pm.resolveActivity(intent, 0) != null && intent.resolveActivity(pm) != null && pm.queryIntentActivities(intent, 0).size() != 0;
    }

    public static void startActivity(@NonNull Class<? extends Activity> clz) {
        Context context = ActivityUtils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, null, context.getPackageName(), clz.getName(), null);
    }

    public static void startActivity(@NonNull Class<? extends Activity> clz, @Nullable Bundle options) {
        Context context = ActivityUtils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, null, context.getPackageName(), clz.getName(), options);
    }

    public static void startActivity(@NonNull Class<? extends Activity> clz, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        Context context = ActivityUtils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, null, context.getPackageName(), clz.getName(), ActivityUtils.getOptionsBundle(context, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Class<? extends Activity> clz) {
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), clz.getName(), null);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, @Nullable Bundle options) {
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), clz.getName(), options);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, View ... sharedElements) {
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), clz.getName(), ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivity((Context)activity, null, activity.getPackageName(), clz.getName(), ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Class<? extends Activity> clz) {
        Context context = ActivityUtils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, extras, context.getPackageName(), clz.getName(), null);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Class<? extends Activity> clz, @Nullable Bundle options) {
        Context context = ActivityUtils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, extras, context.getPackageName(), clz.getName(), options);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Class<? extends Activity> clz, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        Context context = ActivityUtils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, extras, context.getPackageName(), clz.getName(), ActivityUtils.getOptionsBundle(context, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz) {
        ActivityUtils.startActivity((Context)activity, extras, activity.getPackageName(), clz.getName(), null);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, @Nullable Bundle options) {
        ActivityUtils.startActivity((Context)activity, extras, activity.getPackageName(), clz.getName(), options);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, View ... sharedElements) {
        ActivityUtils.startActivity((Context)activity, extras, activity.getPackageName(), clz.getName(), ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivity((Context)activity, extras, activity.getPackageName(), clz.getName(), ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull String pkg, @NonNull String cls) {
        ActivityUtils.startActivity(ActivityUtils.getTopActivityOrApp(), null, pkg, cls, null);
    }

    public static void startActivity(@NonNull String pkg, @NonNull String cls, @Nullable Bundle options) {
        ActivityUtils.startActivity(ActivityUtils.getTopActivityOrApp(), null, pkg, cls, options);
    }

    public static void startActivity(@NonNull String pkg, @NonNull String cls, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        Context context = ActivityUtils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, null, pkg, cls, ActivityUtils.getOptionsBundle(context, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull Activity activity, @NonNull String pkg, @NonNull String cls) {
        ActivityUtils.startActivity((Context)activity, null, pkg, cls, null);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull String pkg, @NonNull String cls, @Nullable Bundle options) {
        ActivityUtils.startActivity((Context)activity, null, pkg, cls, options);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull String pkg, @NonNull String cls, View ... sharedElements) {
        ActivityUtils.startActivity((Context)activity, null, pkg, cls, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivity(@NonNull Activity activity, @NonNull String pkg, @NonNull String cls, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivity((Context)activity, null, pkg, cls, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull String pkg, @NonNull String cls) {
        ActivityUtils.startActivity(ActivityUtils.getTopActivityOrApp(), extras, pkg, cls, null);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull String pkg, @NonNull String cls, @Nullable Bundle options) {
        ActivityUtils.startActivity(ActivityUtils.getTopActivityOrApp(), extras, pkg, cls, options);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull String pkg, @NonNull String cls, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        Context context = ActivityUtils.getTopActivityOrApp();
        ActivityUtils.startActivity(context, extras, pkg, cls, ActivityUtils.getOptionsBundle(context, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls) {
        ActivityUtils.startActivity((Context)activity, extras, pkg, cls, null);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, @Nullable Bundle options) {
        ActivityUtils.startActivity((Context)activity, extras, pkg, cls, options);
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, View ... sharedElements) {
        ActivityUtils.startActivity((Context)activity, extras, pkg, cls, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivity(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivity((Context)activity, extras, pkg, cls, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static boolean startActivity(@NonNull Intent intent) {
        return ActivityUtils.startActivity(intent, ActivityUtils.getTopActivityOrApp(), null);
    }

    public static boolean startActivity(@NonNull Intent intent, @Nullable Bundle options) {
        return ActivityUtils.startActivity(intent, ActivityUtils.getTopActivityOrApp(), options);
    }

    public static boolean startActivity(@NonNull Intent intent, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        Context context = ActivityUtils.getTopActivityOrApp();
        boolean isSuccess = ActivityUtils.startActivity(intent, context, ActivityUtils.getOptionsBundle(context, enterAnim, exitAnim));
        if (isSuccess && Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(enterAnim, exitAnim);
        }
        return isSuccess;
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Intent intent) {
        ActivityUtils.startActivity(intent, (Context)activity, null);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Intent intent, @Nullable Bundle options) {
        ActivityUtils.startActivity(intent, (Context)activity, options);
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Intent intent, View ... sharedElements) {
        ActivityUtils.startActivity(intent, (Context)activity, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivity(@NonNull Activity activity, @NonNull Intent intent, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivity(intent, (Context)activity, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode) {
        ActivityUtils.startActivityForResult(activity, null, activity.getPackageName(), clz.getName(), requestCode, null);
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode, @Nullable Bundle options) {
        ActivityUtils.startActivityForResult(activity, null, activity.getPackageName(), clz.getName(), requestCode, options);
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode, View ... sharedElements) {
        ActivityUtils.startActivityForResult(activity, null, activity.getPackageName(), clz.getName(), requestCode, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivityForResult(activity, null, activity.getPackageName(), clz.getName(), requestCode, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode) {
        ActivityUtils.startActivityForResult(activity, extras, activity.getPackageName(), clz.getName(), requestCode, null);
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode, @Nullable Bundle options) {
        ActivityUtils.startActivityForResult(activity, extras, activity.getPackageName(), clz.getName(), requestCode, options);
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode, View ... sharedElements) {
        ActivityUtils.startActivityForResult(activity, extras, activity.getPackageName(), clz.getName(), requestCode, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull Class<? extends Activity> clz, int requestCode, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivityForResult(activity, extras, activity.getPackageName(), clz.getName(), requestCode, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, int requestCode) {
        ActivityUtils.startActivityForResult(activity, extras, pkg, cls, requestCode, null);
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, int requestCode, @Nullable Bundle options) {
        ActivityUtils.startActivityForResult(activity, extras, pkg, cls, requestCode, options);
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, int requestCode, View ... sharedElements) {
        ActivityUtils.startActivityForResult(activity, extras, pkg, cls, requestCode, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Activity activity, @NonNull String pkg, @NonNull String cls, int requestCode, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivityForResult(activity, extras, pkg, cls, requestCode, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int requestCode) {
        ActivityUtils.startActivityForResult(intent, activity, requestCode, null);
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int requestCode, @Nullable Bundle options) {
        ActivityUtils.startActivityForResult(intent, activity, requestCode, options);
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int requestCode, View ... sharedElements) {
        ActivityUtils.startActivityForResult(intent, activity, requestCode, ActivityUtils.getOptionsBundle(activity, sharedElements));
    }

    public static void startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int requestCode, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivityForResult(intent, activity, requestCode, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivityForResult(@NonNull Fragment fragment, @NonNull Class<? extends Activity> clz, int requestCode) {
        ActivityUtils.startActivityForResult(fragment, null, Utils.getApp().getPackageName(), clz.getName(), requestCode, null);
    }

    public static void startActivityForResult(@NonNull Fragment fragment, @NonNull Class<? extends Activity> clz, int requestCode, @Nullable Bundle options) {
        ActivityUtils.startActivityForResult(fragment, null, Utils.getApp().getPackageName(), clz.getName(), requestCode, options);
    }

    public static void startActivityForResult(@NonNull Fragment fragment, @NonNull Class<? extends Activity> clz, int requestCode, View ... sharedElements) {
        ActivityUtils.startActivityForResult(fragment, null, Utils.getApp().getPackageName(), clz.getName(), requestCode, ActivityUtils.getOptionsBundle(fragment, sharedElements));
    }

    public static void startActivityForResult(@NonNull Fragment fragment, @NonNull Class<? extends Activity> clz, int requestCode, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivityForResult(fragment, null, Utils.getApp().getPackageName(), clz.getName(), requestCode, ActivityUtils.getOptionsBundle(fragment, enterAnim, exitAnim));
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Fragment fragment, @NonNull Class<? extends Activity> clz, int requestCode) {
        ActivityUtils.startActivityForResult(fragment, extras, Utils.getApp().getPackageName(), clz.getName(), requestCode, null);
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Fragment fragment, @NonNull Class<? extends Activity> clz, int requestCode, @Nullable Bundle options) {
        ActivityUtils.startActivityForResult(fragment, extras, Utils.getApp().getPackageName(), clz.getName(), requestCode, options);
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Fragment fragment, @NonNull Class<? extends Activity> clz, int requestCode, View ... sharedElements) {
        ActivityUtils.startActivityForResult(fragment, extras, Utils.getApp().getPackageName(), clz.getName(), requestCode, ActivityUtils.getOptionsBundle(fragment, sharedElements));
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Fragment fragment, @NonNull Class<? extends Activity> clz, int requestCode, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivityForResult(fragment, extras, Utils.getApp().getPackageName(), clz.getName(), requestCode, ActivityUtils.getOptionsBundle(fragment, enterAnim, exitAnim));
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Fragment fragment, @NonNull String pkg, @NonNull String cls, int requestCode) {
        ActivityUtils.startActivityForResult(fragment, extras, pkg, cls, requestCode, null);
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Fragment fragment, @NonNull String pkg, @NonNull String cls, int requestCode, @Nullable Bundle options) {
        ActivityUtils.startActivityForResult(fragment, extras, pkg, cls, requestCode, options);
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Fragment fragment, @NonNull String pkg, @NonNull String cls, int requestCode, View ... sharedElements) {
        ActivityUtils.startActivityForResult(fragment, extras, pkg, cls, requestCode, ActivityUtils.getOptionsBundle(fragment, sharedElements));
    }

    public static void startActivityForResult(@NonNull Bundle extras, @NonNull Fragment fragment, @NonNull String pkg, @NonNull String cls, int requestCode, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivityForResult(fragment, extras, pkg, cls, requestCode, ActivityUtils.getOptionsBundle(fragment, enterAnim, exitAnim));
    }

    public static void startActivityForResult(@NonNull Fragment fragment, @NonNull Intent intent, int requestCode) {
        ActivityUtils.startActivityForResult(intent, fragment, requestCode, null);
    }

    public static void startActivityForResult(@NonNull Fragment fragment, @NonNull Intent intent, int requestCode, @Nullable Bundle options) {
        ActivityUtils.startActivityForResult(intent, fragment, requestCode, options);
    }

    public static void startActivityForResult(@NonNull Fragment fragment, @NonNull Intent intent, int requestCode, View ... sharedElements) {
        ActivityUtils.startActivityForResult(intent, fragment, requestCode, ActivityUtils.getOptionsBundle(fragment, sharedElements));
    }

    public static void startActivityForResult(@NonNull Fragment fragment, @NonNull Intent intent, int requestCode, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivityForResult(intent, fragment, requestCode, ActivityUtils.getOptionsBundle(fragment, enterAnim, exitAnim));
    }

    public static void startActivities(@NonNull Intent[] intents) {
        ActivityUtils.startActivities(intents, ActivityUtils.getTopActivityOrApp(), null);
    }

    public static void startActivities(@NonNull Intent[] intents, @Nullable Bundle options) {
        ActivityUtils.startActivities(intents, ActivityUtils.getTopActivityOrApp(), options);
    }

    public static void startActivities(@NonNull Intent[] intents, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        Context context = ActivityUtils.getTopActivityOrApp();
        ActivityUtils.startActivities(intents, context, ActivityUtils.getOptionsBundle(context, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16 && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startActivities(@NonNull Activity activity, @NonNull Intent[] intents) {
        ActivityUtils.startActivities(intents, (Context)activity, null);
    }

    public static void startActivities(@NonNull Activity activity, @NonNull Intent[] intents, @Nullable Bundle options) {
        ActivityUtils.startActivities(intents, (Context)activity, options);
    }

    public static void startActivities(@NonNull Activity activity, @NonNull Intent[] intents, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        ActivityUtils.startActivities(intents, (Context)activity, ActivityUtils.getOptionsBundle((Context)activity, enterAnim, exitAnim));
        if (Build.VERSION.SDK_INT < 16) {
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void startHomeActivity() {
        Intent homeIntent = new Intent("android.intent.action.MAIN");
        homeIntent.addCategory("android.intent.category.HOME");
        homeIntent.setFlags(0x10000000);
        ActivityUtils.startActivity(homeIntent);
    }

    public static void startLauncherActivity() {
        ActivityUtils.startLauncherActivity(Utils.getApp().getPackageName());
    }

    public static void startLauncherActivity(@NonNull String pkg) {
        String launcherActivity = ActivityUtils.getLauncherActivity(pkg);
        if (TextUtils.isEmpty((CharSequence)launcherActivity)) {
            return;
        }
        ActivityUtils.startActivity(pkg, launcherActivity);
    }

    public static List<Activity> getActivityList() {
        return UtilsBridge.getActivityList();
    }

    public static String getLauncherActivity() {
        return ActivityUtils.getLauncherActivity(Utils.getApp().getPackageName());
    }

    public static String getLauncherActivity(@NonNull String pkg) {
        if (UtilsBridge.isSpace(pkg)) {
            return "";
        }
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.setPackage(pkg);
        PackageManager pm = Utils.getApp().getPackageManager();
        List info = pm.queryIntentActivities(intent, 0);
        if (info == null || info.size() == 0) {
            return "";
        }
        return ((ResolveInfo)info.get((int)0)).activityInfo.name;
    }

    public static List<String> getMainActivities() {
        return ActivityUtils.getMainActivities(Utils.getApp().getPackageName());
    }

    public static List<String> getMainActivities(@NonNull String pkg) {
        ArrayList<String> ret = new ArrayList<String>();
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.setPackage(pkg);
        PackageManager pm = Utils.getApp().getPackageManager();
        List info = pm.queryIntentActivities(intent, 0);
        int size = info.size();
        if (size == 0) {
            return ret;
        }
        for (int i = 0; i < size; ++i) {
            ResolveInfo ri = (ResolveInfo)info.get(i);
            if (!ri.activityInfo.processName.equals(pkg)) continue;
            ret.add(ri.activityInfo.name);
        }
        return ret;
    }

    public static Activity getTopActivity() {
        return UtilsBridge.getTopActivity();
    }

    public static boolean isActivityAlive(Context context) {
        return ActivityUtils.isActivityAlive(ActivityUtils.getActivityByContext(context));
    }

    public static boolean isActivityAlive(Activity activity) {
        return activity != null && !activity.isFinishing() && (Build.VERSION.SDK_INT < 17 || !activity.isDestroyed());
    }

    public static boolean isActivityExistsInStack(@NonNull Activity activity) {
        List<Activity> activities = UtilsBridge.getActivityList();
        for (Activity aActivity : activities) {
            if (!aActivity.equals(activity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isActivityExistsInStack(@NonNull String activity) {
        List<Activity> activities = UtilsBridge.getActivityList();
        for (Activity aActivity : activities) {
            if (!aActivity.getClass().getSimpleName().equals(activity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isActivityExistsInStack(@NonNull Class<? extends Activity> clz) {
        List<Activity> activities = UtilsBridge.getActivityList();
        for (Activity aActivity : activities) {
            if (!aActivity.getClass().equals(clz)) continue;
            return true;
        }
        return false;
    }

    public static void finishActivity(@NonNull Activity activity) {
        ActivityUtils.finishActivity(activity, false);
    }

    public static void finishActivity(@NonNull Activity activity, boolean isLoadAnim) {
        activity.finish();
        if (!isLoadAnim) {
            activity.overridePendingTransition(0, 0);
        }
    }

    public static void finishActivity(@NonNull Activity activity, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        activity.finish();
        activity.overridePendingTransition(enterAnim, exitAnim);
    }

    public static void finishActivity(@NonNull Class<? extends Activity> clz) {
        ActivityUtils.finishActivity(clz, false);
    }

    public static void finishActivity(@NonNull Class<? extends Activity> clz, boolean isLoadAnim) {
        List<Activity> activities = UtilsBridge.getActivityList();
        for (Activity activity : activities) {
            if (!activity.getClass().equals(clz)) continue;
            activity.finish();
            if (isLoadAnim) continue;
            activity.overridePendingTransition(0, 0);
        }
    }

    public static void finishActivity(@NonNull Class<? extends Activity> clz, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        List<Activity> activities = UtilsBridge.getActivityList();
        for (Activity activity : activities) {
            if (!activity.getClass().equals(clz)) continue;
            activity.finish();
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static boolean finishToActivity(@NonNull Activity activity, boolean isIncludeSelf) {
        return ActivityUtils.finishToActivity(activity, isIncludeSelf, false);
    }

    public static boolean finishToActivity(@NonNull Activity activity, boolean isIncludeSelf, boolean isLoadAnim) {
        List<Activity> activities = UtilsBridge.getActivityList();
        for (Activity act : activities) {
            if (act.equals(activity)) {
                if (isIncludeSelf) {
                    ActivityUtils.finishActivity(act, isLoadAnim);
                }
                return true;
            }
            ActivityUtils.finishActivity(act, isLoadAnim);
        }
        return false;
    }

    public static boolean finishToActivity(@NonNull Activity activity, boolean isIncludeSelf, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        List<Activity> activities = UtilsBridge.getActivityList();
        for (Activity act : activities) {
            if (act.equals(activity)) {
                if (isIncludeSelf) {
                    ActivityUtils.finishActivity(act, enterAnim, exitAnim);
                }
                return true;
            }
            ActivityUtils.finishActivity(act, enterAnim, exitAnim);
        }
        return false;
    }

    public static boolean finishToActivity(@NonNull Class<? extends Activity> clz, boolean isIncludeSelf) {
        return ActivityUtils.finishToActivity(clz, isIncludeSelf, false);
    }

    public static boolean finishToActivity(@NonNull Class<? extends Activity> clz, boolean isIncludeSelf, boolean isLoadAnim) {
        List<Activity> activities = UtilsBridge.getActivityList();
        for (Activity act : activities) {
            if (act.getClass().equals(clz)) {
                if (isIncludeSelf) {
                    ActivityUtils.finishActivity(act, isLoadAnim);
                }
                return true;
            }
            ActivityUtils.finishActivity(act, isLoadAnim);
        }
        return false;
    }

    public static boolean finishToActivity(@NonNull Class<? extends Activity> clz, boolean isIncludeSelf, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        List<Activity> activities = UtilsBridge.getActivityList();
        for (Activity act : activities) {
            if (act.getClass().equals(clz)) {
                if (isIncludeSelf) {
                    ActivityUtils.finishActivity(act, enterAnim, exitAnim);
                }
                return true;
            }
            ActivityUtils.finishActivity(act, enterAnim, exitAnim);
        }
        return false;
    }

    public static void finishOtherActivities(@NonNull Class<? extends Activity> clz) {
        ActivityUtils.finishOtherActivities(clz, false);
    }

    public static void finishOtherActivities(@NonNull Class<? extends Activity> clz, boolean isLoadAnim) {
        List<Activity> activities = UtilsBridge.getActivityList();
        for (Activity act : activities) {
            if (act.getClass().equals(clz)) continue;
            ActivityUtils.finishActivity(act, isLoadAnim);
        }
    }

    public static void finishOtherActivities(@NonNull Class<? extends Activity> clz, @AnimRes int enterAnim, @AnimRes int exitAnim) {
        List<Activity> activities = UtilsBridge.getActivityList();
        for (Activity act : activities) {
            if (act.getClass().equals(clz)) continue;
            ActivityUtils.finishActivity(act, enterAnim, exitAnim);
        }
    }

    public static void finishAllActivities() {
        ActivityUtils.finishAllActivities(false);
    }

    public static void finishAllActivities(boolean isLoadAnim) {
        List<Activity> activityList = UtilsBridge.getActivityList();
        for (Activity act : activityList) {
            act.finish();
            if (isLoadAnim) continue;
            act.overridePendingTransition(0, 0);
        }
    }

    public static void finishAllActivities(@AnimRes int enterAnim, @AnimRes int exitAnim) {
        List<Activity> activityList = UtilsBridge.getActivityList();
        for (Activity act : activityList) {
            act.finish();
            act.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public static void finishAllActivitiesExceptNewest() {
        ActivityUtils.finishAllActivitiesExceptNewest(false);
    }

    public static void finishAllActivitiesExceptNewest(boolean isLoadAnim) {
        List<Activity> activities = UtilsBridge.getActivityList();
        for (int i = 1; i < activities.size(); ++i) {
            ActivityUtils.finishActivity(activities.get(i), isLoadAnim);
        }
    }

    public static void finishAllActivitiesExceptNewest(@AnimRes int enterAnim, @AnimRes int exitAnim) {
        List<Activity> activities = UtilsBridge.getActivityList();
        for (int i = 1; i < activities.size(); ++i) {
            ActivityUtils.finishActivity(activities.get(i), enterAnim, exitAnim);
        }
    }

    public static Drawable getActivityIcon(@NonNull Activity activity) {
        return ActivityUtils.getActivityIcon(activity.getComponentName());
    }

    public static Drawable getActivityIcon(@NonNull Class<? extends Activity> clz) {
        return ActivityUtils.getActivityIcon(new ComponentName((Context)Utils.getApp(), clz));
    }

    public static Drawable getActivityIcon(@NonNull ComponentName activityName) {
        PackageManager pm = Utils.getApp().getPackageManager();
        try {
            return pm.getActivityIcon(activityName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Drawable getActivityLogo(@NonNull Activity activity) {
        return ActivityUtils.getActivityLogo(activity.getComponentName());
    }

    public static Drawable getActivityLogo(@NonNull Class<? extends Activity> clz) {
        return ActivityUtils.getActivityLogo(new ComponentName((Context)Utils.getApp(), clz));
    }

    public static Drawable getActivityLogo(@NonNull ComponentName activityName) {
        PackageManager pm = Utils.getApp().getPackageManager();
        try {
            return pm.getActivityLogo(activityName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void startActivity(Context context, Bundle extras, String pkg, String cls, @Nullable Bundle options) {
        Intent intent = new Intent();
        if (extras != null) {
            intent.putExtras(extras);
        }
        intent.setComponent(new ComponentName(pkg, cls));
        ActivityUtils.startActivity(intent, context, options);
    }

    private static boolean startActivity(Intent intent, Context context, Bundle options) {
        if (!ActivityUtils.isIntentAvailable(intent)) {
            Log.e((String)"ActivityUtils", (String)"intent is unavailable");
            return false;
        }
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        if (options != null && Build.VERSION.SDK_INT >= 16) {
            context.startActivity(intent, options);
        } else {
            context.startActivity(intent);
        }
        return true;
    }

    private static boolean isIntentAvailable(Intent intent) {
        return Utils.getApp().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    private static boolean startActivityForResult(Activity activity, Bundle extras, String pkg, String cls, int requestCode, @Nullable Bundle options) {
        Intent intent = new Intent();
        if (extras != null) {
            intent.putExtras(extras);
        }
        intent.setComponent(new ComponentName(pkg, cls));
        return ActivityUtils.startActivityForResult(intent, activity, requestCode, options);
    }

    private static boolean startActivityForResult(Intent intent, Activity activity, int requestCode, @Nullable Bundle options) {
        if (!ActivityUtils.isIntentAvailable(intent)) {
            Log.e((String)"ActivityUtils", (String)"intent is unavailable");
            return false;
        }
        if (options != null && Build.VERSION.SDK_INT >= 16) {
            activity.startActivityForResult(intent, requestCode, options);
        } else {
            activity.startActivityForResult(intent, requestCode);
        }
        return true;
    }

    private static void startActivities(Intent[] intents, Context context, @Nullable Bundle options) {
        if (!(context instanceof Activity)) {
            for (Intent intent : intents) {
                intent.addFlags(0x10000000);
            }
        }
        if (options != null && Build.VERSION.SDK_INT >= 16) {
            context.startActivities(intents, options);
        } else {
            context.startActivities(intents);
        }
    }

    private static boolean startActivityForResult(Fragment fragment, Bundle extras, String pkg, String cls, int requestCode, @Nullable Bundle options) {
        Intent intent = new Intent();
        if (extras != null) {
            intent.putExtras(extras);
        }
        intent.setComponent(new ComponentName(pkg, cls));
        return ActivityUtils.startActivityForResult(intent, fragment, requestCode, options);
    }

    private static boolean startActivityForResult(Intent intent, Fragment fragment, int requestCode, @Nullable Bundle options) {
        if (!ActivityUtils.isIntentAvailable(intent)) {
            Log.e((String)"ActivityUtils", (String)"intent is unavailable");
            return false;
        }
        if (fragment.getActivity() == null) {
            Log.e((String)"ActivityUtils", (String)("Fragment " + fragment + " not attached to Activity"));
            return false;
        }
        if (options != null && Build.VERSION.SDK_INT >= 16) {
            fragment.startActivityForResult(intent, requestCode, options);
        } else {
            fragment.startActivityForResult(intent, requestCode);
        }
        return true;
    }

    private static Bundle getOptionsBundle(Fragment fragment, int enterAnim, int exitAnim) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return null;
        }
        return ActivityOptionsCompat.makeCustomAnimation((Context)activity, (int)enterAnim, (int)exitAnim).toBundle();
    }

    private static Bundle getOptionsBundle(Context context, int enterAnim, int exitAnim) {
        return ActivityOptionsCompat.makeCustomAnimation((Context)context, (int)enterAnim, (int)exitAnim).toBundle();
    }

    private static Bundle getOptionsBundle(Fragment fragment, View[] sharedElements) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return null;
        }
        return ActivityUtils.getOptionsBundle((Activity)activity, sharedElements);
    }

    private static Bundle getOptionsBundle(Activity activity, View[] sharedElements) {
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (sharedElements == null) {
            return null;
        }
        int len = sharedElements.length;
        if (len <= 0) {
            return null;
        }
        Pair[] pairs = new Pair[len];
        for (int i = 0; i < len; ++i) {
            pairs[i] = Pair.create((Object)sharedElements[i], (Object)sharedElements[i].getTransitionName());
        }
        return ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)activity, (Pair[])pairs).toBundle();
    }

    private static Context getTopActivityOrApp() {
        if (UtilsBridge.isAppForeground()) {
            Activity topActivity = ActivityUtils.getTopActivity();
            return topActivity == null ? Utils.getApp() : topActivity;
        }
        return Utils.getApp();
    }
}

