/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.impl;

import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.tps.TpsControlManager;
import com.alibaba.nacos.plugin.control.tps.TpsMetrics;
import com.alibaba.nacos.plugin.control.tps.barrier.TpsBarrier;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;
import com.alibaba.nacos.plugin.control.tps.response.TpsCheckResponse;
import com.alibaba.nacos.plugin.control.tps.rule.TpsControlRule;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class NacosTpsControlManager
extends TpsControlManager {
    protected final Map<String, TpsBarrier> points = new ConcurrentHashMap<String, TpsBarrier>(16);
    protected final Map<String, TpsControlRule> rules = new ConcurrentHashMap<String, TpsControlRule>(16);
    protected ScheduledExecutorService executorService = ExecutorFactory.newSingleScheduledExecutorService(r -> {
        Thread thread = new Thread(r, "nacos.plugin.tps.control.reporter");
        thread.setDaemon(true);
        return thread;
    });

    public NacosTpsControlManager() {
        this.startTpsReport();
    }

    protected void startTpsReport() {
        this.executorService.scheduleWithFixedDelay(new TpsMetricsReporter(), 0L, 900L, TimeUnit.MILLISECONDS);
    }

    public synchronized void registerTpsPoint(String pointName) {
        if (!this.points.containsKey(pointName)) {
            this.points.put(pointName, this.tpsBarrierCreator.createTpsBarrier(pointName));
            if (this.rules.containsKey(pointName)) {
                this.points.get(pointName).applyRule(this.rules.get(pointName));
            } else {
                this.initTpsRule(pointName);
            }
        }
    }

    public synchronized void applyTpsRule(String pointName, TpsControlRule rule) {
        if (rule == null) {
            this.rules.remove(pointName);
        } else {
            this.rules.put(pointName, rule);
        }
        if (this.points.containsKey(pointName)) {
            this.points.get(pointName).applyRule(rule);
        }
    }

    public Map<String, TpsBarrier> getPoints() {
        return this.points;
    }

    public Map<String, TpsControlRule> getRules() {
        return this.rules;
    }

    public TpsCheckResponse check(TpsCheckRequest tpsRequest) {
        if (this.points.containsKey(tpsRequest.getPointName())) {
            try {
                return this.points.get(tpsRequest.getPointName()).applyTps(tpsRequest);
            }
            catch (Throwable throwable) {
                Loggers.TPS.warn("[{}]apply tps error,error={}", (Object)tpsRequest.getPointName(), (Object)throwable);
            }
        }
        return new TpsCheckResponse(true, 100, "skip");
    }

    public String getName() {
        return "nacos";
    }

    class TpsMetricsReporter
    implements Runnable {
        long lastReportSecond = 0L;

        TpsMetricsReporter() {
        }

        public String getTimeFormatOfSecond(long timeStamp) {
            String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timeStamp));
            return format;
        }

        @Override
        public void run() {
            try {
                long now = System.currentTimeMillis();
                StringBuilder stringBuilder = new StringBuilder();
                Set<Map.Entry<String, TpsBarrier>> entries = NacosTpsControlManager.this.points.entrySet();
                long tempSecond = 0L;
                long metricsTime = now - 1000L;
                String formatString = this.getTimeFormatOfSecond(metricsTime);
                for (Map.Entry<String, TpsBarrier> entry : entries) {
                    TpsBarrier tpsBarrier = entry.getValue();
                    String pointName = entry.getKey();
                    TpsMetrics metrics = tpsBarrier.getPointBarrier().getMetrics(metricsTime);
                    if (metrics == null || this.lastReportSecond != 0L && this.lastReportSecond == metrics.getTimeStamp()) continue;
                    tempSecond = metrics.getTimeStamp();
                    stringBuilder.append(pointName).append("|").append("point").append("|").append((Object)metrics.getPeriod()).append("|").append(formatString).append("|").append(metrics.getCounter().getPassCount()).append("|").append(metrics.getCounter().getDeniedCount()).append("|").append("\n");
                }
                if (tempSecond > 0L) {
                    this.lastReportSecond = tempSecond;
                }
                if (stringBuilder.length() > 0) {
                    Loggers.TPS.info("Tps reporting...\n" + stringBuilder.toString());
                }
            }
            catch (Throwable throwable) {
                Loggers.TPS.error("Tps reporting error", throwable);
            }
        }
    }
}

