/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl;

import com.alibaba.nacos.plugin.auth.impl.LdapAuthenticationProvider;
import com.alibaba.nacos.plugin.auth.impl.NacosLdapContextSource;
import com.alibaba.nacos.plugin.auth.impl.authenticate.IAuthenticationManager;
import com.alibaba.nacos.plugin.auth.impl.authenticate.LdapAuthenticationManager;
import com.alibaba.nacos.plugin.auth.impl.configuration.ConditionOnLdapAuth;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleServiceImpl;
import com.alibaba.nacos.plugin.auth.impl.token.TokenManagerDelegate;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserDetailsServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.ldap.LdapAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration(proxyBeanMethods=false)
@EnableAutoConfiguration(exclude={LdapAutoConfiguration.class})
public class LdapAuthConfig {
    @Value(value="${nacos.core.auth.ldap.url:ldap://localhost:389}")
    private String ldapUrl;
    @Value(value="${nacos.core.auth.ldap.basedc:dc=example,dc=org}")
    private String ldapBaseDc;
    @Value(value="${nacos.core.auth.ldap.timeout:3000}")
    private String ldapTimeOut;
    @Value(value="${nacos.core.auth.ldap.userDn:cn=admin,dc=example,dc=org}")
    private String userDn;
    @Value(value="${nacos.core.auth.ldap.password:password}")
    private String password;
    @Value(value="${nacos.core.auth.ldap.filter.prefix:uid}")
    private String filterPrefix;
    @Value(value="${nacos.core.auth.ldap.case.sensitive:true}")
    private boolean caseSensitive;
    @Value(value="${nacos.core.auth.ldap.ignore.partial.result.exception:false}")
    private boolean ignorePartialResultException;

    @Bean
    @Conditional(value={ConditionOnLdapAuth.class})
    public LdapTemplate ldapTemplate(LdapContextSource ldapContextSource) {
        LdapTemplate ldapTemplate = new LdapTemplate((ContextSource)ldapContextSource);
        ldapTemplate.setIgnorePartialResultException(this.ignorePartialResultException);
        return ldapTemplate;
    }

    @Bean
    public LdapContextSource ldapContextSource() {
        return new NacosLdapContextSource(this.ldapUrl, this.ldapBaseDc, this.userDn, this.password, this.ldapTimeOut);
    }

    @Bean
    @Conditional(value={ConditionOnLdapAuth.class})
    public LdapAuthenticationProvider ldapAuthenticationProvider(LdapTemplate ldapTemplate, NacosUserDetailsServiceImpl userDetailsService, NacosRoleServiceImpl nacosRoleService) {
        return new LdapAuthenticationProvider(ldapTemplate, userDetailsService, nacosRoleService, this.filterPrefix, this.caseSensitive);
    }

    @Bean
    @Conditional(value={ConditionOnLdapAuth.class})
    public IAuthenticationManager ldapAuthenticatoinManager(LdapTemplate ldapTemplate, NacosUserDetailsServiceImpl userDetailsService, TokenManagerDelegate jwtTokenManager, NacosRoleServiceImpl roleService) {
        return new LdapAuthenticationManager(ldapTemplate, userDetailsService, jwtTokenManager, roleService, this.filterPrefix, this.caseSensitive);
    }
}

