/*
 * Decompiled with CFR 0.152.
 */
package video.pano.liveplayer.api;

import android.content.Context;
import android.util.AttributeSet;
import video.pano.liveplayer.RendererCommon;
import video.pano.liveplayer.SurfaceViewRenderer;
import video.pano.liveplayer.api.Constants;

public class PanoVideoView
extends SurfaceViewRenderer {
    private Constants.ScalingType mScaleType = Constants.ScalingType.Fit;
    private boolean mMirror = false;
    private boolean mHasInit = false;

    public PanoVideoView(Context context) {
        this(context, null);
    }

    public PanoVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void init(RendererCommon.RendererEvents rendererEvents) {
        if (!this.mHasInit) {
            try {
                super.init(rendererEvents);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            this.setScalingType(this.mScaleType);
            this.mHasInit = true;
        } else if (rendererEvents != this.rendererEvents) {
            this.rendererEvents = rendererEvents;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.init(this.rendererEvents);
    }

    @Override
    public void release() {
        super.release();
        this.mHasInit = false;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.release();
    }

    public void setScalingType(Constants.ScalingType type) {
        RendererCommon.ScalingType renderScaling;
        this.mScaleType = type;
        switch (type) {
            case CropFill: {
                renderScaling = RendererCommon.ScalingType.SCALE_ASPECT_FILL;
                break;
            }
            case FullFill: {
                renderScaling = RendererCommon.ScalingType.SCALE_FILL;
                break;
            }
            default: {
                renderScaling = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
            }
        }
        super.setScalingType(renderScaling);
    }

    @Override
    public void setMirror(boolean mirror) {
        this.mMirror = mirror;
        super.setMirror(mirror);
    }

    public Constants.ScalingType getScalingType() {
        return this.mScaleType;
    }

    public boolean getMirror() {
        return this.mMirror;
    }
}

