/*
 * Decompiled with CFR 0.152.
 */
package video.pano.liveplayer;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import video.pano.liveplayer.EglBase;
import video.pano.liveplayer.EglRenderer;
import video.pano.liveplayer.EglSharedContextHelper;
import video.pano.liveplayer.GlRectDrawer;
import video.pano.liveplayer.RendererCommon;
import video.pano.liveplayer.SurfaceEglRenderer;
import video.pano.liveplayer.ThreadUtils;
import video.pano.liveplayer.VideoFrame;
import video.pano.liveplayer.VideoSink;

public class SurfaceViewRenderer
extends SurfaceView
implements SurfaceHolder.Callback,
VideoSink,
RendererCommon.RendererEvents {
    private static final String TAG = "SurfaceViewRenderer";
    private final String resourceName;
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
    private final SurfaceEglRenderer eglRenderer;
    protected RendererCommon.RendererEvents rendererEvents;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private boolean enableFixedSize;
    private int surfaceWidth;
    private int surfaceHeight;
    private boolean deviceMirror;
    private boolean renderMirror;

    public SurfaceViewRenderer(Context context) {
        this(context, null);
    }

    public SurfaceViewRenderer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().addCallback((SurfaceHolder.Callback)this.eglRenderer);
    }

    protected void init(RendererCommon.RendererEvents rendererEvents) {
        this.init(rendererEvents, EglBase.CONFIG_PLAIN);
    }

    public void init(RendererCommon.RendererEvents rendererEvents, int[] configAttributes) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.eglRenderer.init(EglSharedContextHelper.getEglSharedContext(), this, configAttributes, new GlRectDrawer());
    }

    public void changeEglBase(EglBase eglBase) {
        this.eglRenderer.changeEglBase(eglBase);
    }

    public void release() {
        this.eglRenderer.release();
    }

    public void addFrameListener(EglRenderer.FrameListener listener, float scale, RendererCommon.GlDrawer drawerParam) {
        this.eglRenderer.addFrameListener(listener, scale, drawerParam);
    }

    public void addFrameListener(EglRenderer.FrameListener listener, float scale) {
        this.eglRenderer.addFrameListener(listener, scale);
    }

    public void removeFrameListener(EglRenderer.FrameListener listener) {
        this.eglRenderer.removeFrameListener(listener);
    }

    public void setEnableHardwareScaler(boolean enabled) {
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = enabled;
        this.updateSurfaceSize();
    }

    public void setMovingDistance(int dx, int dy) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width == 0 || height == 0) {
            return;
        }
        this.eglRenderer.setMovingDistance((float)dx / (float)width, (float)dy / (float)height);
    }

    public void setScalingRatioWithFocus(float ratio, int x, int y) {
        this.eglRenderer.setScalingRatioWithFocus(ratio, x, y);
    }

    protected void setScalingRatio(RendererCommon.ScalingRatio ratio) {
        this.eglRenderer.setScalingRatio(ratio);
    }

    protected void setScalingType(RendererCommon.ScalingType scalingType) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setScalingType(scalingType);
        this.videoLayoutMeasure.setScalingType(scalingType);
        this.requestLayout();
    }

    protected void setScalingType(RendererCommon.ScalingType scalingTypeMatchOrientation, RendererCommon.ScalingType scalingTypeMismatchOrientation) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setScalingType(scalingTypeMatchOrientation);
        this.videoLayoutMeasure.setScalingType(scalingTypeMatchOrientation, scalingTypeMismatchOrientation);
        this.requestLayout();
    }

    public void redrawFrame() {
        this.eglRenderer.redrawFrame();
    }

    public int getViewPortX() {
        return this.eglRenderer.getViewportX();
    }

    public int getViewPortY() {
        return this.eglRenderer.getViewportY();
    }

    public int getViewPortWidth() {
        return this.eglRenderer.getViewPortWidth();
    }

    public int getViewPortHeight() {
        return this.eglRenderer.getViewPortHeight();
    }

    public float getOffsetX() {
        return this.eglRenderer.getOffsetX();
    }

    public float getOffsetY() {
        return this.eglRenderer.getOffsetY();
    }

    public void setFpsReduction(float fps) {
        this.eglRenderer.setFpsReduction(fps);
    }

    public void disableFpsReduction() {
        this.eglRenderer.disableFpsReduction();
    }

    public void pauseVideo() {
        this.eglRenderer.pauseVideo();
    }

    @Override
    public void onFrame(VideoFrame frame) {
        this.eglRenderer.onFrame(frame);
    }

    @Override
    public void setDeviceMirror(boolean mirror) {
        this.deviceMirror = mirror;
        this.eglRenderer.setMirror(mirror || this.renderMirror);
    }

    public void setMirror(boolean mirror) {
        this.renderMirror = mirror;
        this.eglRenderer.setMirror(mirror || this.deviceMirror);
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        ThreadUtils.checkIsOnMainThread();
        Point size = this.videoLayoutMeasure.measure(widthSpec, heightSpec, this.rotatedFrameWidth, this.rotatedFrameHeight);
        this.setMeasuredDimension(size.x, size.y);
        this.logD("onMeasure(). New size: " + size.x + "x" + size.y);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setLayoutAspectRatio((float)(right - left) / (float)(bottom - top));
        this.updateSurfaceSize();
    }

    private void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
            int drawnFrameHeight;
            int drawnFrameWidth;
            float frameAspectRatio = (float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight;
            float layoutAspectRatio = (float)this.getWidth() / (float)this.getHeight();
            if (frameAspectRatio > layoutAspectRatio) {
                drawnFrameWidth = (int)((float)this.rotatedFrameHeight * layoutAspectRatio);
                drawnFrameHeight = this.rotatedFrameHeight;
            } else {
                drawnFrameWidth = this.rotatedFrameWidth;
                drawnFrameHeight = (int)((float)this.rotatedFrameWidth / layoutAspectRatio);
            }
            int width = Math.min(this.getWidth(), drawnFrameWidth);
            int height = Math.min(this.getHeight(), drawnFrameHeight);
            this.logD("updateSurfaceSize. Layout size: " + this.getWidth() + "x" + this.getHeight() + ", frame size: " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + ", requested surface size: " + width + "x" + height + ", old surface size: " + this.surfaceWidth + "x" + this.surfaceHeight);
            if (width != this.surfaceWidth || height != this.surfaceHeight) {
                this.surfaceWidth = width;
                this.surfaceHeight = height;
                this.getHolder().setFixedSize(width, height);
            }
        } else {
            this.surfaceHeight = 0;
            this.surfaceWidth = 0;
            this.getHolder().setSizeFromLayout();
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        ThreadUtils.checkIsOnMainThread();
        this.surfaceHeight = 0;
        this.surfaceWidth = 0;
        this.updateSurfaceSize();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    private String getResourceName() {
        try {
            return this.getResources().getResourceEntryName(this.getId());
        }
        catch (Resources.NotFoundException e) {
            return "";
        }
    }

    public void setBackgroundColor(float r, float g, float b, float a) {
        this.eglRenderer.setBackgroundColor(r, g, b, a);
    }

    public void clearImage() {
        this.eglRenderer.clearImage();
    }

    @Override
    public void onFirstFrameRendered() {
        if (this.rendererEvents != null) {
            this.rendererEvents.onFirstFrameRendered();
        }
    }

    @Override
    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        if (this.rendererEvents != null) {
            this.rendererEvents.onFrameResolutionChanged(videoWidth, videoHeight, rotation);
        }
        int rotatedWidth = rotation == 0 || rotation == 180 ? videoWidth : videoHeight;
        int rotatedHeight = rotation == 0 || rotation == 180 ? videoHeight : videoWidth;
        this.postOrRun(() -> {
            this.rotatedFrameWidth = rotatedWidth;
            this.rotatedFrameHeight = rotatedHeight;
            this.updateSurfaceSize();
            this.requestLayout();
        });
    }

    private void postOrRun(Runnable r) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            r.run();
        } else {
            this.post(r);
        }
    }

    private void logD(String string) {
        Log.d((String)TAG, (String)(this.resourceName + ": " + string));
    }
}

