/*
 * Decompiled with CFR 0.152.
 */
package video.pano.liveplayer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import video.pano.liveplayer.EglBase;
import video.pano.liveplayer.GlRectDrawer;
import video.pano.liveplayer.GlTextureFrameBuffer;
import video.pano.liveplayer.GlUtil;
import video.pano.liveplayer.RendererCommon;
import video.pano.liveplayer.TextureBufferImpl;
import video.pano.liveplayer.ThreadUtils;
import video.pano.liveplayer.VideoFrame;
import video.pano.liveplayer.VideoFrameDrawer;
import video.pano.liveplayer.VideoSink;

public class EglRenderer
implements VideoSink {
    private static final String TAG = "EglRenderer";
    private static final long LOG_INTERVAL_SEC = 4L;
    protected final String name;
    private final Object handlerLock = new Object();
    private Handler renderThreadHandler;
    private final ArrayList<FrameListenerAndParams> frameListeners = new ArrayList();
    private volatile ErrorCallback errorCallback;
    private final Object fpsReductionLock = new Object();
    private long nextFrameTimeNs;
    private long minRenderPeriodNs;
    protected EglBase eglBase;
    private final VideoFrameDrawer frameDrawer = new VideoFrameDrawer();
    private RendererCommon.GlDrawer drawer;
    private boolean usePresentationTimeStamp;
    private final Matrix drawMatrix = new Matrix();
    private final Object frameLock = new Object();
    private VideoFrame pendingFrame;
    private VideoFrame renderFrame;
    private int lastRotatedWidth;
    private int lastRotatedHeight;
    private final Object layoutLock = new Object();
    private float layoutAspectRatio;
    private boolean mirror;
    private RendererCommon.ScalingType scalingType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
    private final Object renderLock = new Object();
    private static final float RatioMin = 0.1f;
    private static final float RatioMax = 1.0f;
    private float ratio = 1.0f;
    private float wRatio = 1.0f;
    private float hRatio = 1.0f;
    private float offsetX = -0.0f;
    private float offsetY = -0.0f;
    private float bgColorR = 0.0f;
    private float bgColorG = 0.0f;
    private float bgColorB = 0.0f;
    private float bgColorA = 0.0f;
    private RendererCommon.ScalingRatio predefinedRatio = RendererCommon.ScalingRatio.SCALE_RATIO_NONE;
    private final Object statisticsLock = new Object();
    private int framesReceived;
    private int framesDropped;
    private int framesRendered;
    private long statisticsStartTimeNs;
    private long renderTimeNs;
    private long renderSwapBufferTimeNs;
    private int viewportX;
    private int viewportY;
    private int viewportWidth;
    private int viewportHeight;
    private final GlTextureFrameBuffer bitmapTextureFramebuffer = new GlTextureFrameBuffer(6408);
    private final Runnable logStatisticsRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EglRenderer.this.logStatistics();
            Object object = EglRenderer.this.handlerLock;
            synchronized (object) {
                if (EglRenderer.this.renderThreadHandler != null) {
                    EglRenderer.this.renderThreadHandler.removeCallbacks(EglRenderer.this.logStatisticsRunnable);
                    EglRenderer.this.renderThreadHandler.postDelayed(EglRenderer.this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
                }
            }
        }
    };
    private final EglSurfaceCreation eglSurfaceCreationRunnable = new EglSurfaceCreation();
    private boolean mRedrawFlag = false;

    public EglRenderer(String name) {
        this.name = name;
    }

    public void changeEglBase(EglBase eglBase) {
        this.logD("changeEglBase " + eglBase);
        this.release();
        this.drawer = new GlRectDrawer();
        HandlerThread renderThread = new HandlerThread(this.name + TAG);
        renderThread.start();
        this.renderThreadHandler = new HandlerWithExceptionCallback(renderThread.getLooper(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = EglRenderer.this.handlerLock;
                synchronized (object) {
                    EglRenderer.this.renderThreadHandler = null;
                }
            }
        });
        this.eglBase = eglBase;
        this.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EglBase.Context sharedContext, int[] configAttributes, RendererCommon.GlDrawer drawer, boolean usePresentationTimeStamp) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                throw new IllegalStateException(this.name + "Already initialized");
            }
            this.logD("Initializing EglRenderer");
            this.drawer = drawer;
            this.usePresentationTimeStamp = usePresentationTimeStamp;
            HandlerThread renderThread = new HandlerThread(this.name + TAG);
            renderThread.start();
            this.renderThreadHandler = new HandlerWithExceptionCallback(renderThread.getLooper(), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = EglRenderer.this.handlerLock;
                    synchronized (object) {
                        EglRenderer.this.renderThreadHandler = null;
                    }
                }
            });
            ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, () -> {
                if (sharedContext == null) {
                    this.logD("EglBase10.create context");
                    this.eglBase = EglBase.createEgl10(configAttributes);
                } else {
                    this.logD("EglBase.create shared context");
                    this.eglBase = EglBase.create(sharedContext, configAttributes);
                }
            });
            this.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
            long currentTimeNs = System.nanoTime();
            this.resetStatistics(currentTimeNs);
            this.renderThreadHandler.postDelayed(this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
        }
    }

    public void init(EglBase.Context sharedContext, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        this.init(sharedContext, configAttributes, drawer, false);
    }

    public void createEglSurface(Surface surface) {
        this.createEglSurfaceInternal(surface);
    }

    public void createEglSurface(SurfaceTexture surfaceTexture) {
        this.createEglSurfaceInternal(surfaceTexture);
    }

    private void createEglSurfaceInternal(Object surface) {
        this.eglSurfaceCreationRunnable.setSurface(surface);
        this.postToRenderThread(this.eglSurfaceCreationRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.logD("Releasing.");
        CountDownLatch eglCleanupBarrier = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            this.renderThreadHandler.removeCallbacks(this.logStatisticsRunnable);
            this.renderThreadHandler.postAtFrontOfQueue(() -> {
                Object object = EglBase.lock;
                synchronized (object) {
                    GLES20.glUseProgram((int)0);
                }
                if (this.drawer != null) {
                    this.drawer.release();
                    this.drawer = null;
                }
                this.frameDrawer.release();
                this.bitmapTextureFramebuffer.release();
                if (this.eglBase != null) {
                    this.logD("eglBase detach and release.");
                    this.eglBase.detachCurrent();
                    this.eglBase.release();
                    this.eglBase = null;
                }
                this.frameListeners.clear();
                eglCleanupBarrier.countDown();
                if (this.renderFrame != null) {
                    this.renderFrame.release();
                    this.renderFrame = null;
                }
            });
            Looper renderLooper = this.renderThreadHandler.getLooper();
            this.renderThreadHandler.post(() -> {
                this.logD("Quitting render thread.");
                renderLooper.quit();
            });
            this.renderThreadHandler = null;
        }
        ThreadUtils.awaitUninterruptibly(eglCleanupBarrier);
        object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                this.pendingFrame.release();
                this.pendingFrame = null;
            }
        }
        this.logD("Releasing done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStatistics(long currentTimeNs) {
        Object object = this.statisticsLock;
        synchronized (object) {
            this.statisticsStartTimeNs = currentTimeNs;
            this.framesReceived = 0;
            this.framesDropped = 0;
            this.framesRendered = 0;
            this.renderTimeNs = 0L;
            this.renderSwapBufferTimeNs = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean mirror) {
        this.logD("setMirror: " + mirror);
        Object object = this.layoutLock;
        synchronized (object) {
            this.mirror = mirror;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScalingType(RendererCommon.ScalingType scalingType) {
        Object object = this.renderLock;
        synchronized (object) {
            this.scalingType = scalingType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMovingDistance(float dx, float dy) {
        Object object = this.renderLock;
        synchronized (object) {
            if (this.scalingType == RendererCommon.ScalingType.SCALE_ASPECT_FIT) {
                this.calcRatio(this.ratio);
                this.offsetX -= dx * this.wRatio;
                this.offsetY += dy * this.hRatio;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScalingRatioWithFocus(float r, int focusX, int focusY) {
        Object object = this.renderLock;
        synchronized (object) {
            this.calcOffset(r, focusX, focusY);
            if (this.scalingType == RendererCommon.ScalingType.SCALE_ASPECT_FIT) {
                this.ratio *= r;
                this.ratio = Math.min(this.ratio, 1.0f);
                this.ratio = Math.max(this.ratio, 0.1f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScalingRatio(RendererCommon.ScalingRatio r) {
        Object object = this.renderLock;
        synchronized (object) {
            if (r == RendererCommon.ScalingRatio.SCALE_RATIO_FIT) {
                this.ratio = 1.0f;
                this.predefinedRatio = r;
            } else if (r == RendererCommon.ScalingRatio.SCALE_RATIO_ORIGINAL) {
                this.predefinedRatio = r;
            }
        }
    }

    private void calcRatio(float r) {
        float drawnAspectRatio;
        this.wRatio = r;
        this.hRatio = r;
        int viewportWidth = this.eglBase.surfaceWidth();
        int viewportHeight = this.eglBase.surfaceHeight();
        float frameAspectRatio = 1.0f;
        if (this.lastRotatedHeight != 0) {
            frameAspectRatio = (float)this.lastRotatedWidth / (float)this.lastRotatedHeight;
        }
        if (frameAspectRatio > (drawnAspectRatio = (float)(viewportWidth / viewportHeight))) {
            viewportWidth = Math.round((float)this.eglBase.surfaceWidth() / this.ratio);
            viewportHeight = Math.round((float)viewportWidth / frameAspectRatio);
            if (viewportHeight > this.eglBase.surfaceHeight()) {
                this.hRatio = (float)this.eglBase.surfaceHeight() / (float)viewportHeight;
            }
        } else {
            viewportHeight = Math.round((float)this.eglBase.surfaceHeight() / this.ratio);
            viewportWidth = Math.round((float)viewportHeight * frameAspectRatio);
            if (viewportWidth > this.eglBase.surfaceWidth()) {
                this.wRatio = (float)this.eglBase.surfaceWidth() / (float)viewportWidth;
            }
        }
    }

    private void calcOffset(float r, int focusX, int focusY) {
        if (this.scalingType == RendererCommon.ScalingType.SCALE_ASPECT_FIT) {
            int surfaceWidth = this.eglBase.surfaceWidth();
            int surfaceHeight = this.eglBase.surfaceHeight();
            if (surfaceWidth == 0 || surfaceHeight == 0) {
                return;
            }
            focusY = surfaceHeight - focusY;
            int x = surfaceWidth / 2 - focusX;
            int y = surfaceHeight / 2 - focusY;
            float newRatio = this.ratio * r;
            newRatio = Math.min(newRatio, 1.0f);
            newRatio = Math.max(newRatio, 0.1f);
            this.calcRatio(newRatio);
            this.offsetX += ((float)x * r - (float)x) * this.wRatio / (float)surfaceWidth;
            this.offsetY += ((float)y * r - (float)y) * this.hRatio / (float)surfaceHeight;
        }
    }

    public int getViewportX() {
        return this.viewportX;
    }

    public int getViewportY() {
        return this.viewportY;
    }

    public int getViewPortWidth() {
        return this.viewportWidth;
    }

    public int getViewPortHeight() {
        return this.viewportHeight;
    }

    public float getOffsetX() {
        return -this.offsetX * (float)this.viewportWidth;
    }

    public float getOffsetY() {
        return this.offsetY * (float)this.viewportHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutAspectRatio(float layoutAspectRatio) {
        this.logD("setLayoutAspectRatio: " + layoutAspectRatio);
        Object object = this.layoutLock;
        synchronized (object) {
            this.layoutAspectRatio = layoutAspectRatio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFpsReduction(float fps) {
        this.logD("setFpsReduction: " + fps);
        Object object = this.fpsReductionLock;
        synchronized (object) {
            long previousRenderPeriodNs = this.minRenderPeriodNs;
            this.minRenderPeriodNs = fps <= 0.0f ? Long.MAX_VALUE : (long)((float)TimeUnit.SECONDS.toNanos(1L) / fps);
            if (this.minRenderPeriodNs != previousRenderPeriodNs) {
                this.nextFrameTimeNs = System.nanoTime();
            }
        }
    }

    public void disableFpsReduction() {
        this.setFpsReduction(Float.POSITIVE_INFINITY);
    }

    public void pauseVideo() {
        this.setFpsReduction(0.0f);
    }

    public void addFrameListener(FrameListener listener, float scale) {
        this.addFrameListener(listener, scale, null, false);
    }

    public void addFrameListener(FrameListener listener, float scale, RendererCommon.GlDrawer drawerParam) {
        this.addFrameListener(listener, scale, drawerParam, false);
    }

    public void addFrameListener(FrameListener listener, float scale, RendererCommon.GlDrawer drawerParam, boolean applyFpsReduction) {
        this.postToRenderThread(() -> {
            RendererCommon.GlDrawer listenerDrawer = drawerParam == null ? this.drawer : drawerParam;
            this.frameListeners.add(new FrameListenerAndParams(listener, scale, listenerDrawer, applyFpsReduction));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameListener(FrameListener listener) {
        CountDownLatch latch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            if (Thread.currentThread() == this.renderThreadHandler.getLooper().getThread()) {
                throw new RuntimeException("removeFrameListener must not be called on the render thread.");
            }
            this.postToRenderThread(() -> {
                latch.countDown();
                Iterator<FrameListenerAndParams> iter = this.frameListeners.iterator();
                while (iter.hasNext()) {
                    if (iter.next().listener != listener) continue;
                    iter.remove();
                }
            });
        }
        ThreadUtils.awaitUninterruptibly(latch);
    }

    public void setErrorCallback(ErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame frame) {
        boolean dropOldFrame;
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.framesReceived;
        }
        Object object2 = this.handlerLock;
        synchronized (object2) {
            if (this.renderThreadHandler == null) {
                this.logD("Dropping frame - Not initialized or already released.");
                return;
            }
            Object object3 = this.frameLock;
            synchronized (object3) {
                boolean bl = dropOldFrame = this.pendingFrame != null;
                if (dropOldFrame) {
                    this.pendingFrame.release();
                }
                this.pendingFrame = frame;
                this.pendingFrame.retain();
            }
            this.renderThreadHandler.post(this::renderFrameOnRenderThread);
        }
        if (dropOldFrame) {
            object2 = this.statisticsLock;
            synchronized (object2) {
                ++this.framesDropped;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redrawFrame() {
        if (!this.mRedrawFlag && this.renderFrame != null) {
            this.mRedrawFlag = true;
            Object object = this.handlerLock;
            synchronized (object) {
                if (this.renderThreadHandler != null) {
                    this.renderThreadHandler.post(this::renderFrameOnRenderThread);
                    this.mRedrawFlag = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEglSurface(Runnable completionCallback) {
        this.eglSurfaceCreationRunnable.setSurface(null);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
                this.renderThreadHandler.postAtFrontOfQueue(() -> {
                    if (this.eglBase != null) {
                        this.eglBase.detachCurrent();
                        this.eglBase.releaseSurface();
                    }
                    completionCallback.run();
                });
                return;
            }
        }
        completionCallback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToRenderThread(Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.post(runnable);
            }
        }
    }

    private void clearSurfaceOnRenderThread(float r, float g, float b, float a) {
        if (this.eglBase != null && this.eglBase.hasSurface()) {
            int w = this.eglBase.surfaceWidth();
            int h = this.eglBase.surfaceHeight();
            this.logD("clearSurface, w=" + w + ", h=" + h);
            GLES20.glClearColor((float)r, (float)g, (float)b, (float)a);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
            if (w != this.eglBase.surfaceWidth() || h != this.eglBase.surfaceHeight()) {
                GLES20.glClearColor((float)r, (float)g, (float)b, (float)a);
                GLES20.glClear((int)16384);
                this.eglBase.swapBuffers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackgroundColor(float r, float g, float b, float a) {
        Object object = this.renderLock;
        synchronized (object) {
            this.bgColorR = r;
            this.bgColorG = g;
            this.bgColorB = b;
            this.bgColorA = a;
        }
    }

    public void clearImage() {
        this.clearImage(this.bgColorR, this.bgColorG, this.bgColorB, this.bgColorA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImage(float r, float g, float b, float a) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            this.renderThreadHandler.postAtFrontOfQueue(() -> this.clearSurfaceOnRenderThread(r, g, b, a));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFrameOnRenderThread() {
        float a;
        float b;
        float g;
        float r;
        float scaleY;
        float scaleX;
        float drawnAspectRatio;
        boolean shouldRenderFrame;
        Object object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                if (this.renderFrame != null) {
                    this.renderFrame.release();
                }
                this.renderFrame = this.pendingFrame;
                this.pendingFrame = null;
            }
        }
        if (this.renderFrame == null) {
            return;
        }
        if (this.eglBase == null || !this.eglBase.hasSurface()) {
            this.logD("Dropping frame - No surface");
            this.renderFrame.release();
            this.renderFrame = null;
            return;
        }
        Object object2 = this.fpsReductionLock;
        synchronized (object2) {
            if (this.minRenderPeriodNs == Long.MAX_VALUE) {
                shouldRenderFrame = false;
            } else if (this.minRenderPeriodNs <= 0L) {
                shouldRenderFrame = true;
            } else {
                long currentTimeNs = System.nanoTime();
                if (currentTimeNs < this.nextFrameTimeNs) {
                    this.logD("Skipping frame rendering - fps reduction is active.");
                    shouldRenderFrame = false;
                } else {
                    this.nextFrameTimeNs += this.minRenderPeriodNs;
                    this.nextFrameTimeNs = Math.max(this.nextFrameTimeNs, currentTimeNs);
                    shouldRenderFrame = true;
                }
            }
        }
        long startTimeNs = System.nanoTime();
        this.lastRotatedWidth = this.renderFrame.getRotatedWidth();
        this.lastRotatedHeight = this.renderFrame.getRotatedHeight();
        float frameAspectRatio = (float)this.renderFrame.getRotatedWidth() / (float)this.renderFrame.getRotatedHeight();
        Object object3 = this.layoutLock;
        synchronized (object3) {
            drawnAspectRatio = this.layoutAspectRatio != 0.0f ? this.layoutAspectRatio : frameAspectRatio;
        }
        this.viewportX = 0;
        this.viewportY = 0;
        this.viewportWidth = this.eglBase.surfaceWidth();
        this.viewportHeight = this.eglBase.surfaceHeight();
        Object object4 = this.renderLock;
        synchronized (object4) {
            if (this.scalingType == RendererCommon.ScalingType.SCALE_ASPECT_FIT) {
                if (this.predefinedRatio == RendererCommon.ScalingRatio.SCALE_RATIO_ORIGINAL) {
                    this.predefinedRatio = RendererCommon.ScalingRatio.SCALE_RATIO_NONE;
                    int frameWidth = this.renderFrame.getRotatedWidth();
                    int frameHeight = this.renderFrame.getRotatedHeight();
                    this.ratio = frameAspectRatio > drawnAspectRatio ? (float)this.viewportWidth / (float)frameWidth : (float)this.viewportHeight / (float)frameHeight;
                    this.ratio = Math.min(this.ratio, 1.0f);
                    this.ratio = Math.max(this.ratio, 0.1f);
                }
                if (frameAspectRatio > drawnAspectRatio) {
                    this.viewportWidth = Math.round((float)this.eglBase.surfaceWidth() / this.ratio);
                    this.viewportX = Math.round(this.eglBase.surfaceWidth() / 2 - this.viewportWidth / 2);
                    this.viewportHeight = Math.round((float)this.viewportWidth / frameAspectRatio);
                    this.viewportY = Math.round(this.eglBase.surfaceHeight() / 2 - this.viewportHeight / 2);
                    this.offsetX = Math.max(-(1.0f / this.ratio - 1.0f) / 2.0f * this.ratio, this.offsetX);
                    this.offsetX = Math.min(this.offsetX, (1.0f / this.ratio - 1.0f) / 2.0f * this.ratio);
                    if (this.viewportHeight > this.eglBase.surfaceHeight()) {
                        float hRatio = (float)this.eglBase.surfaceHeight() / (float)this.viewportHeight;
                        this.offsetY = Math.max(-(1.0f / hRatio - 1.0f) / 2.0f * hRatio, this.offsetY);
                        this.offsetY = Math.min(this.offsetY, (1.0f / hRatio - 1.0f) / 2.0f * hRatio);
                    } else {
                        this.offsetY = 0.0f;
                    }
                } else {
                    this.viewportHeight = Math.round((float)this.eglBase.surfaceHeight() / this.ratio);
                    this.viewportY = Math.round(this.eglBase.surfaceHeight() / 2 - this.viewportHeight / 2);
                    this.viewportWidth = Math.round((float)this.viewportHeight * frameAspectRatio);
                    this.viewportX = Math.round(this.eglBase.surfaceWidth() / 2 - this.viewportWidth / 2);
                    this.offsetY = Math.max(-(1.0f / this.ratio - 1.0f) / 2.0f * this.ratio, this.offsetY);
                    this.offsetY = Math.min(this.offsetY, (1.0f / this.ratio - 1.0f) / 2.0f * this.ratio);
                    if (this.viewportWidth > this.eglBase.surfaceWidth()) {
                        float wRatio = (float)this.eglBase.surfaceWidth() / (float)this.viewportWidth;
                        this.offsetX = Math.max(-(1.0f / wRatio - 1.0f) / 2.0f * wRatio, this.offsetX);
                        this.offsetX = Math.min(this.offsetX, (1.0f / wRatio - 1.0f) / 2.0f * wRatio);
                    } else {
                        this.offsetX = 0.0f;
                    }
                }
            }
            if (this.scalingType == RendererCommon.ScalingType.SCALE_ASPECT_FIT || this.scalingType == RendererCommon.ScalingType.SCALE_FILL) {
                scaleX = 1.0f;
                scaleY = 1.0f;
            } else if (frameAspectRatio > drawnAspectRatio) {
                scaleX = drawnAspectRatio / frameAspectRatio;
                scaleY = 1.0f;
            } else {
                scaleX = 1.0f;
                scaleY = frameAspectRatio / drawnAspectRatio;
            }
            r = this.bgColorR;
            g = this.bgColorG;
            b = this.bgColorB;
            a = this.bgColorA;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (this.mirror) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        this.drawMatrix.preScale(scaleX, scaleY);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        if (this.scalingType == RendererCommon.ScalingType.SCALE_ASPECT_FIT) {
            this.drawMatrix.preTranslate(this.offsetX, this.offsetY);
        }
        try {
            if (shouldRenderFrame && this.renderFrame != null && this.drawer != null) {
                GLES20.glClearColor((float)r, (float)g, (float)b, (float)a);
                GLES20.glClear((int)16384);
                if (this.drawer != null && this.renderFrame != null) {
                    this.frameDrawer.drawFrame(this.renderFrame, this.drawer, this.drawMatrix, this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
                }
                long swapBuffersStartTimeNs = System.nanoTime();
                if (this.usePresentationTimeStamp) {
                    this.eglBase.swapBuffers(this.renderFrame.getTimestampNs());
                } else {
                    this.eglBase.swapBuffers();
                }
                long currentTimeNs = System.nanoTime();
                Object object5 = this.statisticsLock;
                synchronized (object5) {
                    ++this.framesRendered;
                    this.renderTimeNs += currentTimeNs - startTimeNs;
                    this.renderSwapBufferTimeNs += currentTimeNs - swapBuffersStartTimeNs;
                }
            }
            this.notifyCallbacks(this.renderFrame, shouldRenderFrame);
        }
        catch (Exception e) {
            this.logE("Error while drawing frame", e);
            ErrorCallback errorCallback = this.errorCallback;
            if (errorCallback != null) {
                errorCallback.onGlOutOfMemory();
            }
            this.drawer.release();
            this.frameDrawer.release();
            this.bitmapTextureFramebuffer.release();
        }
        finally {
            if (this.renderFrame != null && this.renderFrame.getBuffer() instanceof TextureBufferImpl) {
                this.renderFrame.release();
                this.renderFrame = null;
            }
        }
    }

    private void notifyCallbacks(VideoFrame frame, boolean wasRendered) {
        if (this.frameListeners.isEmpty() || this.renderFrame == null) {
            return;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (this.mirror) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        this.drawMatrix.preScale(1.0f, -1.0f);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        Iterator<FrameListenerAndParams> it = this.frameListeners.iterator();
        while (it.hasNext()) {
            FrameListenerAndParams listenerAndParams = it.next();
            if (!wasRendered && listenerAndParams.applyFpsReduction) continue;
            it.remove();
            int scaledWidth = (int)(listenerAndParams.scale * (float)frame.getRotatedWidth());
            int scaledHeight = (int)(listenerAndParams.scale * (float)frame.getRotatedHeight());
            if (scaledWidth == 0 || scaledHeight == 0) {
                listenerAndParams.listener.onFrame(null);
                continue;
            }
            this.bitmapTextureFramebuffer.setSize(scaledWidth, scaledHeight);
            GLES20.glBindFramebuffer((int)36160, (int)this.bitmapTextureFramebuffer.getFrameBufferId());
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.bitmapTextureFramebuffer.getTextureId(), (int)0);
            GLES20.glClearColor((float)this.bgColorR, (float)this.bgColorG, (float)this.bgColorB, (float)this.bgColorA);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(frame, listenerAndParams.drawer, this.drawMatrix, 0, 0, scaledWidth, scaledHeight);
            ByteBuffer bitmapBuffer = ByteBuffer.allocateDirect(scaledWidth * scaledHeight * 4);
            GLES20.glViewport((int)0, (int)0, (int)scaledWidth, (int)scaledHeight);
            GLES20.glReadPixels((int)0, (int)0, (int)scaledWidth, (int)scaledHeight, (int)6408, (int)5121, (Buffer)bitmapBuffer);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GlUtil.checkNoGLES2Error("EglRenderer.notifyCallbacks");
            Bitmap bitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)bitmapBuffer);
            listenerAndParams.listener.onFrame(bitmap);
        }
    }

    private String averageTimeAsString(long sumTimeNs, int count) {
        return count <= 0 ? "NA" : TimeUnit.NANOSECONDS.toMicros(sumTimeNs / (long)count) + " us";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStatistics() {
        DecimalFormat fpsFormat = new DecimalFormat("#.0");
        long currentTimeNs = System.nanoTime();
        Object object = this.statisticsLock;
        synchronized (object) {
            long elapsedTimeNs = currentTimeNs - this.statisticsStartTimeNs;
            if (elapsedTimeNs <= 0L) {
                return;
            }
            float renderFps = (float)((long)this.framesRendered * TimeUnit.SECONDS.toNanos(1L)) / (float)elapsedTimeNs;
            this.logD("Duration: " + TimeUnit.NANOSECONDS.toMillis(elapsedTimeNs) + " ms. Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered + ". Render fps: " + fpsFormat.format(renderFps) + ". Average render time: " + this.averageTimeAsString(this.renderTimeNs, this.framesRendered) + ". Average swapBuffer time: " + this.averageTimeAsString(this.renderSwapBufferTimeNs, this.framesRendered) + ".");
            this.resetStatistics(currentTimeNs);
        }
    }

    private void logD(String string) {
        Log.d((String)TAG, (String)(this.name + ": " + string));
    }

    private void logE(String string, Throwable e) {
        Log.e((String)TAG, (String)(this.name + ": " + string), (Throwable)e);
    }

    private static class HandlerWithExceptionCallback
    extends Handler {
        private final Runnable exceptionCallback;

        public HandlerWithExceptionCallback(Looper looper, Runnable exceptionCallback) {
            super(looper);
            this.exceptionCallback = exceptionCallback;
        }

        public void dispatchMessage(Message msg) {
            try {
                super.dispatchMessage(msg);
            }
            catch (Exception e) {
                Log.e((String)EglRenderer.TAG, (String)"Exception on EglRenderer thread", (Throwable)e);
                this.exceptionCallback.run();
                throw e;
            }
        }
    }

    private class EglSurfaceCreation
    implements Runnable {
        private Object surface;

        private EglSurfaceCreation() {
        }

        public synchronized void setSurface(Object surface) {
            this.surface = surface;
        }

        @Override
        public synchronized void run() {
            if (this.surface != null && EglRenderer.this.eglBase != null && !EglRenderer.this.eglBase.hasSurface()) {
                if (this.surface instanceof Surface) {
                    EglRenderer.this.eglBase.createSurface((Surface)this.surface);
                } else if (this.surface instanceof SurfaceTexture) {
                    EglRenderer.this.eglBase.createSurface((SurfaceTexture)this.surface);
                } else {
                    throw new IllegalStateException("Invalid surface: " + this.surface);
                }
                EglRenderer.this.eglBase.makeCurrent();
                GLES20.glPixelStorei((int)3317, (int)1);
            }
        }
    }

    private static class FrameListenerAndParams {
        public final FrameListener listener;
        public final float scale;
        public final RendererCommon.GlDrawer drawer;
        public final boolean applyFpsReduction;

        public FrameListenerAndParams(FrameListener listener, float scale, RendererCommon.GlDrawer drawer, boolean applyFpsReduction) {
            this.listener = listener;
            this.scale = scale;
            this.drawer = drawer;
            this.applyFpsReduction = applyFpsReduction;
        }
    }

    public static interface ErrorCallback {
        public void onGlOutOfMemory();
    }

    public static interface FrameListener {
        public void onFrame(Bitmap var1);
    }
}

