/*
 * Decompiled with CFR 0.152.
 */
package video.pano.liveplayer;

import android.content.Context;
import android.graphics.Matrix;
import android.os.Bundle;
import android.util.Log;
import com.tencent.live2.V2TXLiveDef;
import com.tencent.live2.V2TXLivePlayer;
import com.tencent.live2.V2TXLivePlayerObserver;
import com.tencent.live2.impl.V2TXLivePlayerImpl;
import javax.microedition.khronos.egl.EGLContext;
import video.pano.liveplayer.EglBase;
import video.pano.liveplayer.TextureBufferImpl;
import video.pano.liveplayer.VideoFrame;
import video.pano.liveplayer.api.Constants;
import video.pano.liveplayer.api.LivePlayerCallback;
import video.pano.liveplayer.api.PanoLivePlayer;
import video.pano.liveplayer.api.PanoVideoView;
import video.pano.liveplayer.api.model.PlayerStats;

class TXPlayer
extends PanoLivePlayer {
    private V2TXLivePlayerImpl mPlayer;
    private Matrix mRenderMatrix;
    private EGLContext mEglContext10;
    private android.opengl.EGLContext mEglContext14;
    private EglBase mEglBase;
    private PanoVideoView mRenderView;
    private LivePlayerCallback mCallback;

    TXPlayer(Context context) {
        this.mPlayer = new V2TXLivePlayerImpl(context);
        this.mRenderMatrix = new Matrix();
        this.mRenderMatrix.preTranslate(0.5f, 0.5f);
        this.mRenderMatrix.preScale(1.0f, -1.0f);
        this.mRenderMatrix.preTranslate(-0.5f, -0.5f);
    }

    @Override
    public void setCallback(final LivePlayerCallback callback) {
        if (callback == null) {
            return;
        }
        this.mCallback = callback;
        this.mPlayer.setObserver(new V2TXLivePlayerObserver(){

            public void onError(V2TXLivePlayer player, int code, String msg, Bundle extraInfo) {
                callback.onError(TXPlayer.this, TXPlayer.this.toQResult(code), msg, extraInfo);
            }

            public void onWarning(V2TXLivePlayer player, int code, String msg, Bundle extraInfo) {
                callback.onWarning(TXPlayer.this, TXPlayer.this.toQResult(code), msg, extraInfo);
            }

            public void onVideoPlayStatusUpdate(V2TXLivePlayer player, V2TXLiveDef.V2TXLivePlayStatus status, V2TXLiveDef.V2TXLiveStatusChangeReason reason, Bundle extraInfo) {
                callback.onVideoPlayStatusUpdate(TXPlayer.this, TXPlayer.this.toPlayStatus(status), TXPlayer.this.toStatusChangeReason(reason), extraInfo);
            }

            public void onAudioPlayStatusUpdate(V2TXLivePlayer player, V2TXLiveDef.V2TXLivePlayStatus status, V2TXLiveDef.V2TXLiveStatusChangeReason reason, Bundle extraInfo) {
                callback.onAudioPlayStatusUpdate(TXPlayer.this, TXPlayer.this.toPlayStatus(status), TXPlayer.this.toStatusChangeReason(reason), extraInfo);
            }

            public void onPlayoutVolumeUpdate(V2TXLivePlayer player, int volume) {
                callback.onPlayoutVolumeUpdate(TXPlayer.this, volume);
            }

            public void onStatisticsUpdate(V2TXLivePlayer player, V2TXLiveDef.V2TXLivePlayerStatistics statistics) {
                PlayerStats playerStatistics = new PlayerStats();
                playerStatistics.appCpu = statistics.appCpu;
                playerStatistics.systemCpu = statistics.systemCpu;
                playerStatistics.width = statistics.width;
                playerStatistics.height = statistics.height;
                playerStatistics.fps = statistics.fps;
                playerStatistics.videoBitrate = statistics.videoBitrate;
                playerStatistics.audioBitrate = statistics.audioBitrate;
                callback.onStatsUpdate(TXPlayer.this, playerStatistics);
            }

            public void onRenderVideoFrame(V2TXLivePlayer player, V2TXLiveDef.V2TXLiveVideoFrame videoFrame) {
                if (videoFrame == null) {
                    TXPlayer.this.logE("Empty frame!");
                    return;
                }
                if (videoFrame.texture == null || videoFrame.texture.textureId == -1) {
                    TXPlayer.this.logE("Invalid texture!");
                    return;
                }
                if (videoFrame.texture.eglContext10 == null && videoFrame.texture.eglContext14 == null) {
                    TXPlayer.this.logE("Empty eglContext!");
                    return;
                }
                if (TXPlayer.this.mRenderView == null) {
                    TXPlayer.this.logE("Empty RenderView!");
                    return;
                }
                if (!TXPlayer.this.isPlaying()) {
                    return;
                }
                TextureBufferImpl outputTextureBuffer = new TextureBufferImpl(videoFrame.width, videoFrame.height, VideoFrame.TextureBuffer.Type.RGB, videoFrame.texture.textureId, TXPlayer.this.mRenderMatrix, null);
                VideoFrame frame = new VideoFrame(outputTextureBuffer, 0, 0L);
                if (videoFrame.texture.eglContext14 != null) {
                    if (!videoFrame.texture.eglContext14.equals((Object)TXPlayer.this.mEglContext14)) {
                        TXPlayer.this.mEglContext14 = videoFrame.texture.eglContext14;
                        try {
                            TXPlayer.this.mEglBase = EglBase.createEgl14(videoFrame.texture.eglContext14, EglBase.CONFIG_PLAIN);
                            TXPlayer.this.mRenderView.changeEglBase(TXPlayer.this.mEglBase);
                        }
                        catch (Exception e) {
                            TXPlayer.this.mEglBase = null;
                            TXPlayer.this.logE("createEgl14 failed : " + e.getMessage());
                        }
                    }
                } else if (videoFrame.texture.eglContext10 != null && !videoFrame.texture.eglContext10.equals(TXPlayer.this.mEglContext10)) {
                    TXPlayer.this.mEglContext10 = videoFrame.texture.eglContext10;
                    try {
                        TXPlayer.this.mEglBase = EglBase.createEgl10(videoFrame.texture.eglContext10, EglBase.CONFIG_PLAIN);
                        TXPlayer.this.mRenderView.changeEglBase(TXPlayer.this.mEglBase);
                    }
                    catch (Exception e) {
                        TXPlayer.this.mEglBase = null;
                        TXPlayer.this.logE("createEgl10 failed : " + e.getMessage());
                    }
                }
                if (TXPlayer.this.mEglBase != null) {
                    TXPlayer.this.mRenderView.onFrame(frame);
                }
            }
        });
    }

    @Override
    public Constants.QResult setRenderView(PanoVideoView renderView) {
        this.mRenderView = renderView;
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setRenderRotation(Constants.RenderRotation rotation) {
        return this.toQResult(this.mPlayer.setRenderRotation(this.toV2TXLiveRotation(rotation)));
    }

    @Override
    public Constants.QResult startPlay(String url) {
        Constants.QResult result = this.toQResult(this.mPlayer.startPlay(url));
        this.mPlayer.enableObserveVideoFrame(true, V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatTexture2D, V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeTexture);
        return result;
    }

    @Override
    public Constants.QResult stopPlay() {
        return this.toQResult(this.mPlayer.stopPlay());
    }

    @Override
    public boolean isPlaying() {
        return this.mPlayer.isPlaying() == 1;
    }

    @Override
    public Constants.QResult pauseAudio() {
        return this.toQResult(this.mPlayer.pauseAudio());
    }

    @Override
    public Constants.QResult resumeAudio() {
        return this.toQResult(this.mPlayer.resumeAudio());
    }

    @Override
    public Constants.QResult pauseVideo() {
        return this.toQResult(this.mPlayer.pauseVideo());
    }

    @Override
    public Constants.QResult resumeVideo() {
        return this.toQResult(this.mPlayer.resumeVideo());
    }

    @Override
    public Constants.QResult setPlayoutVolume(int volume) {
        return this.toQResult(this.mPlayer.setPlayoutVolume(volume));
    }

    @Override
    public Constants.QResult setCacheParams(float minTime, float maxTime) {
        return this.toQResult(this.mPlayer.setCacheParams(minTime, maxTime));
    }

    @Override
    public Constants.QResult enableVolumeEvaluation(int intervalMs) {
        return this.toQResult(this.mPlayer.enableVolumeEvaluation(intervalMs));
    }

    @Override
    public Constants.QResult snapshot() {
        if (!this.isPlaying() || this.mRenderView == null) {
            return Constants.QResult.InvalidState;
        }
        this.mRenderView.addFrameListener(frame -> {
            if (this.mCallback != null) {
                this.mCallback.onSnapshotComplete(this, frame);
            }
        }, 1.0f);
        return Constants.QResult.OK;
    }

    private Constants.QResult toQResult(int code) {
        switch (code) {
            case 0: {
                return Constants.QResult.OK;
            }
            case -2: {
                return Constants.QResult.InvalidArgs;
            }
            case -3: {
                return Constants.QResult.InvalidState;
            }
            case -4: {
                return Constants.QResult.NotSupported;
            }
            case -6: {
                return Constants.QResult.Timeout;
            }
            case 1101: {
                return Constants.QResult.NetworkError;
            }
            case 2105: {
                return Constants.QResult.VideoBlock;
            }
        }
        return Constants.QResult.Failed;
    }

    private V2TXLiveDef.V2TXLiveRotation toV2TXLiveRotation(Constants.RenderRotation rotation) {
        switch (rotation) {
            case Rotation_0: {
                return V2TXLiveDef.V2TXLiveRotation.V2TXLiveRotation0;
            }
            case Rotation_90: {
                return V2TXLiveDef.V2TXLiveRotation.V2TXLiveRotation90;
            }
            case Rotation_180: {
                return V2TXLiveDef.V2TXLiveRotation.V2TXLiveRotation180;
            }
            case Rotation_270: {
                return V2TXLiveDef.V2TXLiveRotation.V2TXLiveRotation270;
            }
        }
        return V2TXLiveDef.V2TXLiveRotation.V2TXLiveRotation0;
    }

    private Constants.PlayStatus toPlayStatus(V2TXLiveDef.V2TXLivePlayStatus status) {
        switch (status) {
            case V2TXLivePlayStatusStopped: {
                return Constants.PlayStatus.Stopped;
            }
            case V2TXLivePlayStatusPlaying: {
                return Constants.PlayStatus.Playing;
            }
            case V2TXLivePlayStatusLoading: {
                return Constants.PlayStatus.Loading;
            }
        }
        return Constants.PlayStatus.Stopped;
    }

    private Constants.StatusChangeReason toStatusChangeReason(V2TXLiveDef.V2TXLiveStatusChangeReason reason) {
        switch (reason) {
            case V2TXLiveStatusChangeReasonInternal: {
                return Constants.StatusChangeReason.Internal;
            }
            case V2TXLiveStatusChangeReasonBufferingBegin: {
                return Constants.StatusChangeReason.BufferingBegin;
            }
            case V2TXLiveStatusChangeReasonBufferingEnd: {
                return Constants.StatusChangeReason.BufferingEnd;
            }
            case V2TXLiveStatusChangeReasonLocalStarted: {
                return Constants.StatusChangeReason.LocalStarted;
            }
            case V2TXLiveStatusChangeReasonLocalStopped: {
                return Constants.StatusChangeReason.LocalStopped;
            }
            case V2TXLiveStatusChangeReasonRemoteStarted: {
                return Constants.StatusChangeReason.RemoteStarted;
            }
            case V2TXLiveStatusChangeReasonRemoteStopped: {
                return Constants.StatusChangeReason.RemoteStopped;
            }
            case V2TXLiveStatusChangeReasonRemoteOffline: {
                return Constants.StatusChangeReason.RemoteOffline;
            }
        }
        return Constants.StatusChangeReason.Internal;
    }

    private void logE(String msg) {
        Log.e((String)"PanoLivePlayer", (String)msg);
    }
}

