/*
 * Decompiled with CFR 0.152.
 */
package video.pano.liveplayer;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import com.tencent.live2.V2TXLiveDef;
import com.tencent.live2.V2TXLivePlayer;
import com.tencent.live2.V2TXLivePlayerObserver;
import com.tencent.live2.impl.V2TXLivePlayerImpl;
import com.tencent.rtmp.ui.TXCloudVideoView;
import video.pano.liveplayer.api.Constants;
import video.pano.liveplayer.api.LivePlayerCallback;
import video.pano.liveplayer.api.LiveVideoFrame;
import video.pano.liveplayer.api.PanoLivePlayer;
import video.pano.liveplayer.api.PanoVideoView;
import video.pano.liveplayer.api.model.LiveTexture;
import video.pano.liveplayer.api.model.PlayerStats;

class TXPlayer
extends PanoLivePlayer {
    private final V2TXLivePlayerImpl mPlayer;

    TXPlayer(Context context) {
        this.mPlayer = new V2TXLivePlayerImpl(context);
    }

    @Override
    public void setCallback(final LivePlayerCallback callback) {
        if (callback == null) {
            return;
        }
        this.mPlayer.setObserver(new V2TXLivePlayerObserver(){

            public void onError(V2TXLivePlayer player, int code, String msg, Bundle extraInfo) {
                callback.onError(TXPlayer.this, TXPlayer.this.toQResult(code), msg, extraInfo);
            }

            public void onWarning(V2TXLivePlayer player, int code, String msg, Bundle extraInfo) {
                callback.onWarning(TXPlayer.this, TXPlayer.this.toQResult(code), msg, extraInfo);
            }

            public void onVideoPlayStatusUpdate(V2TXLivePlayer player, V2TXLiveDef.V2TXLivePlayStatus status, V2TXLiveDef.V2TXLiveStatusChangeReason reason, Bundle extraInfo) {
                callback.onVideoPlayStatusUpdate(TXPlayer.this, TXPlayer.this.toPlayStatus(status), TXPlayer.this.toStatusChangeReason(reason), extraInfo);
            }

            public void onAudioPlayStatusUpdate(V2TXLivePlayer player, V2TXLiveDef.V2TXLivePlayStatus status, V2TXLiveDef.V2TXLiveStatusChangeReason reason, Bundle extraInfo) {
                callback.onAudioPlayStatusUpdate(TXPlayer.this, TXPlayer.this.toPlayStatus(status), TXPlayer.this.toStatusChangeReason(reason), extraInfo);
            }

            public void onPlayoutVolumeUpdate(V2TXLivePlayer player, int volume) {
                callback.onPlayoutVolumeUpdate(TXPlayer.this, volume);
            }

            public void onStatisticsUpdate(V2TXLivePlayer player, V2TXLiveDef.V2TXLivePlayerStatistics statistics) {
                PlayerStats playerStatistics = new PlayerStats();
                playerStatistics.appCpu = statistics.appCpu;
                playerStatistics.systemCpu = statistics.systemCpu;
                playerStatistics.width = statistics.width;
                playerStatistics.height = statistics.height;
                playerStatistics.fps = statistics.fps;
                playerStatistics.videoBitrate = statistics.videoBitrate;
                playerStatistics.audioBitrate = statistics.audioBitrate;
                callback.onStatsUpdate(TXPlayer.this, playerStatistics);
            }

            public void onSnapshotComplete(V2TXLivePlayer player, Bitmap image) {
                callback.onSnapshotComplete(TXPlayer.this, image);
            }

            public void onRenderVideoFrame(V2TXLivePlayer player, V2TXLiveDef.V2TXLiveVideoFrame videoFrame) {
                if (videoFrame != null) {
                    LiveVideoFrame liveVideoFrame = new LiveVideoFrame();
                    liveVideoFrame.pixelFormat = TXPlayer.this.toPixelFormat(videoFrame.pixelFormat);
                    liveVideoFrame.bufferType = TXPlayer.this.toBufferType(videoFrame.bufferType);
                    liveVideoFrame.data = videoFrame.data;
                    liveVideoFrame.buffer = videoFrame.buffer;
                    liveVideoFrame.width = videoFrame.width;
                    liveVideoFrame.height = videoFrame.height;
                    liveVideoFrame.rotation = videoFrame.rotation;
                    if (videoFrame.texture != null) {
                        LiveTexture texture = new LiveTexture();
                        texture.eglContext10 = videoFrame.texture.eglContext10;
                        texture.eglContext14 = videoFrame.texture.eglContext14;
                        texture.textureId = videoFrame.texture.textureId;
                        liveVideoFrame.texture = texture;
                    }
                    callback.onRenderVideoFrame(TXPlayer.this, liveVideoFrame);
                }
            }
        });
    }

    @Override
    public Constants.QResult setRenderView(PanoVideoView renderView) {
        return this.toQResult(this.mPlayer.setRenderView((TXCloudVideoView)renderView.getChildAt(0)));
    }

    @Override
    public Constants.QResult setRenderRotation(Constants.RenderRotation rotation) {
        return this.toQResult(this.mPlayer.setRenderRotation(this.toV2TXLiveRotation(rotation)));
    }

    @Override
    public Constants.QResult setRenderScalingType(Constants.ScalingType scalingTpe) {
        return this.toQResult(this.mPlayer.setRenderFillMode(this.toV2TXLiveFillMode(scalingTpe)));
    }

    @Override
    public Constants.QResult startPlay(String url) {
        return this.toQResult(this.mPlayer.startPlay(url));
    }

    @Override
    public Constants.QResult stopPlay() {
        return this.toQResult(this.mPlayer.stopPlay());
    }

    @Override
    public boolean isPlaying() {
        return this.mPlayer.isPlaying() == 1;
    }

    @Override
    public Constants.QResult pauseAudio() {
        return this.toQResult(this.mPlayer.pauseAudio());
    }

    @Override
    public Constants.QResult resumeAudio() {
        return this.toQResult(this.mPlayer.resumeAudio());
    }

    @Override
    public Constants.QResult pauseVideo() {
        return this.toQResult(this.mPlayer.pauseVideo());
    }

    @Override
    public Constants.QResult resumeVideo() {
        return this.toQResult(this.mPlayer.resumeVideo());
    }

    @Override
    public Constants.QResult setPlayoutVolume(int volume) {
        return this.toQResult(this.mPlayer.setPlayoutVolume(volume));
    }

    @Override
    public Constants.QResult setCacheParams(float minTime, float maxTime) {
        return this.toQResult(this.mPlayer.setCacheParams(minTime, maxTime));
    }

    @Override
    public Constants.QResult enableVolumeEvaluation(int intervalMs) {
        return this.toQResult(this.mPlayer.enableVolumeEvaluation(intervalMs));
    }

    @Override
    public Constants.QResult snapshot() {
        return this.toQResult(this.mPlayer.snapshot());
    }

    @Override
    public Constants.QResult enableCustomRendering(boolean enable, Constants.PixelFormat pixelFormat, Constants.BufferType bufferType) {
        return this.toQResult(this.mPlayer.enableCustomRendering(enable, this.toV2TXLivePixelFormat(pixelFormat), this.toV2TXLivePixelFormat(bufferType)));
    }

    private Constants.QResult toQResult(int code) {
        switch (code) {
            case 0: {
                return Constants.QResult.OK;
            }
            case -2: {
                return Constants.QResult.InvalidArgs;
            }
            case -3: {
                return Constants.QResult.InvalidState;
            }
            case -4: {
                return Constants.QResult.NotSupported;
            }
            case -6: {
                return Constants.QResult.Timeout;
            }
            case 1101: {
                return Constants.QResult.NetworkError;
            }
            case 2105: {
                return Constants.QResult.VideoBlock;
            }
        }
        return Constants.QResult.Failed;
    }

    private V2TXLiveDef.V2TXLiveRotation toV2TXLiveRotation(Constants.RenderRotation rotation) {
        switch (rotation) {
            case Rotation_0: {
                return V2TXLiveDef.V2TXLiveRotation.V2TXLiveRotation0;
            }
            case Rotation_90: {
                return V2TXLiveDef.V2TXLiveRotation.V2TXLiveRotation90;
            }
            case Rotation_180: {
                return V2TXLiveDef.V2TXLiveRotation.V2TXLiveRotation180;
            }
            case Rotation_270: {
                return V2TXLiveDef.V2TXLiveRotation.V2TXLiveRotation270;
            }
        }
        return V2TXLiveDef.V2TXLiveRotation.V2TXLiveRotation0;
    }

    private V2TXLiveDef.V2TXLiveFillMode toV2TXLiveFillMode(Constants.ScalingType scalingTpe) {
        switch (scalingTpe) {
            case Fit: {
                return V2TXLiveDef.V2TXLiveFillMode.V2TXLiveFillModeFit;
            }
            case Fill: {
                return V2TXLiveDef.V2TXLiveFillMode.V2TXLiveFillModeFill;
            }
        }
        return V2TXLiveDef.V2TXLiveFillMode.V2TXLiveFillModeFit;
    }

    private Constants.PlayStatus toPlayStatus(V2TXLiveDef.V2TXLivePlayStatus status) {
        switch (status) {
            case V2TXLivePlayStatusStopped: {
                return Constants.PlayStatus.Stopped;
            }
            case V2TXLivePlayStatusPlaying: {
                return Constants.PlayStatus.Playing;
            }
            case V2TXLivePlayStatusLoading: {
                return Constants.PlayStatus.Loading;
            }
        }
        return Constants.PlayStatus.Stopped;
    }

    private Constants.StatusChangeReason toStatusChangeReason(V2TXLiveDef.V2TXLiveStatusChangeReason reason) {
        switch (reason) {
            case V2TXLiveStatusChangeReasonInternal: {
                return Constants.StatusChangeReason.Internal;
            }
            case V2TXLiveStatusChangeReasonBufferingBegin: {
                return Constants.StatusChangeReason.BufferingBegin;
            }
            case V2TXLiveStatusChangeReasonBufferingEnd: {
                return Constants.StatusChangeReason.BufferingEnd;
            }
            case V2TXLiveStatusChangeReasonLocalStarted: {
                return Constants.StatusChangeReason.LocalStarted;
            }
            case V2TXLiveStatusChangeReasonLocalStopped: {
                return Constants.StatusChangeReason.LocalStopped;
            }
            case V2TXLiveStatusChangeReasonRemoteStarted: {
                return Constants.StatusChangeReason.RemoteStarted;
            }
            case V2TXLiveStatusChangeReasonRemoteStopped: {
                return Constants.StatusChangeReason.RemoteStopped;
            }
            case V2TXLiveStatusChangeReasonRemoteOffline: {
                return Constants.StatusChangeReason.RemoteOffline;
            }
        }
        return Constants.StatusChangeReason.Internal;
    }

    private Constants.PixelFormat toPixelFormat(V2TXLiveDef.V2TXLivePixelFormat pixelFormat) {
        switch (pixelFormat) {
            case V2TXLivePixelFormatI420: {
                return Constants.PixelFormat.I420;
            }
            case V2TXLivePixelFormatTexture2D: {
                return Constants.PixelFormat.Texture2D;
            }
        }
        return Constants.PixelFormat.Unknown;
    }

    private Constants.BufferType toBufferType(V2TXLiveDef.V2TXLiveBufferType bufferType) {
        switch (bufferType) {
            case V2TXLiveBufferTypeByteBuffer: {
                return Constants.BufferType.ByteBuffer;
            }
            case V2TXLiveBufferTypeByteArray: {
                return Constants.BufferType.ByteArray;
            }
            case V2TXLiveBufferTypeTexture: {
                return Constants.BufferType.Texture;
            }
        }
        return Constants.BufferType.Unknown;
    }

    private V2TXLiveDef.V2TXLivePixelFormat toV2TXLivePixelFormat(Constants.PixelFormat pixelFormat) {
        switch (pixelFormat) {
            case I420: {
                return V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatI420;
            }
            case Texture2D: {
                return V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatTexture2D;
            }
        }
        return V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatUnknown;
    }

    private V2TXLiveDef.V2TXLiveBufferType toV2TXLivePixelFormat(Constants.BufferType bufferType) {
        switch (bufferType) {
            case ByteBuffer: {
                return V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteBuffer;
            }
            case ByteArray: {
                return V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteArray;
            }
            case Texture: {
                return V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeTexture;
            }
        }
        return V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeUnknown;
    }
}

