/*
 * Decompiled with CFR 0.152.
 */
package video.api.uploader.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.uploader.api.models.DeepObject;
import video.api.uploader.api.models.VideoSourceLiveStream;

@ApiModel(description="Source information about the video.")
public class VideoSource
implements Serializable,
DeepObject {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_URI = "uri";
    @SerializedName(value="uri")
    private String uri;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_LIVE_STREAM = "liveStream";
    @SerializedName(value="liveStream")
    private VideoSourceLiveStream liveStream;

    public VideoSource uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="/videos/vi4k0jvEUuaTdRAEjQ4Prklg/source", value="The URL where the video is stored.")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public VideoSource type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public VideoSource liveStream(VideoSourceLiveStream liveStream) {
        this.liveStream = liveStream;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoSourceLiveStream getLiveStream() {
        return this.liveStream;
    }

    public void setLiveStream(VideoSourceLiveStream liveStream) {
        this.liveStream = liveStream;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoSource videoSource = (VideoSource)o;
        return Objects.equals(this.uri, videoSource.uri) && Objects.equals(this.type, videoSource.type) && Objects.equals(this.liveStream, videoSource.liveStream);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.type, this.liveStream);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoSource {\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    liveStream: ").append(this.toIndentedString(this.liveStream)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

