/*
 * Decompiled with CFR 0.152.
 */
package video.api.livestream;

import android.content.Context;
import android.view.SurfaceHolder;
import androidx.annotation.RequiresPermission;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.rtmp.utils.ConnectCheckerRtmp;
import com.pedro.rtplibrary.rtmp.RtmpCamera2;
import com.pedro.rtplibrary.view.OpenGlView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.livestream.ApiVideoLiveStream;
import video.api.livestream.R;
import video.api.livestream.enums.CameraFacingDirection;
import video.api.livestream.interfaces.IConnectionChecker;
import video.api.livestream.models.AudioConfig;
import video.api.livestream.models.VideoConfig;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0002\u0015\u001f\u0018\u00002\u00020\u0001B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020+J\u0006\u0010-\u001a\u00020(R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00178F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R$\u0010\"\u001a\u00020!2\u0006\u0010\r\u001a\u00020!8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lvideo/api/livestream/ApiVideoLiveStream;", "", "context", "Landroid/content/Context;", "connectionChecker", "Lvideo/api/livestream/interfaces/IConnectionChecker;", "audioConfig", "Lvideo/api/livestream/models/AudioConfig;", "videoConfig", "Lvideo/api/livestream/models/VideoConfig;", "openGlView", "Lcom/pedro/rtplibrary/view/OpenGlView;", "(Landroid/content/Context;Lvideo/api/livestream/interfaces/IConnectionChecker;Lvideo/api/livestream/models/AudioConfig;Lvideo/api/livestream/models/VideoConfig;Lcom/pedro/rtplibrary/view/OpenGlView;)V", "value", "Lvideo/api/livestream/enums/CameraFacingDirection;", "camera", "getCamera", "()Lvideo/api/livestream/enums/CameraFacingDirection;", "setCamera", "(Lvideo/api/livestream/enums/CameraFacingDirection;)V", "connectCheckerRtmp", "video/api/livestream/ApiVideoLiveStream$connectCheckerRtmp$1", "Lvideo/api/livestream/ApiVideoLiveStream$connectCheckerRtmp$1;", "", "isMuted", "()Z", "setMuted", "(Z)V", "rtmpCamera2", "Lcom/pedro/rtplibrary/rtmp/RtmpCamera2;", "surfaceCallback", "video/api/livestream/ApiVideoLiveStream$surfaceCallback$1", "Lvideo/api/livestream/ApiVideoLiveStream$surfaceCallback$1;", "", "videoBitrate", "getVideoBitrate", "()I", "setVideoBitrate", "(I)V", "prepareEncoders", "", "startStreaming", "streamKey", "", "url", "stopStreaming", "livestream_release"})
public final class ApiVideoLiveStream {
    @NotNull
    private final Context context;
    @NotNull
    private final IConnectionChecker connectionChecker;
    @NotNull
    private final AudioConfig audioConfig;
    @NotNull
    private final VideoConfig videoConfig;
    @NotNull
    private final connectCheckerRtmp.1 connectCheckerRtmp;
    @NotNull
    private final surfaceCallback.1 surfaceCallback;
    @NotNull
    private final RtmpCamera2 rtmpCamera2;

    @RequiresPermission(allOf={"android.permission.RECORD_AUDIO", "android.permission.CAMERA"})
    public ApiVideoLiveStream(@NotNull Context context, @NotNull IConnectionChecker connectionChecker, @NotNull AudioConfig audioConfig, @NotNull VideoConfig videoConfig, @Nullable OpenGlView openGlView) {
        RtmpCamera2 rtmpCamera2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectionChecker, (String)"connectionChecker");
        Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"audioConfig");
        Intrinsics.checkNotNullParameter((Object)videoConfig, (String)"videoConfig");
        this.context = context;
        this.connectionChecker = connectionChecker;
        this.audioConfig = audioConfig;
        this.videoConfig = videoConfig;
        this.connectCheckerRtmp = new ConnectCheckerRtmp(this){
            final /* synthetic */ ApiVideoLiveStream this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAuthErrorRtmp() {
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onAuthError();
            }

            public void onAuthSuccessRtmp() {
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onAuthSuccess();
            }

            public void onConnectionFailedRtmp(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onConnectionFailed(reason);
            }

            public void onConnectionStartedRtmp(@NotNull String rtmpUrl) {
                Intrinsics.checkNotNullParameter((Object)rtmpUrl, (String)"rtmpUrl");
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onConnectionStarted(rtmpUrl);
            }

            public void onConnectionSuccessRtmp() {
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onConnectionSuccess();
            }

            public void onDisconnectRtmp() {
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onDisconnect();
            }

            public void onNewBitrateRtmp(long bitrate) {
            }
        };
        this.surfaceCallback = new SurfaceHolder.Callback(this){
            final /* synthetic */ ApiVideoLiveStream this$0;
            {
                this.this$0 = $receiver;
            }

            public void surfaceCreated(@NotNull SurfaceHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            }

            public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                ApiVideoLiveStream.access$getRtmpCamera2$p(this.this$0).startPreview(ApiVideoLiveStream.access$getVideoConfig$p(this.this$0).getCamera().getFacing());
            }

            public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                if (ApiVideoLiveStream.access$getRtmpCamera2$p(this.this$0).isStreaming()) {
                    ApiVideoLiveStream.access$getRtmpCamera2$p(this.this$0).stopStream();
                }
                ApiVideoLiveStream.access$getRtmpCamera2$p(this.this$0).stopPreview();
            }
        };
        if (openGlView != null) {
            openGlView.getHolder().addCallback((SurfaceHolder.Callback)this.surfaceCallback);
            rtmpCamera2 = new RtmpCamera2(openGlView, (ConnectCheckerRtmp)this.connectCheckerRtmp);
        } else {
            rtmpCamera2 = new RtmpCamera2(this.context, true, (ConnectCheckerRtmp)this.connectCheckerRtmp);
        }
        this.rtmpCamera2 = rtmpCamera2;
        this.prepareEncoders();
    }

    public /* synthetic */ ApiVideoLiveStream(Context context, IConnectionChecker iConnectionChecker, AudioConfig audioConfig, VideoConfig videoConfig, OpenGlView openGlView, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            openGlView = null;
        }
        this(context, iConnectionChecker, audioConfig, videoConfig, openGlView);
    }

    public final int getVideoBitrate() {
        return this.rtmpCamera2.getBitrate();
    }

    public final void setVideoBitrate(int value) {
        this.rtmpCamera2.setVideoBitrateOnFly(value);
    }

    @NotNull
    public final CameraFacingDirection getCamera() {
        return this.rtmpCamera2.getCameraFacing() == CameraHelper.Facing.FRONT ? CameraFacingDirection.FRONT : CameraFacingDirection.BACK;
    }

    public final void setCamera(@NotNull CameraFacingDirection value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (value == CameraFacingDirection.BACK && this.rtmpCamera2.getCameraFacing() == CameraHelper.Facing.FRONT || value == CameraFacingDirection.FRONT && this.rtmpCamera2.getCameraFacing() == CameraHelper.Facing.BACK) {
            this.rtmpCamera2.switchCamera();
        }
    }

    public final boolean isMuted() {
        return this.rtmpCamera2.isAudioMuted();
    }

    public final void setMuted(boolean value) {
        if (value) {
            this.rtmpCamera2.disableAudio();
        } else {
            this.rtmpCamera2.enableAudio();
        }
    }

    private final void prepareEncoders() {
        this.rtmpCamera2.prepareAudio(this.audioConfig.getBitrate(), this.audioConfig.getSampleRate(), this.audioConfig.getStereo(), this.audioConfig.getEchoCanceler(), this.audioConfig.getNoiseSuppressor());
        this.rtmpCamera2.prepareVideo(this.videoConfig.getResolution().getSize().getWidth(), this.videoConfig.getResolution().getSize().getHeight(), this.videoConfig.getFps(), this.videoConfig.getBitrate(), CameraHelper.getCameraOrientation((Context)this.context));
    }

    public final void startStreaming(@NotNull String streamKey, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)streamKey, (String)"streamKey");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.rtmpCamera2.isStreaming()) {
            throw new UnsupportedOperationException("Stream is already started");
        }
        this.prepareEncoders();
        this.rtmpCamera2.startStream(Intrinsics.stringPlus((String)url, (Object)streamKey));
    }

    public static /* synthetic */ void startStreaming$default(ApiVideoLiveStream apiVideoLiveStream, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            String string4 = apiVideoLiveStream.context.getString(R.string.default_rtmp_url);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"fun startStreaming(\n    \u2026am(url + streamKey)\n    }");
            string3 = string4;
        }
        apiVideoLiveStream.startStreaming(string2, string3);
    }

    public final void stopStreaming() {
        this.rtmpCamera2.stopStream();
    }

    public static final /* synthetic */ IConnectionChecker access$getConnectionChecker$p(ApiVideoLiveStream $this) {
        return $this.connectionChecker;
    }

    public static final /* synthetic */ RtmpCamera2 access$getRtmpCamera2$p(ApiVideoLiveStream $this) {
        return $this.rtmpCamera2;
    }

    public static final /* synthetic */ VideoConfig access$getVideoConfig$p(ApiVideoLiveStream $this) {
        return $this.videoConfig;
    }
}

