/*
 * Decompiled with CFR 0.152.
 */
package video.api.livestream;

import android.content.Context;
import android.util.Range;
import android.util.Size;
import io.github.thibaultbee.streampack.streamers.helpers.VideoCameraStreamerConfigurationHelper;
import io.github.thibaultbee.streampack.utils.ContextExtensionsForCameraKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\"\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0007J\u001e\u0010\u0013\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lvideo/api/livestream/VideoStreamerConfigurationHelper;", "", "videoHelper", "Lio/github/thibaultbee/streampack/streamers/helpers/VideoCameraStreamerConfigurationHelper;", "(Lio/github/thibaultbee/streampack/streamers/helpers/VideoCameraStreamerConfigurationHelper;)V", "getBackCamerasList", "", "", "context", "Landroid/content/Context;", "getCameraSupportedResolutions", "Landroid/util/Size;", "getCamerasList", "getFrontCamerasList", "getSupportedBitrates", "Landroid/util/Range;", "", "getSupportedFrameRates", "cameraId", "getSupportedResolutions", "Lkotlin/Pair;", "livestream_release"})
public final class VideoStreamerConfigurationHelper {
    @NotNull
    private final VideoCameraStreamerConfigurationHelper videoHelper;

    public VideoStreamerConfigurationHelper(@NotNull VideoCameraStreamerConfigurationHelper videoHelper) {
        Intrinsics.checkNotNullParameter((Object)videoHelper, (String)"videoHelper");
        this.videoHelper = videoHelper;
    }

    @NotNull
    public final Range<Integer> getSupportedBitrates() {
        return this.videoHelper.getSupportedBitrates("video/avc");
    }

    @NotNull
    public final Pair<Range<Integer>, Range<Integer>> getSupportedResolutions() {
        return this.videoHelper.getSupportedResolutions("video/avc");
    }

    @NotNull
    public final List<Size> getCameraSupportedResolutions(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.videoHelper.getSupportedResolutions(context, "video/avc");
    }

    @NotNull
    public final List<Range<Integer>> getSupportedFrameRates(@NotNull Context context, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        return this.videoHelper.getSupportedFramerates(context, "video/avc", cameraId);
    }

    @NotNull
    public final List<String> getCamerasList(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ContextExtensionsForCameraKt.getCameraList((Context)context);
    }

    @NotNull
    public final List<String> getBackCamerasList(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ContextExtensionsForCameraKt.getBackCameraList((Context)context);
    }

    @NotNull
    public final List<String> getFrontCamerasList(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ContextExtensionsForCameraKt.getFrontCameraList((Context)context);
    }
}

