/*
 * Decompiled with CFR 0.152.
 */
package video.api.livestream;

import android.content.Context;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import io.github.thibaultbee.streampack.error.StreamPackError;
import io.github.thibaultbee.streampack.ext.rtmp.streamers.CameraRtmpLiveStreamer;
import io.github.thibaultbee.streampack.listeners.OnConnectionListener;
import io.github.thibaultbee.streampack.listeners.OnErrorListener;
import io.github.thibaultbee.streampack.streamers.interfaces.ICameraStreamer;
import io.github.thibaultbee.streampack.utils.ContextExtensionsForCameraKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.livestream.ApiVideoLiveStream;
import video.api.livestream.ExtensionsKt;
import video.api.livestream.R;
import video.api.livestream.enums.CameraFacingDirection;
import video.api.livestream.interfaces.IConnectionListener;
import video.api.livestream.models.AudioConfig;
import video.api.livestream.models.VideoConfig;
import video.api.livestream.views.ApiVideoView;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000e*\u0002'*\u0018\u0000 N2\u00020\u0001:\u0001NBV\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00125\b\u0002\u0010\b\u001a/\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010G\u001a\u00020\rJ\b\u0010H\u001a\u00020\rH\u0007J\u0018\u0010I\u001a\u00020\r2\u0006\u0010J\u001a\u00020\u000b2\b\b\u0002\u0010K\u001a\u00020\u000bJ\u0006\u0010L\u001a\u00020\rJ\u0006\u0010M\u001a\u00020\rR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010!\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(R\u0010\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010+R$\u0010,\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0011\u00100\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b0\u0010-R;\u0010\b\u001a/\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00106\u001a\u0002052\u0006\u0010\u0014\u001a\u0002058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R(\u0010<\u001a\u0004\u0018\u00010;2\b\u0010\u0014\u001a\u0004\u0018\u00010;@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R$\u0010B\u001a\u00020A2\u0006\u0010\u0014\u001a\u00020A8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bC\u0010D\"\u0004\bE\u0010F\u00a8\u0006O"}, d2={"Lvideo/api/livestream/ApiVideoLiveStream;", "", "context", "Landroid/content/Context;", "apiVideoView", "Lvideo/api/livestream/views/ApiVideoView;", "connectionListener", "Lvideo/api/livestream/interfaces/IConnectionListener;", "permissionRequester", "Lkotlin/Function2;", "", "", "Lkotlin/Function0;", "", "Lkotlin/ParameterName;", "name", "onGranted", "(Landroid/content/Context;Lvideo/api/livestream/views/ApiVideoView;Lvideo/api/livestream/interfaces/IConnectionListener;Lkotlin/jvm/functions/Function2;)V", "_isStreaming", "", "value", "Lvideo/api/livestream/models/AudioConfig;", "audioConfig", "getAudioConfig", "()Lvideo/api/livestream/models/AudioConfig;", "setAudioConfig", "(Lvideo/api/livestream/models/AudioConfig;)V", "camera", "getCamera", "()Ljava/lang/String;", "setCamera", "(Ljava/lang/String;)V", "Lvideo/api/livestream/enums/CameraFacingDirection;", "cameraPosition", "getCameraPosition", "()Lvideo/api/livestream/enums/CameraFacingDirection;", "setCameraPosition", "(Lvideo/api/livestream/enums/CameraFacingDirection;)V", "errorListener", "video/api/livestream/ApiVideoLiveStream$errorListener$1", "Lvideo/api/livestream/ApiVideoLiveStream$errorListener$1;", "internalConnectionListener", "video/api/livestream/ApiVideoLiveStream$internalConnectionListener$1", "Lvideo/api/livestream/ApiVideoLiveStream$internalConnectionListener$1;", "isMuted", "()Z", "setMuted", "(Z)V", "isStreaming", "scope", "Lkotlinx/coroutines/CoroutineScope;", "streamer", "Lio/github/thibaultbee/streampack/ext/rtmp/streamers/CameraRtmpLiveStreamer;", "", "videoBitrate", "getVideoBitrate", "()I", "setVideoBitrate", "(I)V", "Lvideo/api/livestream/models/VideoConfig;", "videoConfig", "getVideoConfig", "()Lvideo/api/livestream/models/VideoConfig;", "setVideoConfig", "(Lvideo/api/livestream/models/VideoConfig;)V", "", "zoomRatio", "getZoomRatio", "()F", "setZoomRatio", "(F)V", "release", "startPreview", "startStreaming", "streamKey", "url", "stopPreview", "stopStreaming", "Companion", "livestream_release"})
@SourceDebugExtension(value={"SMAP\nApiVideoLiveStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiVideoLiveStream.kt\nvideo/api/livestream/ApiVideoLiveStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,396:1\n1#2:397\n*E\n"})
public final class ApiVideoLiveStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final ApiVideoView apiVideoView;
    @NotNull
    private final IConnectionListener connectionListener;
    @NotNull
    private final Function2<List<String>, Function0<Unit>, Unit> permissionRequester;
    @NotNull
    private final CoroutineScope scope;
    @Nullable
    private AudioConfig audioConfig;
    @Nullable
    private VideoConfig videoConfig;
    @NotNull
    private final internalConnectionListener.1 internalConnectionListener;
    @NotNull
    private final errorListener.1 errorListener;
    @NotNull
    private final CameraRtmpLiveStreamer streamer;
    private boolean _isStreaming;
    @NotNull
    private static final String TAG = "ApiVideoLiveStream";

    @RequiresPermission(allOf={"android.permission.RECORD_AUDIO", "android.permission.CAMERA"})
    public ApiVideoLiveStream(@NotNull Context context, @NotNull ApiVideoView apiVideoView, @NotNull IConnectionListener connectionListener, @NotNull Function2<? super List<String>, ? super Function0<Unit>, Unit> permissionRequester) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)apiVideoView), (String)"apiVideoView");
        Intrinsics.checkNotNullParameter((Object)connectionListener, (String)"connectionListener");
        Intrinsics.checkNotNullParameter(permissionRequester, (String)"permissionRequester");
        this.context = context;
        this.apiVideoView = apiVideoView;
        this.connectionListener = connectionListener;
        this.permissionRequester = permissionRequester;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getMain().getImmediate()));
        this.internalConnectionListener = new OnConnectionListener(this){
            final /* synthetic */ ApiVideoLiveStream this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFailed(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                ApiVideoLiveStream.access$getConnectionListener$p(this.this$0).onConnectionFailed(message);
            }

            public void onLost(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                ApiVideoLiveStream.access$getConnectionListener$p(this.this$0).onDisconnect();
            }

            public void onSuccess() {
                ApiVideoLiveStream.access$getConnectionListener$p(this.this$0).onConnectionSuccess();
            }
        };
        this.errorListener = new OnErrorListener(this){
            final /* synthetic */ ApiVideoLiveStream this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull StreamPackError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                ApiVideoLiveStream.access$set_isStreaming$p(this.this$0, false);
                Log.e((String)"ApiVideoLiveStream", (String)"An error happened", (Throwable)((Throwable)error));
            }
        };
        this.streamer = new CameraRtmpLiveStreamer(this.context, true, (OnErrorListener)this.errorListener, (OnConnectionListener)this.internalConnectionListener);
        this.apiVideoView.setStreamer$livestream_release((ICameraStreamer)this.streamer);
    }

    public /* synthetic */ ApiVideoLiveStream(Context context, ApiVideoView apiVideoView, IConnectionListener iConnectionListener, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function2 = 1.INSTANCE;
        }
        this(context, apiVideoView, iConnectionListener, (Function2<? super List<String>, ? super Function0<Unit>, Unit>)function2);
    }

    @Nullable
    public final AudioConfig getAudioConfig() {
        return this.audioConfig;
    }

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public final void setAudioConfig(@Nullable AudioConfig value) {
        if (!(value != null)) {
            boolean bl = false;
            String string2 = "Audio config must not be null";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.isStreaming()) {
            throw new UnsupportedOperationException("You have to stop streaming first");
        }
        this.permissionRequester.invoke((Object)CollectionsKt.listOf((Object)"android.permission.RECORD_AUDIO"), (Object)new Function0<Unit>(this, value){
            final /* synthetic */ ApiVideoLiveStream this$0;
            final /* synthetic */ AudioConfig $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(0);
            }

            public final void invoke() {
                ApiVideoLiveStream.access$getStreamer$p(this.this$0).configure(this.$value.toSdkConfig$livestream_release());
            }
        });
        this.audioConfig = value;
    }

    @Nullable
    public final VideoConfig getVideoConfig() {
        return this.videoConfig;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public final void setVideoConfig(@Nullable VideoConfig value) {
        boolean mustRestartPreview;
        boolean bl;
        if (!(value != null)) {
            boolean $i$a$-require-ApiVideoLiveStream$videoConfig$22 = false;
            String $i$a$-require-ApiVideoLiveStream$videoConfig$22 = "Audio config must not be null";
            throw new IllegalArgumentException($i$a$-require-ApiVideoLiveStream$videoConfig$22.toString());
        }
        if (this.isStreaming()) {
            throw new UnsupportedOperationException("You have to stop streaming first");
        }
        VideoConfig videoConfig = this.videoConfig;
        if (!(videoConfig != null ? videoConfig.getFps() == value.getFps() : false)) {
            VideoConfig videoConfig2 = this.videoConfig;
            Log.i((String)TAG, (String)("Frame rate has been changed from " + (videoConfig2 != null ? Integer.valueOf(videoConfig2.getFps()) : null) + " to " + value.getFps() + ". Restarting preview."));
            bl = true;
        } else {
            bl = mustRestartPreview = false;
        }
        if (mustRestartPreview) {
            this.stopPreview();
        }
        this.streamer.configure(value.toSdkConfig$livestream_release());
        this.videoConfig = value;
        if (mustRestartPreview) {
            try {
                this.startPreview();
            }
            catch (UnsupportedOperationException e) {
                Log.i((String)TAG, (String)("Can't start preview: " + e.getMessage()));
            }
        }
    }

    public final int getVideoBitrate() {
        return this.streamer.getSettings().getVideo().getBitrate();
    }

    public final void setVideoBitrate(int value) {
        this.streamer.getSettings().getVideo().setBitrate(value);
    }

    @NotNull
    public final CameraFacingDirection getCameraPosition() {
        return CameraFacingDirection.Companion.fromCameraId(this.context, this.streamer.getCamera());
    }

    public final void setCameraPosition(@NotNull CameraFacingDirection value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (value == CameraFacingDirection.BACK && ContextExtensionsForCameraKt.isFrontCamera((Context)this.context, (String)this.streamer.getCamera()) || value == CameraFacingDirection.FRONT && ContextExtensionsForCameraKt.isBackCamera((Context)this.context, (String)this.streamer.getCamera())) {
            this.permissionRequester.invoke((Object)CollectionsKt.listOf((Object)"android.permission.CAMERA"), (Object)new Function0<Unit>(this, value){
                final /* synthetic */ ApiVideoLiveStream this$0;
                final /* synthetic */ CameraFacingDirection $value;
                {
                    this.this$0 = $receiver;
                    this.$value = $value;
                    super(0);
                }

                public final void invoke() {
                    ApiVideoLiveStream.access$getStreamer$p(this.this$0).setCamera(this.$value.toCameraId(ApiVideoLiveStream.access$getContext$p(this.this$0)));
                }
            });
        }
    }

    @NotNull
    public final String getCamera() {
        return this.streamer.getCamera();
    }

    public final void setCamera(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.streamer.setCamera(value);
    }

    public final boolean isMuted() {
        return this.streamer.getSettings().getAudio().isMuted();
    }

    public final void setMuted(boolean value) {
        this.streamer.getSettings().getAudio().setMuted(value);
    }

    public final float getZoomRatio() {
        return this.streamer.getSettings().getCamera().getZoom().getZoomRatio();
    }

    public final void setZoomRatio(float value) {
        this.streamer.getSettings().getCamera().getZoom().setZoomRatio(value);
    }

    public final void startStreaming(@NotNull String streamKey, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)streamKey, (String)"streamKey");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (!(!this.isStreaming())) {
            boolean $i$a$-require-ApiVideoLiveStream$startStreaming$62 = false;
            String $i$a$-require-ApiVideoLiveStream$startStreaming$62 = "Stream is already running";
            throw new IllegalArgumentException($i$a$-require-ApiVideoLiveStream$startStreaming$62.toString());
        }
        if (!(((CharSequence)streamKey).length() > 0)) {
            boolean $i$a$-require-ApiVideoLiveStream$startStreaming$72 = false;
            String $i$a$-require-ApiVideoLiveStream$startStreaming$72 = "Stream key must not be empty";
            throw new IllegalArgumentException($i$a$-require-ApiVideoLiveStream$startStreaming$72.toString());
        }
        if (!(((CharSequence)url).length() > 0)) {
            boolean $i$a$-require-ApiVideoLiveStream$startStreaming$82 = false;
            String $i$a$-require-ApiVideoLiveStream$startStreaming$82 = "Url must not be empty";
            throw new IllegalArgumentException($i$a$-require-ApiVideoLiveStream$startStreaming$82.toString());
        }
        if (!(this.audioConfig != null)) {
            boolean $i$a$-require-ApiVideoLiveStream$startStreaming$92 = false;
            String $i$a$-require-ApiVideoLiveStream$startStreaming$92 = "Audio config must be set";
            throw new IllegalArgumentException($i$a$-require-ApiVideoLiveStream$startStreaming$92.toString());
        }
        if (!(this.videoConfig != null)) {
            boolean bl = false;
            String string2 = "Video config must be set";
            throw new IllegalArgumentException(string2.toString());
        }
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, url, streamKey, null){
            int label;
            final /* synthetic */ ApiVideoLiveStream this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ String $streamKey;
            {
                this.this$0 = $receiver;
                this.$url = $url;
                this.$streamKey = $streamKey;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$url, this.$streamKey, null){
                            int label;
                            final /* synthetic */ ApiVideoLiveStream this$0;
                            final /* synthetic */ String $url;
                            final /* synthetic */ String $streamKey;
                            {
                                this.this$0 = $receiver;
                                this.$url = $url;
                                this.$streamKey = $streamKey;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.label = 1;
                                        v0 = ApiVideoLiveStream.access$getStreamer$p(this.this$0).connect(ExtensionsKt.addTrailingSlashIfNeeded(this.$url) + this.$streamKey, (Continuation)this);
                                        ** if (v0 != var3_2) goto lbl11
lbl10:
                                        // 1 sources

                                        return var3_2;
lbl11:
                                        // 1 sources

                                        ** GOTO lbl18
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl18:
                                        // 3 sources

                                        this.label = 2;
                                        v1 = ApiVideoLiveStream.access$getStreamer$p(this.this$0).startStream((Continuation)this);
                                        ** if (v1 != var3_2) goto lbl23
lbl22:
                                        // 1 sources

                                        return var3_2;
lbl23:
                                        // 1 sources

                                        ** GOTO lbl30
                                    }
                                    case 2: {
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl30:
                                            // 2 sources

                                            ApiVideoLiveStream.access$set_isStreaming$p(this.this$0, true);
                                            ** GOTO lbl39
                                            {
                                                catch (Exception e) {
                                                    ApiVideoLiveStream.access$getStreamer$p(this.this$0).disconnect();
                                                    ApiVideoLiveStream.access$getConnectionListener$p(this.this$0).onConnectionFailed(String.valueOf(e));
                                                    throw e;
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            Log.e((String)"ApiVideoLiveStream", (String)"Failed to start stream", (Throwable)e);
                                        }
lbl39:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void startStreaming$default(ApiVideoLiveStream apiVideoLiveStream, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            String string4 = apiVideoLiveStream.context.getString(R.string.default_rtmp_url);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            string3 = string4;
        }
        apiVideoLiveStream.startStreaming(string2, string3);
    }

    public final void stopStreaming() {
        boolean isConnected = this.streamer.isConnected();
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, isConnected, null){
            int label;
            final /* synthetic */ ApiVideoLiveStream this$0;
            final /* synthetic */ boolean $isConnected;
            {
                this.this$0 = $receiver;
                this.$isConnected = $isConnected;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$isConnected, null){
                            int label;
                            final /* synthetic */ ApiVideoLiveStream this$0;
                            final /* synthetic */ boolean $isConnected;
                            {
                                this.this$0 = $receiver;
                                this.$isConnected = $isConnected;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.label = 1;
                                        v0 = ApiVideoLiveStream.access$getStreamer$p(this.this$0).stopStream((Continuation)this);
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        ApiVideoLiveStream.access$getStreamer$p(this.this$0).disconnect();
                                        if (this.$isConnected) {
                                            ApiVideoLiveStream.access$getConnectionListener$p(this.this$0).onDisconnect();
                                        }
                                        ApiVideoLiveStream.access$set_isStreaming$p(this.this$0, false);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final boolean isStreaming() {
        return this._isStreaming;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public final void startPreview() {
        this.permissionRequester.invoke((Object)CollectionsKt.listOf((Object)"android.permission.CAMERA"), (Object)new Function0<Unit>(this){
            final /* synthetic */ ApiVideoLiveStream this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (this.this$0.getVideoConfig() == null) {
                    Log.w((String)"ApiVideoLiveStream", (String)"Video config is not set");
                    return;
                }
                ApiVideoLiveStream.access$getApiVideoView$p(this.this$0).startPreview$livestream_release();
            }
        });
    }

    public final void stopPreview() {
        this.apiVideoView.stopPreview$livestream_release();
    }

    public final void release() {
        this.streamer.release();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
    }

    public static final /* synthetic */ CameraRtmpLiveStreamer access$getStreamer$p(ApiVideoLiveStream $this) {
        return $this.streamer;
    }

    public static final /* synthetic */ Context access$getContext$p(ApiVideoLiveStream $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$set_isStreaming$p(ApiVideoLiveStream $this, boolean bl) {
        $this._isStreaming = bl;
    }

    public static final /* synthetic */ IConnectionListener access$getConnectionListener$p(ApiVideoLiveStream $this) {
        return $this.connectionListener;
    }

    public static final /* synthetic */ ApiVideoView access$getApiVideoView$p(ApiVideoLiveStream $this) {
        return $this.apiVideoView;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lvideo/api/livestream/ApiVideoLiveStream$Companion;", "", "()V", "TAG", "", "livestream_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

