/*
 * Decompiled with CFR 0.152.
 */
package video.api.livestream_module;

import android.content.Context;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.rtplibrary.base.Camera2Base;
import com.pedro.rtplibrary.rtmp.RtmpCamera2;
import com.pedro.rtplibrary.view.OpenGlView;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.ossrs.rtmp.ConnectCheckerRtmp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.livestream_module.Resolution;
import video.api.livestream_module.model.LiveStream;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0018\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010<J\u001a\u00109\u001a\u00020:2\u0006\u0010>\u001a\u00020?2\n\b\u0002\u0010=\u001a\u0004\u0018\u00010<J\u0006\u0010@\u001a\u00020AJ(\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020\fH\u0016J\u0010\u0010H\u001a\u00020A2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010I\u001a\u00020A2\u0006\u0010C\u001a\u00020DH\u0016J\b\u0010J\u001a\u00020\u0012H\u0002J\b\u0010K\u001a\u00020\u0012H\u0002R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R$\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0015\"\u0004\b \u0010\u0017R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010#\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0015\"\u0004\b%\u0010\u0017R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010&\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u000f\"\u0004\b(\u0010\u0011R$\u0010*\u001a\u00020)2\u0006\u0010\u000b\u001a\u00020)@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R$\u0010/\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u000f\"\u0004\b1\u0010\u0011R\u000e\u00102\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00104\u001a\u0002032\u0006\u0010\u000b\u001a\u000203@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108\u00a8\u0006L"}, d2={"Lvideo/api/livestream_module/ApiVideoLiveStream;", "Landroid/view/SurfaceHolder$Callback;", "context", "Landroid/content/Context;", "connectChecker", "Lnet/ossrs/rtmp/ConnectCheckerRtmp;", "openGlView", "Lcom/pedro/rtplibrary/view/OpenGlView;", "surfaceView", "Landroid/view/SurfaceView;", "(Landroid/content/Context;Lnet/ossrs/rtmp/ConnectCheckerRtmp;Lcom/pedro/rtplibrary/view/OpenGlView;Landroid/view/SurfaceView;)V", "value", "", "audioBitrate", "getAudioBitrate", "()I", "setAudioBitrate", "(I)V", "", "audioMuted", "getAudioMuted", "()Z", "setAudioMuted", "(Z)V", "audioSampleRate", "getAudioSampleRate", "setAudioSampleRate", "echoCanceler", "getEchoCanceler", "setEchoCanceler", "noiseSuppressor", "getNoiseSuppressor", "setNoiseSuppressor", "rtmpCamera2", "Lcom/pedro/rtplibrary/rtmp/RtmpCamera2;", "stereo", "getStereo", "setStereo", "videoBitrate", "getVideoBitrate", "setVideoBitrate", "Lcom/pedro/encoder/input/video/CameraHelper$Facing;", "videoCamera", "getVideoCamera", "()Lcom/pedro/encoder/input/video/CameraHelper$Facing;", "setVideoCamera", "(Lcom/pedro/encoder/input/video/CameraHelper$Facing;)V", "videoFps", "getVideoFps", "setVideoFps", "videoNeedsRefresh", "Lvideo/api/livestream_module/Resolution;", "videoResolution", "getVideoResolution", "()Lvideo/api/livestream_module/Resolution;", "setVideoResolution", "(Lvideo/api/livestream_module/Resolution;)V", "startStreaming", "Lcom/pedro/rtplibrary/base/Camera2Base;", "streamKey", "", "url", "liveStream", "Lvideo/api/livestream_module/model/LiveStream;", "stopStreaming", "", "surfaceChanged", "p0", "Landroid/view/SurfaceHolder;", "p1", "p2", "p3", "surfaceCreated", "surfaceDestroyed", "updateAudio", "updateVideo", "livestream-module_release"})
public final class ApiVideoLiveStream
implements SurfaceHolder.Callback {
    private boolean videoNeedsRefresh;
    @NotNull
    private Resolution videoResolution;
    private int videoFps;
    private int videoBitrate;
    @NotNull
    private CameraHelper.Facing videoCamera;
    private boolean audioMuted;
    private boolean stereo;
    private boolean echoCanceler;
    private boolean noiseSuppressor;
    private int audioBitrate;
    private int audioSampleRate;
    private RtmpCamera2 rtmpCamera2;
    private final Context context;
    private final ConnectCheckerRtmp connectChecker;
    private final OpenGlView openGlView;
    private final SurfaceView surfaceView;

    @NotNull
    public final Resolution getVideoResolution() {
        return this.videoResolution;
    }

    public final void setVideoResolution(@NotNull Resolution value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.videoResolution = value;
        this.updateVideo();
    }

    public final int getVideoFps() {
        return this.videoFps;
    }

    public final void setVideoFps(int value) {
        this.videoFps = value;
        this.updateVideo();
    }

    public final int getVideoBitrate() {
        return this.videoBitrate;
    }

    public final void setVideoBitrate(int value) {
        this.videoBitrate = value;
        this.updateVideo();
    }

    @NotNull
    public final CameraHelper.Facing getVideoCamera() {
        return this.videoCamera;
    }

    public final void setVideoCamera(@NotNull CameraHelper.Facing value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.videoCamera = value;
        if (this.videoCamera == CameraHelper.Facing.BACK && this.rtmpCamera2.isFrontCamera() || this.videoCamera == CameraHelper.Facing.FRONT && !this.rtmpCamera2.isFrontCamera()) {
            this.rtmpCamera2.switchCamera();
        }
    }

    public final boolean getAudioMuted() {
        return this.audioMuted;
    }

    public final void setAudioMuted(boolean value) {
        this.audioMuted = value;
        if (value) {
            this.rtmpCamera2.disableAudio();
        } else {
            this.rtmpCamera2.enableAudio();
        }
    }

    public final boolean getStereo() {
        return this.stereo;
    }

    public final void setStereo(boolean value) {
        this.stereo = value;
        this.updateAudio();
    }

    public final boolean getEchoCanceler() {
        return this.echoCanceler;
    }

    public final void setEchoCanceler(boolean value) {
        this.echoCanceler = value;
        this.updateAudio();
    }

    public final boolean getNoiseSuppressor() {
        return this.noiseSuppressor;
    }

    public final void setNoiseSuppressor(boolean value) {
        this.noiseSuppressor = value;
        this.updateAudio();
    }

    public final int getAudioBitrate() {
        return this.audioBitrate;
    }

    public final void setAudioBitrate(int value) {
        this.audioBitrate = value;
        this.updateAudio();
    }

    public final int getAudioSampleRate() {
        return this.audioSampleRate;
    }

    public final void setAudioSampleRate(int value) {
        this.audioSampleRate = value;
        this.updateAudio();
    }

    private final boolean updateVideo() {
        if (!this.rtmpCamera2.isStreaming()) {
            this.videoNeedsRefresh = false;
            if (this.rtmpCamera2.isOnPreview()) {
                this.rtmpCamera2.stopPreview();
            }
            boolean res = this.rtmpCamera2.prepareVideo(this.videoResolution.getWidth(), this.videoResolution.getHeight(), this.videoFps, this.videoBitrate, CameraHelper.getCameraOrientation((Context)this.context));
            if (this.openGlView != null) {
                SurfaceHolder surfaceHolder = this.openGlView.getHolder();
                Intrinsics.checkNotNullExpressionValue((Object)surfaceHolder, (String)"openGlView.holder");
                Surface surface = surfaceHolder.getSurface();
                Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"openGlView.holder.surface");
                if (surface.isValid()) {
                    this.rtmpCamera2.startPreview(this.videoCamera);
                }
            }
            return res;
        }
        this.videoNeedsRefresh = true;
        return false;
    }

    private final boolean updateAudio() {
        if (!this.rtmpCamera2.isStreaming()) {
            return this.rtmpCamera2.prepareAudio(this.audioBitrate, this.audioSampleRate, this.stereo, this.echoCanceler, this.noiseSuppressor);
        }
        return false;
    }

    public void surfaceCreated(@NotNull SurfaceHolder p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
    }

    public void surfaceChanged(@NotNull SurfaceHolder p0, int p1, int p2, int p3) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        this.rtmpCamera2.startPreview(this.videoCamera);
    }

    public void surfaceDestroyed(@NotNull SurfaceHolder p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        if (this.rtmpCamera2.isStreaming()) {
            this.rtmpCamera2.stopStream();
        }
        this.rtmpCamera2.stopPreview();
    }

    @NotNull
    public final Camera2Base startStreaming(@NotNull String streamKey, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)streamKey, (String)"streamKey");
        if (this.rtmpCamera2.isStreaming()) {
            throw (Throwable)new IOException("Stream is already started");
        }
        boolean audioReady = this.updateAudio();
        if (this.audioMuted) {
            this.rtmpCamera2.disableAudio();
        }
        boolean videoReady = this.updateVideo();
        if (audioReady && videoReady) {
            String string = url;
            if (string == null) {
                string = "rtmp://broadcast.api.video/s/";
            }
            String rtmp = string;
            this.rtmpCamera2.startStream(rtmp + streamKey);
            return (Camera2Base)this.rtmpCamera2;
        }
        throw (Throwable)new IOException("Could not start RTMP streaming. audioReady=" + audioReady + ", videoReady=" + videoReady);
    }

    @NotNull
    public final Camera2Base startStreaming(@NotNull LiveStream liveStream, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)liveStream, (String)"liveStream");
        String string = liveStream.getStreamKey();
        Intrinsics.checkNotNull((Object)string);
        return this.startStreaming(string, url);
    }

    public static /* synthetic */ Camera2Base startStreaming$default(ApiVideoLiveStream apiVideoLiveStream, LiveStream liveStream, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "rtmp://broadcast.api.video/s/";
        }
        return apiVideoLiveStream.startStreaming(liveStream, string);
    }

    public final void stopStreaming() {
        this.rtmpCamera2.stopStream();
        if (this.videoNeedsRefresh) {
            this.updateVideo();
        }
    }

    public ApiVideoLiveStream(@NotNull Context context, @NotNull ConnectCheckerRtmp connectChecker, @Nullable OpenGlView openGlView, @Nullable SurfaceView surfaceView) {
        RtmpCamera2 rtmpCamera2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        this.context = context;
        this.connectChecker = connectChecker;
        this.openGlView = openGlView;
        this.surfaceView = surfaceView;
        this.videoResolution = Resolution.RESOLUTION_720;
        this.videoFps = 30;
        this.videoBitrate = 4500000;
        this.videoCamera = CameraHelper.Facing.BACK;
        this.stereo = true;
        this.audioBitrate = 128000;
        this.audioSampleRate = 44100;
        if (this.surfaceView != null) {
            rtmpCamera2 = new RtmpCamera2(this.surfaceView, this.connectChecker);
        } else if (this.openGlView != null) {
            this.openGlView.getHolder().addCallback((SurfaceHolder.Callback)this);
            rtmpCamera2 = new RtmpCamera2(this.openGlView, this.connectChecker);
        } else {
            rtmpCamera2 = new RtmpCamera2(this.context, true, this.connectChecker);
        }
        this.rtmpCamera2 = rtmpCamera2;
    }
}

