/*
 * Decompiled with CFR 0.152.
 */
package video.api.livestream_module;

import android.content.Context;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.rtplibrary.base.Camera2Base;
import com.pedro.rtplibrary.rtmp.RtmpCamera2;
import com.pedro.rtplibrary.view.OpenGlView;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ossrs.rtmp.ConnectCheckerRtmp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.livestream_module.model.LiveStream;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u000e\u001a\u00020\u000fJ(\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lvideo/api/livestream_module/ApiVideoLiveStream;", "Landroid/view/SurfaceHolder$Callback;", "config", "Lvideo/api/livestream_module/ApiVideoLiveStream$Config;", "(Lvideo/api/livestream_module/ApiVideoLiveStream$Config;)V", "rtmpCamera2", "Lcom/pedro/rtplibrary/rtmp/RtmpCamera2;", "startStreaming", "Lcom/pedro/rtplibrary/base/Camera2Base;", "streamKey", "", "url", "liveStream", "Lvideo/api/livestream_module/model/LiveStream;", "stopStreaming", "", "surfaceChanged", "p0", "Landroid/view/SurfaceHolder;", "p1", "", "p2", "p3", "surfaceCreated", "surfaceDestroyed", "Config", "livestream-module_release"})
public final class ApiVideoLiveStream
implements SurfaceHolder.Callback {
    private RtmpCamera2 rtmpCamera2;
    private final Config config;

    public void surfaceCreated(@NotNull SurfaceHolder p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
    }

    public void surfaceChanged(@NotNull SurfaceHolder p0, int p1, int p2, int p3) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        this.rtmpCamera2.startPreview();
    }

    public void surfaceDestroyed(@NotNull SurfaceHolder p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        if (this.rtmpCamera2.isStreaming()) {
            this.rtmpCamera2.stopStream();
        }
        this.rtmpCamera2.stopPreview();
    }

    @NotNull
    public final Camera2Base startStreaming(@NotNull String streamKey, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)streamKey, (String)"streamKey");
        boolean audioReady = this.rtmpCamera2.prepareAudio(this.config.getAudioBitrate(), this.config.getAudioSampleRate(), this.config.getStereo(), this.config.getEchoCanceler(), this.config.getNoiseSuppressor());
        boolean videoReady = this.rtmpCamera2.prepareVideo(this.config.getVideoQuality().getWidth(), this.config.getVideoQuality().getHeight(), this.config.getVideoFps(), this.config.getVideoBitrate(), CameraHelper.getCameraOrientation((Context)this.config.getContext()));
        if (audioReady && videoReady) {
            String string = url;
            if (string == null) {
                string = "rtmp://broadcast.api.video/s/";
            }
            String rtmp = string;
            this.rtmpCamera2.startStream(rtmp + streamKey);
            return (Camera2Base)this.rtmpCamera2;
        }
        throw (Throwable)new IOException("Could not start RTMP streaming. audioReady=" + audioReady + ", videoReady=" + videoReady);
    }

    @NotNull
    public final Camera2Base startStreaming(@NotNull LiveStream liveStream, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)liveStream, (String)"liveStream");
        String string = liveStream.getStreamKey();
        Intrinsics.checkNotNull((Object)string);
        return this.startStreaming(string, url);
    }

    public static /* synthetic */ Camera2Base startStreaming$default(ApiVideoLiveStream apiVideoLiveStream, LiveStream liveStream, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "rtmp://broadcast.api.video/s/";
        }
        return apiVideoLiveStream.startStreaming(liveStream, string);
    }

    public final void stopStreaming() {
        this.rtmpCamera2.stopStream();
    }

    public ApiVideoLiveStream(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.rtmpCamera2 = this.config.getSurfaceView() != null ? new RtmpCamera2(this.config.getSurfaceView(), this.config.getConnectChecker()) : (this.config.getOpenGlView() != null ? new RtmpCamera2(this.config.getOpenGlView(), this.config.getConnectChecker()) : new RtmpCamera2(this.config.getContext(), true, this.config.getConnectChecker()));
        if (this.config.getOpenGlView() != null) {
            this.config.getOpenGlView().getHolder().addCallback((SurfaceHolder.Callback)this);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\u0018\u00002\u00020\u0001:\u0002)*Bk\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0017R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0017R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006+"}, d2={"Lvideo/api/livestream_module/ApiVideoLiveStream$Config;", "", "audioBitrate", "", "audioSampleRate", "stereo", "", "echoCanceler", "noiseSuppressor", "openGlView", "Lcom/pedro/rtplibrary/view/OpenGlView;", "surfaceView", "Landroid/view/SurfaceView;", "context", "Landroid/content/Context;", "connectChecker", "Lnet/ossrs/rtmp/ConnectCheckerRtmp;", "videoBitrate", "videoQuality", "Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;", "videoFps", "(IIZZZLcom/pedro/rtplibrary/view/OpenGlView;Landroid/view/SurfaceView;Landroid/content/Context;Lnet/ossrs/rtmp/ConnectCheckerRtmp;ILvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;I)V", "getAudioBitrate", "()I", "getAudioSampleRate", "getConnectChecker", "()Lnet/ossrs/rtmp/ConnectCheckerRtmp;", "getContext", "()Landroid/content/Context;", "getEchoCanceler", "()Z", "getNoiseSuppressor", "getOpenGlView", "()Lcom/pedro/rtplibrary/view/OpenGlView;", "getStereo", "getSurfaceView", "()Landroid/view/SurfaceView;", "getVideoBitrate", "getVideoFps", "getVideoQuality", "()Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;", "Builder", "Quality", "livestream-module_release"})
    public static final class Config {
        private final int audioBitrate;
        private final int audioSampleRate;
        private final boolean stereo;
        private final boolean echoCanceler;
        private final boolean noiseSuppressor;
        @Nullable
        private final OpenGlView openGlView;
        @Nullable
        private final SurfaceView surfaceView;
        @NotNull
        private final Context context;
        @NotNull
        private final ConnectCheckerRtmp connectChecker;
        private final int videoBitrate;
        @NotNull
        private final Quality videoQuality;
        private final int videoFps;

        public final int getAudioBitrate() {
            return this.audioBitrate;
        }

        public final int getAudioSampleRate() {
            return this.audioSampleRate;
        }

        public final boolean getStereo() {
            return this.stereo;
        }

        public final boolean getEchoCanceler() {
            return this.echoCanceler;
        }

        public final boolean getNoiseSuppressor() {
            return this.noiseSuppressor;
        }

        @Nullable
        public final OpenGlView getOpenGlView() {
            return this.openGlView;
        }

        @Nullable
        public final SurfaceView getSurfaceView() {
            return this.surfaceView;
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        @NotNull
        public final ConnectCheckerRtmp getConnectChecker() {
            return this.connectChecker;
        }

        public final int getVideoBitrate() {
            return this.videoBitrate;
        }

        @NotNull
        public final Quality getVideoQuality() {
            return this.videoQuality;
        }

        public final int getVideoFps() {
            return this.videoFps;
        }

        private Config(int audioBitrate, int audioSampleRate, boolean stereo, boolean echoCanceler, boolean noiseSuppressor, OpenGlView openGlView, SurfaceView surfaceView, Context context, ConnectCheckerRtmp connectChecker, int videoBitrate, Quality videoQuality, int videoFps) {
            this.audioBitrate = audioBitrate;
            this.audioSampleRate = audioSampleRate;
            this.stereo = stereo;
            this.echoCanceler = echoCanceler;
            this.noiseSuppressor = noiseSuppressor;
            this.openGlView = openGlView;
            this.surfaceView = surfaceView;
            this.context = context;
            this.connectChecker = connectChecker;
            this.videoBitrate = videoBitrate;
            this.videoQuality = videoQuality;
            this.videoFps = videoFps;
        }

        public /* synthetic */ Config(int audioBitrate, int audioSampleRate, boolean stereo, boolean echoCanceler, boolean noiseSuppressor, OpenGlView openGlView, SurfaceView surfaceView, Context context, ConnectCheckerRtmp connectChecker, int videoBitrate, Quality videoQuality, int videoFps, DefaultConstructorMarker $constructor_marker) {
            this(audioBitrate, audioSampleRate, stereo, echoCanceler, noiseSuppressor, openGlView, surfaceView, context, connectChecker, videoBitrate, videoQuality, videoFps);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;", "", "width", "", "height", "(Ljava/lang/String;III)V", "getHeight", "()I", "getWidth", "QUALITY_240", "QUALITY_480", "QUALITY_720", "QUALITY_1080", "QUALITY_2160", "livestream-module_release"})
        public static final class Quality
        extends Enum<Quality> {
            public static final /* enum */ Quality QUALITY_240;
            public static final /* enum */ Quality QUALITY_480;
            public static final /* enum */ Quality QUALITY_720;
            public static final /* enum */ Quality QUALITY_1080;
            public static final /* enum */ Quality QUALITY_2160;
            private static final /* synthetic */ Quality[] $VALUES;
            private final int width;
            private final int height;

            static {
                Quality[] qualityArray = new Quality[5];
                Quality[] qualityArray2 = qualityArray;
                qualityArray[0] = QUALITY_240 = new Quality(352, 240);
                qualityArray[1] = QUALITY_480 = new Quality(858, 480);
                qualityArray[2] = QUALITY_720 = new Quality(1280, 720);
                qualityArray[3] = QUALITY_1080 = new Quality(1920, 1080);
                qualityArray[4] = QUALITY_2160 = new Quality(3860, 2160);
                $VALUES = qualityArray;
            }

            public final int getWidth() {
                return this.width;
            }

            public final int getHeight() {
                return this.height;
            }

            private Quality(int width, int height) {
                this.width = width;
                this.height = height;
            }

            public static Quality[] values() {
                return (Quality[])$VALUES.clone();
            }

            public static Quality valueOf(String string) {
                return Enum.valueOf(Quality.class, string);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007J\u0006\u00108\u001a\u000209J\t\u0010:\u001a\u00020\u0003H\u00c6\u0003J\t\u0010;\u001a\u00020\u0007H\u00c6\u0003J\t\u0010<\u001a\u00020\u0013H\u00c6\u0003J\t\u0010=\u001a\u00020\u0007H\u00c6\u0003J\t\u0010>\u001a\u00020\u0005H\u00c6\u0003J\t\u0010?\u001a\u00020\u0007H\u00c6\u0003J\t\u0010@\u001a\u00020\u0007H\u00c6\u0003J\t\u0010A\u001a\u00020\nH\u00c6\u0003J\t\u0010B\u001a\u00020\nH\u00c6\u0003J\t\u0010C\u001a\u00020\nH\u00c6\u0003J\u000b\u0010D\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u0085\u0001\u0010F\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0007H\u00c6\u0001J\u000e\u0010G\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nJ\u0013\u0010H\u001a\u00020\n2\b\u0010I\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010J\u001a\u00020\u0007H\u00d6\u0001J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\nJ\u0010\u0010\r\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010L\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\nJ\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\t\u0010M\u001a\u00020NH\u00d6\u0001J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001b\"\u0004\b!\u0010\u001dR\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0017\"\u0004\b1\u0010\u0019R\u001a\u0010\u0014\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0017\"\u0004\b3\u0010\u0019R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107\u00a8\u0006O"}, d2={"Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Builder;", "", "context", "Landroid/content/Context;", "connectChecker", "Lnet/ossrs/rtmp/ConnectCheckerRtmp;", "audioBitrate", "", "audioSampleRate", "audioStereo", "", "audioCancelEcho", "audioSuppressNoise", "openGlView", "Lcom/pedro/rtplibrary/view/OpenGlView;", "surfaceView", "Landroid/view/SurfaceView;", "videoBitrate", "videoQuality", "Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;", "videoFps", "(Landroid/content/Context;Lnet/ossrs/rtmp/ConnectCheckerRtmp;IIZZZLcom/pedro/rtplibrary/view/OpenGlView;Landroid/view/SurfaceView;ILvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;I)V", "getAudioBitrate", "()I", "setAudioBitrate", "(I)V", "getAudioCancelEcho", "()Z", "setAudioCancelEcho", "(Z)V", "getAudioSampleRate", "setAudioSampleRate", "getAudioStereo", "setAudioStereo", "getAudioSuppressNoise", "setAudioSuppressNoise", "getConnectChecker", "()Lnet/ossrs/rtmp/ConnectCheckerRtmp;", "getContext", "()Landroid/content/Context;", "getOpenGlView", "()Lcom/pedro/rtplibrary/view/OpenGlView;", "setOpenGlView", "(Lcom/pedro/rtplibrary/view/OpenGlView;)V", "getSurfaceView", "()Landroid/view/SurfaceView;", "setSurfaceView", "(Landroid/view/SurfaceView;)V", "getVideoBitrate", "setVideoBitrate", "getVideoFps", "setVideoFps", "getVideoQuality", "()Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;", "setVideoQuality", "(Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;)V", "build", "Lvideo/api/livestream_module/ApiVideoLiveStream$Config;", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "echoCanceler", "equals", "other", "hashCode", "noiseSuppressor", "stereo", "toString", "", "livestream-module_release"})
        public static final class Builder {
            @NotNull
            private final Context context;
            @NotNull
            private final ConnectCheckerRtmp connectChecker;
            private int audioBitrate;
            private int audioSampleRate;
            private boolean audioStereo;
            private boolean audioCancelEcho;
            private boolean audioSuppressNoise;
            @Nullable
            private OpenGlView openGlView;
            @Nullable
            private SurfaceView surfaceView;
            private int videoBitrate;
            @NotNull
            private Quality videoQuality;
            private int videoFps;

            @NotNull
            public final Builder audioBitrate(int audioBitrate) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.audioBitrate = audioBitrate;
                return builder;
            }

            @NotNull
            public final Builder audioSampleRate(int audioSampleRate) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.audioSampleRate = audioSampleRate;
                return builder;
            }

            @NotNull
            public final Builder stereo(boolean stereo) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.audioStereo = stereo;
                return builder;
            }

            @NotNull
            public final Builder echoCanceler(boolean audioCancelEcho) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.audioCancelEcho = audioCancelEcho;
                return builder;
            }

            @NotNull
            public final Builder openGlView(@Nullable OpenGlView openGlView) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.openGlView = openGlView;
                return builder;
            }

            @NotNull
            public final Builder surfaceView(@Nullable SurfaceView surfaceView) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.surfaceView = surfaceView;
                return builder;
            }

            @NotNull
            public final Builder noiseSuppressor(boolean audioSuppressNoise) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.audioSuppressNoise = audioSuppressNoise;
                return builder;
            }

            @NotNull
            public final Builder videoBitrate(int videoBitrate) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.videoBitrate = videoBitrate;
                return builder;
            }

            @NotNull
            public final Builder videoQuality(@NotNull Quality videoQuality) {
                Intrinsics.checkNotNullParameter((Object)((Object)videoQuality), (String)"videoQuality");
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.videoQuality = videoQuality;
                return builder;
            }

            @NotNull
            public final Builder videoFps(int videoFps) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.videoFps = videoFps;
                return builder;
            }

            @NotNull
            public final Config build() {
                return new Config(this.audioBitrate, this.audioSampleRate, this.audioStereo, this.audioCancelEcho, this.audioSuppressNoise, this.openGlView, this.surfaceView, this.context, this.connectChecker, this.videoBitrate, this.videoQuality, this.videoFps, null);
            }

            @NotNull
            public final Context getContext() {
                return this.context;
            }

            @NotNull
            public final ConnectCheckerRtmp getConnectChecker() {
                return this.connectChecker;
            }

            public final int getAudioBitrate() {
                return this.audioBitrate;
            }

            public final void setAudioBitrate(int n) {
                this.audioBitrate = n;
            }

            public final int getAudioSampleRate() {
                return this.audioSampleRate;
            }

            public final void setAudioSampleRate(int n) {
                this.audioSampleRate = n;
            }

            public final boolean getAudioStereo() {
                return this.audioStereo;
            }

            public final void setAudioStereo(boolean bl) {
                this.audioStereo = bl;
            }

            public final boolean getAudioCancelEcho() {
                return this.audioCancelEcho;
            }

            public final void setAudioCancelEcho(boolean bl) {
                this.audioCancelEcho = bl;
            }

            public final boolean getAudioSuppressNoise() {
                return this.audioSuppressNoise;
            }

            public final void setAudioSuppressNoise(boolean bl) {
                this.audioSuppressNoise = bl;
            }

            @Nullable
            public final OpenGlView getOpenGlView() {
                return this.openGlView;
            }

            public final void setOpenGlView(@Nullable OpenGlView openGlView) {
                this.openGlView = openGlView;
            }

            @Nullable
            public final SurfaceView getSurfaceView() {
                return this.surfaceView;
            }

            public final void setSurfaceView(@Nullable SurfaceView surfaceView) {
                this.surfaceView = surfaceView;
            }

            public final int getVideoBitrate() {
                return this.videoBitrate;
            }

            public final void setVideoBitrate(int n) {
                this.videoBitrate = n;
            }

            @NotNull
            public final Quality getVideoQuality() {
                return this.videoQuality;
            }

            public final void setVideoQuality(@NotNull Quality quality) {
                Intrinsics.checkNotNullParameter((Object)((Object)quality), (String)"<set-?>");
                this.videoQuality = quality;
            }

            public final int getVideoFps() {
                return this.videoFps;
            }

            public final void setVideoFps(int n) {
                this.videoFps = n;
            }

            public Builder(@NotNull Context context, @NotNull ConnectCheckerRtmp connectChecker, int audioBitrate, int audioSampleRate, boolean audioStereo, boolean audioCancelEcho, boolean audioSuppressNoise, @Nullable OpenGlView openGlView, @Nullable SurfaceView surfaceView, int videoBitrate, @NotNull Quality videoQuality, int videoFps) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
                Intrinsics.checkNotNullParameter((Object)((Object)videoQuality), (String)"videoQuality");
                this.context = context;
                this.connectChecker = connectChecker;
                this.audioBitrate = audioBitrate;
                this.audioSampleRate = audioSampleRate;
                this.audioStereo = audioStereo;
                this.audioCancelEcho = audioCancelEcho;
                this.audioSuppressNoise = audioSuppressNoise;
                this.openGlView = openGlView;
                this.surfaceView = surfaceView;
                this.videoBitrate = videoBitrate;
                this.videoQuality = videoQuality;
                this.videoFps = videoFps;
            }

            public /* synthetic */ Builder(Context context, ConnectCheckerRtmp connectCheckerRtmp, int n, int n2, boolean bl, boolean bl2, boolean bl3, OpenGlView openGlView, SurfaceView surfaceView, int n3, Quality quality, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n5 & 4) != 0) {
                    n = 128000;
                }
                if ((n5 & 8) != 0) {
                    n2 = 44100;
                }
                if ((n5 & 0x10) != 0) {
                    bl = true;
                }
                if ((n5 & 0x20) != 0) {
                    bl2 = false;
                }
                if ((n5 & 0x40) != 0) {
                    bl3 = false;
                }
                if ((n5 & 0x80) != 0) {
                    openGlView = null;
                }
                if ((n5 & 0x100) != 0) {
                    surfaceView = null;
                }
                if ((n5 & 0x200) != 0) {
                    n3 = 4500000;
                }
                if ((n5 & 0x400) != 0) {
                    quality = Quality.QUALITY_720;
                }
                if ((n5 & 0x800) != 0) {
                    n4 = 25;
                }
                this(context, connectCheckerRtmp, n, n2, bl, bl2, bl3, openGlView, surfaceView, n3, quality, n4);
            }

            @NotNull
            public final Context component1() {
                return this.context;
            }

            @NotNull
            public final ConnectCheckerRtmp component2() {
                return this.connectChecker;
            }

            public final int component3() {
                return this.audioBitrate;
            }

            public final int component4() {
                return this.audioSampleRate;
            }

            public final boolean component5() {
                return this.audioStereo;
            }

            public final boolean component6() {
                return this.audioCancelEcho;
            }

            public final boolean component7() {
                return this.audioSuppressNoise;
            }

            @Nullable
            public final OpenGlView component8() {
                return this.openGlView;
            }

            @Nullable
            public final SurfaceView component9() {
                return this.surfaceView;
            }

            public final int component10() {
                return this.videoBitrate;
            }

            @NotNull
            public final Quality component11() {
                return this.videoQuality;
            }

            public final int component12() {
                return this.videoFps;
            }

            @NotNull
            public final Builder copy(@NotNull Context context, @NotNull ConnectCheckerRtmp connectChecker, int audioBitrate, int audioSampleRate, boolean audioStereo, boolean audioCancelEcho, boolean audioSuppressNoise, @Nullable OpenGlView openGlView, @Nullable SurfaceView surfaceView, int videoBitrate, @NotNull Quality videoQuality, int videoFps) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
                Intrinsics.checkNotNullParameter((Object)((Object)videoQuality), (String)"videoQuality");
                return new Builder(context, connectChecker, audioBitrate, audioSampleRate, audioStereo, audioCancelEcho, audioSuppressNoise, openGlView, surfaceView, videoBitrate, videoQuality, videoFps);
            }

            public static /* synthetic */ Builder copy$default(Builder builder, Context context, ConnectCheckerRtmp connectCheckerRtmp, int n, int n2, boolean bl, boolean bl2, boolean bl3, OpenGlView openGlView, SurfaceView surfaceView, int n3, Quality quality, int n4, int n5, Object object) {
                if ((n5 & 1) != 0) {
                    context = builder.context;
                }
                if ((n5 & 2) != 0) {
                    connectCheckerRtmp = builder.connectChecker;
                }
                if ((n5 & 4) != 0) {
                    n = builder.audioBitrate;
                }
                if ((n5 & 8) != 0) {
                    n2 = builder.audioSampleRate;
                }
                if ((n5 & 0x10) != 0) {
                    bl = builder.audioStereo;
                }
                if ((n5 & 0x20) != 0) {
                    bl2 = builder.audioCancelEcho;
                }
                if ((n5 & 0x40) != 0) {
                    bl3 = builder.audioSuppressNoise;
                }
                if ((n5 & 0x80) != 0) {
                    openGlView = builder.openGlView;
                }
                if ((n5 & 0x100) != 0) {
                    surfaceView = builder.surfaceView;
                }
                if ((n5 & 0x200) != 0) {
                    n3 = builder.videoBitrate;
                }
                if ((n5 & 0x400) != 0) {
                    quality = builder.videoQuality;
                }
                if ((n5 & 0x800) != 0) {
                    n4 = builder.videoFps;
                }
                return builder.copy(context, connectCheckerRtmp, n, n2, bl, bl2, bl3, openGlView, surfaceView, n3, quality, n4);
            }

            @NotNull
            public String toString() {
                return "Builder(context=" + this.context + ", connectChecker=" + this.connectChecker + ", audioBitrate=" + this.audioBitrate + ", audioSampleRate=" + this.audioSampleRate + ", audioStereo=" + this.audioStereo + ", audioCancelEcho=" + this.audioCancelEcho + ", audioSuppressNoise=" + this.audioSuppressNoise + ", openGlView=" + this.openGlView + ", surfaceView=" + this.surfaceView + ", videoBitrate=" + this.videoBitrate + ", videoQuality=" + (Object)((Object)this.videoQuality) + ", videoFps=" + this.videoFps + ")";
            }

            public int hashCode() {
                Context context = this.context;
                ConnectCheckerRtmp connectCheckerRtmp = this.connectChecker;
                int n = ((((context != null ? context.hashCode() : 0) * 31 + (connectCheckerRtmp != null ? connectCheckerRtmp.hashCode() : 0)) * 31 + Integer.hashCode(this.audioBitrate)) * 31 + Integer.hashCode(this.audioSampleRate)) * 31;
                int n2 = this.audioStereo ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                int n3 = (n + n2) * 31;
                int n4 = this.audioCancelEcho ? 1 : 0;
                if (n4 != 0) {
                    n4 = 1;
                }
                int n5 = (n3 + n4) * 31;
                int n6 = this.audioSuppressNoise ? 1 : 0;
                if (n6 != 0) {
                    n6 = 1;
                }
                OpenGlView openGlView = this.openGlView;
                SurfaceView surfaceView = this.surfaceView;
                Quality quality = this.videoQuality;
                return (((((n5 + n6) * 31 + (openGlView != null ? openGlView.hashCode() : 0)) * 31 + (surfaceView != null ? surfaceView.hashCode() : 0)) * 31 + Integer.hashCode(this.videoBitrate)) * 31 + (quality != null ? ((Object)((Object)quality)).hashCode() : 0)) * 31 + Integer.hashCode(this.videoFps);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Builder)) break block3;
                        Builder builder = (Builder)object;
                        if (!Intrinsics.areEqual((Object)this.context, (Object)builder.context) || !Intrinsics.areEqual((Object)this.connectChecker, (Object)builder.connectChecker) || this.audioBitrate != builder.audioBitrate || this.audioSampleRate != builder.audioSampleRate || this.audioStereo != builder.audioStereo || this.audioCancelEcho != builder.audioCancelEcho || this.audioSuppressNoise != builder.audioSuppressNoise || !Intrinsics.areEqual((Object)this.openGlView, (Object)builder.openGlView) || !Intrinsics.areEqual((Object)this.surfaceView, (Object)builder.surfaceView) || this.videoBitrate != builder.videoBitrate || !Intrinsics.areEqual((Object)((Object)this.videoQuality), (Object)((Object)builder.videoQuality)) || this.videoFps != builder.videoFps) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

