/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.client.api.models.DeepObject;

public class LiveStreamAssets
implements Serializable,
DeepObject {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_HLS = "hls";
    @SerializedName(value="hls")
    private URI hls;
    public static final String SERIALIZED_NAME_IFRAME = "iframe";
    @SerializedName(value="iframe")
    private String iframe;
    public static final String SERIALIZED_NAME_PLAYER = "player";
    @SerializedName(value="player")
    private URI player;
    public static final String SERIALIZED_NAME_THUMBNAIL = "thumbnail";
    @SerializedName(value="thumbnail")
    private URI thumbnail;

    public LiveStreamAssets hls(URI hls) {
        this.hls = hls;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://live.api.video/li4pqNqGUkhKfWcBGpZVLRY5.m3u8", value="The http live streaming (HLS) link for your live video stream.")
    public URI getHls() {
        return this.hls;
    }

    public void setHls(URI hls) {
        this.hls = hls;
    }

    public LiveStreamAssets iframe(String iframe) {
        this.iframe = iframe;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<iframe src=\\\"https://embed.api.video/live/li4pqNqGUkhKfWcBGpZVLRY5\\\" width=\\\"100%\\\" height=\\\"100%\\\" frameborder=\\\"0\\\" scrolling=\\\"no\\\" allowfullscreen=\\\"\\\"></iframe>", value="The embed code for the iframe containing your live video stream.")
    public String getIframe() {
        return this.iframe;
    }

    public void setIframe(String iframe) {
        this.iframe = iframe;
    }

    public LiveStreamAssets player(URI player) {
        this.player = player;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://embed.api.video/live/li400mYKSgQ6xs7taUeSaEKr", value="A link to the video player that is playing your live stream.")
    public URI getPlayer() {
        return this.player;
    }

    public void setPlayer(URI player) {
        this.player = player;
    }

    public LiveStreamAssets thumbnail(URI thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://live.api.video/li400mYKSgQ6xs7taUeSaEKr/thumbnail.jpg", value="A link to the thumbnail for your video.")
    public URI getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(URI thumbnail) {
        this.thumbnail = thumbnail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveStreamAssets liveStreamAssets = (LiveStreamAssets)o;
        return Objects.equals(this.hls, liveStreamAssets.hls) && Objects.equals(this.iframe, liveStreamAssets.iframe) && Objects.equals(this.player, liveStreamAssets.player) && Objects.equals(this.thumbnail, liveStreamAssets.thumbnail);
    }

    public int hashCode() {
        return Objects.hash(this.hls, this.iframe, this.player, this.thumbnail);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LiveStreamAssets {\n");
        sb.append("    hls: ").append(this.toIndentedString(this.hls)).append("\n");
        sb.append("    iframe: ").append(this.toIndentedString(this.iframe)).append("\n");
        sb.append("    player: ").append(this.toIndentedString(this.player)).append("\n");
        sb.append("    thumbnail: ").append(this.toIndentedString(this.thumbnail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

