/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import video.api.client.api.models.DeepObject;
import video.api.client.api.models.Metadata;
import video.api.client.api.models.Nullable;

public class VideoUpdatePayload
implements Serializable,
DeepObject {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_PLAYER_ID = "playerId";
    @SerializedName(value="playerId")
    private Nullable<String> playerId;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_PUBLIC = "public";
    @SerializedName(value="public")
    private Boolean _public;
    public static final String SERIALIZED_NAME_PANORAMIC = "panoramic";
    @SerializedName(value="panoramic")
    private Boolean panoramic;
    public static final String SERIALIZED_NAME_MP4_SUPPORT = "mp4Support";
    @SerializedName(value="mp4Support")
    private Boolean mp4Support;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private List<Metadata> metadata = null;

    public VideoUpdatePayload playerId(String playerId) {
        this.playerId = new Nullable<String>(playerId);
        return this;
    }

    public VideoUpdatePayload unsetPlayerId() {
        this.playerId = null;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(example="pl4k0jvEUuaTdRAEjQ4Jfrgz", value="The unique ID for the player you want to associate with your video.")
    public String getPlayerId() {
        return this.playerId == null ? null : this.playerId.getValue();
    }

    public void setPlayerId(String playerId) {
        this.playerId = new Nullable<String>(playerId);
    }

    public VideoUpdatePayload title(String title) {
        this.title = title;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(value="The title you want to use for your video.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public VideoUpdatePayload description(String description) {
        this.description = description;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(example="A film about good books.", value="A brief description of the video.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public VideoUpdatePayload _public(Boolean _public) {
        this._public = _public;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(example="true", value="Whether the video is publicly available or not. False means it is set to private. Default is true. Tutorials on [private videos](https://api.video/blog/endpoints/private-videos/).")
    public Boolean getPublic() {
        return this._public;
    }

    public void setPublic(Boolean _public) {
        this._public = _public;
    }

    public VideoUpdatePayload panoramic(Boolean panoramic) {
        this.panoramic = panoramic;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(example="false", value="Whether the video is a 360 degree or immersive video.")
    public Boolean getPanoramic() {
        return this.panoramic;
    }

    public void setPanoramic(Boolean panoramic) {
        this.panoramic = panoramic;
    }

    public VideoUpdatePayload mp4Support(Boolean mp4Support) {
        this.mp4Support = mp4Support;
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(example="true", value="Whether the player supports the mp4 format.")
    public Boolean getMp4Support() {
        return this.mp4Support;
    }

    public void setMp4Support(Boolean mp4Support) {
        this.mp4Support = mp4Support;
    }

    public VideoUpdatePayload tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public VideoUpdatePayload addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(example="[\"maths\", \"string theory\", \"video\"]", value="A list of terms or words you want to tag the video with. Make sure the list includes all the tags you want as whatever you send in this list will overwrite the existing list for the video.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public VideoUpdatePayload metadata(List<Metadata> metadata) {
        this.metadata = metadata;
        return this;
    }

    public VideoUpdatePayload addMetadataItem(Metadata metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<Metadata>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @javax.annotation.Nullable
    @ApiModelProperty(value="A list (array) of dictionaries where each dictionary contains a key value pair that describes the video. As with tags, you must send the complete list of metadata you want as whatever you send here will overwrite the existing metadata for the video. [Dynamic Metadata](https://api.video/blog/endpoints/dynamic-metadata/) allows you to define a key that allows any value pair.")
    public List<Metadata> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<Metadata> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoUpdatePayload videoUpdatePayload = (VideoUpdatePayload)o;
        return Objects.equals(this.playerId, videoUpdatePayload.playerId) && Objects.equals(this.title, videoUpdatePayload.title) && Objects.equals(this.description, videoUpdatePayload.description) && Objects.equals(this._public, videoUpdatePayload._public) && Objects.equals(this.panoramic, videoUpdatePayload.panoramic) && Objects.equals(this.mp4Support, videoUpdatePayload.mp4Support) && Objects.equals(this.tags, videoUpdatePayload.tags) && Objects.equals(this.metadata, videoUpdatePayload.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.playerId, this.title, this.description, this._public, this.panoramic, this.mp4Support, this.tags, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoUpdatePayload {\n");
        sb.append("    playerId: ").append(this.toIndentedString(this.playerId)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    _public: ").append(this.toIndentedString(this._public)).append("\n");
        sb.append("    panoramic: ").append(this.toIndentedString(this.panoramic)).append("\n");
        sb.append("    mp4Support: ").append(this.toIndentedString(this.mp4Support)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

