/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Adding restream destinations is optional. However, if you set a restream destination, you must provide all attributes for each destination.")
public class RestreamsRequestObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_SERVER_URL = "serverUrl";
    @SerializedName(value="serverUrl")
    private String serverUrl;
    public static final String SERIALIZED_NAME_STREAM_KEY = "streamKey";
    @SerializedName(value="streamKey")
    private String streamKey;

    public RestreamsRequestObject name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="My RTMP server", required=true, value="Use this parameter to define a name for the restream destination.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RestreamsRequestObject serverUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    @ApiModelProperty(example="rtmp://my.broadcast.example.com/app", required=true, value="Use this parameter to set the RTMP URL of the restream destination.")
    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public RestreamsRequestObject streamKey(String streamKey) {
        this.streamKey = streamKey;
        return this;
    }

    @ApiModelProperty(example="dw-dew8-q6w9-k67w-1ws8", required=true, value="Use this parameter to provide the unique key of the live stream that you want to restream.")
    public String getStreamKey() {
        return this.streamKey;
    }

    public void setStreamKey(String streamKey) {
        this.streamKey = streamKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestreamsRequestObject restreamsRequestObject = (RestreamsRequestObject)o;
        return Objects.equals(this.name, restreamsRequestObject.name) && Objects.equals(this.serverUrl, restreamsRequestObject.serverUrl) && Objects.equals(this.streamKey, restreamsRequestObject.streamKey);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.serverUrl, this.streamKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RestreamsRequestObject {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    serverUrl: ").append(this.toIndentedString(this.serverUrl)).append("\n");
        sb.append("    streamKey: ").append(this.toIndentedString(this.streamKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

