/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;
import video.api.client.api.models.LiveStreamAssets;

public class LiveStream
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_LIVE_STREAM_ID = "liveStreamId";
    @SerializedName(value="liveStreamId")
    private String liveStreamId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_STREAM_KEY = "streamKey";
    @SerializedName(value="streamKey")
    private String streamKey;
    public static final String SERIALIZED_NAME_RECORD = "record";
    @SerializedName(value="record")
    private Boolean record;
    public static final String SERIALIZED_NAME_PUBLIC = "public";
    @SerializedName(value="public")
    private Boolean _public;
    public static final String SERIALIZED_NAME_ASSETS = "assets";
    @SerializedName(value="assets")
    private LiveStreamAssets assets;
    public static final String SERIALIZED_NAME_PLAYER_ID = "playerId";
    @SerializedName(value="playerId")
    private String playerId;
    public static final String SERIALIZED_NAME_BROADCASTING = "broadcasting";
    @SerializedName(value="broadcasting")
    private Boolean broadcasting;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;

    public LiveStream liveStreamId(String liveStreamId) {
        this.liveStreamId = liveStreamId;
        return this;
    }

    @ApiModelProperty(example="li400mYKSgQ6xs7taUeSaEKr", required=true, value="The unique identifier for the live stream. Live stream IDs begin with \"li.\"")
    public String getLiveStreamId() {
        return this.liveStreamId;
    }

    public void setLiveStreamId(String liveStreamId) {
        this.liveStreamId = liveStreamId;
    }

    public LiveStream name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My Live Stream", value="The name of your live stream.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LiveStream streamKey(String streamKey) {
        this.streamKey = streamKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="cc1b4df0-d1c5-4064-a8f9-9f0368385135", value="The unique, private stream key that you use to begin streaming.")
    public String getStreamKey() {
        return this.streamKey;
    }

    public void setStreamKey(String streamKey) {
        this.streamKey = streamKey;
    }

    public LiveStream record(Boolean record) {
        this.record = record;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether you are recording or not.")
    public Boolean getRecord() {
        return this.record;
    }

    public void setRecord(Boolean record) {
        this.record = record;
    }

    public LiveStream _public(Boolean _public) {
        this._public = _public;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="BETA FEATURE Please limit all public = false (\"private\") livestreams to 3,000 users. Whether your video can be viewed by everyone, or requires authentication to see it. A setting of false will require a unique token for each view.")
    public Boolean getPublic() {
        return this._public;
    }

    public void setPublic(Boolean _public) {
        this._public = _public;
    }

    public LiveStream assets(LiveStreamAssets assets) {
        this.assets = assets;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LiveStreamAssets getAssets() {
        return this.assets;
    }

    public void setAssets(LiveStreamAssets assets) {
        this.assets = assets;
    }

    public LiveStream playerId(String playerId) {
        this.playerId = playerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="pl45d5vFFGrfdsdsd156dGhh", value="The unique identifier for the player.")
    public String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public LiveStream broadcasting(Boolean broadcasting) {
        this.broadcasting = broadcasting;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether or not you are broadcasting the live video you recorded for others to see. True means you are broadcasting to viewers, false means you are not.")
    public Boolean getBroadcasting() {
        return this.broadcasting;
    }

    public void setBroadcasting(Boolean broadcasting) {
        this.broadcasting = broadcasting;
    }

    public LiveStream createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-01-31T10:17:47Z", value="When the player was created, presented in ISO-8601 format.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LiveStream updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-01-31T10:18:47Z", value="When the player was last updated, presented in ISO-8601 format.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveStream liveStream = (LiveStream)o;
        return Objects.equals(this.liveStreamId, liveStream.liveStreamId) && Objects.equals(this.name, liveStream.name) && Objects.equals(this.streamKey, liveStream.streamKey) && Objects.equals(this.record, liveStream.record) && Objects.equals(this._public, liveStream._public) && Objects.equals(this.assets, liveStream.assets) && Objects.equals(this.playerId, liveStream.playerId) && Objects.equals(this.broadcasting, liveStream.broadcasting) && Objects.equals(this.createdAt, liveStream.createdAt) && Objects.equals(this.updatedAt, liveStream.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.liveStreamId, this.name, this.streamKey, this.record, this._public, this.assets, this.playerId, this.broadcasting, this.createdAt, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LiveStream {\n");
        sb.append("    liveStreamId: ").append(this.toIndentedString(this.liveStreamId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    streamKey: ").append(this.toIndentedString(this.streamKey)).append("\n");
        sb.append("    record: ").append(this.toIndentedString(this.record)).append("\n");
        sb.append("    _public: ").append(this.toIndentedString(this._public)).append("\n");
        sb.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        sb.append("    playerId: ").append(this.toIndentedString(this.playerId)).append("\n");
        sb.append("    broadcasting: ").append(this.toIndentedString(this.broadcasting)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

