/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.ApiResponse;
import video.api.client.api.Pair;
import video.api.client.api.models.Environment;
import video.api.client.api.models.Page;
import video.api.client.api.models.PlayerTheme;
import video.api.client.api.models.PlayerThemeCreationPayload;
import video.api.client.api.models.PlayerThemeUpdatePayload;
import video.api.client.api.models.PlayerThemesListResponse;

public class PlayerThemesApi {
    private ApiClient localVarApiClient;

    public PlayerThemesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public PlayerThemesApi() {
        this.localVarApiClient = new ApiClient(Environment.PRODUCTION.basePath);
    }

    public PlayerThemesApi(String basePath) {
        this.localVarApiClient = new ApiClient(basePath);
    }

    public PlayerThemesApi(String apiKey, String basePath) {
        this.localVarApiClient = new ApiClient(apiKey, basePath);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call createCall(PlayerThemeCreationPayload playerThemeCreationPayload, ApiCallback _callback) throws ApiException {
        PlayerThemeCreationPayload localVarPostBody = playerThemeCreationPayload;
        String localVarPath = "/players";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call createValidateBeforeCall(PlayerThemeCreationPayload playerThemeCreationPayload, ApiCallback _callback) throws ApiException {
        if (playerThemeCreationPayload == null) {
            throw new ApiException("Missing the required parameter 'playerThemeCreationPayload' when calling create");
        }
        Call localVarCall = this.createCall(playerThemeCreationPayload, _callback);
        return localVarCall;
    }

    public PlayerTheme create(PlayerThemeCreationPayload playerThemeCreationPayload) throws ApiException {
        ApiResponse<PlayerTheme> localVarResp = this.createWithHttpInfo(playerThemeCreationPayload);
        return localVarResp.getData();
    }

    public ApiResponse<PlayerTheme> createWithHttpInfo(PlayerThemeCreationPayload playerThemeCreationPayload) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(playerThemeCreationPayload, null);
        Type localVarReturnType = new TypeToken<PlayerTheme>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createAsync(PlayerThemeCreationPayload playerThemeCreationPayload, ApiCallback<PlayerTheme> _callback) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(playerThemeCreationPayload, _callback);
        Type localVarReturnType = new TypeToken<PlayerTheme>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call getCall(String playerId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/players/{playerId}".replaceAll("\\{playerId\\}", this.localVarApiClient.escapeString(playerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call getValidateBeforeCall(String playerId, ApiCallback _callback) throws ApiException {
        if (playerId == null) {
            throw new ApiException("Missing the required parameter 'playerId' when calling get");
        }
        Call localVarCall = this.getCall(playerId, _callback);
        return localVarCall;
    }

    public PlayerTheme get(String playerId) throws ApiException {
        ApiResponse<PlayerTheme> localVarResp = this.getWithHttpInfo(playerId);
        return localVarResp.getData();
    }

    public ApiResponse<PlayerTheme> getWithHttpInfo(String playerId) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(playerId, null);
        Type localVarReturnType = new TypeToken<PlayerTheme>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAsync(String playerId, ApiCallback<PlayerTheme> _callback) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(playerId, _callback);
        Type localVarReturnType = new TypeToken<PlayerTheme>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call updateCall(String playerId, PlayerThemeUpdatePayload playerThemeUpdatePayload, ApiCallback _callback) throws ApiException {
        PlayerThemeUpdatePayload localVarPostBody = playerThemeUpdatePayload;
        String localVarPath = "/players/{playerId}".replaceAll("\\{playerId\\}", this.localVarApiClient.escapeString(playerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call updateValidateBeforeCall(String playerId, PlayerThemeUpdatePayload playerThemeUpdatePayload, ApiCallback _callback) throws ApiException {
        if (playerId == null) {
            throw new ApiException("Missing the required parameter 'playerId' when calling update");
        }
        if (playerThemeUpdatePayload == null) {
            throw new ApiException("Missing the required parameter 'playerThemeUpdatePayload' when calling update");
        }
        Call localVarCall = this.updateCall(playerId, playerThemeUpdatePayload, _callback);
        return localVarCall;
    }

    public PlayerTheme update(String playerId, PlayerThemeUpdatePayload playerThemeUpdatePayload) throws ApiException {
        ApiResponse<PlayerTheme> localVarResp = this.updateWithHttpInfo(playerId, playerThemeUpdatePayload);
        return localVarResp.getData();
    }

    public ApiResponse<PlayerTheme> updateWithHttpInfo(String playerId, PlayerThemeUpdatePayload playerThemeUpdatePayload) throws ApiException {
        Call localVarCall = this.updateValidateBeforeCall(playerId, playerThemeUpdatePayload, null);
        Type localVarReturnType = new TypeToken<PlayerTheme>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateAsync(String playerId, PlayerThemeUpdatePayload playerThemeUpdatePayload, ApiCallback<PlayerTheme> _callback) throws ApiException {
        Call localVarCall = this.updateValidateBeforeCall(playerId, playerThemeUpdatePayload, _callback);
        Type localVarReturnType = new TypeToken<PlayerTheme>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call deleteCall(String playerId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/players/{playerId}".replaceAll("\\{playerId\\}", this.localVarApiClient.escapeString(playerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call deleteValidateBeforeCall(String playerId, ApiCallback _callback) throws ApiException {
        if (playerId == null) {
            throw new ApiException("Missing the required parameter 'playerId' when calling delete");
        }
        Call localVarCall = this.deleteCall(playerId, _callback);
        return localVarCall;
    }

    public void delete(String playerId) throws ApiException {
        this.deleteWithHttpInfo(playerId);
    }

    public ApiResponse<Void> deleteWithHttpInfo(String playerId) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(playerId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAsync(String playerId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(playerId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private Call listCall(String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/players";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call listValidateBeforeCall(String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCall(sortBy, sortOrder, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<PlayerThemesListResponse> listWithHttpInfo(String sortBy, String sortOrder, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(sortBy, sortOrder, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<PlayerThemesListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listAsync(String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback<PlayerThemesListResponse> _callback) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(sortBy, sortOrder, currentPage, pageSize, _callback);
        Type localVarReturnType = new TypeToken<PlayerThemesListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistRequest list() {
        return new APIlistRequest();
    }

    private Call uploadLogoCall(String playerId, File file, String link, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/players/{playerId}/logo".replaceAll("\\{playerId\\}", this.localVarApiClient.escapeString(playerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (link != null) {
            localVarFormParams.put("link", link);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call uploadLogoValidateBeforeCall(String playerId, File file, String link, ApiCallback _callback) throws ApiException {
        if (playerId == null) {
            throw new ApiException("Missing the required parameter 'playerId' when calling uploadLogo");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadLogo");
        }
        Call localVarCall = this.uploadLogoCall(playerId, file, link, _callback);
        return localVarCall;
    }

    public PlayerTheme uploadLogo(String playerId, File file, String link) throws ApiException {
        ApiResponse<PlayerTheme> localVarResp = this.uploadLogoWithHttpInfo(playerId, file, link);
        return localVarResp.getData();
    }

    public ApiResponse<PlayerTheme> uploadLogoWithHttpInfo(String playerId, File file, String link) throws ApiException {
        Call localVarCall = this.uploadLogoValidateBeforeCall(playerId, file, link, null);
        Type localVarReturnType = new TypeToken<PlayerTheme>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call uploadLogoAsync(String playerId, File file, String link, ApiCallback<PlayerTheme> _callback) throws ApiException {
        Call localVarCall = this.uploadLogoValidateBeforeCall(playerId, file, link, _callback);
        Type localVarReturnType = new TypeToken<PlayerTheme>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call deleteLogoCall(String playerId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/players/{playerId}/logo".replaceAll("\\{playerId\\}", this.localVarApiClient.escapeString(playerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call deleteLogoValidateBeforeCall(String playerId, ApiCallback _callback) throws ApiException {
        if (playerId == null) {
            throw new ApiException("Missing the required parameter 'playerId' when calling deleteLogo");
        }
        Call localVarCall = this.deleteLogoCall(playerId, _callback);
        return localVarCall;
    }

    public void deleteLogo(String playerId) throws ApiException {
        this.deleteLogoWithHttpInfo(playerId);
    }

    public ApiResponse<Void> deleteLogoWithHttpInfo(String playerId) throws ApiException {
        Call localVarCall = this.deleteLogoValidateBeforeCall(playerId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteLogoAsync(String playerId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteLogoValidateBeforeCall(playerId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIlistRequest {
        private String sortBy;
        private String sortOrder;
        private Integer currentPage;
        private Integer pageSize;

        private APIlistRequest() {
        }

        public APIlistRequest sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public APIlistRequest sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public APIlistRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIlistRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PlayerThemesApi.this.listCall(this.sortBy, this.sortOrder, this.currentPage, this.pageSize, _callback);
        }

        public Page<PlayerTheme> execute() throws ApiException {
            ApiResponse localVarResp = PlayerThemesApi.this.listWithHttpInfo(this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
            return new Page<PlayerTheme>(((PlayerThemesListResponse)localVarResp.getData()).getData(), ((PlayerThemesListResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIlistRequest copy() {
            APIlistRequest copy = new APIlistRequest();
            copy.sortBy(this.sortBy);
            copy.sortOrder(this.sortOrder);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<PlayerThemesListResponse> executeWithHttpInfo() throws ApiException {
            return PlayerThemesApi.this.listWithHttpInfo(this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
        }

        public Call executeAsync(final ApiCallback<Page<PlayerTheme>> _callback) throws ApiException {
            ApiCallback<PlayerThemesListResponse> apiCallback = new ApiCallback<PlayerThemesListResponse>(){

                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onFailure(e, statusCode, responseHeaders);
                }

                @Override
                public void onSuccess(PlayerThemesListResponse result, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onSuccess(new Page<PlayerTheme>(result.getData(), result.getPagination(), () -> {
                        try {
                            return APIlistRequest.this.copy().currentPage((APIlistRequest.this.currentPage == null ? 1 : APIlistRequest.this.currentPage) + 1).execute();
                        }
                        catch (ApiException e) {
                            throw new RuntimeException(e);
                        }
                    }), statusCode, responseHeaders);
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                    _callback.onUploadProgress(bytesWritten, contentLength, done);
                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                    _callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            return PlayerThemesApi.this.listAsync(this.sortBy, this.sortOrder, this.currentPage, this.pageSize, apiCallback);
        }
    }
}

