/*
 * Decompiled with CFR 0.152.
 */
package video.api.client;

import okhttp3.OkHttpClient;
import video.api.client.api.ApiClient;
import video.api.client.api.clients.CaptionsApi;
import video.api.client.api.clients.ChaptersApi;
import video.api.client.api.clients.LiveStreamsApi;
import video.api.client.api.clients.PlayerThemesApi;
import video.api.client.api.clients.RawStatisticsApi;
import video.api.client.api.clients.UploadTokensApi;
import video.api.client.api.clients.VideosApi;
import video.api.client.api.clients.WatermarksApi;
import video.api.client.api.clients.WebhooksApi;
import video.api.client.api.models.Environment;

public class ApiVideoClient {
    private final ApiClient apiClient;
    private final CaptionsApi captions;
    private final ChaptersApi chapters;
    private final LiveStreamsApi liveStreams;
    private final PlayerThemesApi playerThemes;
    private final RawStatisticsApi rawStatistics;
    private final UploadTokensApi uploadTokens;
    private final VideosApi videos;
    private final WatermarksApi watermarks;
    private final WebhooksApi webhooks;

    public ApiVideoClient() {
        this(Environment.PRODUCTION);
    }

    public ApiVideoClient(Environment environment) {
        this(new ApiClient(environment.basePath));
    }

    public ApiVideoClient(String apiKey) {
        this(apiKey, Environment.PRODUCTION);
    }

    public ApiVideoClient(String apiKey, Environment environment) {
        this(new ApiClient(apiKey, environment.basePath));
    }

    public ApiVideoClient(OkHttpClient client) {
        this(new ApiClient(client, Environment.PRODUCTION.basePath));
    }

    public ApiVideoClient(OkHttpClient client, Environment environment) {
        this(new ApiClient(client, environment.basePath));
    }

    public ApiVideoClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.captions = new CaptionsApi(this.apiClient);
        this.chapters = new ChaptersApi(this.apiClient);
        this.liveStreams = new LiveStreamsApi(this.apiClient);
        this.playerThemes = new PlayerThemesApi(this.apiClient);
        this.rawStatistics = new RawStatisticsApi(this.apiClient);
        this.uploadTokens = new UploadTokensApi(this.apiClient);
        this.videos = new VideosApi(this.apiClient);
        this.watermarks = new WatermarksApi(this.apiClient);
        this.webhooks = new WebhooksApi(this.apiClient);
    }

    public CaptionsApi captions() {
        return this.captions;
    }

    public ChaptersApi chapters() {
        return this.chapters;
    }

    public LiveStreamsApi liveStreams() {
        return this.liveStreams;
    }

    public PlayerThemesApi playerThemes() {
        return this.playerThemes;
    }

    public RawStatisticsApi rawStatistics() {
        return this.rawStatistics;
    }

    public UploadTokensApi uploadTokens() {
        return this.uploadTokens;
    }

    public VideosApi videos() {
        return this.videos;
    }

    public WatermarksApi watermarks() {
        return this.watermarks;
    }

    public WebhooksApi webhooks() {
        return this.webhooks;
    }

    public ApiClient getHttpClient() {
        return this.apiClient;
    }

    public long getUploadChunkSize() {
        return this.apiClient.getUploadChunkSize();
    }

    public void setUploadChunkSize(long uploadChunkSize) {
        this.apiClient.setUploadChunkSize(uploadChunkSize);
    }
}

