/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public abstract class AbstractPagerTool
implements ViewTool {
    public static final int DEFAULT_ITEMS_PER_PAGE = 10;
    public static final int DEFAULT_SLIP_SIZE = 20;
    protected static final String STORED_ITEMS_KEY = (class$org$apache$velocity$tools$view$tools$AbstractPagerTool == null ? (class$org$apache$velocity$tools$view$tools$AbstractPagerTool = AbstractPagerTool.class$("org.apache.velocity.tools.view.tools.AbstractPagerTool")) : class$org$apache$velocity$tools$view$tools$AbstractPagerTool).getName();
    private List items;
    private int index = 0;
    private int slipSize = 20;
    private int itemsPerPage = 10;
    protected HttpSession session;
    static /* synthetic */ Class class$org$apache$velocity$tools$view$tools$AbstractPagerTool;

    public void init(Object object) {
        ViewContext viewContext = (ViewContext)object;
        HttpServletRequest httpServletRequest = viewContext.getRequest();
        this.session = httpServletRequest.getSession(false);
        this.setup(httpServletRequest);
    }

    public abstract void setup(HttpServletRequest var1);

    public void reset() {
        this.items = null;
        this.index = 0;
        this.itemsPerPage = 10;
    }

    public void setItems(List list) {
        this.items = list;
        this.setStoredItems(list);
    }

    public void setIndex(int n) {
        if (n < 0) {
            n = 0;
        }
        this.index = n;
    }

    public void setItemsPerPage(int n) {
        if (n < 1) {
            n = 10;
        }
        this.itemsPerPage = n;
    }

    public void setSlipSize(int n) {
        if (n < 2) {
            n = 20;
        }
        this.slipSize = n;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public int getSlipSize() {
        return this.slipSize;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasItems() {
        return !this.getItems().isEmpty();
    }

    public List getItems() {
        if (this.items == null) {
            this.items = this.getStoredItems();
        }
        return this.items != null ? this.items : Collections.EMPTY_LIST;
    }

    public Integer getNextIndex() {
        int n = this.index + this.itemsPerPage;
        if (n < this.getItems().size()) {
            return new Integer(n);
        }
        return null;
    }

    public Integer getPrevIndex() {
        int n = Math.min(this.index, this.getItems().size()) - this.itemsPerPage;
        if (this.index > 0) {
            return new Integer(Math.max(0, n));
        }
        return null;
    }

    public int getPagesAvailable() {
        return (int)Math.ceil((double)this.getItems().size() / (double)this.itemsPerPage);
    }

    public List getPage() {
        if (!this.hasItems()) {
            return null;
        }
        int n = Math.min(this.getItems().size() - 1, this.index);
        int n2 = Math.min(this.getItems().size(), this.index + this.itemsPerPage);
        return this.getItems().subList(n, n2);
    }

    public Integer getPageNumber(int n) {
        if (!this.hasItems()) {
            return null;
        }
        return new Integer(1 + n / this.itemsPerPage);
    }

    public Integer getPageNumber() {
        return this.getPageNumber(this.index);
    }

    public String getPageDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.index + 1;
        int n2 = this.getItems().size();
        if (n >= n2) {
            stringBuffer.append(n2);
            stringBuffer.append(" of ");
            stringBuffer.append(n2);
        } else {
            int n3 = Math.min(this.index + this.itemsPerPage, n2);
            stringBuffer.append(n);
            stringBuffer.append(" - ");
            stringBuffer.append(n3);
            stringBuffer.append(" of ");
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    public List getSlip() {
        int n = this.getPagesAvailable();
        if (n <= 1) {
            return Collections.EMPTY_LIST;
        }
        int n2 = this.getPageNumber() - 1;
        int n3 = Math.max(0, n2 - this.slipSize / 2);
        int n4 = Math.min(n, n3 + this.slipSize);
        if (n4 - n3 < this.slipSize) {
            n3 = Math.max(0, n4 - this.slipSize);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n4 - n3);
        for (int i = n3; i < n4; ++i) {
            arrayList.add(new Integer(i * this.itemsPerPage));
        }
        return arrayList;
    }

    protected List getStoredItems() {
        if (this.session != null) {
            return (List)this.session.getAttribute(STORED_ITEMS_KEY);
        }
        return null;
    }

    protected void setStoredItems(List list) {
        if (this.session != null) {
            this.session.setAttribute(STORED_ITEMS_KEY, (Object)list);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

