/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.io.VelocityWriter;
import org.apache.velocity.tools.generic.log.LogSystemCommonsLog;
import org.apache.velocity.tools.view.ToolboxManager;
import org.apache.velocity.tools.view.context.ChainedContext;
import org.apache.velocity.tools.view.servlet.ServletToolboxManager;
import org.apache.velocity.util.SimplePool;

public class VelocityViewServlet
extends HttpServlet {
    public static final String CONTENT_TYPE = "default.contentType";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String DEFAULT_OUTPUT_ENCODING = "ISO-8859-1";
    public static final String SERVLET_CONTEXT_KEY = (class$javax$servlet$ServletContext == null ? (class$javax$servlet$ServletContext = VelocityViewServlet.class$("javax.servlet.ServletContext")) : class$javax$servlet$ServletContext).getName();
    protected static final String TOOLBOX_KEY = "org.apache.velocity.toolbox";
    protected static final String INIT_PROPS_KEY = "org.apache.velocity.properties";
    protected ToolboxManager toolboxManager = null;
    private static SimplePool writerPool = new SimplePool(40);
    private VelocityEngine velocity = null;
    private String defaultContentType;
    private boolean warnOfOutputStreamDeprecation = true;
    static /* synthetic */ Class class$javax$servlet$ServletContext;
    static /* synthetic */ Class class$org$apache$velocity$tools$view$servlet$ServletLogger;
    static /* synthetic */ Class class$org$apache$velocity$tools$view$servlet$WebappLoader;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initVelocity(servletConfig);
        this.initToolbox(servletConfig);
        this.defaultContentType = this.getVelocityProperty(CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
        String string = this.getVelocityProperty("output.encoding", DEFAULT_OUTPUT_ENCODING);
        if (!DEFAULT_OUTPUT_ENCODING.equalsIgnoreCase(string)) {
            int n = this.defaultContentType.lastIndexOf("charset");
            if (n < 0) {
                this.defaultContentType = this.defaultContentType + "; charset=" + string;
            } else {
                this.velocity.warn((Object)"VelocityViewServlet: Charset was already specified in the Content-Type property.  Output encoding property will be ignored.");
            }
        }
        this.velocity.info((Object)("VelocityViewServlet: Default content-type is: " + this.defaultContentType));
    }

    protected String findInitParameter(ServletConfig servletConfig, String string) {
        String string2 = servletConfig.getInitParameter(string);
        if (string2 == null || string2.length() == 0) {
            ServletContext servletContext = servletConfig.getServletContext();
            string2 = servletContext.getInitParameter(string);
        }
        return string2;
    }

    protected String getVelocityProperty(String string, String string2) {
        String string3 = (String)this.velocity.getProperty(string);
        if (string3 == null || string3.length() == 0) {
            return string2;
        }
        return string3;
    }

    protected VelocityEngine getVelocityEngine() {
        return this.velocity;
    }

    protected void setVelocityEngine(VelocityEngine velocityEngine) {
        if (velocityEngine == null) {
            throw new NullPointerException("Cannot set the VelocityEngine to null");
        }
        this.velocity = velocityEngine;
    }

    protected void initToolbox(ServletConfig servletConfig) throws ServletException {
        String string = this.findInitParameter(servletConfig, TOOLBOX_KEY);
        if (string != null) {
            this.toolboxManager = ServletToolboxManager.getInstance(this.getServletContext(), string);
        } else {
            this.velocity.info((Object)"VelocityViewServlet: No toolbox entry in configuration.");
        }
    }

    protected void initVelocity(ServletConfig servletConfig) throws ServletException {
        this.velocity = new VelocityEngine();
        this.setVelocityEngine(this.velocity);
        LogSystemCommonsLog.setVelocityEngine(this.velocity);
        this.velocity.setApplicationAttribute((Object)SERVLET_CONTEXT_KEY, (Object)this.getServletContext());
        this.velocity.setProperty("runtime.log.logsystem.class", (Object)(class$org$apache$velocity$tools$view$servlet$ServletLogger == null ? (class$org$apache$velocity$tools$view$servlet$ServletLogger = VelocityViewServlet.class$("org.apache.velocity.tools.view.servlet.ServletLogger")) : class$org$apache$velocity$tools$view$servlet$ServletLogger).getName());
        this.velocity.setProperty("resource.loader", (Object)"webapp");
        this.velocity.setProperty("webapp.resource.loader.class", (Object)(class$org$apache$velocity$tools$view$servlet$WebappLoader == null ? (class$org$apache$velocity$tools$view$servlet$WebappLoader = VelocityViewServlet.class$("org.apache.velocity.tools.view.servlet.WebappLoader")) : class$org$apache$velocity$tools$view$servlet$WebappLoader).getName());
        try {
            ExtendedProperties extendedProperties = this.loadConfiguration(servletConfig);
            this.velocity.setExtendedProperties(extendedProperties);
        }
        catch (Exception exception) {
            this.getServletContext().log("VelocityViewServlet: Unable to read Velocity configuration file: " + exception);
            this.getServletContext().log("VelocityViewServlet: Using default Velocity configuration.");
        }
        try {
            this.velocity.init();
        }
        catch (Exception exception) {
            this.getServletContext().log("VelocityViewServlet: PANIC! unable to init() - " + exception);
            throw new ServletException((Throwable)exception);
        }
    }

    protected ExtendedProperties loadConfiguration(ServletConfig servletConfig) throws IOException {
        String string = this.findInitParameter(servletConfig, INIT_PROPS_KEY);
        ExtendedProperties extendedProperties = new ExtendedProperties();
        if (string != null) {
            extendedProperties.load(this.getServletContext().getResourceAsStream(string));
            this.velocity.info((Object)("VelocityViewServlet: Custom Properties File: " + string));
        } else {
            this.velocity.info((Object)"VelocityViewServlet: No custom properties found. Using default Velocity configuration.");
        }
        return extendedProperties;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doRequest(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doRequest(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Context context = null;
        try {
            context = this.createContext(httpServletRequest, httpServletResponse);
            this.setContentType(httpServletRequest, httpServletResponse);
            Template template = this.handleRequest(httpServletRequest, httpServletResponse, context);
            if (template == null) {
                this.velocity.warn((Object)"VelocityViewServlet: couldn't find template to match request.");
                return;
            }
            this.mergeTemplate(template, context, httpServletResponse);
        }
        catch (Exception exception) {
            this.velocity.error((Object)("VelocityViewServlet: Exception processing the template: " + exception));
            this.error(httpServletRequest, httpServletResponse, exception);
        }
        finally {
            this.requestCleanup(httpServletRequest, httpServletResponse, context);
        }
    }

    protected void requestCleanup(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Context context) {
    }

    protected Template handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Context context) throws Exception {
        String string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        String string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
        if (string == null) {
            string = httpServletRequest.getServletPath();
            string2 = httpServletRequest.getPathInfo();
        }
        if (string2 != null) {
            string = string + string2;
        }
        return this.getTemplate(string);
    }

    protected void setContentType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType(this.defaultContentType);
    }

    protected Context createContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ChainedContext chainedContext = new ChainedContext(this.velocity, httpServletRequest, httpServletResponse, this.getServletContext());
        if (this.toolboxManager != null) {
            chainedContext.setToolbox(this.toolboxManager.getToolbox(chainedContext));
        }
        return chainedContext;
    }

    public Template getTemplate(String string) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.velocity.getTemplate(string);
    }

    public Template getTemplate(String string, String string2) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.velocity.getTemplate(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void mergeTemplate(Template template, Context context, HttpServletResponse httpServletResponse) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, IOException, UnsupportedEncodingException, Exception {
        VelocityWriter velocityWriter = null;
        Writer writer = this.getResponseWriter(httpServletResponse);
        try {
            velocityWriter = (VelocityWriter)writerPool.get();
            if (velocityWriter == null) {
                velocityWriter = new VelocityWriter(writer, 4096, true);
            } else {
                velocityWriter.recycle(writer);
            }
            this.performMerge(template, context, (Writer)velocityWriter);
            Object var7_6 = null;
            if (velocityWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (velocityWriter == null) throw throwable;
            try {
                velocityWriter.flush();
                velocityWriter.recycle(null);
                writerPool.put((Object)velocityWriter);
                throw throwable;
            }
            catch (Exception exception) {
                this.velocity.debug((Object)("VelocityViewServlet: Trouble releasing VelocityWriter: " + exception.getMessage()));
            }
            throw throwable;
        }
        try {
            velocityWriter.flush();
            velocityWriter.recycle(null);
            writerPool.put((Object)velocityWriter);
            return;
        }
        catch (Exception exception) {
            this.velocity.debug((Object)("VelocityViewServlet: Trouble releasing VelocityWriter: " + exception.getMessage()));
        }
    }

    protected void performMerge(Template template, Context context, Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, Exception {
        template.merge(context, writer);
    }

    protected void error(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) throws ServletException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>\n");
            stringBuffer.append("<head><title>Error</title></head>\n");
            stringBuffer.append("<body>\n");
            stringBuffer.append("<h2>VelocityViewServlet : Error processing the template</h2>\n");
            Throwable throwable = exception;
            String string = throwable.getMessage();
            if (string != null && string.trim().length() > 0) {
                stringBuffer.append(string);
                stringBuffer.append("\n<br>\n");
            }
            if (throwable instanceof MethodInvocationException) {
                throwable = ((MethodInvocationException)throwable).getWrappedThrowable();
            }
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            stringBuffer.append("<pre>\n");
            stringBuffer.append(stringWriter.toString());
            stringBuffer.append("</pre>\n");
            stringBuffer.append("</body>\n");
            stringBuffer.append("</html>");
            this.getResponseWriter(httpServletResponse).write(stringBuffer.toString());
        }
        catch (Exception exception2) {
            this.velocity.error((Object)("VelocityViewServlet: Exception while printing error screen: " + exception2));
            throw new ServletException((Throwable)exception);
        }
    }

    protected Writer getResponseWriter(HttpServletResponse httpServletResponse) throws UnsupportedEncodingException, IOException {
        Writer writer = null;
        try {
            writer = httpServletResponse.getWriter();
        }
        catch (IllegalStateException illegalStateException) {
            String string;
            if (this.warnOfOutputStreamDeprecation) {
                this.warnOfOutputStreamDeprecation = false;
                this.velocity.warn((Object)"VelocityViewServlet: Use of ServletResponse's getOutputStream() method with VelocityViewServlet is deprecated -- support will be removed in an upcoming release");
            }
            if ((string = httpServletResponse.getCharacterEncoding()) == null) {
                string = DEFAULT_OUTPUT_ENCODING;
            }
            writer = new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), string);
        }
        return writer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

