/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.context;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.context.ToolboxContext;
import org.apache.velocity.tools.view.context.ViewContext;

public class ChainedContext
extends VelocityContext
implements ViewContext {
    private Map toolbox;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HttpSession session;
    private ServletContext application;
    private VelocityEngine velocity;

    public ChainedContext(Context context, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        this(context, null, httpServletRequest, httpServletResponse, servletContext);
    }

    public ChainedContext(VelocityEngine velocityEngine, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        this(null, velocityEngine, httpServletRequest, httpServletResponse, servletContext);
    }

    public ChainedContext(Context context, VelocityEngine velocityEngine, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        super(null, context);
        this.velocity = velocityEngine;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.session = httpServletRequest.getSession(false);
        this.application = servletContext;
    }

    public void setToolbox(ToolboxContext toolboxContext) {
        this.setToolbox(toolboxContext.getToolbox());
    }

    public void setToolbox(Map map) {
        this.toolbox = map;
        this.session = this.request.getSession(false);
    }

    public Object internalGet(String string) {
        Object object = null;
        if (this.toolbox != null && (object = (Object)this.toolbox.get(string)) != null) {
            return object;
        }
        if (string.equals("request")) {
            return this.request;
        }
        if (string.equals("response")) {
            return this.response;
        }
        if (string.equals("session")) {
            return this.session;
        }
        if (string.equals("application")) {
            return this.application;
        }
        object = super.internalGet(string);
        if (object != null) {
            return object;
        }
        return this.getAttribute(string);
    }

    public Object getAttribute(String string) {
        Object object = this.request.getAttribute(string);
        if (object == null) {
            if (this.session != null) {
                try {
                    object = this.session.getAttribute(string);
                }
                catch (IllegalStateException illegalStateException) {
                    object = null;
                }
            }
            if (object == null) {
                object = this.application.getAttribute(string);
            }
        }
        return object;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.application;
    }

    public Context getVelocityContext() {
        return this;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocity;
    }
}

